/*************************************************************
Description:
    mbtk_task.c
    Used to implement mobiletek standard task or thread interfaces
Author:
    YangDagang
Date:
    2019-7-13
*************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <errno.h>
#include <fcntl.h>
#include <pthread.h>
#include "mbtk_type.h"
#include "mbtk_queue.h"
#include "mbtk_task.h"
#include "mbtk_log.h"

/*************************************************************
    Constants and Macros
*************************************************************/

/*************************************************************
    Definitions:enum,struct,union
*************************************************************/


/*************************************************************
    Variables:local,extern
*************************************************************/

/*************************************************************
    Local Function Declaration
*************************************************************/

/*************************************************************
    Extern Function Declaration
*************************************************************/

/*************************************************************
    Function Definitions
*************************************************************/
void mbtk_mutex_init(mbtk_mutex *mutex)
{
    pthread_mutex_init(&mutex->crit_sect, NULL);
}

void mbtk_mutex_deinit(mbtk_mutex *mutex)
{
    pthread_mutex_destroy(&mutex->crit_sect);
}

void mbtk_mutex_lock(mbtk_mutex *mutex)
{
    pthread_mutex_lock(&mutex->crit_sect);
}

void mbtk_mutex_unlock(mbtk_mutex *mutex)
{
    pthread_mutex_unlock(&mutex->crit_sect);
}

int mbtk_task_start(mbtk_task_info *task)
{
    static pthread_attr_t thread_attr;
    pthread_attr_init(&thread_attr);
    if(pthread_attr_setdetachstate(&thread_attr, PTHREAD_CREATE_DETACHED))
    {
        LOGE("pthread_attr_setdetachstate() fail.");
        return -1;
    }

    if (pthread_create((pthread_t*)task->task_id,
        &thread_attr, task->thread_run, task->args) != 0)
    {
        LOGE("%s errno: %d (%s)",__func__, errno, strerror(errno));
        return -1;
    }
    pthread_attr_destroy(&thread_attr);

    return 0;
}

int mbtk_task_queue_start(void *param,mbtk_task_cb_handle cb)
{
    int res = 0;
    mbtk_task_queue_info *ts = (mbtk_task_queue_info *)param;

    if(cb == NULL)
    {
        return MBTK_FAILE;
    }
    mbtk_queue_init(&ts->queue);
    mbtk_mutex_init(&ts->mutex);
    pthread_cond_init(&ts->cond, NULL);
    res = pthread_create(&ts->thread_id,NULL,cb,NULL);
    usleep(500000);
    return res;
}

void mbtk_task_queue_stop(void *param)
{
    mbtk_task_queue_info *ts = (mbtk_task_queue_info *)param;
    pthread_cancel(ts->thread_id);
}

int mbtk_signal_send(void *param,mbtk_signal_info* info)
{
    int res = 0;
    mbtk_task_queue_info *ts = (mbtk_task_queue_info *)param;

    mbtk_mutex_lock(&ts->mutex);
    res = mbtk_queue_put(&ts->queue,(void*)info);
    pthread_cond_signal(&ts->cond);
    mbtk_mutex_unlock(&ts->mutex);
    return res;
}

mbtk_signal_info *mbtk_signal_get(void *param)
{
    void *res = NULL;
    mbtk_task_queue_info *ts = (mbtk_task_queue_info *)param;

    mbtk_mutex_lock(&ts->mutex);
    res = mbtk_queue_get(&ts->queue);
    if(res == NULL){
        // extern int pthread_cond_wait (pthread_cond_t *__restrict __cond,
        //      pthread_mutex_t *__restrict __mutex)
        pthread_cond_wait(&ts->cond, (pthread_mutex_t*)(&ts->mutex));
        res = mbtk_queue_get(&ts->queue);
    }
    mbtk_mutex_unlock(&ts->mutex);
    return res;
}

