/*************************************************************
Description:
    mbtk_queue.c
    Used to implement mobiletek standard queue interfaces
Author:
    YangDagang
Date:
    2019-7-13
*************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "mbtk_type.h"
#include "mbtk_queue.h"

/*************************************************************
    Constants and Macros
*************************************************************/

/*************************************************************
    Definitions:enum,struct,union
*************************************************************/


/*************************************************************
    Variables:local,extern
*************************************************************/

/*************************************************************
    Local Function Declaration
*************************************************************/

/*************************************************************
    Extern Function Declaration
*************************************************************/

/*************************************************************
    Function Definitions
*************************************************************/
/*=============================================
FUNCTION
    mbtk_tcpip_ptr

DESCRIPTION
    get tcpip information pointer

DEPENDENCIES
    None

PARAMETERS
    None

RETURN VALUE
    tcpip information pointer

SIDE EFFECTS
    None
=============================================*/
void mbtk_queue_init(mbtk_queue_node_t *queue)
{
    if(queue == NULL)
    {
        return;
    }
    queue->count = 0;
    queue->payload = NULL;
    queue->front = NULL;
    queue->rear = NULL;
    mbtk_mutex_init(&queue->mutex);
}

int mbtk_queue_put(mbtk_queue_node_t *queue,void *payload)
{
    mbtk_queue_node_t *curr = NULL;
    mbtk_queue_node_t *p = NULL;

    if(payload == NULL || queue == NULL)
    {
        return -1;
    }
    mbtk_mutex_lock(&queue->mutex);
    curr = (mbtk_queue_node_t*)malloc(sizeof(mbtk_queue_node_t));
    if(curr == NULL)
    {
        mbtk_mutex_unlock(&queue->mutex);
        return -1;
    }
    curr->count = 0;
    curr->rear = NULL;
    curr->payload = payload;
    if(queue->front != NULL)
    {
        p = queue->front;
        p->rear = curr;
        curr->front = p;
        queue->front = curr;
    }
    else
    {
        //fisrt add node
        queue->front = curr;
        queue->rear = curr;
        curr->front = queue;
    }
    queue->count++;
    mbtk_mutex_unlock(&queue->mutex);
    return 0;
}

int mbtk_queue_insert(mbtk_queue_node_t *queue,void *payload)
{
    mbtk_queue_node_t *curr = NULL;
    mbtk_queue_node_t *p = NULL;

    if(payload == NULL || queue == NULL)
    {
        return -1;
    }
    mbtk_mutex_lock(&queue->mutex);
    curr = (mbtk_queue_node_t*)malloc(sizeof(mbtk_queue_node_t));
    if(curr == NULL)
    {
        mbtk_mutex_unlock(&queue->mutex);
        return -1;
    }
    curr->rear = NULL;
    curr->count = 0;
    curr->payload = payload;
    if(queue->front != NULL)
    {
        p = queue->rear;
        queue->rear = curr;
        curr->front = queue;
        curr->rear = p;
        p->front = curr;
    }
    else
    {
        //fisrt add node
        queue->front = curr;
        queue->rear = curr;
        curr->front = queue;
    }
    queue->count++;
    mbtk_mutex_unlock(&queue->mutex);
    return 0;
}

void* mbtk_queue_get(mbtk_queue_node_t *queue)
{
    mbtk_queue_node_t *curr = NULL;
    void *payload = NULL;

    if((queue == NULL) || mbtk_queue_empty(queue))
    {
        return NULL;
    }
    mbtk_mutex_lock(&queue->mutex);
    curr = queue->rear;
    payload = curr->payload;
    if(curr->rear != NULL)
    {
        queue->rear = curr->rear;
        curr->rear->front = queue;
    }
    else
    {
        queue->front = NULL;
        queue->rear = NULL;
    }
    free(curr);
    curr = NULL;
    queue->count--;
    mbtk_mutex_unlock(&queue->mutex);
    return payload;
}

bool mbtk_queue_empty(mbtk_queue_node_t *queue)
{
    bool is_empty = FALSE;

    mbtk_mutex_lock(&queue->mutex);
    if(queue != NULL)
    {
        if((queue->front == NULL) && (queue->rear == NULL))
        {
            is_empty = TRUE;
        }
    }
    mbtk_mutex_unlock(&queue->mutex);
    return is_empty;
}

bool mbtk_queue_is_full(mbtk_queue_node_t *queue)
{
    bool is_full = FALSE;

    mbtk_mutex_lock(&queue->mutex);
    if((queue != NULL) && (queue->count == MBTK_QUEUE_MAX_NUM))
    {
        is_full = TRUE;
    }
    mbtk_mutex_unlock(&queue->mutex);
    return is_full;
}

void mbtk_queue_deinit(mbtk_queue_node_t *queue)
{
    if(queue == NULL)
    {
        return;
    }
    queue->count = 0;
    queue->payload = NULL;
    queue->front = NULL;
    queue->rear = NULL;
    mbtk_mutex_deinit(&queue->mutex);
}
