/*
* mbtk_audio_internal.h
*
* MBTK Audio internal header.
*
* Author : lb
* Date   : 2023/12/20 10:13:09
*/
#ifndef _MBTK_AUDIO_INTERNAL_H
#define _MBTK_AUDIO_INTERNAL_H
#include "mbtk_audio2.h"
#include "audio_if_api.h"
#include "audio_if_audio_hw_mrvl.h"

typedef enum {
    AUDIO_PLAY_STATE_STOP,
    AUDIO_PLAY_STATE_RUNNING,
    AUDIO_PLAY_STATE_PAUSE
} audio_play_state_enum;

typedef enum {
    AUDIO_RECORDER_STATE_STOP,
    AUDIO_RECORDER_STATE_RUNNING,
    AUDIO_RECORDER_STATE_PAUSE
} audio_recorder_state_enum;

typedef struct {
    struct audio_stream_out *stream_out;
    char buff_remain[MBTK_PCM_WB_BUF_SIZE];
    int buff_remain_len;
} audio_play_info_t;

typedef struct {
    struct audio_stream_in *stream_in;
    audio_recorder_state_enum state;
    pthread_cond_t cond;
    pthread_mutex_t mutex;

    mbtk_recorder_callback_func recorder_cb;
} audio_recorder_info_t;

typedef struct {
    mbtk_audio_sample_rate_enum sample_rate;
    int channel;
    unsigned int playback_size;
    audio_hw_device_t *audio_ahw_dev_ubus;

    mbtk_audio_direction_enum direction;
    union {
        audio_play_info_t play;
        audio_recorder_info_t recorder;
    }info;
} audio_inter_info_t;

#endif /* _MBTK_AUDIO_INTERNAL_H */
