/*************************************************************************
	> File Name: main.c
	> Author: LFJ
	> Mail: 
	> Created Time: 2018年09月05日 星期三 13时48分17秒
 ************************************************************************/

#include <stdio.h>

#include "MQTTClient.h"
#include "mbtk_mqtt.h"
#include "pthread.h"
#include "string.h"
#include "unistd.h"
#include "sys/stat.h"
#include "sys/types.h"
#include "sys/socket.h"
#include "netinet/in.h"
#include "arpa/inet.h"
#include "fcntl.h"
#include "mbtk_sock2.h"

#include "mbtk_type.h"
#include "mbtk_http.h"

/*
static Cloud_MQTT_t *iot_mqtt;

void set_mqtt_t(Cloud_MQTT_t *piot_mqtt)
{
    iot_mqtt = piot_mqtt;
}
Cloud_MQTT_t * get_mqtt_t()
{
    return iot_mqtt;
}
*/

extern regnwl_info_t regnwl_info;


#define CORE_AUTH_SDK_VERSION "sdk-c-4.1.0"
#define CORE_AUTH_TIMESTAMP   "2524608000000"
#define MBTK_MQTT_HTTP_AUTH_PATH               "/auth/register/device"
#define MBTK_MQTT_HTTP_SIGN_METHOD_HMACSHA256  "hmacsha256"


const char * mqtt_url[7] = {
                   "iot-as-mqtt.cn-shanghai.aliyuncs.com",        /* Shanghai */
                   "iot-as-mqtt.ap-southeast-1.aliyuncs.com",    /* Singapore */
                    "iot-as-mqtt.ap-northeast-1.aliyuncs.com",    /* Japan */
                    "iot-as-mqtt.us-west-1.aliyuncs.com",         /* America */
                    "iot-as-mqtt.eu-central-1.aliyuncs.com",      /* Germany */
                    "118.114.239.159",      /* me */
                    NULL,                                         /* Custom */
   };


const char    *http_host[6] = {
    "iot-auth.cn-shanghai.aliyuncs.com",          /* Shanghai */
    "iot-auth.ap-southeast-1.aliyuncs.com",      /* Singapore */
    "iot-auth.ap-northeast-1.aliyuncs.com",      /* Japan */
    "iot-auth.us-west-1.aliyuncs.com",           /* America */
    "iot-auth.eu-central-1.aliyuncs.com",         /* Germany */
    NULL,                                         /* Custom */
 };

mbtk_mqtt_device_session_t mbtk_mqtt_device ={0};


char mbtk_mqtt_http_url[255] ={0};
char mbtk_mqtt_http_content[1024] ={0};

char Device_Secret[255] = {0};


int mbtk_imqtt_http_dynreg_sign(char *product_key,char* product_secret,char*device_name,char* random,char* sign)
{
    int sign_source_len = 0;
    uint8_t signnum[32];
    uint8_t  *sign_source = NULL;
    const char *dynamic_register_sign_fmt = "deviceName%sproductKey%srandom%s";

    /* Start Dynamic Register */
    /* Calculate SHA256 Value */
    sign_source_len = strlen(dynamic_register_sign_fmt) + strlen(device_name) + strlen(product_key) + strlen(random) + 1;
    sign_source = malloc(sign_source_len);
    if (sign_source == NULL)
    {
        return -1;
    }
    memset(sign_source, 0, sign_source_len);
    snprintf((char *)sign_source, sign_source_len, dynamic_register_sign_fmt, device_name, product_key, random);

    core_hmac_sha256(sign_source, strlen((const char *)sign_source), (uint8_t *)product_secret, strlen(product_secret),
                      signnum);
    core_hex2str(signnum, 32, sign,0);
    free(sign_source);
    sign_source = NULL;

    return 0;

}


int mbtk_imqtt_send_post_request(char *product_key, char *product_secret, char *device_name, int host)
{

    printf("product_key: %s\n", product_key);
    printf("product_secret: %s\n", product_secret);
    printf("device_name: %s\n", device_name);

    int32_t res = 0, content_len = 0;
    char content[255] = {0};
    char random[15+1]={0};;
    char  sign[65] = {0};
    int dynamic_register_request_len = 0;
//    char *content_fmt = "productKey=%s&deviceName=%s&random=%s&sign=%s&signMethod=%s";
    char *signMethod = MBTK_MQTT_HTTP_SIGN_METHOD_HMACSHA256;


    memcpy(random, "8Ygb7ULYh53B6OA", strlen("8Ygb7ULYh53B6OA"));
    char *content_src[] = { product_key, device_name, random,sign,signMethod};
    mbtk_imqtt_http_dynreg_sign(product_key,product_secret,device_name,random,sign);

    sprintf(content, "productKey=%s&deviceName=%s&random=%s&sign=%s&signMethod=%s",
                    product_key, device_name, random, sign, MBTK_MQTT_HTTP_SIGN_METHOD_HMACSHA256);

    memset(mbtk_mqtt_http_url, 0, sizeof(mbtk_mqtt_http_url));
    sprintf(mbtk_mqtt_http_url, "https://%s:443/auth/register/device", http_host[host]);

    memset(mbtk_mqtt_http_content, 0, sizeof(mbtk_mqtt_http_content));
    memcpy(mbtk_mqtt_http_content, content, strlen(content));

    printf("mbtk_mqtt_http_url:%s\n", mbtk_mqtt_http_url);
    printf("mbtk_mqtt_http_content:%s\n", mbtk_mqtt_http_content);

    return 0;
}

void mbtk_mqt_http_device_secret_response(void *data,int data_len)
{
    if(data != NULL && data_len != 0)
    {
        char* ptr_start = NULL;
        char* ptr_end = NULL;
        char fac[64] = {'\0'};
        ptr_start = strstr(data, "deviceSecret");
        if(ptr_start != NULL)
        {
            ptr_end = strstr(ptr_start, "\",");
            if(ptr_end != NULL)
            {
                strncpy(Device_Secret, ptr_start + 15, ptr_end - ptr_start - 15);
                printf("device_secret:%s\n", Device_Secret);
            }
            printf("ptr_start:%s,\n ptr_end:%s\n", ptr_start, ptr_end);
        }

    }

	return;
}


static void mbtk_mqtt_http_data_cb_func(
    int session_id, mbtk_http_data_type_enum type,
    void *data,int data_len)
{
    if(type == MBTK_HTTP_DATA_HEADER) {
        printf("Header(%d):%s\n",data_len,(char*)data);
        mbtk_mqt_http_device_secret_response((char*)data, data_len);
    } else if(type == MBTK_HTTP_DATA_CONTENT) {
        printf("Data(%d):%s\n",data_len,(char*)data);
        mbtk_mqt_http_device_secret_response((char*)data, data_len);
    } else {
        printf(">>>>>Complete<<<<<\n");
    }
}

int mbtk_aliyun_mqtt_one_type_one_secret_regint_get_info(mbtk_mqtt_device_session_t *mbtk_mqtt_device_t)
{
    printf("mbtk_mqtt_http_request    1111111");
    char product_key[255] = {0};
    char product_secret[255] = {0};
    char device_name[255] = {0};

    int http_handle = mbtk_http_handle_get(TRUE, mbtk_mqtt_http_data_cb_func);
    if(http_handle < 0)
    {
        printf("mbtk_http_handle_get() fail.");
        return -1;
    }

    int http_session = mbtk_http_session_create(http_handle,HTTP_OPTION_POST,HTTP_VERSION_1_1);
    if(http_handle < 0)
    {
        printf("mbtk_http_session_create() fail.");
        return -1;
    }

//    mbtk_http_session_option_reset(http_handle, http_session , HTTP_OPTION_HEAD_ONLY);
//    mbtk_http_session_option_reset(http_handle, http_session , HTTP_OPTION_POST);

    memcpy(product_key, mbtk_mqtt_device_t->product_key, strlen(mbtk_mqtt_device_t->product_key));
    memcpy(product_secret, mbtk_mqtt_device_t->product_secret, strlen(mbtk_mqtt_device_t->product_secret));
    memcpy(device_name, mbtk_mqtt_device_t->device_name, strlen(mbtk_mqtt_device_t->device_name));

    mbtk_imqtt_send_post_request(product_key, product_secret,device_name, 0);

    if(mbtk_http_session_url_set(http_handle, http_session, mbtk_mqtt_http_url)) {
        printf("mbtk_http_session_url_set() fail.\n");
        return -1;
    }

    const mbtk_http_session_t* session = mbtk_http_session_get(http_handle, http_session);
    printf("HTTP:%d,%s,%d,%s\n",session->option,session->host,session->port,session->uri);

    char *header = "Accept: text/xml,text/javascript,text/html,application/json\r\n" \
                          "Content-Type: application/x-www-form-urlencoded\r\n";


    mbtk_http_session_head_add(http_handle, http_session, "Accept", "text/xml,text/javascript,text/html,application/json");

    mbtk_http_session_head_add(http_handle, http_session, "Content-Type", "application/x-www-form-urlencoded");

    mbtk_http_session_content_set(http_handle, http_session, mbtk_mqtt_http_content, strlen(mbtk_mqtt_http_content) );

//    mbtk_http_session_option_reset(http_handle, http_session , HTTP_OPTION_HEAD_ONLY);
//    mbtk_http_session_option_reset(http_handle, http_session , HTTP_OPTION_POST);

    memset(Device_Secret, 0, sizeof(Device_Secret));
    if(mbtk_http_session_start(http_handle, http_session)) {
        printf("mbtk_http_session_start() fail.\n");
        return -1;
    }

    if(mbtk_http_handle_free(http_handle))
    {
        printf("mbtk_http_handle_free() fail.");
        return -1;
    }

    if(strlen(Device_Secret ) > 0)
    {
        printf("\nstrlen(Device_Secret :%d\n )", strlen(Device_Secret ));
        memcpy(mbtk_mqtt_device_t->device_secret,Device_Secret, strlen(Device_Secret) );
    }else{
        printf("get Device_Secret fail\n");
        return -1;
    }

    printf("MBTK_HTTP exit.");
    return 0;

}


void mbtk_aliyun_mqtt_get_connect_para(char *password,char *cliendid,char *username, mbtk_mqtt_device_session_t *mbtk_mqtt_device_t)
{
  /*********password.mqttClientId.user_name *************/
    char content[MBTK_IMQTT_PASSWORD_LEN] = {0};

    printf("mbtk_mqtt_device_t->device_name: %s\n", mbtk_mqtt_device_t->device_name);
    printf("mbtk_mqtt_device_t->product_key: %s\n", mbtk_mqtt_device_t->product_key);
    printf("mbtk_mqtt_device_t->product_secret: %s\n", mbtk_mqtt_device_t->product_secret);

    sprintf(content,"deviceName%sproductKey%srandom123",mbtk_mqtt_device_t->device_name,mbtk_mqtt_device_t->product_key);
    core_hmac_sha1((const char*)content,strlen((const char*)content),(char *)password,mbtk_mqtt_device_t->product_secret,strlen(mbtk_mqtt_device_t->product_secret));


//    snprintf((char *)cliendid,MBTK_IMQTT_CLIENT_ID_LEN,"%s|securemode=-2,authType=regnwl,random=123,signmethod=hmacsha1,instanceId=%s|",mbtk_mqtt_device_t->device_name,"iot-06z00ag5qidat54");

    snprintf((char *)cliendid,MBTK_IMQTT_CLIENT_ID_LEN,"%s|securemode=-2,authType=regnwl,random=123,signmethod=hmacsha1|",mbtk_mqtt_device_t->device_name);
    snprintf((char *)username,MBTK_IMQTT_USER_NAME_LEN,"%s&%s",mbtk_mqtt_device_t->device_name,mbtk_mqtt_device_t->product_key);
}


void mbtk_imqtt_auth_hostname(char *dest, char *product_key, int host)
{
//  char *host = "&product_key.iot-as-mqtt.cn-shanghai.aliyuncs.com";
    int8_t      public_instance = 1;

    snprintf(dest, 100, "%s.%s", product_key, mqtt_url[host]);
}


void mbtk_imqtt_auth_clientid(char *dest,char *product_key, char *device_name)
{
//	char *clientid = "gyj01ZAd7HF.MATT1|securemode=3,signmethod=hmacsha256,timestamp=1647830635443|";

    sprintf(dest, "%s.%s|securemode=3,signmethod=hmacsha256,timestamp=%s|", product_key,device_name,CORE_AUTH_TIMESTAMP);
}

void mbtk_imqtt_auth_clientid_yixinyimi_unregin(char *dest,char *client_id)
{
//	char *clientid = "client_id|securemode=-2,authType=connwl|";

    sprintf(dest, "%s|securemode=-2,authType=connwl|", client_id);

}


void mbtk_aliyun_imqtt_auth_clientid(char *dest, char *product_key, char *device_name)
{

    sprintf(dest, "%s.%s|timestamp=%s,_ss=1,_v=%s,securemode=2,signmethod=hmacsha256,ext=3|", product_key,device_name,CORE_AUTH_TIMESTAMP,CORE_AUTH_SDK_VERSION);

    //instanceId 实例id
//    sprintf(dest, "%s.%s|timestamp=%s,_ss=1,_v=%s,securemode=2,signmethod=hmacsha256,ext=3,instanceId=%s|", product_key,device_name,CORE_AUTH_TIMESTAMP,CORE_AUTH_SDK_VERSION,"iot-06z00ag5qidat54");
}


void mbtk_imqtt_auth_username(char *dest,char *device_name, char *product_key)
{
	//data.username.cstring="$deviceName&$productKey";

    snprintf(dest,128, "%s&%s", device_name, product_key );
}

void mbtk_imqtt_auth_password(char *dest, char *device_name, char *product_key, char *device_secret)
{
//	> data.password.cstring=hmacsha1($deviceSecret,$content);
//	$content为productKey，deviceName,timestamp,clientId按照手母顺序排序，然后将参数值依次拼接例如


    char content[300] = {0};
    uint8_t source_temp[65]={0};
    sprintf(content,"clientId%s.%sdeviceName%sproductKey%stimestamp%s",product_key, device_name, device_name, product_key,CORE_AUTH_TIMESTAMP);
	
//    sprintf(content,"clientId%sdeviceName%sproductKey%stimestamp%s",client_id, device_name, product_key,CORE_AUTH_TIMESTAMP);
    core_hmac_sha256((uint8_t *)content, strlen((const char *)content), (uint8_t *)device_secret, strlen(device_secret),
                      source_temp);
		  
    core_hex2str(source_temp, 32, dest,0);
}

void iot_aliyun_mqtt_init(Cloud_MQTT_t *piot_mqtt,int host,int port ,char *device_name,char *product_key, 
		char * DeviceSecret,int keepAliveInterval,int version,char *sub_topic,char *pub_topic,pMessageArrived_Fun mqtt_data_rx_cb) 
{
    mbtk_imqtt_auth_hostname(piot_mqtt->mqtt_host,product_key,host);
    mbtk_imqtt_auth_clientid(piot_mqtt->mqtt_client_id,product_key,device_name);
    mbtk_imqtt_auth_username(piot_mqtt->mqtt_user,device_name,product_key);
    mbtk_imqtt_auth_password(piot_mqtt->mqtt_pass,device_name,product_key,DeviceSecret);
    piot_mqtt->mqtt_port = port;
    piot_mqtt->keepAliveInterval = keepAliveInterval;
    //    piot_mqtt->mqtt_version = version;
    piot_mqtt->mqtt_version = 3;

    printf("mqtt_host is %s\nmqtt_port is %d\nmqtt_client_id is %s\nmqtt_user is %s\nmqtt_pass is %s\n",piot_mqtt->mqtt_host,piot_mqtt->mqtt_port,piot_mqtt->mqtt_client_id,piot_mqtt->mqtt_user,piot_mqtt->mqtt_pass);
    memset(piot_mqtt->sub_topic, '\0', MQTT_TOPIC_SIZE);
    memset(piot_mqtt->pub_topic, '\0', MQTT_TOPIC_SIZE);
    
    sprintf(piot_mqtt->sub_topic, "%s", sub_topic);	//将初始化好的订阅主题填到数组中
    printf("subscribe:%s\n", piot_mqtt->sub_topic);

    sprintf(piot_mqtt->pub_topic, "%s", pub_topic);	//将初始化好的发布主题填到数组中
    printf("pub:%s\n", piot_mqtt->pub_topic);
    
    piot_mqtt->DataArrived_Cb = mqtt_data_rx_cb;		//设置接收到数据回调函数
    printf("iot_mqtt_init end\n");
}

void mbtk_aliyun_mqtt_one_type_one_secret_unregin_set_info_init(Cloud_MQTT_t *piot_mqtt,mbtk_mqtt_device_session_t *device,int keepAliveInterval,int version,pMessageArrived_Fun mqtt_data_rx_cb) 
{

    mbtk_imqtt_auth_hostname(piot_mqtt->mqtt_host,device->product_key,device->host);
    mbtk_aliyun_mqtt_get_connect_para(piot_mqtt->mqtt_pass, piot_mqtt->mqtt_client_id, piot_mqtt->mqtt_user, device);

    piot_mqtt->mqtt_port = device->port;
    piot_mqtt->keepAliveInterval = keepAliveInterval;
    piot_mqtt->mqtt_version = version;

    printf("mqtt_host is %s\nmqtt_port is %d\nmqtt_client_id is %s\nmqtt_user is %s\nmqtt_pass is %s\n",piot_mqtt->mqtt_host,piot_mqtt->mqtt_port,piot_mqtt->mqtt_client_id,piot_mqtt->mqtt_user,piot_mqtt->mqtt_pass);
    printf("piot_mqtt->mqtt_version:%d\n", piot_mqtt->mqtt_version);
    memset(piot_mqtt->sub_topic, '\0', MQTT_TOPIC_SIZE);
    memset(piot_mqtt->pub_topic, '\0', MQTT_TOPIC_SIZE);
    
    piot_mqtt->DataArrived_Cb = mqtt_data_rx_cb;		//设置接收到数据回调函数
    printf("iot_mqtt_init end\n");
}

int mbtk_aliyun_mqtt_one_type_one_secret_unregin_get_regin_info(char *clientId, char *deviceToken)
{
    int ret = 0;
    if(strlen(regnwl_info.deviceToken) > 5)
    {
        memcpy(clientId, regnwl_info.clientId, strlen(regnwl_info.clientId));
        memcpy(deviceToken, regnwl_info.deviceToken , strlen(regnwl_info.deviceToken));
    }else{
        ret=  -1;
    }

    printf("regnwl_info.clientId:%s\n", regnwl_info.clientId);
    printf("regn->deviceToken:%s\n", regnwl_info.deviceToken);
    return ret;
}


void iot_aliyun_mqtt_one_type_one_secret_unregin_connect_init(Cloud_MQTT_t *piot_mqtt,mbtk_mqtt_device_session_t *device, char *clientId, char *deviceToken,
         int keepAliveInterval,int version,char *sub_topic,char *pub_topic,pMessageArrived_Fun mqtt_data_rx_cb) 
{
    mbtk_imqtt_auth_hostname(piot_mqtt->mqtt_host,device->product_key,device->host);
    mbtk_imqtt_auth_clientid_yixinyimi_unregin(piot_mqtt->mqtt_client_id, clientId);
    mbtk_imqtt_auth_username(piot_mqtt->mqtt_user,device->device_name,device->product_key);
    sprintf(piot_mqtt->mqtt_pass, "%s", deviceToken);
    piot_mqtt->mqtt_port = device->port;
    piot_mqtt->keepAliveInterval = keepAliveInterval;
    //    piot_mqtt->mqtt_version = version;
    piot_mqtt->mqtt_version = 3;

    printf("mqtt_host is %s\nmqtt_port is %d\nmqtt_client_id is %s\nmqtt_user is %s\nmqtt_pass is %s\n",piot_mqtt->mqtt_host,piot_mqtt->mqtt_port,piot_mqtt->mqtt_client_id,piot_mqtt->mqtt_user,piot_mqtt->mqtt_pass);
    memset(piot_mqtt->sub_topic, '\0', MQTT_TOPIC_SIZE);
    memset(piot_mqtt->pub_topic, '\0', MQTT_TOPIC_SIZE);
    
    sprintf(piot_mqtt->sub_topic, "%s", sub_topic);	//将初始化好的订阅主题填到数组中
    printf("subscribe:%s\n", piot_mqtt->sub_topic);

    sprintf(piot_mqtt->pub_topic, "%s", pub_topic);	//将初始化好的发布主题填到数组中
    printf("pub:%s\n", piot_mqtt->pub_topic);
    
    piot_mqtt->DataArrived_Cb = mqtt_data_rx_cb;		//设置接收到数据回调函数
    printf("iot_mqtt_init end\n");
}


void mbtk_aliyun_mqtt_one_type_one_secret_regint_connect_init(Cloud_MQTT_t *piot_mqtt,int host,int port ,char *device_name,char *product_key, 
		char * DeviceSecret,int keepAliveInterval,int version,char *sub_topic,char *pub_topic,pMessageArrived_Fun mqtt_data_rx_cb) 
{
    mbtk_imqtt_auth_hostname(piot_mqtt->mqtt_host,product_key,host);
    mbtk_aliyun_imqtt_auth_clientid(piot_mqtt->mqtt_client_id,product_key,device_name);
    mbtk_imqtt_auth_username(piot_mqtt->mqtt_user,device_name,product_key);
    mbtk_imqtt_auth_password(piot_mqtt->mqtt_pass,device_name,product_key,DeviceSecret);
    piot_mqtt->mqtt_port = port;
    piot_mqtt->keepAliveInterval = keepAliveInterval;
    //    piot_mqtt->mqtt_version = version;
    piot_mqtt->mqtt_version = 3;

    printf("mqtt_host is %s\nmqtt_port is %d\nmqtt_client_id is %s\nmqtt_user is %s\nmqtt_pass is %s\n",piot_mqtt->mqtt_host,piot_mqtt->mqtt_port,piot_mqtt->mqtt_client_id,piot_mqtt->mqtt_user,piot_mqtt->mqtt_pass);
    memset(piot_mqtt->sub_topic, '\0', MQTT_TOPIC_SIZE);
    memset(piot_mqtt->pub_topic, '\0', MQTT_TOPIC_SIZE);
    
    sprintf(piot_mqtt->sub_topic, "%s", sub_topic);	//将初始化好的订阅主题填到数组中
    printf("subscribe:%s\n", piot_mqtt->sub_topic);

    sprintf(piot_mqtt->pub_topic, "%s", pub_topic);	//将初始化好的发布主题填到数组中
    printf("pub:%s\n", piot_mqtt->pub_topic);
    
    piot_mqtt->DataArrived_Cb = mqtt_data_rx_cb;		//设置接收到数据回调函数
    printf("iot_mqtt_init end\n");
}


void iot_mqtt_init(Cloud_MQTT_t *piot_mqtt,char *host,int port ,char *clientid,char *user,char *pass,int keepAliveInterval,int version,char *sub_topic,char *pub_topic,pMessageArrived_Fun mqtt_data_rx_cb) 
{

    memcpy(piot_mqtt->mqtt_host,host,strlen(host));
    memcpy(piot_mqtt->mqtt_client_id,clientid,strlen(clientid));
    memcpy(piot_mqtt->mqtt_user,user,strlen(user));
    memcpy(piot_mqtt->mqtt_pass,pass,strlen(pass));
    piot_mqtt->mqtt_port = port;
    piot_mqtt->keepAliveInterval = keepAliveInterval;
    piot_mqtt->mqtt_version = version;

    
    printf("mqtt_host is %s\nmqtt_port is %d\nmqtt_client_id is %s\nmqtt_user is %s\nmqtt_pass is %s\n",piot_mqtt->mqtt_host,piot_mqtt->mqtt_port,piot_mqtt->mqtt_client_id,piot_mqtt->mqtt_user,piot_mqtt->mqtt_pass);
    memset(piot_mqtt->sub_topic, '\0', MQTT_TOPIC_SIZE);
    memset(piot_mqtt->pub_topic, '\0', MQTT_TOPIC_SIZE);
    
    sprintf(piot_mqtt->sub_topic, "%s", sub_topic);	//将初始化好的订阅主题填到数组中
    printf("subscribe:%s\n", piot_mqtt->sub_topic);

    sprintf(piot_mqtt->pub_topic, "%s", pub_topic);	//将初始化好的发布主题填到数组中
    printf("pub:%s\n", piot_mqtt->pub_topic);
    
    piot_mqtt->DataArrived_Cb = mqtt_data_rx_cb;		//设置接收到数据回调函数
    printf("iot_mqtt_init end\n");
}
/*
void MQTTMessageArrived_Cb(MessageData* md)
{
    MQTTMessage *message = md->message; 

    Cloud_MQTT_t *piot_mqtt = get_mqtt_t();

    if (NULL != piot_mqtt->DataArrived_Cb) {
        piot_mqtt->DataArrived_Cb((void *)message->payload, message->payloadlen);//异步消息体
    }
}
*/

int mbtk_aliyun_mqtt_one_type_one_secret_unregin_device_connect(Cloud_MQTT_t *piot_mqtt)
{
    int rc = 0, ret = 0;
    Network* network = (Network*)malloc(sizeof(Network));
    memset(network ,0x0, sizeof(Network));
    NewNetwork(network);
    piot_mqtt->network = network;

    printf("topic = %s\n", piot_mqtt->sub_topic);
//    set_mqtt_t(piot_mqtt);
    piot_mqtt->network->is_support_ssl = 1;
    printf("23131mqtt_host is %s\nmqtt_port is %d\nmqtt_client_id is %s\nmqtt_user is %s\nmqtt_pass is %s\n",piot_mqtt->mqtt_host,piot_mqtt->mqtt_port,piot_mqtt->mqtt_client_id,piot_mqtt->mqtt_user,piot_mqtt->mqtt_pass);
    rc = ConnectNetwork(piot_mqtt->network, piot_mqtt->mqtt_host, piot_mqtt->mqtt_port,piot_mqtt->network->is_support_ssl,piot_mqtt->network->ingnore_cert);
    if (rc != 0) {
        ret = -101;
        goto __END;
    }
    MQTTClient(&piot_mqtt->Client, piot_mqtt->network, 1000*30, piot_mqtt->mqtt_buffer, MQTT_BUF_SIZE, piot_mqtt->mqtt_read_buffer, MQTT_BUF_SIZE);
    MQTTPacket_connectData data = MQTTPacket_connectData_initializer;

    data.MQTTVersion = piot_mqtt->mqtt_version;
    data.clientID.cstring = piot_mqtt->mqtt_client_id;
    data.username.cstring = piot_mqtt->mqtt_user;
    data.password.cstring = piot_mqtt->mqtt_pass;
    data.keepAliveInterval = piot_mqtt->keepAliveInterval;
    data.willFlag = 0;
    data.will.qos = 0;
    data.will.retained     =                    0;
    data.will.topicName.cstring =            NULL;
    data.will.message.cstring   =            NULL;

    data.cleansession = 1;
    rc = MQTTConnect(&piot_mqtt->Client, &data);
    if (rc) {
        printf("mqtt connect broker fail \n");
        printf("rc = %d\n", rc);
        ret = -102;
        goto __END;
    }
__END:
    return ret;
}

int mqtt_device_connect(Cloud_MQTT_t *piot_mqtt)
{
    int rc = 0, ret = 0;
    Network* network = (Network*)malloc(sizeof(Network));
    memset(network ,0x0, sizeof(Network));
    NewNetwork(network);
    piot_mqtt->network = network;

    printf("topic = %s\n", piot_mqtt->sub_topic);
//    set_mqtt_t(piot_mqtt);
    printf("23131mqtt_host is %s\nmqtt_port is %d\nmqtt_client_id is %s\nmqtt_user is %s\nmqtt_pass is %s\n",piot_mqtt->mqtt_host,piot_mqtt->mqtt_port,piot_mqtt->mqtt_client_id,piot_mqtt->mqtt_user,piot_mqtt->mqtt_pass);
    rc = ConnectNetwork(piot_mqtt->network, piot_mqtt->mqtt_host, piot_mqtt->mqtt_port,piot_mqtt->network->is_support_ssl,piot_mqtt->network->ingnore_cert);
    if (rc != 0) {
        ret = -101;
        goto __END;
    }
    MQTTClient(&piot_mqtt->Client, piot_mqtt->network, 1000, piot_mqtt->mqtt_buffer, MQTT_BUF_SIZE, piot_mqtt->mqtt_read_buffer, MQTT_BUF_SIZE);
    MQTTPacket_connectData data = MQTTPacket_connectData_initializer;

    if (piot_mqtt->willFlag) {
        data.willFlag = 1;
        memcpy(&data.will, &piot_mqtt->will, sizeof(MQTTPacket_willOptions));
    } else {
        data.willFlag = 0;
    }
    data.MQTTVersion = piot_mqtt->mqtt_version;
    data.clientID.cstring = piot_mqtt->mqtt_client_id;
    data.username.cstring = piot_mqtt->mqtt_user;
    data.password.cstring = piot_mqtt->mqtt_pass;
    data.keepAliveInterval = piot_mqtt->keepAliveInterval;
    data.cleansession = 1;
    rc = MQTTConnect(&piot_mqtt->Client, &data);
    if (rc) {
        printf("mqtt connect broker fail \n");
        printf("rc = %d\n", rc);
        ret = -102;
        goto __END;
    }
__END:
    return ret;
}

int mqtt_device_disconnect(Cloud_MQTT_t *piot_mqtt)//断开mqtt连接
{
    int ret = 0;

    ret = MQTTDisconnect(&piot_mqtt->Client,piot_mqtt->network);
    printf("disconnectNetwork ret = %d\n", ret);

    return ret;
}

void iot_yield(Cloud_MQTT_t *piot_mqtt,iot_device_info_t *gateway)
{
    int ret;
    switch (gateway->iotstatus) {
        case IOT_STATUS_LOGIN:
        ret = mqtt_device_connect(piot_mqtt);
        if (ret < 0) {
            printf("iot connect error code %d\n", ret);
            sleep(1);
        }
        break;
        case IOT_STATUS_CONNECT:
        ret = MQTTYield(&piot_mqtt->Client, 200);
        //printf("iot_yield ret %d\n",ret);
        if (ret != SUCCESS) {
            printf("why???\n");
            gateway->iotstatus = IOT_STATUS_DROP;
        }
        break;
        case IOT_STATUS_DROP:
        mqtt_device_disconnect(piot_mqtt);
        //gateway.iotstatus = IOT_STATUS_LOGIN;
        usleep(1000);
        break;
        default:
        break;
    }
}

int mqtt_will_msg_set(Cloud_MQTT_t *piot_mqtt, char *pbuf, int len)//设置遗嘱函数
{
    memset(piot_mqtt->will_topic, '\0', MQTT_TOPIC_SIZE);
    MQTTPacket_willOptions mqtt_will = MQTTPacket_willOptions_initializer;

    strcpy(piot_mqtt->will_topic, piot_mqtt->pub_topic);
    memcpy(&piot_mqtt->will, &mqtt_will, sizeof(MQTTPacket_willOptions));

    piot_mqtt->willFlag = 1;
    piot_mqtt->will.retained = 0;
    piot_mqtt->will.topicName.cstring = (char *)piot_mqtt->will_topic;
    piot_mqtt->will.message.cstring = (char *)pbuf;
    piot_mqtt->will.qos = QOS2;
    return 0;

}

int mbtk_MQTTSubscribe(Client* c, const char* topicFilter, enum QoS qos, messageHandler messageHandler)
{
    return MQTTSubscribe(c, topicFilter, qos, messageHandler);
}
int mbtk_MQTTUnsubscribe(Client* c, const char* topicFilter)
{
    return MQTTUnsubscribe(c,topicFilter);
}
/*
int mbtk_MQTTPublish(Client* c, const char* topicName, MQTTMessage* message)
{
    return MQTTPublish(c,topicName,message);
}
*/
int mbtk_MQTTPublish(char *pbuf, int len, char retain,Client* c,const char* pub_topic,enum QoS qos,char dup)
{
    int ret = 0;
    MQTTMessage message;
    char my_topic[128] = {0};

    strcpy(my_topic, pub_topic);

    message.payload = (void *)pbuf;
    message.payloadlen = len;
    message.dup = dup;
    message.qos = qos;
    if (retain) {
        message.retained = 1;
    } else {
        message.retained = 0;
    }

    ret = MQTTPublish(c, my_topic, &message);	//发布一个主题

    return ret;
}

