#include "lynq-qser-fota.h"
#include "mbtk_type.h"
#include "mbtk_fota.h"


char addr_buf[128]={0};
int segment_size =0;


int Process_flag = 0;


int fota_cb(int status, int percent)
{
//    printf("%d: percent: %d%%\n", percent/10, percent);
    Process_flag = percent/10;
    return 0;
}

int lynq_read_process(void)
{
    return Process_flag;
}

int lynq_rock_main(int first_run)
{
    UNUSED(first_run);
    printf("%s, %d", __FUNCTION__, __LINE__);
    int ret = 0;

    printf("addr_buf:%s, segment_size:%d\n", addr_buf, segment_size);
    ret = mbtk_fota_init(fota_cb);
    if(!strcmp(addr_buf, "http"))
    {
    
        ret = mbtk_fota_fw_write_by_url(addr_buf, segment_size,10, 600);
    }
    else
    {
        ret =mbtk_fota_fw_write(addr_buf, segment_size);
    }

    if(ret)
    {
        printf("lynq_rock_main fail\n");
        return -1;
    }

    mbtk_fota_done1(1);


    return 0;
}

int lynq_fota_set_addr_value(char *value,int size)
{
    UNUSED(value);
    UNUSED(size);
    printf("111%s, %d", __FUNCTION__, __LINE__);

    if(value == NULL)
    {
        return -1;
    }

    memset(addr_buf, 0, sizeof(addr_buf));
    memcpy(addr_buf, value, strlen(value));
    segment_size = size;

    printf("addr_buf:%s, value:%s\n", addr_buf, value);
    printf("segment_size:%d, size:%d\n", segment_size, size);

    return 0;
}

int lynq_fota_nrestart(void)
{
    printf("%s, %d", __FUNCTION__, __LINE__);
    int ret = 0;

    ret = mbtk_fota_init(fota_cb);
    if(!strcmp(addr_buf, "http"))
    {
        ret = mbtk_fota_fw_write_by_url(addr_buf, segment_size,10, 600);
    }
    else
    {
        ret =mbtk_fota_fw_write(addr_buf, segment_size);
    }

    if(ret)
    {
        printf("lynq_fota_nrestart fail\n");
        return -1;
    }

    return 0;
}

int lynq_get_upgrade_status(void)
{
    printf("%s, %d", __FUNCTION__, __LINE__);

    return mbtk_fota_status();
}

int lynq_get_reboot_upgrade_status(void)
{
    return mbtk_fota_get_asr_reboot_cnt_flag();
}

