#include "lynq_systime.h"
#include "mbtk_type.h"
#include <stdlib.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <stdio.h>
#include <errno.h>
#include <netdb.h>
#include <string.h>
#include <unistd.h>
#include <time.h>
#include <netinet/in.h>

#include <cutils/properties.h>
#include <sys/time.h>


#include "mbtk_ntp.h"
#include "mbtk_net_control.h"
#include "lynq_systime.h"
#include "mbtk_type.h"


#define MBTK_AT_NTP_LEN_MAX 128




typedef enum {
    LYNQ_TIME_TYPE_CELL = 0,  //NITZ
    LYNQ_TIME_TYPE_NTP,
    LYNQ_TIME_TYPE_GNSS,
    LYNQ_TIME_TYPE_USER,
    
    LYNQ_TIME_TYPE_UNUSE
} lynq_time_type_enum;

//enable set time from ntp
int ntp_sync_time(int enable); 
//enable set time from nitz
int modem_time_enable(int enable);
//enable set time from gnss
int gnss_time_enable(int enable);
//enable set time from user
int user_set_time(char* date, char* time);
// RTC TIME set to system
int lynq_sync_time_from_rtc(void);
//check sysytem type
int lynq_get_time_src_status (time_src_status_s * time_src);
// system time set to RTC
int lynq_set_rtc_time(void);
// get RTC time
int lynq_get_rtc_time(unsigned long *ulsec);



//int req_time_set(int type, char *time, int *cme_err);
static int metis_strptime(char *str_time)
{
    printf("%s(), str_time:%s\n", __FUNCTION__, str_time);
    struct tm stm;
    char dateTime[30];
    struct timeval tv;
    if(strptime(str_time, "%Y-%m-%d %H:%M:%S",&stm) != NULL)
    {
        time_t _t = mktime(&stm);
        tv.tv_sec = _t;
        if(settimeofday(&tv, NULL)) {
            printf("Set time fail:%d");
            return -1;
        } else {
            printf("Set time to %s.", str_time);
            return 0;
        }
    } else {
        printf("Set time fail.");
        return -1;
    }
    return 0;
}



static void* ntp_pthread_run(int* ntp_flag)
{
    if (mbtk_net_state_get() == MBTK_NET_STATE_OFF) 
    {
        printf("Network is disconnected. Set time fail.");
        if(NULL != ntp_flag)
       {
            *ntp_flag = -1;
       }
        return NULL;
    }
    printf("Network is connected.");

    char time_type[10];
    while(1){
        memset(time_type, 0, 10);
        property_get("persist.mbtk.time_type", time_type, "0");
    	if(atoi(time_type) == LYNQ_TIME_TYPE_NTP) // NTP time
    	{
            char time_str[100] = {0};
            time_t time = 0;
            if((time = (time_t)mbtk_at_systime()) == 0) 
            {
                printf("NTP client fail!\n");
                if(NULL != ntp_flag)
                {
                     *ntp_flag = -1;
                }
                return NULL;
            }
            struct tm *tm_t;
            tm_t = localtime(&time);
            strftime(time_str,128,"%F %T",tm_t);

            // NTP time
            metis_strptime(time_str);
            break;
    	} else {
            break;
    	}

        sleep(64); // Sleep 64s.
    }
    if(NULL != ntp_flag)
    {
         *ntp_flag = 0;
    }
    return NULL;
}

int set_time_user(char* data_time_str)
{

    int ret = 0;
    if(strlen(data_time_str) > 0)
    {
        ret = metis_strptime(data_time_str);
    }

    return ret;
}


//MBTK_TIME_TYPE_CELL = 0,  //NITZ
//MBTK_TIME_TYPE_NTP,
//MBTK_TIME_TYPE_GNSS,
//MBTK_TIME_TYPE_USER
void set_time_type(int mbtk_time_type)
{
    char type_str[10] = {0};
    sprintf(type_str, "%d", mbtk_time_type);
    property_set("persist.mbtk.time_type", type_str);

    return;
}




int ntp_sync_time(int enable)
{
    if(0 != enable && 1 != enable)
    {
        return -1;
    }
    UNUSED(enable);
    int ntp_status = 0;
    if(enable)
    {
        ntp_pthread_run(&ntp_status);
        if(ntp_status == 0)
        {
            set_time_type(LYNQ_TIME_TYPE_NTP);
        }
        else
        {
            set_time_type(LYNQ_TIME_TYPE_UNUSE);
        }
    }
    else
    {
        set_time_type(LYNQ_TIME_TYPE_UNUSE);
    }

    return 0;
}

//enable set time from nitz
int modem_time_enable(int enable)
{
    UNUSED(enable);

    if(enable)
    {
        set_time_type(LYNQ_TIME_TYPE_CELL);
    }
    else
    {
        set_time_type(LYNQ_TIME_TYPE_UNUSE);
    }
    return 0;
}


//enable set time from gnss
int gnss_time_enable(int enable)
{
    UNUSED(enable);
    if(enable)
    {
        set_time_type(LYNQ_TIME_TYPE_GNSS);
    }
    else
    {
        set_time_type(LYNQ_TIME_TYPE_UNUSE);
    }

    return 0;
}


//enable set time from user
int user_set_time(char* date, char* time)
{
    UNUSED(date);
    UNUSED(time);
    if(date == NULL || time == NULL)
    {
        return -1;
    }

    int ret = 0;
    char time_str[128] ={0};
    memset(time_str, 0x0, MBTK_AT_NTP_LEN_MAX);

    char *p = time;
    char *p1 = strstr(p, ":");
    char *p2 = strstr(p1+1, ":");
    if(p2 == NULL)
    {
        sprintf(time_str, "%s %s:00", date, time);  //2023-11-30 11:30
        set_time_type(LYNQ_TIME_TYPE_USER);
        ret = set_time_user(time_str);
    }else
    {
        sprintf(time_str, "%s %s", date, time); //2023-11-30 11:30:31
        set_time_type(LYNQ_TIME_TYPE_USER);
        ret = set_time_user(time_str);
    }

    return ret;
}


//check sysytem type
int lynq_get_time_src_status (time_src_status_s * time_src)
{
    UNUSED(time_src);
    int type = 0;
    char time_type[] ={0};
    property_get("persist.mbtk.time_type", time_type, "0");

    type = atoi(time_type);
    printf("time_type :%d", type);
    if(type == LYNQ_TIME_TYPE_NTP)
    {
        time_src->ntp = 1;
        time_src->nitz = 0;
        time_src->gnss = 0;
    }
    else if(type == LYNQ_TIME_TYPE_CELL)
    {
        time_src->ntp = 0;
        time_src->nitz = 1;
        time_src->gnss = 0;
    }
    else if(type == LYNQ_TIME_TYPE_GNSS)
    {
        time_src->ntp = 0;
        time_src->nitz = 0;
        time_src->gnss = 1;
    }
    else if(type == LYNQ_TIME_TYPE_UNUSE)
    {
        time_src->ntp = 0;
        time_src->nitz = 0;
        time_src->gnss = 0;
    }

    return 0;
}

// RTC TIME set to system
int lynq_sync_time_from_rtc(void)
{
    system("hwclock --hctosys");
    return 0;
}

// system time set to RTC
int lynq_set_rtc_time(void)
{
//    system("hwclock --systohc");
    system("hwclock -w rtc0");
    return 0;
}

int lynq_get_rtc_time(unsigned long *ulsec)
{
    UNUSED(ulsec);

    return 0;
}


