#include "lynq-qser-voice.h"
#include "mbtk_type.h"
#include "mbtk_info_api.h"
#include "mbtk_audio.h"
#include "mbtk_log.h"


static mbtk_info_handle_t* call_info_handle = NULL;
static int level_call = 0;

char* phone_num_t = NULL;
int state_t = 0;
int call_id_t = 0;

QSER_VoiceCall_StateHandlerFunc_t lynq_call_func_cb_handle;


voice_client_handle_type g_call_val = -1;


void call_state_change_cb(const void* data, int data_len)
{
    mbtk_call_info_t *reg = (mbtk_call_info_t *)data;
    switch (reg->call_wait)
    {
        case MBTK_CLCC:
            {
				LOGI("RING : %d, %d, %d, %d, %d, %s, %d", reg->dir1, reg->dir, reg->state, reg->mode, reg->mpty, reg->phone_number, reg->type);
				phone_num_t = reg->phone_number;
                switch
(reg->state)
                {
                    case 0:
                        state_t = E_QSER_VOICE_CALL_STATE_ACTIVE;
                        break;
                    case 1:
                        state_t = E_QSER_VOICE_CALL_STATE_HOLDING;
                        break;
                    case 2:
                        state_t = E_QSER_VOICE_CALL_STATE_DIALING;
                        break;
                    case 3:
                        state_t = E_QSER_VOICE_CALL_STATE_ALERTING;
                        break;
                    case 4:
                        state_t = E_QSER_VOICE_CALL_STATE_INCOMING;
                        break;
                    case 5:
                        state_t = E_QSER_VOICE_CALL_STATE_WAITING;
                        break;
                    case 6:
                        state_t = E_QSER_VOICE_CALL_STATE_END;
                        break;
                }
				state_t = reg->state;
                call_id_t = reg->dir1;
				
				lynq_call_func_cb_handle(call_id_t, phone_num_t, state_t, NULL);
            }
			break;
        case MBTK_DISCONNECTED:
            {
				LOGI("RING : call dis connected!");
				state_t = E_QSER_VOICE_CALL_STATE_END;
				lynq_call_func_cb_handle(call_id_t, phone_num_t, state_t, NULL);
            }
			break;
        case MBTK_CPAS:
            LOGI("CALL : Call state = %d", reg->pas);
			switch (reg->pas)
			{
                case MBTK_CALL_RADY:
                    LOGI("CALL: call READY");
                    break;
                case MBTK_CALL_UNAVAILABLE:
                    LOGI("CALL: call unavaliable");
                    break;
                case MBTK_CALL_UNKNOWN:
                    LOGI("CALL: call unknown");
                    break;
                case MBTK_CALL_RINGING:
                    LOGI("CALL: call ringing");
                    break;
                case MBTK_CALL_PROGRESS:
                    LOGI("CALL: call progress");
                    break;
                case MBTK_CALL_ASLEEP:
                    LOGI("CALL: call asleep");
                    break;
                case MBTK_CALL_ACTIVE:
                    LOGI("CALL: call active");
                    break;
                default:
                    //printf("\r\n");
                    break;
			}
            break;
        default:
            LOGI("RING : None call_wait = %d", reg->call_wait);
            break;
    }

}

int qser_voice_call_client_init(voice_client_handle_type *ph_voice)
{
    //UNUSED(ph_voice);

    int err;
    uint32 handler = 0;

    if(call_info_handle == NULL)
    {
        call_info_handle = mbtk_info_handle_get();
        if(call_info_handle)
        {
            LOGI("creat qser_voice_call_client_init is success");
            *ph_voice = call_info_handle->client_fd;
            g_call_val = call_info_handle->client_fd;
        }
        else
        {
            LOGE("creat qser_voice_call_client_init is fail");
            return -1;
        }
    }
#if 0
    //对声音调节部分使用ubus初始化
    err = mbtk_audio_ubus_client_init(&handler, NULL);
    if(err)
    {
        printf("Error audio : %d\n", err);
        return -1;
    }
    else
    {
        printf("speech init success.\n");
    }
#endif
    return 0;
}

int qser_voice_call_client_deinit(voice_client_handle_type h_voice)
{
    //UNUSED(h_voice);

    int err;
    uint32 handler = 0;

    if (h_voice != g_call_val || g_call_val == -1)
    {
        LOGE("handle NULL");
        return -1;
    }

    if(call_info_handle)
    {
        mbtk_call_hang(call_info_handle);// hang up all
        mbtk_info_handle_free(&call_info_handle);
    }
    else
    {
        LOGE("deinit qser_voice_call_client_deinit is fail");
        return -1;

    }
#if 0
    err = mbtk_audio_ubus_client_deinit(handler);
    if(err)
    {
        printf("Error audio : %d\n", err);
        return -1;
    }
    handler = 0;
#endif
    return 0;
}

int qser_voice_call_start(voice_client_handle_type h_voice,E_QSER_VCALL_ID_T simId,char * phone_number, int *call_id)
{
    //UNUSED(h_voice);
    UNUSED(simId);
    //UNUSED(phone_number);
    UNUSED(call_id);

    char* phone_num_t = NULL;
    int err;

    if (h_voice != g_call_val || g_call_val == -1)
    {
        LOGE("handle NULL");
        return -1;
    }

    if(call_info_handle == NULL)
    {
        LOGE("qser_voice_call_start call_info_handle NULL");
        return -1;
    }

    if (phone_number == NULL)
    {
        LOGE("qser_voice_call_start phone_number NULL");
        return -1;

    }

    phone_num_t  = phone_number;

    err = mbtk_call_start(call_info_handle, phone_num_t);
    if(err)
    {
        LOGE("Error : %d\n", err);
        return -1;
    }
    else
    {
        LOGI("Call success.");
    }

    return 0;
}

int qser_voice_call_end (voice_client_handle_type h_voice,int call_id)
{
    //UNUSED(h_voice);
    UNUSED(call_id);

    int err;

    if (h_voice != g_call_val || g_call_val == -1)
    {
        LOGE("handle NULL");
        return -1;
    }

    if(call_info_handle == NULL)
    {
        LOGE("qser_voice_call_end call_info_handle NULL");
        return -1;
    }

    // hang up all
    err = mbtk_call_hang(call_info_handle);
    if(err)
    {
        LOGE("Error : %d", err);
        return -1;
    }
    else
    {
        LOGI("Call hang up all.");
    }

    return 0;
}

int qser_voice_call_answer(voice_client_handle_type h_voice,int call_id)
{
    //UNUSED(h_voice);
    UNUSED(call_id);

    int err;

    if (h_voice != g_call_val || g_call_val == -1)
    {
        LOGE("handle NULL");
        return -1;
    }

    if(call_info_handle == NULL)
    {
        LOGE("qser_voice_call_anser call_info_handle NULL");
        return -1;
    }

    err = mbtk_call_answer(call_info_handle);
    if(err)
    {
        LOGE("Error : %d", err);
        return -1;
    }
    else
    {
        LOGI("Answer success.");
    }

    return 0;
}

int qser_voice_set_dtmf(const char callnum)
{
    int ret = 0;
    int tmp;
    char callnum_c;
    mbtk_call_dtmf_info_t *dtmf = NULL;

    if(call_info_handle == NULL)
    {
        LOGE("qser_voice_set_dtmf call_info_handle NULL");
        return -1;
    }

    dtmf = (mbtk_call_dtmf_info_t*)malloc(sizeof(mbtk_call_dtmf_info_t));
    memset(dtmf,0x00, sizeof(mbtk_call_dtmf_info_t));

    tmp = (int)callnum;

    callnum_c = callnum;

    if ((tmp >= 48 && tmp <= 57) || (tmp >= 65 && tmp <= 68) || (tmp == 42) ||  (tmp == 35))
    {
        dtmf->duration = 300;
        dtmf->character = callnum_c;

        ret = mbtk_dtmf_send(call_info_handle, dtmf);
        if (ret)
        {
            LOGE("mbtk_dtmf_send Error : %d", ret);
            ret = -1;
            goto err;
        }
    }
    else
    {
        LOGE("qser_voice_set_dtmf callnum demand ERR");
        ret = -1;
        goto err;
    }

err:
    free(dtmf);
    return ret;

}

int qser_voice_call_addstatehandler(voice_client_handle_type h_voice,QSER_VoiceCall_StateHandlerFunc_t handlerPtr,void* contextPtr)
{
    //UNUSED(h_voice);
    //UNUSED(handlerPtr);
    //UNUSED(contextPtr);
    int err;

    if (h_voice != g_call_val || g_call_val == -1)
    {
        LOGE("handle NULL");
        return -1;
    }

    if(call_info_handle == NULL)
    {
        LOGE("qser_voice_call_addstatehandler call_info_handle NULL");
        return -1;
    }

    lynq_call_func_cb_handle = handlerPtr;

    call_id_t = *(int *)contextPtr;
    //printf(">contextPtr = [%d]\n",*(int *)contextPtr);

    err = mbtk_call_state_change_cb_reg(call_info_handle, call_state_change_cb);
    if(err)
    {
        LOGE("Error : %d", err);
        return -1;
    }
    else
    {
        LOGI("add success.");
    }

    return 0;
}

int qser_voice_call_removestatehandle(voice_client_handle_type h_voice)
{
    //UNUSED(h_voice);
    int err;

    if (h_voice != g_call_val || g_call_val == -1)
    {
        LOGE("handle NULL");
        return -1;
    }

    if(call_info_handle == NULL)
    {
        LOGE("qser_voice_call_removestatehandle call_info_handle NULL");
        return -1;
    }

    err = mbtk_call_state_change_cb_reg(call_info_handle, NULL);
    if(err)
    {
        LOGE("Error : %d", err);
        return -1;
    }
    else
    {
        LOGI("remove success.");
    }

    return 0;
}

int qser_voice_set_speech_volume(const int volume)
{
    //UNUSED(volume);
    
#if 0

    if(volume < 0 || volume > 5)
    {
        level_call = 0;
    }
    else
    {
        //支持-36~12
        switch(volume)
        {
            case 0 :
            level_call = -20;
            break;
            case 1 :
            level_call = -14;
            break;
            case 2 :
            level_call = -8;
            break;
            case 3 :
            level_call = 0;
            break;
            case 4 :
            level_call = 5;
            break;
            case 5 :
            level_call = 12;
            break;
            default:
            break;
        }
    }

    mbtk_audio_dsp_set(1, level_call);
    if(err)
    {
        printf("Error : %d\n", err);
        return -1;
    }
    else
    {
        printf("Set success.\n");
    }
#endif

    char cmd[128] = {0};
    int lv = 0;

    memset(cmd ,0x00, sizeof(cmd));

    if(volume < 0 || volume > 5)
    {
        LOGE("Error volume : %d", volume);
        return -1;
    }
    else
    {
        switch(volume)
        {
            case 0 :
                lv = 0;
                break;
            case 1 :
                lv = 20;
                break;
            case 2 :
                lv = 40;
                break;
            case 3 :
                lv = 60;
                break;
            case 4 :
                lv = 80;
                break;
            case 5 :
                lv = 100;
                break;
            default:
                break;
        }
    }
    level_call = volume;

    sprintf(cmd, "ubus call audio_if volume_set \'{\"param0\":%d}\'", lv);
    int err = system(cmd);
    if ((err != -1) || (err != 127))
    {
        LOGI("Set success.");
    }
    else
    {
        LOGE("Error : %d", err);
        return -1;
    }

    return 0;
}

int qser_voice_get_speech_volume(int *volume)
{

    //UNUSED(volume);
#if 0
    int err;

    volume = level_call;
    if(volume < 0 || volume > 5)
    {
        printf("Error : %d\n", volume);
        return -1;
    }
    else
    {
        printf("Get success.\n");
    }
#endif
    int volume_t;

    volume_t = level_call;
    if(volume_t < 0 || volume_t > 5)
    {
        LOGE("Error volume : %d", volume_t);
        return -1;
    }
    else
    {
        *volume = volume_t;
        LOGI("Get success.");
    }

    return 0;
}



