#include <sys/epoll.h>
#include <string.h>

#include "mbtk_log.h"
#include "mbtk_http_base.h"

static void http_sock_cb_func(int handle, int fd, int event);

static bool http_sock_inited = FALSE;
static int http_handle = -1;
static int http_fd = -1;

static void http_sock_cb_func(int handle, int fd, int event)
{
    if(http_handle == handle && http_fd == fd) {
        if(event & EPOLLIN) { // READ

        } else if(event & EPOLLRDHUP) { // Close

        } else {
            LOGW("Unknown event:%x",event);
        }
    }
}

int mbtk_http_init()
{
    if(http_sock_inited) {
        LOGE("HTTP has inited.");
        return -1;
    }

    mbtk_init_info init_info;
    memset(&init_info, 0x0, sizeof(mbtk_init_info));
    init_info.net_type = MBTK_NET_LINUX;
    init_info.sock_cb = http_sock_cb_func;
    http_handle = mbtk_sock_init(&init_info);
    if(http_handle < 0) {
        LOGE("mbtk_sock_init() fail.");
        return -1;
    }

    http_sock_inited = TRUE;
    return 0;
}

int mbtk_http_deinit()
{
    if(!http_sock_inited) {
        LOGE("HTTP not inited.");
        return -1;
    }

    int err = mbtk_sock_deinit(http_handle);
    if(err != MBTK_SOCK_SUCCESS) {
        LOGE("mbtk_sock_deinit() fail.");
        return -1;
    }

    http_handle = -1;
    http_sock_inited = FALSE;
    return 0;
}


int mbtk_http_open
(
    bool is_ssl,
    bool ingnore_cert,
    const void *host,
    uint16 port
)
{
    int err;
    mbtk_sock_info sock_info;
    memset(&sock_info,0x0,sizeof(mbtk_sock_info));

    sock_info.type = MBTK_SOCK_TCP;
    sock_info.is_support_ssl = is_ssl;
    sock_info.ingnore_cert = ingnore_cert;
    memcpy(sock_info.address,host,strlen(host));
    sock_info.port = port;

    http_fd = mbtk_sock_open(http_handle,&sock_info, 3000, &err);

    return http_fd;
}

/*=============================================
FUNCTION
    mbtk_http_read

DESCRIPTION
    read content from socket.

DEPENDENCIES
    None

PARAMETERS
    *buf      Store read content.
    len       the length of Content.
    timeout   Set timeout

RETURN VALUE
    Length of read content

SIDE EFFECTS
    None
=============================================*/
int mbtk_http_read
(
    int sock_fd,
    void *buf,
    uint16 len,
    int timeout_ms
)
{
    int err;
    int read_len = mbtk_sock_read(http_handle, sock_fd, buf, len, timeout_ms, &err);
    if(read_len < 0) {
        if(err == MBTK_SOCK_ETIMEOUT) {
            return -2;
        } else {
            return -1;
        }
    } else {
        return read_len;
    }
}

#if 0
int mbtk_http_read_line
(
    FILE *file,
    void *buf,
    uint16 len
)
{
    if(file) {
        char *buf_ptr = (char*)buf;
        char *line = NULL;
read_again:
        line = fgets(buf_ptr,len,file);
        if(!line && errno == EWOULDBLOCK) {
            usleep(100000);
            goto read_again;
        }
        if(line && strlen(line) > 0
            && strlen(line) <= len
            && buf_ptr[strlen(line) - 1] == '\n') {
            LOGV("Read-Line[%d]:%s",strlen(line),line);
            return strlen(line);
        }else{
            LOGE("fgets() fail.");
            return -1;
        }
    }

    return -1;
}
#else
int mbtk_http_read_line
(
    int sock_fd,
    void *buf,
    uint16 len
)
{
#if 1
    if(sock_fd > 0) {
        char *buf_ptr = (char*)buf;
        char read_buf[1];
        int read_len = 0;
        while(TRUE) {
            if(mbtk_sock_read_sync(http_handle, sock_fd, read_buf, 1) == 1) {
                *buf_ptr++ = read_buf[0];
                read_len++;

                if(read_buf[0] == '\n' || read_len >= len) {
                    return read_len;
                }
            } else {
                return -1;
            }
        }
    }
#else
    if(http_handle >= 0) {
        char *buf_ptr = (char*)buf;
        char read_buf[1];
        int read_len = 0;
        while(TRUE) {
            if(read(http_fd, read_buf, 1) == 1) {
                *buf_ptr++ = read_buf[0];
                read_len++;

                if(read_buf[0] == '\n' || read_len >= len) {
                    return read_len;
                }
            } else {
                if(errno == EWOULDBLOCK) {
                    usleep(100000);
                }
            }
        }
    }

#endif

    return -1;
}

#endif

/*=============================================
FUNCTION
    mbtk_http_write

DESCRIPTION
    Write content to socket.

DEPENDENCIES
    None

PARAMETERS
    *buf    Content to be transferred
    len     the length of Content.

RETURN VALUE
    Length of written content

SIDE EFFECTS
    None
=============================================*/
int mbtk_http_write
(
    int sock_fd,
    void *buf,
    uint16 len
)
{
    int err;
    LOGV("Write[%d]:%s",len,(char*)buf);
    return mbtk_sock_write(http_handle, sock_fd, buf, len, 300, &err);
}

/*=============================================
FUNCTION
    mbtk_http_close

DESCRIPTION
    close HTTP service.

DEPENDENCIES
    None

PARAMETERS
    *err    Error number

RETURN VALUE
    TURE or FALSE

SIDE EFFECTS
    None
=============================================*/
int mbtk_http_close(int sock_fd)
{
    int err;

    if(mbtk_sock_close(http_handle, sock_fd,1000, &err)) {
        return -1;
    }

    sock_fd = -1;
    return 0;
}

