#if 1
#include <stdio.h>
//#include <stdlib.h>
//#include <unistd.h>
#include <errno.h>
#include <pthread.h>
//#include <string.h>
#include <fcntl.h>
//#include <signal.h>

#include "mbtk_log.h"
#include "mbtk_info_api.h"

#define MBTK_RESULT_FAIL -1
#define MBTK_RESULT_SUCCESS 0

typedef enum{
    MBTK_READY_INIT = -1,
    MBTK_READY_SUCCESS,
    MBTK_READY_MODEM_FAIL,
    MBTK_READY_RESPONSE_FAIL,
    MBTK_READY_SOCKET_FAIL,
    MBTK_READY_RIL_FAIL
}mbtk_ready_status_type;
    
static mbtk_ready_status_type mbtk_ready_status = MBTK_READY_INIT;
static mbtk_info_handle_t* mbtk_handle = NULL;
#if 1
static mbtk_ready_status_type modem_check(void)
{
    char imei[16]= {0};
    int cme_err = 0;

    if(mbtk_handle == NULL)
    {
        mbtk_handle = mbtk_info_handle_get();
        if(mbtk_handle == NULL)
        {
            LOGE("[SDK_READY] mbtk_info_handle_get fail.");
            return MBTK_READY_RIL_FAIL;
        }
    }

    mbtk_handle->info_err = 0;
    cme_err = mbtk_imei_get(mbtk_handle, imei);
    //LOGE("[SDK_READY] imei = [%s], cme_err = [%d]", imei, cme_err);
    if(cme_err == 0 && strlen(imei) == 0)
    {
        mbtk_info_handle_free(&mbtk_handle);
        mbtk_handle = NULL;
        return MBTK_READY_RIL_FAIL;
    }
    if(cme_err != 0 || strlen(imei) == 0)
    {
        mbtk_info_handle_free(&mbtk_handle);
        mbtk_handle = NULL;
        return MBTK_READY_MODEM_FAIL;
    }
    return MBTK_READY_SUCCESS;
}
#endif

static void* sdk_ready_check_pthread(void *arg)
{
    UNUSED(arg);
    LOGE("[SDK_READY] sdk_ready_check_pthread entry.");

    mbtk_ready_status_type now_ready_status = MBTK_READY_INIT;
    char buf[2] = {0};
    int sleep_time = 30;
    while(1)
    {
        now_ready_status = modem_check();
        if(now_ready_status != mbtk_ready_status)
        {
            buf[0] = '0' + now_ready_status;
            property_set("persist.mbtk.sdk.state", buf);
            mbtk_ready_status = now_ready_status;
        }

        if(now_ready_status != MBTK_READY_SUCCESS)
        {
            sleep_time += 2;
        }
        else
        {
            sleep_time = 30;
        }
        
        sleep(sleep_time);
    }
    LOGE("[SDK_READY] sdk_ready_check_pthread exit.");
    return NULL;
}

int main(int argc, char *argv[])
{
    if(mbtk_ready_status != MBTK_READY_INIT)
    {
        LOGE("[SDK_READY] sdk has check.");
        return MBTK_RESULT_FAIL;
    }

#ifdef MBTK_DUMP_SUPPORT
    mbtk_debug_open(NULL, TRUE);
#endif

	LOGE("[SDK_READY] sdk check init.");
    pthread_t sdk_ready_pid;
    pthread_attr_t thread_attr;
    pthread_attr_init(&thread_attr);
    if(pthread_attr_setdetachstate(&thread_attr, PTHREAD_CREATE_DETACHED))
    {
        LOGE("[SDK_READY] pthread_attr_setdetachstate() fail.");
        return MBTK_RESULT_FAIL;
    }
    
    if(pthread_create(&sdk_ready_pid, &thread_attr, sdk_ready_check_pthread, NULL))
    {
        LOGE("[SDK_READY] pthread_create() fail.");
    }

    pthread_attr_destroy(&thread_attr);

    LOGE("[SDK_READY] sdk check start.");
    while(1)
    {
        sleep(24 * 60 * 60);
    }

    LOGE("[SDK_READY]!!!mbtk_sdk_ready exit!!!");
    return MBTK_RESULT_SUCCESS;
}
#endif