#include "mbtk_log.h"
#include "mbtk_audio2.h"
#include "mbtk_audio_ubus.h"

#define AUD_DEMO_WAV "/user_data/demo.wav"

int mbtk_at_loopback(int type)
{
    LOGD("mbtk_at_loopback() : type - %d", type);
    if(0 == type) // Stop
    {
        if(mbtk_audio_loopback_stop()) {
            return -1;
        }

        mbtk_audio_ubus_deinit();
    }
    else // Start
    {
        mbtk_audio_ubus_init();

        mbtk_audio_mode_set(0);
        mbtk_audio_loopback_start(2);
    }

    return 0;
}

int mbtk_at_play(const char *args)
{
    int ret = 0;
    if(mbtk_audio_wav_init()) {
        LOGE("mbtk_audio_wav_init() fail.");
        return -1;
    }

    if(mbtk_audio_wav_play_start(AUD_DEMO_WAV)) {
        LOGE("mbtk_audio_wav_play_start() fail.");
        ret = -1;
        goto exit;
    }

    sleep(5);

exit:
    if(mbtk_audio_wav_deinit()) {
        LOGE("mbtk_audio_wav_deinit() fail.");
        return -1;
    }

    return ret;
}

int mbtk_at_rec(const char *args)
{
    int ret = 0;
    if(mbtk_audio_wav_init()) {
        LOGE("mbtk_audio_wav_init() fail.");
        return -1;
    }

    if(mbtk_audio_wav_recorder_start(AUD_DEMO_WAV, MBTK_AUDIO_SAMPLE_RATE_8000)) {
        LOGE("mbtk_audio_wav_recorder_start() fail.");
        ret = -1;
        goto exit;
    }

    sleep(5);

exit:
    if(mbtk_audio_wav_deinit()) {
        LOGE("mbtk_audio_wav_deinit() fail.");
        return -1;
    }

    return 0;
}
