#include "mbtk_file.h"

/**
* Return TRUE if file exist,FLASE or not.
*/
bool file_exist(const char *path)
{
    return (access(path, F_OK) == 0) ? true : false;
}

/*
 * Return file descriptor if open file success, return -1 or not.
 *
 * flag : File open flag.
 *  O_RDONLY 以只读方式打开文件
 *  O_WRONLY 以只写方式打开文件
 *  O_RDWR 以可读写方式打开文件
 *      上述三种旗标是互斥
 *
 *  O_CREAT 若欲打开的文件不存在则自动建立该文件。
 *  O_EXCL 如果 O_CREAT 也被设置，此指令会去检查文件是否存在。文件若不存在则
 *      建立该文件，否则将导致打开文件错误。此外，若 O_CREAT 与 O_EXCL 同时设置，
 *      并且欲打开的文件为符号连接，则会打开文件失败。
 *  O_NOCTTY 如果欲打开的文件为终端机设备时，则不会将该终端机当成进程控制终端机。
 *  O_TRUNC 若文件存在并且以可写的方式打开时，此旗标会令文件长度清为 0，而原来存于该文件的资料也会消失。
 *  O_APPEND 当读写文件时会从文件尾开始移动，也就是所写入的数据会以附加的方式加入到文件后面。
 *  O_NONBLOCK 以不可阻断的方式打开文件，也就是无论有无数据读取或等待，都会立即返回进程之中。
 *  O_NDELAY 同 O_NONBLOCK。
 *  O_SYNC 以同步的方式打开文件。
 *  O_NOFOLLOW 如果参数 pathname 所指的文件为一符号连接，则会令打开文件失败。
 *  O_DIRECTORY 如果参数 pathname 所指的文件并非为一目录，则会令打开文件失败
 */
int file_open(const char *path, int flag)
{
    // Only for create file : rwxrw-rx-
    int result = open(path, flag, 0766);
    if(result == -1) {
        LOGE("Open file[%s] fail:%d", path, errno);
    }
    return result;
}

/*
* Return file size,or -1 if get file size fail.
*/
int file_length(int fd)
{
    int cur=  lseek(fd, 0, SEEK_CUR);
    if(cur < 0)
    {
        LOGE("lseek(SEEK_CUR) error: %d", errno);
        return -1;
    }
    int len = lseek(fd, 0, SEEK_END);
    if (len < 0)
    {
        LOGE("lseek(SEEK_END) error: %d", errno);
        return -1;
    }

    // Reset position
    if(cur != len) {
        if(lseek(fd, cur, SEEK_SET))
        {
            LOGE("lseek(SEEK_SET) error: %d", errno);
            return -1;
        }
    }
    return len;
}

// Read data of specified length.
int file_read(int fd, void *buf, int nbyte)
{
    int count = 0;
    int len = 0;
    while (true)
    {
        len = read(fd, buf + count, nbyte - count);
        if (len > 0)
        {
            count += len;
        }
        else
        {
            break;
        }

        if (count == nbyte)
            break;
    }

    return count;
}

// Write data of specified length.
int file_write(int fd, void *buf, int nbyte)
{
    int count = 0;
    int len = 0;
    while (true)
    {
        len = write(fd, buf + count, nbyte - count);
        if (len > 0)
        {
            count += len;
        }
        else
        {
            LOGE("write() fail,ret = %d,errno = %d", len, errno);
            break;
        }

        if (count == nbyte)
            break;
    }

    return count;
}

int file_close(int fd)
{
    int result = close(fd);
    if(result == -1) {
        LOGE("Close file fail:%d", errno);
    }
    return result;
}
