#include <stdio.h>
#include <errno.h>
#include <unistd.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <string.h>
#include <fcntl.h>

#include "mbtk_log.h"
#include "mbtk_utils.h"
#include "mbtk_gpio.h"


static int gpio_export(int gpio)
{
    int fd = -1;
    char buffer[50];

    memset(buffer, 0, sizeof(buffer));
    sprintf(buffer,"/sys/class/gpio/gpio%d/direction", gpio);
    if(access(buffer , F_OK) == 0)
    {
        LOGD("%d has export.", gpio);
        return 0;
    }

    fd = open("/sys/class/gpio/export", O_WRONLY);
    if(fd < 0)
    {
        LOGE("Open gpio export file fail.");
        return -1;
    }

    memset(buffer, 0, sizeof(buffer));
    sprintf(buffer , "%d", gpio);
    if(write(fd, buffer, strlen(buffer)) <= 0)
    {
        LOGE("Gpio[%d] export fail.", gpio);
        close(fd);
        return -1;
    }
    close(fd);
    return 0;
}

static int gpio_unexport(int gpio)
{
    int fd = -1;
    char buffer[50];

    memset(buffer, 0, sizeof(buffer));
    sprintf(buffer,"/sys/class/gpio/gpio%d/direction", gpio);
    if(access(buffer , F_OK))
    {
        LOGD("%d not export.", gpio);
        return 0;
    }

    fd = open("/sys/class/gpio/unexport", O_WRONLY);
    if(fd < 0)
    {
        LOGE("Open gpio unexport file fail.");
        return -1;
    }

    memset(buffer, 0, sizeof(buffer));
    sprintf(buffer , "%d", gpio);
    if(write(fd, buffer, strlen(buffer)) <= 0)
    {
        LOGE("Gpio[%d] unexport fail.", gpio);
        close(fd);
        return -1;
    }
    close(fd);
    return 0;
}

mbtk_gpio_direct_t mbtk_gpio_direct_get(int gpio)
{
    char buffer[50];
    int fd = -1;

    memset(buffer, 0, sizeof(buffer));
    sprintf(buffer, "/sys/class/gpio/gpio%d/direction", gpio);
    fd = open(buffer, O_RDONLY);
    if(fd < 0)
    {
        LOGE("Open gpio[%d] direct fail.", gpio);
        return MBTK_GPIO_DIRECT_UNKNOWN;
    }

    memset(buffer, 0x0, sizeof(buffer));
    if(read(fd, buffer, sizeof(buffer)) <= 0)
    {
        LOGE("Get gpio[%d] direct fail.", gpio);
        close(fd);
        return MBTK_GPIO_DIRECT_UNKNOWN;
    }
    close(fd);

    if(strcmp(buffer, "out") == 0) {
        return MBTK_GPIO_DIRECT_OUT;
    } else if(strcmp(buffer, "in") == 0) {
        return MBTK_GPIO_DIRECT_IN;
    } else {
        LOGE("direct : %s", buffer);
        return MBTK_GPIO_DIRECT_UNKNOWN;
    }
}

int mbtk_gpio_direct_set(int gpio, mbtk_gpio_direct_t dir)
{
    char buffer[50];
    int fd = -1;
    int ret = 0;

    if(gpio_export(gpio)) {
        return -1;
    }

    memset(buffer, 0, sizeof(buffer));
    sprintf(buffer, "/sys/class/gpio/gpio%d/direction", gpio);
    fd = open(buffer, O_WRONLY);
    if(fd < 0)
    {
        LOGE("Open gpio[%d] direct fail.", gpio);
        return -1;
    }

    if(MBTK_GPIO_DIRECT_OUT == dir) {
        if(write(fd, "out", 3) != 3) {
            ret = -1;
            LOGE("Write out fail:%d", errno);
        }
    } else if(MBTK_GPIO_DIRECT_IN == dir) {
        if(write(fd, "in", 2) != 2) {
            ret = -1;
            LOGE("Write in fail:%d", errno);
        }
    } else {
        LOGE("Unknown direct : %d", dir);
        ret = -1;
    }

    close(fd);
    return ret;
}

int mbtk_gpio_value_get(int gpio)
{
    char buffer[50];
    int fd =-1;

    memset(buffer, 0, sizeof(buffer));
    sprintf(buffer, "/sys/class/gpio/gpio%d/value", gpio);
    fd = open(buffer, O_RDONLY);
    if(fd == -1)
    {
        LOGE("Open gpio[%d] fail.", gpio);
        return -1;
    }

    if(read(fd, buffer, sizeof(buffer)) <= 0)
    {
        LOGE("Get gpio[%d] value fail", gpio);
        close(fd);
        return -1;
    }

    close(fd);
    return atoi(buffer);
}

int mbtk_gpio_value_set(int gpio, mbtk_gpio_direct_t dir, int value)
{
    char buffer[50];
    int fd = -1;
    int ret =-1;

    if(gpio_export(gpio)) {
        return -1;
    }

    if(mbtk_gpio_direct_set(gpio, dir)) {
        return -1;
    }

    memset(buffer, 0, sizeof(buffer));
    sprintf(buffer, "/sys/class/gpio/gpio%d/value", gpio);
    fd = open(buffer, O_WRONLY);
    if(fd == -1)
    {
        LOGE("Open gpio[%d] value fail.", gpio);
        return -1;
    }
    if(value == 0) {
        ret = write(fd, "0", 1);
    } else {
        ret = write(fd, "1", 1);
    }

    close(fd);
    if(ret != 1)
    {
        LOGE("Set gpio[%d] value fail.", gpio);
        return -1;
    } else {
        return 0;
    }
}

