#ifndef MBTK_INFO_INCLUDE
#define MBTK_INFO_INCLUDE
#include <netinet/in.h>

#include "mbtk_type.h"
#include "mbtk_list.h"
#include "mbtk_log.h"
#include "mbtk_utils.h"
#include "mbtk_info_api.h"

#define MBTK_INFO_PACKET_FLAG 0x5F6F7F8F
#define SOCK_INFO_PATH "/tmp/info_sock"
#define SOCK_MSG_LEN_MAX 2048

// Tag(4) + Packet_Length(2)
#define SOCK_PACK_EXTRA_LEN 6
// SOCK_PACK_EXTRA_LEN + Id(2) + Error(2) + Number(2)
#define SOCK_PACK_LEN_MIN (SOCK_PACK_EXTRA_LEN + 6)

typedef enum
{
    MBTK_INFO_TYPE_REQ,
    MBTK_INFO_TYPE_RSP,
    MBTK_INFO_TYPE_IND,
    MBTK_INFO_TYPE_UNKNOWN
} mbtk_info_type_enum;

typedef enum
{
    // Device Information
    MBTK_INFO_ID_DEV_BEGIN = 0,
    // <string> IMEI
    MBTK_INFO_ID_DEV_IMEI_REQ,
    MBTK_INFO_ID_DEV_IMEI_RSP,
    // <string> SN
    MBTK_INFO_ID_DEV_SN_REQ,
    MBTK_INFO_ID_DEV_SN_RSP,
    // <string> MEID
    MBTK_INFO_ID_DEV_MEID_REQ,
    MBTK_INFO_ID_DEV_MEID_RSP,
    // <string> VERSION
    MBTK_INFO_ID_DEV_VERSION_REQ,
    MBTK_INFO_ID_DEV_VERSION_RSP,
    // <string> MODEL
    MBTK_INFO_ID_DEV_MODEL_REQ,
    MBTK_INFO_ID_DEV_MODEL_RSP,
    // <uint8> 0:Close 1:Open
    MBTK_INFO_ID_DEV_VOLTE_REQ,
    MBTK_INFO_ID_DEV_VOLTE_RSP,
    // <string> Temperature
    MBTK_INFO_ID_DEV_TEMP_REQ,  // Temperature
    MBTK_INFO_ID_DEV_TEMP_RSP,
    // <uint8><string>  YYYY-MM-DD-HH:MM:SS
    MBTK_INFO_ID_DEV_TIME_REQ,  // Time
    MBTK_INFO_ID_DEV_TIME_RSP,
    //<string>  "23/03/20,01:58:00+32"
    MBTK_INFO_ID_DEV_CELL_TIME_REQ,  // Time
    MBTK_INFO_ID_DEV_CELL_TIME_RSP,

    MBTK_INFO_ID_DEV_MODEM_REQ,
    MBTK_INFO_ID_DEV_MODEM_RSP,

    MBTK_INFO_ID_DEV_END,

    // Sim Information
    MBTK_INFO_ID_SIM_BEGIN = 1000,
    // <uint8> 0:NOT_EXIST 1:READY ...
    MBTK_INFO_ID_SIM_STATE_REQ,
    MBTK_INFO_ID_SIM_STATE_RSP,
    // <uint8> 0: SIM 1: USIM 2: TEST SIM 3: TEST USIM 4: UNKNOWN
    MBTK_INFO_ID_SIM_STYPE_REQ,
    MBTK_INFO_ID_SIM_STYPE_RSP,
    // <string> PIN
    MBTK_INFO_ID_SIM_PIN_REQ,
    MBTK_INFO_ID_SIM_PIN_RSP,
    // <string> PIN
    MBTK_INFO_ID_SIM_ENABLE_PIN_REQ,
    MBTK_INFO_ID_SIM_ENABLE_PIN_RSP,
    // <string> PUK
    MBTK_INFO_ID_SIM_PUK_REQ,
    MBTK_INFO_ID_SIM_PUK_RSP,
    // <string> PLMN
    MBTK_INFO_ID_SIM_PLMN_REQ,
    MBTK_INFO_ID_SIM_PLMN_RSP,
    // <uint8> <uint8> <uint8> <uint8> PIN PUK LAST TIMES
    MBTK_INFO_ID_SIM_PINPUK_TIMES_REQ,
    MBTK_INFO_ID_SIM_PINPUK_TIMES_RSP,
    // <string> IMSI
    MBTK_INFO_ID_SIM_IMSI_REQ,
    MBTK_INFO_ID_SIM_IMSI_RSP,
    // <string> ICCID
    MBTK_INFO_ID_SIM_ICCID_REQ,
    MBTK_INFO_ID_SIM_ICCID_RSP,
    // <string> Phone Number
    MBTK_INFO_ID_SIM_PN_REQ,
    MBTK_INFO_ID_SIM_PN_RSP,
    // <string> <string> old_PIN new_PIN
    MBTK_INFO_ID_SIM_CHANGE_PIN_REQ,
    MBTK_INFO_ID_SIM_CHANGE_PIN_RSP,

    MBTK_INFO_ID_SIM_END,

    // Network Information
    MBTK_INFO_ID_NET_BEGIN = 2000,
    // <uint8> 0:OFF 1:ON
    MBTK_INFO_ID_NET_RADIO_REQ,
    MBTK_INFO_ID_NET_RADIO_RSP,
    // sel_mode(uint8)type(uint8)plmn(uint32)...sel_mode(uint8)type(uint8)plmn(uint32)
    MBTK_INFO_ID_NET_AVAILABLE_REQ,
    MBTK_INFO_ID_NET_AVAILABLE_RSP,
    // <uint8> 0: automatic 1: manual
    // or
    // sel_mode(uint8)type(uint8)plmn(uint32)
    MBTK_INFO_ID_NET_SEL_MODE_REQ,
    MBTK_INFO_ID_NET_SEL_MODE_RSP,
    // mbtk_band_info_t
    MBTK_INFO_ID_NET_BAND_REQ,
    MBTK_INFO_ID_NET_BAND_RSP,
    // mbtk_signal_info_t
    MBTK_INFO_ID_NET_SIGNAL_REQ,
    MBTK_INFO_ID_NET_SIGNAL_RSP,
    // mbtk_net_reg_info_t
    MBTK_INFO_ID_NET_REG_REQ,
    MBTK_INFO_ID_NET_REG_RSP,
    // mbtk_apn_info_t
    MBTK_INFO_ID_NET_APN_REQ,
    MBTK_INFO_ID_NET_APN_RSP,
    // mbtk_qser_apn_info_t
    MBTK_INFO_ID_NET_QSER_APN_REQ,
    MBTK_INFO_ID_NET_QSER_APN_RSP,
    // mbtk_apn_del
    MBTK_INFO_ID_NET_APN_DEL_REQ,
    MBTK_INFO_ID_NET_APN_DEL_RSP,
    // mbtk_cell_info_t[]
    MBTK_INFO_ID_NET_CELL_REQ,
    MBTK_INFO_ID_NET_CELL_RSP,
    // REQ:
    // <call_type[1]><cid[1]><timeout[1]>
    //  call_type : mbtk_data_call_type_enum
    //  cid : 1 - 15
    //  timeout : second
    // RSP:
    //  <type[1]><ipv4><ipv6>
    //  type : 0-IPV4   1-IPV6  2-IPV4V6
    //  ipv4 : mbtk_ipv4_info_t
    //  ipv6 : mbtk_ipv6_info_t
    MBTK_INFO_ID_NET_DATA_CALL_REQ,
    MBTK_INFO_ID_NET_DATA_CALL_RSP,

    // mbtk_net_ims
    MBTK_INFO_ID_NET_IMS_REQ,
    MBTK_INFO_ID_NET_IMS_RSP,

    MBTK_INFO_ID_NET_IMS_REG_STATE_REQ,
    MBTK_INFO_ID_NET_IMS_REG_STATE_RSP,


    MBTK_INFO_ID_NET_END,


    // Call Information
    MBTK_INFO_ID_CALL_BEGIN = 3000,
    MBTK_INFO_ID_CALL_STATE_REQ,
    MBTK_INFO_ID_CALL_STATE_RSP,

    // Start call.
    MBTK_INFO_ID_CALL_START_REQ,
    MBTK_INFO_ID_CALL_START_RSP,
    //answer call
    MBTK_INFO_ID_CALL_ANSWER_REQ,
    MBTK_INFO_ID_CALL_ANSWER_RSP,
    //hang up all call
    MBTK_INFO_ID_CALL_HANGUP_REQ,
    MBTK_INFO_ID_CALL_HANGUP_RSP,
    //hang up a call
    MBTK_INFO_ID_CALL_HANGUP_A_REQ,
    MBTK_INFO_ID_CALL_HANGUP_A_RSP,
    //hang up waiting or background call
    MBTK_INFO_ID_CALL_HANGUP_B_REQ,
    MBTK_INFO_ID_CALL_HANGUP_B_RSP,
    //hang up foreground resume background
    MBTK_INFO_ID_CALL_HANGUP_C_REQ,
    MBTK_INFO_ID_CALL_HANGUP_C_RSP,
    //wait in call
    MBTK_INFO_ID_CALL_WAITIN_REQ,
    MBTK_INFO_ID_CALL_WAITIN_RSP,
    //mute call
    MBTK_INFO_ID_CALL_MUTE_REQ,
    MBTK_INFO_ID_CALL_MUTE_RSP,
    //dtmf call
    MBTK_INFO_ID_CALL_DTMF_REQ,
    MBTK_INFO_ID_CALL_DTMF_RSP,

    MBTK_INFO_ID_CALL_END,

    // SMS Information
    MBTK_INFO_ID_SMS_BEGIN = 4000,
    MBTK_INFO_ID_SMS_STATE_REQ,
    MBTK_INFO_ID_SMS_STATE_RSP,
    MBTK_INFO_ID_SMS_CMGF_REQ,
    MBTK_INFO_ID_SMS_CMGF_RSP,
    MBTK_INFO_ID_SMS_CPMS_REQ,
    MBTK_INFO_ID_SMS_CPMS_RSP,
    MBTK_INFO_ID_SMS_CMGS_REQ,
    MBTK_INFO_ID_SMS_CMGS_RSP,
    MBTK_INFO_ID_SMS_CMSS_REQ,
    MBTK_INFO_ID_SMS_CMSS_RSP,
    MBTK_INFO_ID_SMS_CMGR_REQ,
    MBTK_INFO_ID_SMS_CMGR_RSP,
    MBTK_INFO_ID_SMS_CMGW_REQ,
    MBTK_INFO_ID_SMS_CMGW_RSP,
    MBTK_INFO_ID_SMS_CMGD_REQ,
    MBTK_INFO_ID_SMS_CMGD_RSP,
    MBTK_INFO_ID_SMS_CMGL_REQ,
    MBTK_INFO_ID_SMS_CMGL_RSP,
    MBTK_INFO_ID_SMS_CSCA_REQ,
    MBTK_INFO_ID_SMS_CSCA_RSP,
    MBTK_INFO_ID_SMS_CSMP_REQ,
    MBTK_INFO_ID_SMS_CSMP_RSP,
    MBTK_INFO_ID_SMS_CSCB_REQ,
    MBTK_INFO_ID_SMS_CSCB_RSP,
    MBTK_INFO_ID_SMS_CNMI_REQ,
    MBTK_INFO_ID_SMS_CNMI_RSP,

    MBTK_INFO_ID_SMS_END,

    // PhoneBook Information
    MBTK_INFO_ID_PB_BEGIN = 5000,
    MBTK_INFO_ID_PB_STATE_REQ,
    MBTK_INFO_ID_PB_STATE_RSP,

    MBTK_INFO_ID_PB_END,

    //wakeup
    MBTK_INFO_ID_WAKEUP_STA_BEGIN = 6000,
    MBTK_INFO_ID_WAKEUP_STA_REQ,
    MBTK_INFO_ID_WAKEUP_STA_RSP,

    MBTK_INFO_ID_WAKEUP_STA_END,

    //oos(out of service）)
    MBTK_INFO_ID_OOS_STA_BEGIN = 7000,
    MBTK_INFO_ID_OOS_STA_REQ,
    MBTK_INFO_ID_OOS_STA_RSP,

    MBTK_INFO_ID_OOS_STA_END,

	//led
    MBTK_INFO_ID_LED_BEGIN = 8000,
    MBTK_INFO_ID_LED_REQ,
    MBTK_INFO_ID_LED_RSP,
    MBTK_INFO_ID_LED_END,

    // IND Information
    MBTK_INFO_ID_IND_BEGIN = 10000,
    // <uint8>  State
    MBTK_INFO_ID_IND_NET_STATE_CHANGE,
    // <uint8>  State
    MBTK_INFO_ID_IND_CALL_STATE_CHANGE,
    // <uint8>  State
    MBTK_INFO_ID_IND_SMS_STATE_CHANGE,
    // <uint8>  State
    MBTK_INFO_ID_IND_RADIO_STATE_CHANGE,
    // <uint8>  State
    MBTK_INFO_ID_IND_SIM_STATE_CHANGE,
    // <uint8>  State
    MBTK_INFO_ID_IND_PDP_STATE_CHANGE,
    // <uint8> State
    MBTK_INFO_ID_IND_SERVER_STATE_CHANGE,////mbtk wyq for server_ready_status add
    // <uint8> State
    MBTK_INFO_ID_IND_SIGNAL_STATE_CHANGE,


    MBTK_INFO_ID_IND_END,
    MBTK_INFO_ID_REQ_UNKNOWN        // Unknown information.
} mbtk_info_id_enum;

typedef enum {
    MBTK_NET_CS_STATE = 0,
    MBTK_NET_PS_STATE
} mbtk_net_state_type_enum;

typedef enum {
    MBTK_INFO_ERR_SUCCESS = 300,
    MBTK_INFO_ERR_FORMAT,       // Packet format error.
    MBTK_INFO_ERR_REQ_UNKNOWN,  // Unknown request.
    MBTK_INFO_ERR_REQ_PARAMETER,  // Request parameter error.
    MBTK_INFO_ERR_UNSUPPORTED,  // Unsupported operation.
    MBTK_INFO_ERR_MEMORY,       // Insufficient memory.
    MBTK_INFO_ERR_IND_FULL,     // Register IND fail(FULL).
    MBTK_INFO_ERR_IND_UNKNOWN,  // Register IND fail(Unknown IND).
    MBTK_INFO_ERR_CID,  // CID error.
    MBTK_INFO_ERR_TIMEOUT,  // Timeout.
    MBTK_INFO_ERR_TIME_FORMAT,  // Time format error.

    //mbtk wyq for data_call add start
    MBTK_INFO_ERR_CID_EXIST,
    MBTK_INFO_ERR_CID_NO_EXIST,
    MBTK_INFO_ERR_NET_NO_INIT,
    //mbtk wyq for data_call add end

    MBTK_INFO_ERR_UNKNOWN = 400,  // Unknown error.
    // CME error start index.
    MBTK_INFO_ERR_CME = 500,
    MBTK_INFO_ERR_CME_NON = 1000
} mbtk_info_err_enum;

/*
GSM band��
    1 �C PGSM 900 (standard or primary)
    2 �C DCS GSM 1800
    4 �C PCS GSM 1900
    8 �C EGSM 900 (extended)
    16 �C GSM 450
    32 �C GSM 480
    64 �C GSM 850
    512 - BAND_LOCK_BIT // used for GSM band setting
*/
typedef enum
{
    MBTK_GSM_BAND_PGSM_900 = 1,
    MBTK_GSM_BAND_DCS_GSM_1800 = 2,
    MBTK_GSM_BAND_PCS_GSM_1900 = 4,
    MBTK_GSM_BAND_EGSM_900 = 8,
    MBTK_GSM_BAND_GSM_450 = 16,
    MBTK_GSM_BAND_GSM_480 = 32,
    MBTK_GSM_BAND_GSM_850 = 64,
    MBTK_GSM_BAND_BAND_LOCK_BIT = 512
} mbtk_gsm_band_enum;

/*
UMTS band��
    1 �C UMTS_BAND_1
    2 �C UMTS_BAND_2
    4 �C UMTS_BAND_3
    8 �C UMTS_BAND_4
    16 �C UMTS_BAND_5
    32 �C UMTS_BAND_6
    64 �C UMTS_BAND_7
    128 �C UMTS_BAND_8
    256 �C UMTS_BAND_9
*/
typedef enum
{
    MBTK_UMTS_BAND_1 = 1,
    MBTK_UMTS_BAND_2 = 2,
    MBTK_UMTS_BAND_3 = 4,
    MBTK_UMTS_BAND_4 = 8,
    MBTK_UMTS_BAND_5 = 16,
    MBTK_UMTS_BAND_6 = 32,
    MBTK_UMTS_BAND_7 = 64,
    MBTK_UMTS_BAND_8 = 128,
    MBTK_UMTS_BAND_9 = 256
} mbtk_umts_band_enum;

/*
LTEbandH(TDD-LTE band)
    32 �C TDLTE_BAND_38
    64 �C TDLTE_BAND_39
    128 �C TDLTE_BAND_40
    256 �C TDLTE_BAND_41
*/
typedef enum
{
    MBTK_TDLTE_BAND_38 = 32,
    MBTK_TDLTE_BAND_39 = 64,
    MBTK_TDLTE_BAND_40 = 128,
    MBTK_TDLTE_BAND_41 = 256
} mbtk_tdlte_band_enum;

/*
LTEbandL(FDD-LTE band)
    1 �C FDDLTE_BAND_1
    4 �C FDDLTE _BAND_3
    8 �C FDDLTE _BAND_4
    64 �C FDDLTE _BAND_7
    65536 �C FDDLTE _BAND_17
    524288 �C FDDLTE _BAND_20
*/
typedef enum
{
    MBTK_FDDLTE_BAND_1 = 1,
    MBTK_FDDLTE_BAND_3 = 4,
    MBTK_FDDLTE_BAND_4 = 8,
    MBTK_FDDLTE_BAND_7 = 64,
    MBTK_FDDLTE_BAND_17 = 65536,
    MBTK_FDDLTE_BAND_20 = 524288
} mbtk_fddlte_band_enum;

typedef enum
{
    MBTK_LTE_EXT_BAND_65 = 1,
    MBTK_LTE_EXT_BAND_66 = 2,
    MBTK_LTE_EXT_BAND_67 = 4,
    MBTK_LTE_EXT_BAND_68 = 8,
    MBTK_LTE_EXT_BAND_69 = 16
} mbtk_lte_ext_band_enum;

/*
0: unknown
1: available
2: current
3: forbidden
*/
typedef enum
{
    MBTK_NET_AVIL_STATE_UNKNOWN = 0,
    MBTK_NET_AVIL_STATE_AVAILABLE,
    MBTK_NET_AVIL_STATE_CURRENT,
    MBTK_NET_AVIL_STATE_FORBIDDEN
} mbtk_net_avil_state_enum;

typedef struct
{
    uint16 tac;
    uint16 earfcn;
} mbtk_local_info_t;

typedef struct
{
    uint16 info_id;
    uint16 info_err;
    const uint8 *data;
    uint16 data_len;
} mbtk_info_pack_t;

typedef struct
{
    uint8 type; // 0: GSM 1: UMTS 2: LTE
    bool running;

    int cell_num;
    mbtk_cell_info_t cell[CELL_NUM_MAX];
} mbtK_cell_pack_info_t;

typedef enum {
    MBTK_MOBILE_ORIGINATED_CALL,
    MBTK_TERMINATED_CALL,
} mbtk_call_dir_enum;

typedef enum {
    MBTK_VOICE,
    MBTK_DATA,
    MBTK_FAX,
    MBTK_VOICE_FOLLOWED_BY_DATA_VOICE_MODE,
    MBTK_ALTERNATING_VOICE_VOICE_MODE,
    MBTK_ALTERNATING_FAX_VOICE_MODE,
    MBTK_VOICE_FOLLOWED_BY_DATA_DATA_MODE,
    MBTK_ALTERNATING_VOICE_DATA_MODE,
    MBTK_ALTERNATING_FAX_FAX_MODE,
    MBTL_UNKNOW,
} mbtk_call_mode_enum;

typedef enum {
    MBTK_NOT_MULITYPARTY_CALL,
    MBTK_MULITYPARTY__CALL,
} mbtk_call_mpty_enum;

typedef struct
{
    int cid;
    bool act;
    bool waitting;
} info_cgact_wait_t;

typedef struct
{
    uint32 count;
    list_node_t *net_list;
} mbtk_net_array_info_t;

typedef struct
{
    bool inited;
    mbtk_radio_state_enum radio_state;
    mbtk_sim_state_enum sim_state;
    mbtk_radio_technology_enum net_type;
    mbtk_ip_type_enum ip_type;
    struct sockaddr_in addr4;
    struct sockaddr_in preferred_dns4;
    struct sockaddr_in alternate_dns4;

    struct sockaddr_in6 addr6;
    struct sockaddr_in6 preferred_dns6;
    struct sockaddr_in6 alternate_dns6;
} net_info_t;

#ifdef __cplusplus
extern "C" {
#endif
char* type2str(mbtk_info_type_enum type);

char* apn2str(mbtk_ip_type_enum type);

char* id2str(int id);

char* err2str(mbtk_info_err_enum err);

/*
IPv6 : 254.128.0.0.0.0.0.0.0.1.0.2.144.5.212.239 -> uint128
*/
int str_2_ipv6(const void *ip_str, void *ipv6);

/*
IPv6 : uint128 -> fe80::215:1dff:fe81:484c
*/
int ipv6_2_str(const void *ipv6, void *ipv6_str);

/*
0   GSM
1   GSM_COMPACT
2   UTRAN
3   GSM_EGPRS
4   UTRAN_HSDPA
5   UTRAN_HSUPA
6   UTRAN_HSDPA_HSUPA
7   EUTRAN
8   ECGSM
*/
mbtk_net_type_enum mbtk_net_type_get(mbtk_radio_technology_enum radio_tech);

mbtk_info_type_enum mbtk_info_type_get(int info_id);

mbtk_info_pack_t* mbtk_info_pack_creat(int info_id);

#if 0
int mbtk_info_pack_data_set(mbtk_info_pack_t *pack, const void *data, int data_len);
void* mbtk_info_pack_data_get(mbtk_info_pack_t *pack, int *data_len);
#endif

int mbtk_info_pack_send(int fd, mbtk_info_pack_t *pack);

mbtk_info_pack_t** mbtk_info_pack_recv(int fd, bool is_server, mbtk_info_err_enum *err);

int mbtk_info_pack_free(mbtk_info_pack_t **pack);
#ifdef __cplusplus
}
#endif


#endif /* MBTK_INFO_INCLUDE */


