#include "ql/ql_nw.h"
#include "mbtk_type.h"
#include "mbtk_info_api.h"

extern mbtk_info_handle_t* ql_info_handle;
extern int ql_info_handle_num;
static bool inited = FALSE;

#define SIGNAL_STRENGTH_INVALID_1 99
#define SIGNAL_STRENGTH_INVALID_2 255


typedef struct
{
    uint8 *operator_l;
    uint8 *operator_s;
    uint32 mcc_mnc;
} operator_mcc_mnc_t;

typedef struct
{
    QL_NW_EventHandlerFunc_t handlerPtr;
    void* contextPtr;
} ql_cust_cb_func;

static ql_cust_cb_func ql_func_cb_handle;

static int roaming_pref = 1;  // Open roaming for default.

static operator_mcc_mnc_t operator_mcc_mnc [] =
{
    {"China Mobile","CMCC",46000},
    {"China Unicom","CU",46001},
    {"China Mobile","CMCC",46002},
    {"China Telecom","CT",46003},
    {"China Mobile","CMCC",46004},
    {"China Telecom","CT",46005},
    {"China Unicom","CU",46006},
    {"China Mobile","CMCC",46007},
    {"China Mobile","CMCC",46008},
    {"China Unicom","CU",46009},
    {"China Telecom","CT",46011}
};

typedef enum {
    RADIO_TECH_3GPP = 1, /* 3GPP Technologies - GSM, WCDMA */
    RADIO_TECH_3GPP2 = 2 /* 3GPP2 Technologies - CDMA */
} RIL_RadioTechnologyFamily;

void ql_nw_state_change_cb(const void* data, int data_len)
{
    ///mbtk_net_info_t *reg = (mbtk_net_info_t *)data;
    uint8 *net_data = NULL;

    net_data = (uint8*)data;
    /*
    uint8 data[3];
    data[0] = (uint8)MBTK_NET_CS_STATE;

    net_data[0] = *(uint8 *)(data);                                 //MBTK_NET_PS_STATE
    net_data[1] = *(uint8 *)(data + sizeof(uint8));                 //mbtk_net_reg_state_enum state Reg State
    net_data[2] = *(uint8 *)(data + sizeof(uint8) + sizeof(uint8)); //act
    */
    if(roaming_pref == 0)
    {
        mbtk_modem_info_t info;
        if(*net_data == 5)
        {
            info.fun=4;
            //ql_netw_status_cb(5);
        }
        else
            info.fun=1;
        info.rst=0;
        //mbtk_set_modem_fun(ql_info_handle, &info);
    }

    if(ql_func_cb_handle.handlerPtr != NULL)
    {
        ql_func_cb_handle.handlerPtr(QL_NW_IND_DATA_REG_EVENT_FLAG,&(net_data[2]), sizeof(&(net_data[2])), NULL);
    }
}

QL_NW_ERROR_CODE ql_nw_init()
{
    if(!inited && ql_info_handle == NULL)
    {
        ql_info_handle = mbtk_info_handle_get();
        if(ql_info_handle)
        {
            ql_info_handle_num++;
            inited = TRUE;
            return QL_NW_SUCCESS;
        } else {
            LOGE("mbtk_info_handle_get() fail.");
            return QL_NW_GENERIC_FAILURE;
        }
    } else {
        if(!inited) {
            ql_info_handle_num++;
            inited = TRUE;
        }
        return QL_NW_SUCCESS;
    }
}

QL_NW_ERROR_CODE ql_nw_release()
{
    if(ql_info_handle)
    {
        LOGD("ql_info_handle_num = %d", ql_info_handle_num);
        if(ql_info_handle_num == 1) { // 最后一个引用，可释放。
            int ret = mbtk_info_handle_free(&ql_info_handle);
            if(ret) {
                LOGE("mbtk_info_handle_free() fail.");
                return QL_NW_GENERIC_FAILURE;
            }
            else
            {
                ql_info_handle_num = 0;
                ql_info_handle = NULL;
                return QL_NW_SUCCESS;
            }
        } else {
            ql_info_handle_num--;
            return QL_NW_SUCCESS;
        }
    }
    else
    {
        LOGE("NW handle not inited.");
        return QL_NW_GENERIC_FAILURE;
    }
}

static uint8 net_pre_change(bool mbtk_2_ql,int net_mode)
{
    uint8 mbtk_net_pre = 0xFF;

    /*
    QL_NW_PREF_NET_TYPE_GSM_WCDMA = 0,                      //4
    QL_NW_PREF_NET_TYPE_GSM_ONLY = 1,                       //0
    QL_NW_PREF_NET_TYPE_WCDMA = 2,                          //1
    QL_NW_PREF_NET_TYPE_GSM_WCDMA_AUTO = 3,                 //2
    QL_NW_PREF_NET_TYPE_LTE_GSM_WCDMA = 9,                  //12
    QL_NW_PREF_NET_TYPE_LTE_ONLY = 11,                      //5
    QL_NW_PREF_NET_TYPE_LTE_WCDMA = 12,                     //9
    QL_NW_PREF_NET_TYPE_LTE_GSM_GSM_PREF = 13,              //7
    QL_NW_PREF_NET_TYPE_LTE_GSM_LTE_PREF = 14,              //8
    QL_NW_PREF_NET_TYPE_LTE_GSM = 15,                       //6
    QL_NW_PREF_NET_TYPE_LTE_WCDMA_WCDMA_PREF = 16,          //10
    QL_NW_PREF_NET_TYPE_LTE_WCDMA_LTE_PREF = 17,            //11
    QL_NW_PREF_NET_TYPE_LTE_GSM_WCDMA_GSM_PREF = 19,        //13
    QL_NW_PREF_NET_TYPE_LTE_GSM_WCDMA_WCDMA_PREF = 20,      //14
    QL_NW_PREF_NET_TYPE_LTE_GSM_WCDMA_LTE_PREF = 21,        //15
    */
    /*
    0 : GSM only
    1 : UMTS only
    2 : GSM/UMTS(auto)
    3 : GSM/UMTS(GSM preferred)
    4 : GSM/UMTS(UMTS preferred)
    5 : LTE only
    6 : GSM/LTE(auto)
    7 : GSM/LTE(GSM preferred)
    8 : GSM/LTE(LTE preferred)
    9 : UMTS/LTE(auto)
    10 : UMTS/LTE(UMTS preferred)
    11 : UMTS/LTE(LTE preferred)
    12 : GSM/UMTS/LTE(auto)
    13 : GSM/UMTS/LTE(GSM preferred)
    14 : GSM/UMTS/LTE(UMTS preferred)
    15 : GSM/UMTS/LTE(LTE preferred)
    */

    if(mbtk_2_ql) {
        switch(net_mode)
        {
            case MBTK_NET_PREF_GSM_UMTS_UMTS_PREF:
                mbtk_net_pre = QL_NW_PREF_NET_TYPE_GSM_WCDMA;
                break;
            case MBTK_NET_PREF_GSM_ONLY:
                mbtk_net_pre = QL_NW_PREF_NET_TYPE_GSM_ONLY;
                break;
            case MBTK_NET_PREF_UMTS_ONLY:
                mbtk_net_pre = QL_NW_PREF_NET_TYPE_WCDMA;
                break;
            case MBTK_NET_PREF_GSM_UMTS_AUTO:
                mbtk_net_pre = QL_NW_PREF_NET_TYPE_GSM_WCDMA_AUTO;
                break;
            case MBTK_NET_PREF_GSM_UMTS_LTE_AUTO:
                mbtk_net_pre = QL_NW_PREF_NET_TYPE_LTE_GSM_WCDMA;
                break;
            case MBTK_NET_PREF_LTE_ONLY:
                mbtk_net_pre = QL_NW_PREF_NET_TYPE_LTE_ONLY;
                break;
            case MBTK_NET_PREF_UMTS_LTE_AUTO:
                mbtk_net_pre = QL_NW_PREF_NET_TYPE_LTE_WCDMA;
                break;
            case MBTK_NET_PREF_GSM_LTE_GSM_PREF:
                mbtk_net_pre = QL_NW_PREF_NET_TYPE_LTE_GSM_GSM_PREF;
                break;
            case MBTK_NET_PREF_GSM_LTE_LTE_PREF:
                mbtk_net_pre = QL_NW_PREF_NET_TYPE_LTE_GSM_LTE_PREF;
                break;
            case MBTK_NET_PREF_GSM_LTE_AUTO:
                mbtk_net_pre = QL_NW_PREF_NET_TYPE_LTE_GSM;
                break;
            case MBTK_NET_PREF_UMTS_LTE_UMTS_PREF:
                mbtk_net_pre = QL_NW_PREF_NET_TYPE_LTE_WCDMA_WCDMA_PREF;
                break;
            case MBTK_NET_PREF_UMTS_LTE_LTE_PREF:
                mbtk_net_pre = QL_NW_PREF_NET_TYPE_LTE_WCDMA_LTE_PREF;
                break;
            case MBTK_NET_PREF_GSM_UMTS_LTE_GSM_PREF:
                mbtk_net_pre = QL_NW_PREF_NET_TYPE_LTE_GSM_WCDMA_GSM_PREF;
                break;
            case MBTK_NET_PREF_GSM_UMTS_LTE_UMTS_PREF:
                mbtk_net_pre = QL_NW_PREF_NET_TYPE_LTE_GSM_WCDMA_WCDMA_PREF;
                break;
            case MBTK_NET_PREF_GSM_UMTS_LTE_LTE_PREF:
                mbtk_net_pre = QL_NW_PREF_NET_TYPE_LTE_GSM_WCDMA_LTE_PREF;
                break;
            default:
                mbtk_net_pre = 0xFF;
                break;
        }
    } else {
        switch(net_mode)
        {
            case QL_NW_PREF_NET_TYPE_GSM_WCDMA:
                mbtk_net_pre = MBTK_NET_PREF_GSM_UMTS_UMTS_PREF;
                break;
            case QL_NW_PREF_NET_TYPE_GSM_ONLY:
                mbtk_net_pre = MBTK_NET_PREF_GSM_ONLY;
                break;
            case QL_NW_PREF_NET_TYPE_WCDMA:
                mbtk_net_pre = MBTK_NET_PREF_UMTS_ONLY;
                break;
            case QL_NW_PREF_NET_TYPE_GSM_WCDMA_AUTO:
                mbtk_net_pre = MBTK_NET_PREF_GSM_UMTS_AUTO;
                break;
            case QL_NW_PREF_NET_TYPE_LTE_GSM_WCDMA:
                mbtk_net_pre = MBTK_NET_PREF_GSM_UMTS_LTE_AUTO;
                break;
            case QL_NW_PREF_NET_TYPE_LTE_ONLY:
                mbtk_net_pre = MBTK_NET_PREF_LTE_ONLY;
                break;
            case QL_NW_PREF_NET_TYPE_LTE_WCDMA:
                mbtk_net_pre = MBTK_NET_PREF_UMTS_LTE_AUTO;
                break;
            case QL_NW_PREF_NET_TYPE_LTE_GSM_GSM_PREF:
                mbtk_net_pre = MBTK_NET_PREF_GSM_LTE_GSM_PREF;
                break;
            case QL_NW_PREF_NET_TYPE_LTE_GSM_LTE_PREF:
                mbtk_net_pre = MBTK_NET_PREF_GSM_LTE_LTE_PREF;
                break;
            case QL_NW_PREF_NET_TYPE_LTE_GSM:
                mbtk_net_pre = MBTK_NET_PREF_GSM_LTE_AUTO;
                break;
            case QL_NW_PREF_NET_TYPE_LTE_WCDMA_WCDMA_PREF:
                mbtk_net_pre = MBTK_NET_PREF_UMTS_LTE_UMTS_PREF;
                break;
            case QL_NW_PREF_NET_TYPE_LTE_WCDMA_LTE_PREF:
                mbtk_net_pre = MBTK_NET_PREF_UMTS_LTE_LTE_PREF;
                break;
            case QL_NW_PREF_NET_TYPE_LTE_GSM_WCDMA_GSM_PREF:
                mbtk_net_pre = MBTK_NET_PREF_GSM_UMTS_LTE_GSM_PREF;
                break;
            case QL_NW_PREF_NET_TYPE_LTE_GSM_WCDMA_WCDMA_PREF:
                mbtk_net_pre = MBTK_NET_PREF_GSM_UMTS_LTE_UMTS_PREF;
                break;
            case QL_NW_PREF_NET_TYPE_LTE_GSM_WCDMA_LTE_PREF:
                mbtk_net_pre = MBTK_NET_PREF_GSM_UMTS_LTE_LTE_PREF;
                break;
            default:
                mbtk_net_pre = 0xFF;
                break;
        }
    }
    return mbtk_net_pre;
}

QL_NW_ERROR_CODE ql_nw_set_config(QL_NW_CONFIG_INFO_T *pt_info)
{
    if(ql_info_handle == NULL || pt_info == NULL)
    {
        LOGE("ARG error.");
        return QL_NW_GENERIC_FAILURE;
    }

	if(pt_info->preferred_nw_mode < QL_NW_PREF_NET_TYPE_GSM_WCDMA || pt_info->preferred_nw_mode > QL_NW_PREF_NET_TYPE_LTE_GSM_WCDMA_LTE_PREF)
	{
        LOGE("Unknown preferred_nw_mode(%d) error.", pt_info->preferred_nw_mode);
		return QL_NW_GENERIC_FAILURE;
	}

    roaming_pref = pt_info->roaming_pref;

    mbtk_band_info_t band;
    memset(&band, 0, sizeof(mbtk_band_info_t));
    band.net_pref = net_pre_change(FALSE, pt_info->preferred_nw_mode);
    if(band.net_pref == 0xFF)
    {
        LOGE("net_pre_change() fail.");
        return QL_NW_GENERIC_FAILURE;
    }
    if(mbtk_current_band_set(ql_info_handle, &band)) {
        return QL_NW_GENERIC_FAILURE;
    } else {
        return QL_NW_SUCCESS;
    }
}

QL_NW_ERROR_CODE ql_nw_get_config(QL_NW_CONFIG_INFO_T *pt_info)
{
    if(ql_info_handle == NULL || pt_info == NULL)
    {
        LOGE("ARG error.");
        return QL_NW_GENERIC_FAILURE;
    }
    pt_info->roaming_pref = roaming_pref;
    mbtk_band_info_t band;
    if(mbtk_current_band_get(ql_info_handle, &band)) {
        return QL_NW_GENERIC_FAILURE;
    } else {
        pt_info->preferred_nw_mode = (QL_NW_PREFERRED_NETWORK_TYPE)net_pre_change(TRUE, band.net_pref);
        return QL_NW_SUCCESS;
    }
}

QL_NW_ERROR_CODE ql_nw_get_nitz_time_info(QL_NW_NITZ_TIME_INFO_T *pt_info)
{
    if(ql_info_handle == NULL || pt_info == NULL)
    {
        LOGE("ARG error.");
        return QL_NW_GENERIC_FAILURE;
    }
    memset(pt_info, 0x0, sizeof(QL_NW_NITZ_TIME_INFO_T));
    char time_str[100]={0};
    ///printf("mbtk_net_time_get begin\n");
    int err = mbtk_net_time_get(ql_info_handle, time_str);
    if(err) {
        LOGE("mbtk_net_time_get() fail.");
        return QL_NW_GENERIC_FAILURE;
    } else {
        memset(pt_info->nitz_time,0,32);
        memcpy(pt_info->nitz_time,time_str,strlen(time_str));
        if(mbtk_get_abs_time(time_str, &(pt_info->abs_time))) {
            LOGE("mbtk_get_abs_time() fail.");
            return QL_NW_GENERIC_FAILURE;
        }

        pt_info->leap_sec = 0;

        return QL_NW_SUCCESS;
    }
}

//--------------------------------------------------------------------------------------
QL_NW_ERROR_CODE ql_nw_event_register(unsigned int bitmask)
{
    /*
    NW_IND_VOICE_REG_EVENT_IND_FLAG 语音拨号注册事件
    NW_IND_DATA_REG_EVENT_IND_FLAG (1 << 1) 数据拨号注册事件
    NW_IND_SIGNAL_STRENGTH_EVENT_IND_FLAG (1 << 2) 信号强度事件
    NW_IND_NITZ_TIME_UPDATE_EVENT_IND_FLAG (1 << 3) 网络时间更新事件
    */
    if(bitmask == QL_NW_IND_VOICE_REG_EVENT_FLAG)
        {}
    if(bitmask == QL_NW_IND_DATA_REG_EVENT_FLAG)
        {}
    if(bitmask == QL_NW_IND_SIGNAL_STRENGTH_EVENT_FLAG)
        {}
    if(bitmask == QL_NW_IND_NITZ_TIME_UPDATE_EVENT_FLAG)
        {}
    return QL_NW_SUCCESS;
}
//--------------------------------------------------------------------------------------

QL_NW_ERROR_CODE ql_nw_get_operator_name(QL_NW_OPERATOR_INFO_T *pt_info)
{
    if(ql_info_handle == NULL || pt_info == NULL)
    {
        LOGE("ARG error.");
        return QL_NW_GENERIC_FAILURE;
    }
    char OperatorFN[128];
    char OperatorSH[128];
    char MccMnc[128];
    mbtk_net_info_t net;
    if(!mbtk_net_sel_mode_get(ql_info_handle, &net) && net.plmn > 0)
    {
        // printf("Net : %d, %d, %d\n", net.net_sel_mode, net.net_type, net.plmn);
        int i = 0;
        while(i < ARRAY_SIZE(operator_mcc_mnc))
        {
            if(operator_mcc_mnc[i].mcc_mnc == net.plmn)
                break;
            i++;
        }

        if(i == ARRAY_SIZE(operator_mcc_mnc))   // No found mcc&mnc
        {
            strcpy(OperatorFN, "UNKNOWN");
            strcpy(OperatorSH, "UNKNOWN");
            sprintf(MccMnc, "%d", net.plmn);
        }
        else
        {
            strcpy(OperatorFN, operator_mcc_mnc[i].operator_l);
            strcpy(OperatorSH, operator_mcc_mnc[i].operator_s);
            sprintf(MccMnc, "%d", operator_mcc_mnc[i].mcc_mnc);
        }
        memset(pt_info->long_eons,0,128);
        memcpy(pt_info->long_eons,operator_mcc_mnc[i].operator_l,strlen(operator_mcc_mnc[i].operator_l));
        memset(pt_info->short_eons,0,128);
        memcpy(pt_info->short_eons,operator_mcc_mnc[i].operator_s,strlen(operator_mcc_mnc[i].operator_s));
        memset(pt_info->mcc,0,4);
        memset(pt_info->mnc,0,4);
        sprintf(pt_info->mcc, "%d", (operator_mcc_mnc[i].mcc_mnc)/100);
        if(0 == operator_mcc_mnc[i].mcc_mnc % 100)
        {
            strcpy(pt_info->mnc, "00");   
        }
        else
        {
            sprintf(pt_info->mnc, "%d", (operator_mcc_mnc[i].mcc_mnc)%100);
        }
        //pt_info->act;
        return QL_NW_SUCCESS;
    }

    return QL_NW_GENERIC_FAILURE;
}

QL_NW_ERROR_CODE ql_nw_perform_scan(QL_NW_SCAN_RESULT_LIST_INFO_T *pt_info)
{
    if(ql_info_handle == NULL || pt_info == NULL)
    {
        LOGE("ARG error.");
        return -1;
    }
	list_node_t* net_list = NULL;
    int ret = mbtk_available_net_get(ql_info_handle, &net_list);
    if(ret != 0)
    {
        LOGE("mbtk_available_net_get fail.");
        return QL_NW_GENERIC_FAILURE;
    }
    else
    {
        memset(pt_info, 0x0, sizeof(QL_NW_SCAN_RESULT_LIST_INFO_T));
        mbtk_net_info_t* net = NULL;
		list_first(net_list);
        int i=0;
        while ((net = (mbtk_net_info_t*) list_next(net_list)))
        {
            //printf("Net : %d, %d, %d, %d\n", net->net_sel_mode, net->net_type, net->net_state, net->plmn);
            if(net->net_state == 8)
                pt_info->entry[i].status = QL_NW_ACCESS_TECH_E_UTRAN_CA;
            else if(net->net_state == 0xff)
                pt_info->entry[i].status = QL_NW_ACCESS_TECH_NONE;
            else
                pt_info->entry[i].status = net->net_state;

            int j = 0;
            while(j < ARRAY_SIZE(operator_mcc_mnc))
            {
                if(operator_mcc_mnc[j].mcc_mnc == net->plmn)
                    break;
                j++;
            }
            if(j == ARRAY_SIZE(operator_mcc_mnc))   // No found mcc&mnc
            {
                strcpy(pt_info->entry[i].operator_name.long_eons, "UNKNOWN");
                strcpy(pt_info->entry[i].operator_name.short_eons, "UNKNOWN");
                sprintf(pt_info->entry[i].operator_name.mcc, "%d", (net->plmn)/100);
                sprintf(pt_info->entry[i].operator_name.mnc, "%d", (net->plmn)%100);
            }
            else
            {
                strcpy(pt_info->entry[i].operator_name.long_eons, operator_mcc_mnc[j].operator_l);
                strcpy(pt_info->entry[i].operator_name.short_eons, operator_mcc_mnc[j].operator_s);
                sprintf(pt_info->entry[i].operator_name.mcc, "%d", (net->plmn)/100);
                sprintf(pt_info->entry[i].operator_name.mnc, "%d", (net->plmn)%100);
            }
            pt_info->entry[i].operator_name ;
            pt_info->entry[i].act = net->net_type;
            i++;
            if(i > 40)
                break;
        }
        pt_info->entry_len = i;
        list_free(net_list);
        return QL_NW_SUCCESS;
    }
}

#if 0
static int ql_query_registration_state(const char *type, int* regState,int *imsRegState,int * LAC, int *CID,int *netType,int * radioTechFam,int *netRejected)
{
    if(ql_info_handle == NULL || str_empty(type) || regState == NULL || imsRegState == NULL
        || LAC == NULL || CID == NULL || netType == NULL || radioTechFam == NULL || netRejected == NULL)
    {
        return -1;
    }
    mbtk_net_reg_info_t reg;
    int err = mbtk_net_reg_get(ql_info_handle, &reg);
    if(err) {
        *netRejected = err;
        return -1;
    } else {
        //printf("REG : %d, %d, %d, %04x, %08o\n", reg.state, reg.type, reg.ims_reg, reg.lac, reg.ci);
        // Voice/Data/IMS
        if(strcmp("VOICE", type) == 0) {
            *regState = reg.call_state;
        } else if(strcmp("DATA", type) == 0) {
            *regState = reg.data_state;
        } else if(strcmp("IMS", type) == 0) {
            *imsRegState = reg.ims_state;
        } else {
            return -1;
        }

        if(reg.call_state != MBTK_NET_REG_STATE_NON || reg.data_state != MBTK_NET_REG_STATE_NON || reg.ims_state != MBTK_NET_REG_STATE_NON) {
            sprintf(LAC, "%04x", reg.lac);
            sprintf(CID, "%08o", reg.ci);
            *netType = reg.type;
            *radioTechFam = RADIO_TECH_3GPP;
        }
        return 0;
    }

}
#endif

QL_NW_ERROR_CODE ql_nw_get_reg_status(QL_NW_REG_STATUS_INFO_T *pt_info)
{
    if(ql_info_handle == NULL || pt_info == NULL)
    {
        LOGE("ARG error.");
        return QL_NW_GENERIC_FAILURE;
    }
    /*VOICE/DATA/IMS*/
    mbtk_net_reg_info_t reg;
    int err = mbtk_net_reg_get(ql_info_handle, &reg);
    if(err) {
        LOGE("mbtk_net_reg_get fail.");
        return QL_NW_GENERIC_FAILURE;
    } else {
        memset(pt_info, 0x0, sizeof(QL_NW_REG_STATUS_INFO_T));
        pt_info->data_reg.state = (QL_NW_REG_STATE)reg.data_state;
        pt_info->data_reg.lac = reg.lac;
        pt_info->data_reg.cid = reg.ci;
        pt_info->voice_reg.state = (QL_NW_REG_STATE)reg.call_state;
        pt_info->voice_reg.lac = reg.lac;
        pt_info->voice_reg.cid = reg.ci;
        switch(reg.type)
        {
            case MBTK_RADIO_TECH_GSM:
            case MBTK_RADIO_TECH_GSM_COMPACT:
            case MBTK_RADIO_TECH_GSM_EGPRS:
            case MBTK_RADIO_TECH_UTRAN_HSPA:
            {
                pt_info->data_reg.rat = QL_NW_RADIO_TECH_GPRS;
                pt_info->voice_reg.rat = QL_NW_RADIO_TECH_GSM;
                break;
            }
            case MBTK_RADIO_TECH_UTRAN:
            case MBTK_RADIO_TECH_UTRAN_HSDPA:
            case MBTK_RADIO_TECH_UTRAN_HSUPA:
            case MBTK_RADIO_TECH_UTRAN_HSDPA_HSUPA:
            {
                pt_info->data_reg.rat = QL_NW_RADIO_TECH_UMTS;
                pt_info->voice_reg.rat = QL_NW_RADIO_TECH_UMTS;
                break;
            }
            case MBTK_RADIO_TECH_E_UTRAN:
            {
                pt_info->data_reg.rat = QL_NW_RADIO_TECH_LTE;
                pt_info->voice_reg.rat = QL_NW_RADIO_TECH_LTE;
                break;
            }
            default:
            {
                pt_info->data_reg.rat = QL_NW_RADIO_TECH_UNKNOWN;
                pt_info->voice_reg.rat = QL_NW_RADIO_TECH_UNKNOWN;
                break;
            }
        }
    }

    return 0;

#if 0
    int ret = ql_query_registration_state("VOICE", &(pt_info->voice_reg.state), &imsRegState, &(pt_info->voice_reg.lac), &(pt_info->voice_reg.cid), &netType, &(pt_info->voice_reg.rejectCause), &netRejected);
    if(ret != 0)
        err = QL_NW_GENERIC_FAILURE;
    else
        err = QL_NW_SUCCESS;
    ret = ql_query_registration_state("DATA", &(pt_info->data_reg.state), &imsRegState, &(pt_info->data_reg.lac), &(pt_info->data_reg.cid), &netType, &(pt_info->data_reg.rejectCause), &netRejected);
    if(ret != 0)
        err =  QL_NW_GENERIC_FAILURE;
    else
        err = QL_NW_SUCCESS;

    if(err == QL_NW_SUCCESS)
    {
        if(netType < 0 || netType > 8)
            pt_info->data_reg.rat = QL_NW_ACCESS_TECH_NONE;
        else
            pt_info->data_reg.rat = netType;
    }
    return err;
#endif
}

QL_NW_ERROR_CODE ql_nw_set_selection(QL_NW_SELECTION_INFO_T *pt_info)
{
    if(ql_info_handle == NULL || pt_info == NULL)
    {
        LOGE("ARG error.");
        return QL_NW_GENERIC_FAILURE;
    }

    mbtk_net_info_t net;
    net.net_type = 0xFF;
    char mccmnc[10];
    if(pt_info->nw_selection_mode == 0)
    {
        net.net_sel_mode = 0;
        net.plmn = 0;
    }
    else if(pt_info->nw_selection_mode == 1 && !str_empty(pt_info->mnc) && !str_empty(pt_info->mcc))
    {
        net.net_sel_mode = 1;
        memset(mccmnc, 0, 10);
        //memcpy(mccmnc, pt_info->mcc, 3);
        //memcpy(mccmnc + 3, pt_info->mnc, 3);
        sprintf(mccmnc,"%s%s",pt_info->mcc,pt_info->mnc);
        net.plmn = (uint32)atoi(mccmnc);
        if(pt_info->act < QL_NW_ACCESS_TECH_GSM || pt_info->act > QL_NW_ACCESS_TECH_UTRAN_HSPAP)
            net.net_type = 0xff;
        else
            net.net_type = pt_info->act;
    }
    else
    {
        LOGE("ARG error.");
        return QL_NW_GENERIC_FAILURE;
    }
    //printf("mccmnc = %s\n",mccmnc);
    //printf("net.plmn = %d\n",net.plmn);
    int ret = mbtk_net_sel_mode_set(ql_info_handle, &net);
    if(ret == 0)
    {
        return QL_NW_SUCCESS;
    }
    else
    {
        printf("mbtk_net_sel_mode_set error: %d\n",ret );
        return QL_NW_GENERIC_FAILURE;
    }
}

QL_NW_ERROR_CODE ql_nw_get_selection(QL_NW_SELECTION_INFO_T *pt_info)
{
    if(ql_info_handle == NULL || pt_info == NULL)
    {
        LOGE("ARG error.");
        return QL_NW_GENERIC_FAILURE;
    }
    char OperatorFN[128];
    char OperatorSH[128];
    char MccMnc[128];
    mbtk_net_info_t net;
    if(!mbtk_net_sel_mode_get(ql_info_handle, &net) && net.plmn > 0)
    {
        memset(pt_info, 0x0, sizeof(QL_NW_SELECTION_INFO_T));
        // printf("Net : %d, %d, %d\n", net.net_sel_mode, net.net_type, net.plmn);
        int i = 0;
        while(i < ARRAY_SIZE(operator_mcc_mnc))
        {
            if(operator_mcc_mnc[i].mcc_mnc == net.plmn)
                break;
            i++;
        }
        if(i == ARRAY_SIZE(operator_mcc_mnc))   // No found mcc&mnc
        {
            strcpy(OperatorFN, "UNKNOWN");
            strcpy(OperatorSH, "UNKNOWN");
            sprintf(MccMnc, "%d", net.plmn);
        }
        else
        {
            strcpy(OperatorFN, operator_mcc_mnc[i].operator_l);
            strcpy(OperatorSH, operator_mcc_mnc[i].operator_s);
            sprintf(MccMnc, "%d", operator_mcc_mnc[i].mcc_mnc);

            sprintf(pt_info->mcc,"%d",operator_mcc_mnc[i].mcc_mnc/100);
            sprintf(pt_info->mnc,"%d",operator_mcc_mnc[i].mcc_mnc%100);

        }
        pt_info->nw_selection_mode = net.net_sel_mode;

        pt_info->act = net.net_type;
        return QL_NW_SUCCESS;
    }

    return QL_NW_GENERIC_FAILURE;

}

QL_NW_ERROR_CODE ql_nw_get_signal_strength(QL_NW_SIGNAL_STRENGTH_INFO_T *pt_info)
{
    if(ql_info_handle == NULL || pt_info == NULL)
    {
        LOGE("ARG error.");
        return QL_NW_GENERIC_FAILURE;
    }

    int ret;
    mbtk_signal_info_t signal;
    ret = mbtk_net_signal_get(ql_info_handle, &signal);
    if(ret != 0) {
        LOGE("mbtk_net_signal_get fail.");
        return QL_NW_GENERIC_FAILURE;
    }
    else
    {
        int rssi = 0;
        if(SIGNAL_STRENGTH_INVALID_1 == signal.rssi)
        {
            rssi = SIGNAL_STRENGTH_INVALID_1;
        }
        else
        {
            rssi = 2 * signal.rssi - 113;
        }
        if(signal.type == MBTK_RADIO_TECH_GSM)              //GSM
        {
            pt_info->GW_SignalStrength.bitErrorRate = signal.ber;
            pt_info->GW_SignalStrength.ecio = signal.ecno;
            pt_info->GW_SignalStrength.rscp = signal.rscp;
            pt_info->GW_SignalStrength.rssi = rssi;
            
            pt_info->LTE_SignalStrength.rsrp = SIGNAL_STRENGTH_INVALID_1;
            pt_info->LTE_SignalStrength.rsrq = SIGNAL_STRENGTH_INVALID_1;
            pt_info->LTE_SignalStrength.rssnr = SIGNAL_STRENGTH_INVALID_2;
            pt_info->LTE_SignalStrength.rssi = SIGNAL_STRENGTH_INVALID_1;
        }
        else if(signal.type == MBTK_RADIO_TECH_E_UTRAN)     //LTE
        {
            pt_info->LTE_SignalStrength.cqi = SIGNAL_STRENGTH_INVALID_1;
            pt_info->LTE_SignalStrength.rsrp = signal.rsrp;
            pt_info->LTE_SignalStrength.rsrq = signal.rsrq;
            pt_info->LTE_SignalStrength.rssnr = signal.ecno;
            pt_info->LTE_SignalStrength.rssi = rssi;

            pt_info->GW_SignalStrength.bitErrorRate = SIGNAL_STRENGTH_INVALID_1;
            pt_info->GW_SignalStrength.ecio = SIGNAL_STRENGTH_INVALID_2;
            pt_info->GW_SignalStrength.rscp = SIGNAL_STRENGTH_INVALID_2;
            pt_info->GW_SignalStrength.rssi = SIGNAL_STRENGTH_INVALID_1;
        }
        else
        {
            return QL_NW_GENERIC_FAILURE;
        }
        LOGI("ql_GW_SignalStrength: %d , %d, %d, %d", pt_info->GW_SignalStrength.rssi, 
            pt_info->GW_SignalStrength.bitErrorRate, pt_info->GW_SignalStrength.rscp, pt_info->GW_SignalStrength.ecio);
        LOGI("ql_LTE_SignalStrength: %d , %d, %d, %d", pt_info->LTE_SignalStrength.rssi, 
            pt_info->LTE_SignalStrength.rsrp, pt_info->LTE_SignalStrength.rsrq, pt_info->LTE_SignalStrength.rssnr, pt_info->LTE_SignalStrength.cqi);
        return QL_NW_SUCCESS;
    }
}

QL_NW_ERROR_CODE ql_nw_get_cell_info(QL_NW_CELL_INFO_T *pt_info)
{
    list_node_t* cell_list = NULL;
    mbtk_cell_type_enum type;
    if(ql_info_handle == NULL || pt_info == NULL)
    {
        LOGE("ARG error.");
        return QL_NW_GENERIC_FAILURE;
    }

    memset(pt_info, 0, sizeof(QL_NW_CELL_INFO_T));
    int err = mbtk_cell_get(ql_info_handle, &type, &cell_list);
    if(err || cell_list == NULL) {
        LOGE("mbtk_cell_get fail.");
        return QL_NW_GENERIC_FAILURE;
    } else {
        list_first(cell_list);
        mbtk_cell_info_t* cell = (mbtk_cell_info_t*) list_next(cell_list);
        if(cell) { // Current server cell.
            switch(type)
            {
                case MBTK_CELL_TYPE_GSM:
                {
                    LOGD("GSM : lac=%d, ci=%d, arfcn=%d, bsic=%d", cell->value1, cell->value2, cell->value3, cell->value4);
                    pt_info->gsm_info[0].lac = cell->value1;
                    pt_info->gsm_info[0].cid = cell->value2;
                    pt_info->gsm_info[0].arfcn = cell->value3;
                    pt_info->gsm_info[0].bsic = cell->value4;
                    pt_info->gsm_info[0].mcc = cell->value5;
                    pt_info->gsm_info[0].mnc = cell->value6;
                    pt_info->gsm_info[0].flag = 0;
                    pt_info->gsm_info_num++;
                    pt_info->gsm_info_valid = 1;
                }
                    break;
                case MBTK_CELL_TYPE_UMTS:
                {
                    LOGD("UMTS : lac=%d, ci=%d, arfcn=%d", cell->value1, cell->value2, cell->value3);
                    pt_info->umts_info[0].lac = cell->value1;
                    pt_info->umts_info[0].cid = cell->value2;
                    pt_info->umts_info[0].uarfcn = cell->value3;
                    pt_info->umts_info[0].mcc = cell->value4;
                    pt_info->umts_info[0].mnc = cell->value5;
                    pt_info->umts_info[0].psc = cell->value6;
                    pt_info->umts_info[0].flag = 0;
                    pt_info->umts_info_num++;
                    pt_info->umts_info_valid = 1;
                }
                    break;
                case MBTK_CELL_TYPE_LTE:
                {
                    LOGD("LTE : tac=%d, PCI=%d, dlEuarfcn=%d, ulEuarfcn=%d, band=%d", cell->value1, cell->value2, cell->value3, cell->value4, cell->value5);
                    pt_info->lte_info[0].tac = cell->value1;
                    pt_info->lte_info[0].pci = cell->value2;
                    pt_info->lte_info[0].earfcn = cell->value3;
                    pt_info->lte_info[0].cid = cell->value8;
                    pt_info->lte_info[0].mcc = cell->value6;
                    pt_info->lte_info[0].mnc = cell->value7;
                    pt_info->lte_info[0].flag = 0;
                    pt_info->lte_info_num++;
                    pt_info->lte_info_valid = 1;
                    break;
                }
                default:
                    break;
            }
        }
        while ((cell = (mbtk_cell_info_t*) list_next(cell_list)))
        {
            switch(type)
            {
                case MBTK_CELL_TYPE_GSM:
                {
                    LOGD("CELL : %d, %d, %d, %d, %d", cell->value1, cell->value2, cell->value3, cell->value4, cell->value5);
                    pt_info->gsm_info[pt_info->gsm_info_num].lac = cell->value1;
                    pt_info->gsm_info[pt_info->gsm_info_num].cid = cell->value2;
                    pt_info->gsm_info[pt_info->gsm_info_num].arfcn = cell->value3;
                    pt_info->gsm_info[pt_info->gsm_info_num].bsic = cell->value4;
                    pt_info->gsm_info[pt_info->gsm_info_num].flag = 1;
                    pt_info->gsm_info_num++;
                    pt_info->gsm_info_valid = 1;
                }
                    break;
                case MBTK_CELL_TYPE_UMTS:
                {
                    LOGD("CELL : lac=%d, ci=%d, arfcn=%d", cell->value1, cell->value2, cell->value3);
                    pt_info->umts_info[pt_info->umts_info_num].lac = cell->value1;
                    pt_info->umts_info[pt_info->umts_info_num].cid = cell->value2;
                    pt_info->umts_info[pt_info->umts_info_num].uarfcn = cell->value3;
                    pt_info->umts_info[pt_info->umts_info_num].flag = 1;
                    pt_info->umts_info_num++;
                    pt_info->umts_info_valid = 1;
                }
                    break;
                case MBTK_CELL_TYPE_LTE:
                {
                    LOGD("CELL : phyCellId=%d, euArfcn=%d, rsrp=%d, rsrq=%d", cell->value1, cell->value2, cell->value3, cell->value4);
                    pt_info->lte_info[pt_info->lte_info_num].cid = cell->value1;
                    pt_info->lte_info[pt_info->lte_info_num].earfcn = cell->value2;
                    pt_info->lte_info[pt_info->lte_info_num].tac = cell->value3;
                    pt_info->lte_info[pt_info->lte_info_num].pci = cell->value4;
                    pt_info->lte_info[pt_info->lte_info_num].flag = 1;
                    pt_info->lte_info_num++;
                    pt_info->lte_info_valid = 1;
                }
                    break;
                default:
                    break;
            }
        }
        list_free(cell_list);
    }

    LOGD("get_cell_success: %d, %d, %d.",pt_info->gsm_info_valid, pt_info->umts_info_valid, pt_info->lte_info_valid);
    return QL_NW_SUCCESS;
}

QL_NW_ERROR_CODE ql_nw_add_event_handler(QL_NW_EventHandlerFunc_t handlerPtr,void* contextPtr)
{
    if(ql_info_handle == NULL || handlerPtr == NULL)
    {
        LOGE("ARG error.");
        return QL_NW_GENERIC_FAILURE;
    }
    mbtk_net_state_change_cb_reg(ql_info_handle, ql_nw_state_change_cb);
    ql_func_cb_handle.handlerPtr = handlerPtr;
    ql_func_cb_handle.contextPtr = contextPtr;
    return QL_NW_SUCCESS;
}

QL_NW_ERROR_CODE ql_nw_get_volte_state(VOLTE_STATE *state)
{
    int ret;
    if(ql_info_handle == NULL || state == NULL)
    {
        LOGE("ARG error.");
        return QL_NW_GENERIC_FAILURE;
    }
    ret = mbtk_volte_state_get(ql_info_handle, &(state->reg_state));
    if(ret != 0)
        return QL_NW_GENERIC_FAILURE;
    else
        return QL_NW_SUCCESS;
}

QL_NW_ERROR_CODE ql_nw_csq_get_signal_strength(QL_NW_CSQ_SIGNAL_STRENGTH_INFO_T *pt_info)
{
    int ret;
    if(ql_info_handle == NULL || pt_info == NULL)
    {
        LOGE("ARG error.");
        return QL_NW_GENERIC_FAILURE;
    }
    mbtk_signal_info_t signal;
    ret = mbtk_net_signal_get(ql_info_handle, &signal);
    if(ret != 0)
        return QL_NW_GENERIC_FAILURE;
    else
    {
        pt_info->rssi = (signal.rssi * 2 - 113);
        pt_info->bitErrorRate = signal.ber;
        LOGD("pt_info->rssi = %d  pt_info->bitErrorRate = %d",pt_info->rssi,pt_info->bitErrorRate);
        return QL_NW_SUCCESS;
    }
}

//*********************************************************************************

