/*
*
* Data : 2023/03/28 16:00:28
* Author : Hanzhiyu
*
*/
#include "ql/ql_sleep_wakelock.h"
#include <stdio.h>
#include <unistd.h>
#include <stddef.h>
#include "mbtk_type.h"
#include "mbtk_log.h"

typedef struct
{
    int fd;
    char name[128];
} lock_name;

lock_name ql_lock_name[512]={0};
static bool autosleep_enable = FALSE;

extern int Ql_Autosleep_Enable(char enable)
{
    if(enable == 1)
    {
        if(!access("/sys/power/autosleep", W_OK))
        {
            system("echo mem > /sys/power/autosleep");
            autosleep_enable = TRUE;
            return 0;
        }
        else
        {
            LOGE("/sys/power/autosleep can not write.");
            return -1;
        }
    }
    else
    {
        if(!access("/sys/power/autosleep", W_OK))
        {
            system("echo off > /sys/power/autosleep");
            autosleep_enable = FALSE;
            return 0;
        }
        else
        {
            LOGE("/sys/power/autosleep can not write.");
            return -1;
        }
    }
}

extern int Ql_SLP_WakeLock_Create(const char *name, size_t len)
{
    if(!autosleep_enable) {
        LOGE("Autosleep not enable.");
        return -1;
    }

    if(name != NULL && len < 127)
    {
        int i;
        for(i=0;i<512;i++)
        {
            if(ql_lock_name[i].fd == 0)
                break;
        }
        memcpy(ql_lock_name[i].name, name, strlen(name)+1);
        ql_lock_name[i].fd = i;
        return ql_lock_name[i].fd;
    }
    else
        return -1;
}

extern int Ql_SLP_WakeLock_Lock(int fd)
{
    if(!autosleep_enable) {
        LOGE("Autosleep not enable.");
        return -1;
    }

    int i;
    for(i=0;i<512;i++)
    {
        if(ql_lock_name[i].fd == fd)
            break;
    }
    if(i == 512)
        return -1;

    if(!access("/sys/power/wake_lock", W_OK))
    {
        char cmd[128]={0};
        sprintf(cmd, "echo %s > /sys/power/wake_lock", ql_lock_name[i].name);
        system(cmd);
        return 0;
    }
    else
    {
        printf("/sys/power/wake_lock can not write.");
        return -1;
    }
}

extern int Ql_SLP_WakeLock_Unlock(int fd)
{
    if(!autosleep_enable) {
        LOGE("Autosleep not enable.");
        return -1;
    }

    int i;
    for(i=0;i<512;i++)
    {
        if(ql_lock_name[i].fd == fd)
            break;
    }
    if(i == 512)
        return -1;

    if(!access("/sys/power/wake_unlock", W_OK))
    {
        char cmd[128]={0};
        sprintf(cmd, "echo %s > /sys/power/wake_unlock", ql_lock_name[i].name);
        system(cmd);
        return 0;
    }
    else
    {
        printf("/sys/power/wake_unlock can not write.");
        return -1;
    }

}

extern int Ql_SLP_WakeLock_Destroy(int fd)
{
    if(!autosleep_enable) {
        LOGE("Autosleep not enable.");
        return -1;
    }

    int i;
    for(i=0;i<512;i++)
    {
        if(ql_lock_name[i].fd == fd)
        break;
    }
    if(i == 512)
        return -1;
    else
    {
        ql_lock_name[i].fd = 0;
        memset(ql_lock_name[i].name, 0, 128);
        return 0;
    }
}

