#include "mbtk_type.h"
#include "ql/ql_at.h"
#include "ql/ql_vcall.h"
#include "ql/ql_mcm_call.h"
#include "ql/ql_voice.h"

typedef struct
{
    int  cmdIdx;
    char *funcName;
} st_api_test_case;

//for server test
st_api_test_case at_api_testcases[] =
{
    {0,   "print_help"},
    {1,   "QL_Voice_Call_Ecall"},
    {2,   "QL_Voice_Call_Ecall_HangUp"},

    {-1,    NULL}
};


voice_client_handle_type h_voice = 0;


void print_help(void)
{
    int i;

    printf("Supported test cases:\n");
    for(i = 0; ; i++)
    {
        if(at_api_testcases[i].cmdIdx == -1)
        {
            break;
        }
        printf("%d:\t%s\n", at_api_testcases[i].cmdIdx, at_api_testcases[i].funcName);
    }
}

static void ql_voice_call_ind_func(unsigned int ind_id,
                                   void* ind_data,
                                   uint32_t ind_data_len)
{
    if(NULL == ind_data)
    {
        return;
    }

    switch(ind_id)
    {
        case E_QL_MCM_VOICE_CALL_IND:
        {
            if(ind_data_len != sizeof(ql_mcm_voice_call_ind))
            {
                break;
            }

            ql_mcm_voice_call_ind *pVoiceCallInd = (ql_mcm_voice_call_ind*)ind_data;

            char *call_state[] = {"INCOMING", "DIALING", "ALERTING", "ACTIVE", "HOLDING", "END", "WAITING"};

            int i = 0;
            for(i = 0; i < pVoiceCallInd->calls_len; i++)
            {
                printf("######### Call id=%d, PhoneNum:%s, event=%s!  ######\n",
                            pVoiceCallInd->calls[i].call_id, pVoiceCallInd->calls[i].number, call_state[pVoiceCallInd->calls[i].state]);
            }

            break;
        }

        case E_QL_MCM_VOICE_ECALL_STATUE_IND:
        {
            if(ind_data_len != sizeof(ql_mcm_voice_ecall_status_ind))
            {
                break;
            }

            ql_mcm_voice_ecall_status_ind *pEcallStatusInd
                                           = (ql_mcm_voice_ecall_status_ind*)ind_data;

            if (pEcallStatusInd->ecall_msd_tx_status_valid)
            {
                if (pEcallStatusInd->ecall_msd_tx_status == E_QL_MCM_VOICE_ECALL_MSD_TRANSMISSION_STATUS_SUCCESS)
                {
                    printf("========== Ecall status  call_id =%d ,   ecall msd tx success.\r\n", pEcallStatusInd->call_id);
                }
                else
                {
                    printf("========== Ecall status  call_id =%d ,   ecall msd tx failure.\r\n",  pEcallStatusInd->call_id);
                }
            }
            else
            {
                printf("========== Ecall status  call_id =%d  \r\n", pEcallStatusInd->call_id);
            }

            break;
        }

        case E_QL_MCM_VOICE_UNKOWN_IND:
        default:
            break;
    }
}

//"\t1 call init\n"
QL_VOICE_ERROR_CODE ql_voice_call_init()
{
    int ret = 0;
    ret = QL_Voice_Call_Client_Init(&h_voice);
    if(ret < 0)
    {
        printf("QL_Voice_Call_Client_Init FAIL. ret:%d\n",ret);
        ret = QL_VOICE_GENERIC_FAILURE;
    }
    else{
        printf("QL_Voice_Call_Client_Init ret = %d, with h_voice=%d\n", ret, h_voice);
    }

    return ret;
}

//"\t9 call deinit\n"
QL_VOICE_ERROR_CODE ql_voice_call_release()
{
    int ret = 0;
    ret = QL_Voice_Call_Client_Deinit(h_voice);
    if(ret)
    {
        ret = QL_VOICE_GENERIC_FAILURE;
    }
    
    return ret;
}

//\t2 call register handle\n"
QL_VOICE_ERROR_CODE ql_voice_call_event_register(QL_VOICE_EventHandlerFunc_t handlerPtr, void* contextPtr)
{
    int ret = 0;
    ret = QL_Voice_Call_AddCommonStateHandler(h_voice, (QL_VoiceCall_CommonStateHandlerFunc_t)ql_voice_call_ind_func);
    if(ret < 0)
    {
        printf("QL_Voice_Call_AddCommonStateHandler FAIL.       ret:%d\n",ret);
        ret = QL_VOICE_GENERIC_FAILURE;
    }
    
    return ret;
}

/*
    Phone call.
     -call_num   : dst phone number
*/
QL_VOICE_ERROR_CODE ql_voice_call_start(char* call_num)
{
    int ret = 0;

    ret = QL_Voice_Call_Start(h_voice, 0, call_num, NULL);
    if(ret)
    {
        ret = QL_VOICE_GENERIC_FAILURE;
    }
    return ret;
}


/*
    Put through.
*/
QL_VOICE_ERROR_CODE ql_voice_call_answer()
{
    int ret = 0;
    ret = QL_Voice_Call_Answer(h_voice, 0);
    if(ret)
    {
        ret = QL_VOICE_GENERIC_FAILURE;
    }
    return ret;
}
QL_VOICE_ERROR_CODE ql_voice_auto_answer(int seconds)
{
    int ret = 0;

    ret = QL_Voice_Call_SetAutoAnswer(h_voice, E_QL_MCM_VOICE_AUTO_ANSWER_ENABLE, 6000);
    if(ret)
    {
        ret = QL_VOICE_GENERIC_FAILURE;
    }
    return ret;
}

/*
    Hang up.
*/
QL_VOICE_ERROR_CODE ql_voice_call_end()
{
    int ret = 0;
    ret = QL_Voice_Call_End(h_voice, 0);
    if(ret)
    {
        ret = QL_VOICE_GENERIC_FAILURE;
    }

    return ret;
}


/* hold the voice */
QL_VOICE_ERROR_CODE ql_voice_call_hold()
{
    int ret = 0;
    QL_Voice_Call_Hold(h_voice);

    return ret;
}

/* unhold the voice */
QL_VOICE_ERROR_CODE ql_voice_call_unhold()
{
    int ret = 0;

    QL_Voice_Call_UnHold(h_voice);

    return ret;
}

