#ifndef  __HD8040_PORT_H
#define  __HD8040_PORT_H

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <fcntl.h>
#include <termios.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/un.h>
//#include <sys/prctl.h>
#include <sys/time.h>
#include <dirent.h>
#include <sys/stat.h>

#define SUCCESS 0
#define FAIL -1

#ifndef HDBD_LOG
#define HDBD_LOG printf
#endif

typedef unsigned char  uint8_t;
typedef unsigned short int uint16_t;
typedef unsigned int   uint32_t;
/* For communication buadrate */
#define COMM_BAUDRATE_PHONE 115200

/* For upgrade baudrate */
#define UPGRADE_BAUDRATE_PHONE 460800

/* <Function define Config begin */
#define DEBUG_RUN_TIME 0
/* Function define Config end> */

/* Function Declaration */
/* Basic operation for serial port */
extern int uart_set(int fd, int speed, int flow_ctrl, int databits, int stopbits, int parity);
extern int uart_init(int fd, int speed, int flow_ctrl, int databits, int stopbits, int parity);
extern int uart_send(int fd, const uint8_t *cmd, int cmd_len);
extern int uart_recv(int fd, uint8_t *buf, int *actual_length, int timeout);
extern void clearBuffer(int fd, int selector);
extern int uart_open(unsigned char * GPS_DEVICE);
extern int uart_close(int fd);
extern int OpenUart(char* UART_DEV);
extern int set_baudrate(int fd, uint8_t baud);
#endif
