#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <fcntl.h>
#include <time.h>
#include <unistd.h>
#include <errno.h>
#include "log_config.h"

#define  ALOG_DEV "/dev/log_radio"

static const char *log_file, *log_ip, *log_port, *log_prefix, *pid_file, *hostname;
static int log_size = 1 * 1024 * 1024;

static log_config_entry *config = NULL;
static char tmp_log[48] = {0};


static int fileter_log(int pri, char *tag, struct filter_list_t *filter)
{
    struct filter_list_t *_filter = filter;

    while(_filter)
    {
        // _filter->priority
        // 获取 筛选的等级 p
        int p = 0;
        if(_filter->tag)
        {
            int len = strlen(_filter->tag);
            // tag and priority
            if(0 == memcmp(_filter->tag, tag, len) && ((pri > p) || (pri == p)))
                return 0;
        }else{ // have no tag
            if(pri < p)
                return -1;
            else
                return 0;
        }
        _filter = _filter->next;
    }

    return -1;
}

int common_log_print(
    int fd,
    struct file_list_t *_file_list,
    char *entry)
{
    char priChar;
    char timeBuf[32];
    char defaultBuffer[512];
    size_t totalLen;
    int fd_new = fd;
	struct stat s;
	time_t timetemp; // 定义一个时间结构体变量
    char * ret = NULL;

	if (log_size && (!stat(tmp_log, &s)) && (s.st_size > log_size)) {
        fd_new = get_rotate_file(fd_new, log_file, _file_list);
		if (fd_new < 0) {
			fprintf(stderr, "failed to open %s: %s\n", log_file, strerror(errno));
			exit(-1);
        }
	}

    // if(fileter_log(entry->priority, entry->tag, config->filter_list))
    // {
        // printf("%s %d: fileter pri:%d tag:%s!\n", __FUNCTION__, __LINE__, entry->priority, entry->tag);
    //     return -1;
    // }
	time(&timetemp); // 获得时间参数
    struct tm* ptm = localtime(&timetemp);
    strftime(timeBuf, sizeof(timeBuf), "%Y-%m-%d %H:%M:%S", ptm);

    totalLen = snprintf(defaultBuffer, sizeof(defaultBuffer),
    "%s : %s\n", timeBuf, entry);

    ret = write(fd_new, defaultBuffer, totalLen);

    return ret;
}

void* common_log_thread(void* argv)
{
    int dev_fd, ret;
    int log_fd;
    char buf[512] = {0};
    static struct file_list_t file_list;
    config = (log_config_entry *)argv;

    pthread_detach(pthread_self());
    if (NULL == argv || NULL == config->name)
        return NULL;

    dev_fd = open(config->name, O_RDONLY, 0600);
    if (dev_fd < 0) {
        fprintf(stderr, "failed to open %s: %s\n", config->name, strerror(errno));
        exit(-1);
    }

    memset(&file_list, 0, sizeof(struct file_list_t));
    file_list.total = config->rotate_file_count;
    log_file = config->out_path;

    if (config->ip && config->port) {
        int port = atoi(config->port);
        printf("%s %d : %s:%s\n", __FUNCTION__, __LINE__, config->ip, config->port);
        log_fd = tcp_connect(config->ip, port);
    } else if (log_file) {
        sprintf(tmp_log, "/tmp/log%s", strstr_tail(log_file, "/"));
        // 先将文件保存到 /tmp/log/ 目录下，后面到达 rotate_file_size 后，转移到out_path
        log_fd = open(tmp_log, O_CREAT | O_WRONLY| O_APPEND, 0600);
        if (log_fd < 0) {
            fprintf(stderr, "failed to open %s: %s\n", tmp_log, strerror(errno));
            exit(-1);
        }
    } else {
        log_fd = STDOUT_FILENO;
    }
    if(config->rotate_file_size)
        log_size = config->rotate_file_size;

    printf("uart log start...\n");
    while (1) {
        ret = read(dev_fd, buf, sizeof(buf));
        if (ret < 0) {
            printf("read error\n");
            break;
        }
        // common_log_process(buf, ret, &entry);
        common_log_print(log_fd, &file_list, buf);
        memset(buf, 0, sizeof(buf));
    }
    close(dev_fd);
    close(log_fd);

    printf("%s exit \n", __FUNCTION__);
    pthread_exit(NULL);
	return NULL;
}
