#include "lynq-qser-autosuspend.h"

#include <stdio.h>
#include <unistd.h>
#include <stddef.h>
#include "mbtk_type.h"
#include "mbtk_log.h"

/*白名单配置备注
例如AT*POWERIND=31，就相当于设置NETWORK、SIM、SMS、CS CALL、PS DATA变化时都不主动上报，
其中PS DATA目前暂时不支持，只是保留了这个标志位（ARS人员回复当前平台结论）
AP power state: 1~31 means suspend, bitmap: bit0 - NETWORK;bit1 - SIM;bit2 - SMS;bit3 - CS CALL;bit4 - PS DATA
0 means resume all.

该值上电默认值是1，既平台默认是NW不主动上报

白名单的状态由四位数字组成，从左往右判断
第一位代表是否屏蔽电话唤醒，
第二位代表是否屏蔽网络注册状态唤醒，
第三位代表是否屏蔽数据业务唤醒，
第四位代表是否屏蔽短信唤醒。

其中 0 代表屏蔽，1 代表不屏蔽。

第一位：1：打开电话唤醒，其他：屏蔽电话唤醒
第二位：1：打开网络注册状态唤醒，其他：屏蔽网络注册状态唤醒
第三位：1：打开数据业务唤醒，其他：屏蔽数据业务唤醒
第四位：1：打开短信唤醒，其他屏蔽短信唤醒

注意：从左往右开始判断
平台原因：所以默认状态位1011
*/

static void qser_lpm_handler(qser_lpm_edge_t edge_state)
{
 printf("this is qser_lpm_handler, edge_state=%d\n", edge_state);
}


int main(int argc, char *argv[])
{
    char operator[10];
    int opt;
    int lv_voll = 0;
    int fd_t;
    mbtk_log_init("radio", "SLEEP_TEST");

    printf("=========sleep main=========\n"
        "\t0 exit\n"
        "\t1 autosuspend enable\n"
        "\t2 wakelock create\n"
        "\t3 wakelock lock\n"
        "\t4 wakelock unlock\n"
        "\t5 wakelock destroy\n"
        "\t6 whitelist set\n"
        "\t7 whitelist get\n"
        "\t8 lpm init\n"
        "\t9 lpm destroy\n"
        "operator: >> \n");

    while(1)
    {

        fgets(operator, sizeof(operator), stdin);
        fflush(stdin);
        opt = atoi(operator);
        switch (opt)
        {
        case 0:
            printf("main exit\n");
            return 0;
        case 1:
            {
                printf(">>>>>Input 0 or 1<<<<<\n");
                char tmp_en[4]={0};
                memset(tmp_en, 0x00, sizeof(tmp_en));
                fgets(tmp_en, sizeof(tmp_en)-1, stdin);
                fflush(stdin);

                if (tmp_en[0] == '0' || tmp_en[0] == '1')
                    qser_autosuspend_enable(tmp_en[0]);
                else
                    printf(">>>>>re Input 0 or 1 error<<<<<\n");
            }
            break;
        case 2:
            {
                printf(">>>>>Input name<<<<<\n");
                char t_name[64]={0};
                int len_name;
                char tmp_c[64]={0};
                memset(tmp_c, 0x00, sizeof(tmp_c));
                fgets(tmp_c, sizeof(tmp_c)-1, stdin);
                fflush(stdin);
                len_name = strlen(tmp_c)-1;
                strncpy(t_name, tmp_c, len_name);
                printf(">>>>>name=[%s] name_len=[%d]<<<<<\n",t_name, len_name);

                fd_t = qser_wakelock_create(t_name, len_name);
                if (fd_t == -1)
                {
                    printf(">>>>>Output error =[%d]<<<<<\n",fd_t);
                }
                else
                {
                    printf(">>>>>Output ID NUM =[%d]<<<<<\n",fd_t);
                }
            }
            break;
        case 3:
            {
                printf(">>>>>Input ID NUM<<<<<\n");
                char tmp_l[127]={0};
                fgets(tmp_l, sizeof(tmp_l), stdin);
                fflush(stdin);
                fd_t = atoi(tmp_l);
                fd_t = qser_wakelock_lock(fd_t);
                if (fd_t == -1)
                {
                    printf(">>>>>Output error =[%d]<<<<<\n",fd_t);
                }
                else
                {
                    printf(">>>>>Output succuess<<<<<\n");
                }
            }
            break;
        case 4:
            {
                printf(">>>>>Input ID NUM<<<<<\n");
                char tmp_ul[127]={0};
                memset(tmp_ul, 0x00, sizeof(tmp_ul));
                fgets(tmp_ul, sizeof(tmp_ul)-1, stdin);
                fflush(stdin);
                fd_t = atoi(tmp_ul);
                fd_t = qser_wakelock_unlock(fd_t);
                if (fd_t == -1)
                {
                    printf(">>>>>Output error =[%d]<<<<<\n",fd_t);
                }
                else
                {
                    printf(">>>>>Output succuess<<<<<\n");
                }
            }
            break;
        case 5:
            {
                printf(">>>>>Input ID NUM<<<<<\n");
                char tmp_d[127]={0};
                memset(tmp_d, 0x00, sizeof(tmp_d));
                fgets(tmp_d, sizeof(tmp_d)-1, stdin);
                fflush(stdin);
                fd_t = atoi(tmp_d);
                fd_t = qser_wakelock_destroy(fd_t);
                if (fd_t == -1)
                {
                    printf(">>>>>Output error =[%d]<<<<<\n",fd_t);
                }
                else
                {
                    printf(">>>>>Output succuess<<<<<\n");
                }
            }
            break;
        case 6:
            {
                printf(">>>>>Input whitelish NUM  4位(eg:1010) <<<<<\n");
                char whitelish[16]={0};
                int len_whitelish;
                char tmp[16]={0};
                memset(tmp, 0x00, sizeof(tmp));
                fgets(tmp, sizeof(tmp)-1, stdin);
                fflush(stdin);
                len_whitelish = strlen(tmp)-1;

                strncpy(whitelish, tmp, len_whitelish);
                printf(">>>set tmp =[%s] list = [%s] len_whitelish =[%d]\n",tmp, whitelish,len_whitelish);

                qser_whitelist_set(whitelish);
            }
            break;
        case 7:
            {
                char whitelish_get[10]={0};

                qser_whitelist_get(whitelish_get);
                printf(">>>get list = [%s]\n", whitelish_get);
            }
            break;
        case 8:
            {
                qser_pm_cfg_t *qser_lpm_cfg = NULL;
                qser_lpm_cfg = (qser_pm_cfg_t *)malloc(sizeof(qser_pm_cfg_t));
                qser_lpm_cfg->wakeupin.wakeupin_pin = 50;
                qser_lpm_cfg->wakeupin.wakeupin_edge = E_QL_LPM_FALLING;
                qser_lpm_init(qser_lpm_handler, qser_lpm_cfg);
                free(qser_lpm_cfg);
            }
            break;
        case 9:
            qser_lpm_deinit();
            break;

        default:
            break;
        }

    }

    return 0;
}

