/*
    MBTK ADC interface define.
*/
/******************************************************************************

                   EDIT HISTORY FOR FILE

  WHEN        WHO       WHAT,WHERE,WHY
--------    --------    -------------------------------------------------------
2023/4/3      b.liu    Initial version

******************************************************************************/
#ifndef __MBTK_ADC_H__
#define __MBTK_ADC_H__

#define ADC_DEVICE_802 "/sys/devices/soc.0/d4000000.apb/pxa2xx-i2c.2/i2c-2/2-0030/pm802-bat/adc"
#define ADC_DEVICE_803 "/sys/kernel/debug/adc"
#define ADC_DEVICE_PMIC802 "/sys/devices/platform/asr-adc/pm80x_adc"
#define ADC_DEVICE_AUX "/sys/devices/platform/asr-adc/aux_adc"

/*
* MBTK ADC define.
*/
typedef enum {
    MBTK_ADC0 = 0,  /* ADC 0 */
    MBTK_ADC1,       /* ADC 1 */
    MBTK_ADC2       /* ADC 2 */
} mbtk_adc_enum;


/*===========================================================================
FUNCTION mbtk_adc_get

DESCRIPTION:
  Get ADC's value.

PARAMETERS:
  adc_dev : Refer to : ADC_DEVICE_802/ADC_DEVICE_803/ADC_DEVICE_PMIC802/ADC_DEVICE_AUX
  adc [IN]: ADC path, refer to mbtk_adc_enum.

RETURN VALUE:
  int : ADC value.

===========================================================================*/
int mbtk_adc_get(const char* adc_dev, mbtk_adc_enum adc);
int mbtk_adc_close(const char* adc_dev);


#endif /* __MBTK_ADC_H__ */

