/*-----------------------------------------------------------------------------------------------*/
/**
  @file mbtk_openssl.h
  @brief OPENSSL API
*/
/*-----------------------------------------------------------------------------------------------*/

/*-------------------------------------------------------------------------------------------------
  Copyright (c) 2024 mobiletek Wireless Solution, Co., Ltd. All Rights Reserved.
  mobiletek Wireless Solution Proprietary and Confidential.
-------------------------------------------------------------------------------------------------*/

/*-------------------------------------------------------------------------------------------------
  EDIT HISTORY
  This section contains comments describing changes made to the file.
  Notice that changes are listed in reverse chronological order.
  $Header: $
  when       who          what, where, why
  --------   ---------    -----------------------------------------------------------------
  20250410    yq.wang      Created .
-------------------------------------------------------------------------------------------------*/
#ifndef __MBTK_OPENSSL_H__
#define __MBTK_OPENSSL_H__
#include <stdbool.h>
#include <openssl/ssl.h>
#include <openssl/err.h>

#define MBTK_OPENSSL_FILETYPE_PEM SSL_FILETYPE_PEM
#define MBTK_OPENSSL_FILETYPE_ASN1 SSL_FILETYPE_ASN1

#define MBTK_OPENSSL_VERIFY_NONE SSL_VERIFY_NONE
#define MBTK_OPENSSL_VERIFY_PEER SSL_VERIFY_PEER
//The following is valid only on the server side
#define MBTK_OPENSSL_VERIFY_FAIL_IF_NO_PEER_CERT SSL_VERIFY_FAIL_IF_NO_PEER_CERT
#define MBTK_OPENSSL_VERIFY_CLIENT_ONCE SSL_VERIFY_CLIENT_ONCE

#define MBTK_OPENSSL_INIT_LOAD_SSL_STRINGS OPENSSL_INIT_LOAD_SSL_STRINGS
#define MBTK_OPENSSL_INIT_LOAD_CRYPTO_STRINGS OPENSSL_INIT_LOAD_CRYPTO_STRINGS
#define MBTK_OPENSSL_INIT_ADD_ALL_CIPHERS OPENSSL_INIT_ADD_ALL_CIPHERS
#define MBTK_OPENSSL_INIT_ADD_ALL_DIGESTS OPENSSL_INIT_ADD_ALL_DIGESTS
#define MBTK_OPENSSL_INIT_NO_LOAD_SSL_STRINGS OPENSSL_INIT_NO_LOAD_SSL_STRINGS
#define MBTK_OPENSSL_INIT_NO_LOAD_CRYPTO_STRINGS OPENSSL_INIT_NO_LOAD_CRYPTO_STRINGS

#define MBTK_OPENSSL_SAFETY_LEVEL_0 0
#define MBTK_OPENSSL_SAFETY_LEVEL_1 1
#define MBTK_OPENSSL_SAFETY_LEVEL_2 2
#define MBTK_OPENSSL_SAFETY_LEVEL_3 3
#define MBTK_OPENSSL_SAFETY_LEVEL_4 4
#define MBTK_OPENSSL_SAFETY_LEVEL_5 5

typedef int (*mbtk_verify_callback)(int preverify_ok, X509_STORE_CTX *x509_ctx);

typedef enum {
    MBTK_OPENSSL_RESULT_SUCCESS = 0,
    MBTK_OPENSSL_RESULT_FAIL
}mbtk_openssl_result_e;

typedef struct {
    int fd;
    SSL_CTX *ctx;
    SSL *ssl;
} mbtk_openssl_info_s;

typedef struct {
    bool load_cert;                 /* Whether to load the certificate */
    const char *ca_file;            /* the file with the CA certificate(s) */
    const char *crt_file;           /* the file with the client certificate */
    const char *key_file;           /* the file with the client key */
    int ssl_filetype;               /* Specifies the encoding format of the certificate file */
    int verify_mode;                /* Verification mode */
    mbtk_verify_callback verify_cb; /* Custom validation callback functions */
    uint64_t init_opts;             /* The bit mask of the initialization option */
    int safety_level;               /* Set security level(0-5) */
}mbtk_openssl_options_s;

mbtk_openssl_result_e mbtk_openssl_options_default(mbtk_openssl_options_s *opt);
int mbtk_openssl_write(SSL *ssl, const void *buf, int len);
int mbtk_openssl_read(SSL *ssl, void *buf, int len);
mbtk_openssl_result_e mbtk_openssl_init(int fd, mbtk_openssl_options_s *opt, mbtk_openssl_info_s *inter_info);
mbtk_openssl_result_e mbtk_openssl_deinit(mbtk_openssl_info_s *inter_info);

#endif