/*************************************************************
Description:
    MBTK sleep head file.
Author:
    XiaoRui
Date:
    2024/10/24 20:08:03
*************************************************************/
#ifndef _MBTK_SLEEP_H
#define _MBTK_SLEEP_H

#include <stdio.h>
#include <time.h>
#include <sys/time.h>
#include <unistd.h>
#include <sys/un.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <errno.h>
#include <sys/ioctl.h>
#include <net/if.h>
#include <string.h>
#include <fcntl.h>
#include <signal.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <sys/file.h>
#include <stddef.h>
#include <sys/types.h>
#include <pthread.h>
#include <sys/epoll.h>
#include <linux/input.h>

#include "mbtk_type.h"

/*************************************************************
    Constants and Macros
*************************************************************/
typedef void (*mbtk_sleep_callback_func)(const void* data, int data_len);

#define LOCK_MAX_SIZE       129
#define EPOLL_SIZE_HINT     128

/*
This module is system sleep, the system cannot sleep when the lock exists
To verify whether it is in sleep state, it is necessary to test the power consumption
Power management principle, as long as a wakelock lock exists, the system will not enter the Suspend state
So the name can be arbitrarily chosen to indicate that such a lock is needed so that the system does not sleep
*/
#define MTBK_POWERIND           "/system/etc/powerind"      //1806


/*************************************************************
    Definitions:enum,struct,union,class
*************************************************************/
typedef struct
{
    int fd;
    char name[64];
} mbtk_lock_name_s;



/*************************************************************
    Extern variables
*************************************************************/


/*************************************************************
    Public Function Declaration
*************************************************************/
int mbtk_powerrind_get();
int mbtk_autosuspend_enable(char enable);
int mbtk_wakelock_create(const char* name , size_t len);
int mbtk_wakelock_lock(int fd);
int mbtk_wakelock_unlock(int fd);
int mbtk_wakelock_destroy(int fd);
int mbtk_suspend_timer_set(int time, mbtk_sleep_callback_func cb);
int mbtk_suspend_timer_cancel(void);

#endif /* _MBTK_SLEEP_H */
