#include <stdio.h>
#include <unistd.h>
#include <string.h>


#define SETTING_FILE			"/etc/wifi/hostapd.conf"	
#define SETTING_LINE_MAX		64				
#define SETTING_LINE_MAX_LEN		512				
#define SETTING_KEY_MAX_LEN		64				
#define SETTING_VALUE_MAX_LEN		190 
#define SETTING_SPLIT_CHAR		'='	
#define ACL_DENY_FILE "/etc/wifi/hostapd.deny"
#define ACL_ACCEPT_FILE "/etc/wifi/hostapd.accept"
#define DHCP_PATH "/tmp/dhcp.leases"
#define DEF_INTERFACE "wlan0"




typedef struct {
unsigned long long rx_packets; 
unsigned long long rx_bytes; 
unsigned long long rx_errors; 
unsigned long long rx_dropped; 
unsigned long long tx_packets; 
unsigned long long tx_bytes; 
unsigned long long tx_errors; 
unsigned long long tx_dropped; 
} mbtk_wifi_pkt_stats_t;

typedef struct
{
char addr[16];
char macaddr[18]; 
char name[20]; 
char ifname[18]; 
int uptime; 
} mbtk_lanhost_t;


typedef struct
{
 int array_len; 
 mbtk_lanhost_t array[32]; 
} mbtk_lanhost_ts;




int mbtk_wifi_get_setting(const char *path, const char *key, char *value, int value_max_len);
int mbtk_wifi_set_setting(const char *path, const char *key, const char *value);
int mbtk_wifi_ap_start(void);
int mbtk_wifi_ap_stop(void);
int mbtk_wifi_set_file(const char *path, const char *value);
int mbtk_wifi_get_file(const char *path, char *value, int value_max_len);
int mbtk_wifi_get_pkt(mbtk_wifi_pkt_stats_t* pkt_stat);
int mbtk_wifi_get_dhcp(mbtk_lanhost_ts* lanhost_arr);
int mbkt_wifi_get_uptime(mbtk_lanhost_ts* lanhost_arr);





