#ifndef STA_CTRL_INCLUDE
#define STA_CTRL_INCLUDE

#include "mbtk_type.h"

#define STA_BUF_SIZE 2048

typedef enum{
    STA_ERR_SUCCESS,
    STA_ERR_DRIVER,
    STA_ERR_TIMEOUT,
    STA_ERR_UNKNOWN
} sta_err_enum;

typedef void (*sta_ctrl_msg_cb)(char*);

sta_err_enum
sta_ctrl_cmd_process
(
    const char *cmd,
    char *cmd_rsp,
    size_t rsp_len
);

sta_err_enum
sta_ctrl_driver_init(bool open);

sta_err_enum
sta_ctrl_wpa_init
(
    const char *conf_file,
    const char *interface,
    sta_ctrl_msg_cb cb
);

sta_err_enum
sta_ctrl_wpa_deinit
(
    void
);

#endif /* STA_CTRL_INCLUDE */

