/*
* mbtk_audio2.h
*
* MBTK audio API for asr1806.
*
* Author : lb
* Date   : 2023/12/20 10:12:15
*/
#ifndef _MBTK_AUDIO2_H
#define _MBTK_AUDIO2_H
#include "mbtk_type.h"

#define MBTK_PCM_NB_BUF_SIZE 320
#define MBTK_PCM_WB_BUF_SIZE 640

typedef void (*mbtk_recorder_callback_func)(void *data, uint32 data_len);

typedef void (*mbtk_audio_pa_switch_func)(bool open);

typedef void (*mbtk_audio_volume_set_func)();


typedef enum {
    MBTK_AUDIO_DIRECTION_OUTPUT = 0,    // Play
    MBTK_AUDIO_DIRECTION_INPUT         // Recorder
} mbtk_audio_direction_enum;

typedef enum {
    MBTK_AUDIO_SAMPLE_RATE_8000 = 0,
    MBTK_AUDIO_SAMPLE_RATE_16000
} mbtk_audio_sample_rate_enum;

int mbtk_audio_pcm_init();

void mbtk_audio_pa_func_set(mbtk_audio_pa_switch_func pa_switch_func);

void mbtk_audio_volume_set_func_set(mbtk_audio_volume_set_func volume_set_func);

int mbtk_audio_pcm_sample_rate_set(mbtk_audio_sample_rate_enum sample_rate);

// Send PCM to location SPK.
int mbtk_audio_pcm_play_start();

int mbtk_audio_pcm_play_data_send(const void* data,uint32 data_len);

int mbtk_audio_pcm_play_stop();

// Get PCM from location MIC.
int mbtk_audio_pcm_recorder_start(mbtk_recorder_callback_func recorder_cb);

int mbtk_audio_pcm_recorder_pause();

int mbtk_audio_pcm_recorder_resume();

int mbtk_audio_pcm_recorder_stop();

int mbtk_audio_pcm_deinit();

int mbtk_audio_wav_init();

int mbtk_audio_wav_play_start(const void *wav_file);

int mbtk_audio_wav_stream_play_start(const unsigned char *pcm_data, int data_size, int sample_rate, int num_channels);

int mbtk_audio_wav_play_pause();

int mbtk_audio_wav_play_resume();

int mbtk_audio_wav_play_stop();

int mbtk_audio_wav_recorder_start(const void *wav_file, mbtk_audio_sample_rate_enum sample_rate);

int mbtk_audio_wav_recorder_pause();

int mbtk_audio_wav_recorder_resume();

int mbtk_audio_wav_recorder_stop();

int mbtk_audio_wav_deinit();

// Send PCM to the other end of the voice.
int mbtk_audio_voice_pcm_playback_start();

// Get PCM from the other end of the voice.
int mbtk_audio_voice_pcm_record_start();

/**
 *    device: UINT32
 *         0: earpiece
 *         1: speaker
 *         2: headset
 *    enable_state: UINT32
 *         0: close
 *         1: open
 */
int mbtk_audio_set_loopback_enable_state(int device, int enable_state);
int mbtk_audio_get_loopback_enable_state(int *device, int *enable_state);


#endif /* _MBTK_AUDIO2_H */
