/*
* mbtk_loop_buffer.h
*
* MBTK loop buffer header.
*
* Author : lb
* Date   : 2024/12/5 19:46:11
*/
#ifndef _MBTK_LOOP_BUFFER_H
#define _MBTK_LOOP_BUFFER_H
#include "mbtk_type.h"

typedef void mbtk_loop_buff_handle;

mbtk_loop_buff_handle* mbtk_loopbuff_get(int size);

int mbtk_loopbuff_free(mbtk_loop_buff_handle* handle);

int mbtk_loopbuff_write(mbtk_loop_buff_handle* handle, const void *data, int data_len);

int mbtk_loopbuff_read(mbtk_loop_buff_handle* handle, void *data, int data_len);

int mbtk_loopbuff_writen(mbtk_loop_buff_handle* handle, const void *data, int data_len);

int mbtk_loopbuff_readn(mbtk_loop_buff_handle* handle, void *data, int data_len);

// Only for read seek.
int mbtk_loopbuff_seek(mbtk_loop_buff_handle* handle, int offset);

int mbtk_loopbuff_size(mbtk_loop_buff_handle* handle);

void mbtk_loopbuff_print(mbtk_loop_buff_handle* handle);

#endif /* _MBTK_LOOP_BUFFER_H */
