/*-----------------------------------------------------------------------------------------------*/
/**
  @file mbtk_mbedtls.h
  @brief MBEDTLS API
*/
/*-----------------------------------------------------------------------------------------------*/

/*-------------------------------------------------------------------------------------------------
  Copyright (c) 2024 mobiletek Wireless Solution, Co., Ltd. All Rights Reserved.
  mobiletek Wireless Solution Proprietary and Confidential.
-------------------------------------------------------------------------------------------------*/

/*-------------------------------------------------------------------------------------------------
  EDIT HISTORY
  This section contains comments describing changes made to the file.
  Notice that changes are listed in reverse chronological order.
  $Header: $
  when       who          what, where, why
  --------   ---------    -----------------------------------------------------------------
  20250409    yq.wang      Created .
-------------------------------------------------------------------------------------------------*/
#ifndef __MBTK_MBEDTLS_H__
#define __MBTK_MBEDTLS_H__
#include <stdbool.h>

#include <mbedtls/ssl.h>
#include <mbedtls/entropy.h>
#include <mbedtls/ctr_drbg.h>
#include <mbedtls/error.h>
#include <mbedtls/debug.h>
#include <mbedtls/x509_crt.h>
#include <mbedtls/pk.h>
#include <mbedtls/ssl.h>
#include <mbedtls/net_sockets.h>

#define MBTK_MBEDTLS_SSL_IS_CLIENT MBEDTLS_SSL_IS_CLIENT
#define MBTK_MBEDTLS_SSL_IS_SERVER MBEDTLS_SSL_IS_SERVER

#define MBTK_MBEDTLS_SSL_TRANSPROT_STREAM MBEDTLS_SSL_TRANSPORT_STREAM
#define MBTK_MBEDTLS_SSL_TRANSPROT_DATAGRAM MBEDTLS_SSL_TRANSPORT_DATAGRAM

#define MBTK_MBEDTLS_SSL_PRESET_DEFAULT MBEDTLS_SSL_PRESET_DEFAULT
#define MBTK_MBEDTLS_SSL_PRESET_SUITEB MBEDTLS_SSL_PRESET_SUITEB

#define MBTK_MBEDTLS_SSL_VERIFY_NONE MBEDTLS_SSL_VERIFY_NONE
#define MBTK_MBEDTLS_SSL_VERIFY_OPTIONAL MBEDTLS_SSL_VERIFY_OPTIONAL
#define MBTK_MBEDTLS_SSL_VERIFY_REQUIRED MBEDTLS_SSL_VERIFY_REQUIRED

#define MBTK_MBEDTLS_SSL_RENEGOTIATION_ENABLED MBEDTLS_SSL_RENEGOTIATION_ENABLED
#define MBTK_MBEDTLS_SSL_RENEGOTIATION_DISABLED MBEDTLS_SSL_RENEGOTIATION_DISABLED

#define MBTK_MBEDTLS_SSL_LEGACY_NO_RENEGOTIATION MBEDTLS_SSL_LEGACY_NO_RENEGOTIATION
#define MBTK_MBEDTLS_SSL_LEGACY_ALLOW_RENEGOTIATION MBEDTLS_SSL_LEGACY_ALLOW_RENEGOTIATION
#define MBTK_MBEDTLS_SSL_LEGACY_BREAK_HANDSHAKE MBEDTLS_SSL_LEGACY_BREAK_HANDSHAKE

#define MBTK_MBEDTLS_SSL_MINOR_VERSION_2 MBEDTLS_SSL_MINOR_VERSION_2
#define MBTK_MBEDTLS_SSL_MINOR_VERSION_3 MBEDTLS_SSL_MINOR_VERSION_3
#define MBTK_MBEDTLS_SSL_MINOR_VERSION_4 MBEDTLS_SSL_MINOR_VERSION_4

#define MBTK_MBEDTLS_SSL_MD_MD5 MBEDTLS_X509_ID_FLAG(MBEDTLS_MD_MD5)
#define MBTK_MBEDTLS_SSL_MD_SHA1 MBEDTLS_X509_ID_FLAG(MBEDTLS_MD_SHA1)
#define MBTK_MBEDTLS_SSL_MD_SHA224 MBEDTLS_X509_ID_FLAG(MBEDTLS_MD_SHA224)
#define MBTK_MBEDTLS_SSL_MD_SHA256 MBEDTLS_X509_ID_FLAG(MBEDTLS_MD_SHA256)
#define MBTK_MBEDTLS_SSL_MD_SHA384 MBEDTLS_X509_ID_FLAG(MBEDTLS_MD_SHA384)

typedef enum {
    MBTK_MBEDTLS_SSL_RESULT_SUCCESS = 0,
    MBTK_MBEDTLS_SSL_RESULT_FAIL
}mbtk_mbedtls_ssl_result_e;

typedef struct {
    int fd;
    mbedtls_entropy_context *entropy;
    mbedtls_ctr_drbg_context *ctr_drbg;
    mbedtls_ssl_context *ssl;
    mbedtls_ssl_config *conf;
    mbedtls_x509_crt *cacert;
    mbedtls_x509_crt *clientcert;
    mbedtls_pk_context *clientkey;
} mbtk_mbedtls_ssl_info_s;

typedef struct {
    bool load_cert;                /* Whether to load the certificate */
    const char *ca_file;           /* the file with the CA certificate(s) */
    const char *crt_file;          /* the file with the client certificate */
    const char *key_file;          /* the file with the client key */
    const unsigned char *pers_str; /* Personalized string, distinguish between different application scenarios of random number sequence */
    int pers_str_size;             /* Personalized string length */
    int type;                      /* Client/server */
    int transprot;                 /* Transport protocol */
    int preset;                    /* The default security configuration level */
    int auth_mode;                 /* Set the certificate authentication mode for SSL/TLS connections */
    int renegotiation;             /* Enables or disables the session renegotiation function */
    int allow_legacy;              /* Controls whether to enable compatibility support for TLS renegotiation of earlier versions */
    int min_version;               /* minimum protocol version accepted */
    int max_version;               /* maximum protocol version accepted */
    uint32_t allowed_mds;          /* List of allowed hashing algorithms (e.g. SHA-256) */
}mbtk_mbedtls_ssl_options_s;

mbtk_mbedtls_ssl_result_e mbtk_mbedtls_ssl_options_default(mbtk_mbedtls_ssl_options_s *opt);
int mbtk_mbedtls_ssl_write(mbedtls_ssl_context *ssl, const unsigned char *buf, size_t len );
int mbtk_mbedtls_ssl_read(mbedtls_ssl_context *ssl, unsigned char *buf, size_t len );
mbtk_mbedtls_ssl_result_e mbtk_mbedtls_ssl_init(int fd , mbtk_mbedtls_ssl_options_s *opt, mbtk_mbedtls_ssl_info_s* inter_info);
mbtk_mbedtls_ssl_result_e mbtk_mbedtls_ssl_deinit(mbtk_mbedtls_ssl_info_s* inter_info);

#endif
