#ifndef STA_CLI_INCLUDE
#define STA_CLI_INCLUDE
#include <stdio.h>
#include <stdbool.h>

typedef enum
{
    CMD_ID_NON = 0,
    CMD_ID_SCAN,
    CMD_ID_SCAN_RESULTS,
    CMD_ID_STATUS,
    CMD_ID_MIB,
    CMD_ID_RECONFIGURE,
    CMD_ID_DISCONNECT,
    CMD_ID_RECONNECT,
    CMD_ID_SAVE_CONFIG,
    CMD_ID_GET_NETWORK,
    CMD_ID_SET_NETWORK,
    CMD_ID_REMOVE_NETWORK,
    CMD_ID_ADD_NETWORK,
    CMD_ID_DISABLE_NETWORK,
    CMD_ID_ENABLE_NETWORK,
    CMD_ID_SELECT_NETWORK,
    CMD_ID_LIST_NETWORKS,
    CMD_ID_REASSOCIATE,
    CMD_ID_REATTACH
}sta_cli_cmd_id_enum;

bool sta_cli_cmd_parse
(
    const char *cmd,
    char *reply,
    size_t reply_len
);

int sta_cli_ssid_get(char *ssid);
int sta_cli_psk_get(char *psk);
int sta_cli_ssid_set(char *ssid);
int sta_cli_psk_set(char *psk);


#endif /* STA_CLI_INCLUDE */