#ifndef __MBTK_LPM_H__
#define __MBTK_LPM_H__

typedef enum 
{
    E_MBTK_LPM_FALLING	= 0, /* Falling, Means wakeupin falling to wakeup the module, or wakeupout falling to wakeup mcu. */
    E_MBTK_LPM_RISING	= 1, /* Rising, Means  wakeupin rising to wakeup the module,  or wakeupout rising to wakeup  mcu. */
}mbtk_lpm_edge_t;

/* Callback function registered via Mbtk_Lpm_Init();
 * It will be called when wakeup_in state changed.
 * lpm_edge: report the wakeup_in state.
*/
typedef void (*mbtk_lpm_handler_t)
(
	mbtk_lpm_edge_t lpm_edge
);

/* Init MBTK LPM Init function.
 * Para:
 * 	mbtk_lpm_handler: the callback handler.
 * 	
 * Return value:
 *	0  --> success
 * 	-1 --> failed
*/
extern int mbtk_lpm_init(mbtk_lpm_handler_t mbtk_lpm_handler);

/* Deinit MBTK LPM function
 * Rmmod MBTK_lpm kmod, remove lpm handler.
 * Return value:
 * 	0  --> success
 *	-1 --> failed 
*/
extern int mbtk_lpm_deinit(void);

#endif // __MBTK_LPM_H__

