/*************************************************************
Description:
    HTTP platform related function implementation.
Author:
    LiuBin
Date:
    2020/4/30 14:02:58
*************************************************************/
#ifndef _MBTK_HTTP_BASE_H
#define _MBTK_HTTP_BASE_H

#include <stdio.h>

#include "mbtk_type.h"
#include "mbtk_log.h"
#include "mbtk_sock2.h"

/*************************************************************
    Public Function Declaration
*************************************************************/
int mbtk_http_init();
int mbtk_http_deinit();
int mbtk_http_open
(
    bool is_ssl,
    bool ingnore_cert,
    const void *host,
    uint16 port
);

/*=============================================
FUNCTION
    mbtk_http_read

DESCRIPTION
    read content from socket.

DEPENDENCIES
    None

PARAMETERS
    *buf      Store read content.
    len       the length of Content.
    timeout   Set timeout

RETURN VALUE
    Length of read content

SIDE EFFECTS
    None
=============================================*/
int mbtk_http_read
(
    int sock_fd,
    void *buf,
    uint16 len,
    int timeout_ms
);

#if 0
int mbtk_http_read_line
(
    FILE *file,
    void *buf,
    uint16 len
);
#else
int mbtk_http_read_line
(
    int sock_fd,
    void *buf,
    uint16 len
);
#endif

/*=============================================
FUNCTION
    mbtk_http_write

DESCRIPTION
    Write content to socket.

DEPENDENCIES
    None

PARAMETERS
    *buf    Content to be transferred
    len     the length of Content.

RETURN VALUE
    Length of written content

SIDE EFFECTS
    None
=============================================*/
int mbtk_http_write
(
    int sock_fd,
    void *buf,
    uint16 len
);

/*=============================================
FUNCTION
    mbtk_http_close

DESCRIPTION
    close HTTP service.

DEPENDENCIES
    None

PARAMETERS
    *err    Error number

RETURN VALUE
    TURE or FALSE

SIDE EFFECTS
    None
=============================================*/
int mbtk_http_close(int sock_fd);

#endif /* _MBTK_HTTP_BASE_H */
