#ifndef SPARSE_FILE_H
#define SPARSE_FILE_H

#ifdef __cplusplus
extern "C" {
#endif

#include "sparse_format.h"

#define SPARSE_FILE_HEADER_SIZE \
  (sizeof(sparse_header_t) + 2 * sizeof(chunk_header_t))

#define SPARSE_FILE_FOOTER_SIZE (sizeof(chunk_header_t))

#define SPARSE_BLOCK_SZ 4096

typedef struct {
  char header[SPARSE_FILE_HEADER_SIZE];
  char footer[SPARSE_FILE_FOOTER_SIZE];
  size_t header_size;
  size_t data_size;
  size_t fill_size;
  size_t footer_size;
} sparse_file_t;

int sparse_file_new(sparse_file_t *sparse_file, size_t offset,
                    size_t size, size_t file_size);

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* SPARSE_FILE_H */
