#include "mbtk_sleep.h"
#include "mbtk_log.h"

static mbtk_lock_name_s mbtk_lock_name[LOCK_MAX_SIZE]={0};


int mbtk_autosuspend_enable(char enable)
{
    if((enable == 1) || enable == '1')
    {
        if(!access("/sys/power/autosleep", W_OK))
        {
            system("echo mem > /sys/power/autosleep");
            autosleep_enable = TRUE;
            return 0;
        }
        else
        {
            LOGE("/sys/power/autosleep can not write.");
            return -1;
        }
    }
    else if((enable == 0) || enable == '0')
    {
        if(!access("/sys/power/autosleep", W_OK))
        {
            system("echo off > /sys/power/autosleep");
            autosleep_enable = FALSE;
            return 0;
        }
        else
        {
            LOGE("/sys/power/autosleep can not write.");
            return -1;
        }
    }
    else
    {
        LOGE("qser_autosuspend_enablecan enable err.");
        return -1;
    }

    return 0;
}

int mbtk_wakelock_create(const char* name , size_t len)
{
    int len_t;

    len_t = strlen(name);

    if((name != NULL) && (len < 33) && (len_t < 33))
    {
        int i;
        for(i=1 ;i<LOCK_MAX_SIZE;i++)
        {
            if(strcmp(mbtk_lock_name[i].name, name) == 0)
            {
                LOGE("Repeated names.");
                return -1;
            }
        }

        for(i=1 ;i<LOCK_MAX_SIZE;i++)
        {
            if(mbtk_lock_name[i].fd == 0)
                break;
        }
        
        if (i >= LOCK_MAX_SIZE)
        {
            LOGE("Fd is full.");
            return -1;
        }

        memcpy(mbtk_lock_name[i].name, name, strlen(name)+1);
        mbtk_lock_name[i].fd = i;
        return mbtk_lock_name[i].fd -1;//Starting from scratch
    }
    else
        return -1;

    return -1;
}

int mbtk_wakelock_lock(int fd)
{
    int i;
    for(i=1;i<LOCK_MAX_SIZE;i++)
    {
        if(mbtk_lock_name[i].fd -1 == fd)
            break;
    }
    if(i == LOCK_MAX_SIZE)
    {
        LOGE("LOCK_MAX_SIZE is full\n");
        return -1;
    }

    if(!access("/sys/power/wake_lock", W_OK))
    {
        char cmd[128]={0};
        sprintf(cmd, "echo %s > /sys/power/wake_lock", mbtk_lock_name[i].name);
        system(cmd);
        return 0;
    }
    else
    {
        LOGE("/sys/power/wake_lock can not write.");
        return -1;
    }

    return 0;
}

int mbtk_wakelock_unlock(int fd)
{
    int i;
    for(i=1;i<LOCK_MAX_SIZE;i++)
    {
        if(mbtk_lock_name[i].fd -1 == fd)
            break;
    }
    if(i == LOCK_MAX_SIZE)
    {
        LOGE("LOCK_MAX_SIZE is full\n");
        return -1;
    }

    if(!access("/sys/power/wake_unlock", W_OK))
    {
        char cmd[128]={0};
        sprintf(cmd, "echo %s > /sys/power/wake_unlock", mbtk_lock_name[i].name);
        system(cmd);
        return 0;
    }
    else
    {
        LOGE("/sys/power/wake_unlock can not write.");
        return -1;
    }

    return 0;
}

int mbtk_wakelock_destroy(int fd)
{
    int i;
    for(i=1;i<LOCK_MAX_SIZE;i++)
    {
        if(mbtk_lock_name[i].fd -1 == fd)
        break;
    }

    if(i == LOCK_MAX_SIZE)
    {
        LOGE("LOCK_MAX_SIZE is full\n");
        return -1;
    }
    else
    {
        mbtk_lock_name[i].fd = 0;
        memset(mbtk_lock_name[i].name, 0, 64);
        return 0;
    }

    return 0;
}



