/*
* gnss_6228.h
*
* UC6228CI Header.
*
* Author : lb
* Date   : 2024/5/20 17:53:51
*/
#ifndef _GNSS_6228_H
#define _GNSS_6228_H
#include "gnss_info.h"
#include "mbtk_type.h"

typedef struct {
    char pdtName[32];
    char Config[32];
    char hwVer[32];
    char fwVer[64];
    char PN[64];
    char SN[64];
} gnss_6228_dev_info_t;

int gnss_6228_dev_open();

int gnss_6228_dev_close(int fd);

int gnss_6228_open(const char *dev);

int gnss_6228_close(int fd);

int gnss_6228_fw_dl(int fd, const char *fw_name, const char *dev);

void gnss_6228_dl_read_cb(const void *data, int data_len);

gnss_err_enum gnss_6228_set(int fd, const char *cmd, void *cmd_rsp, int cmd_rsp_len);

void gnss_6228_set_cb(const void *data, int data_len);

#endif /* _GNSS_6228_H */
