/*
* gnss_hd8122.h
*
* UC6228CI Header.
*
* Author : lb
* Date   : 2024/5/20 17:53:51
*/
#ifndef _GNSS_HD8122_H
#define _GNSS_HD8122_H
#include "gnss_info.h"
#include "mbtk_type.h"

#define HD8122_PACK_LEN_MIN 8
#define HD8122_PACK_HEAD 0xD9F1

typedef enum {
    HD8122_ID_TYPE_NAV = 0x01,
    HD8122_ID_TYPE_ACK = 0x05,
    HD8122_ID_TYPE_CFG = 0x06,
    HD8122_ID_TYPE_MON = 0x0A,
    HD8122_ID_TYPE_AID = 0x0B
} hd8122_id_type_enum;

typedef enum {
    HD8122_ID_NAV_POSECEF = 0x01,
    HD8122_ID_NAV_POSLLH = 0x02,
    HD8122_ID_NAV_DOP = 0x04,
    HD8122_ID_NAV_TIME = 0x05,
    HD8122_ID_NAV_VELECEF = 0x11,
    HD8122_ID_NAV_VELNED = 0x12,
    HD8122_ID_NAV_TIMEUTC = 0x21,
    HD8122_ID_NAV_CLOCK = 0x22,
    HD8122_ID_NAV_CLOCK2 = 0x23,
    HD8122_ID_NAV_PVERR = 0x26,
    HD8122_ID_NAV_SVINFO = 0x30,
    HD8122_ID_NAV_SVSTATE = 0x32,
    HD8122_ID_NAV_AUTO = 0xC0,
    HD8122_ID_NAV_PVT = 0xC1
} hd8122_id_nav_enum;

typedef enum {
    HD8122_ID_ACK_NAK = 0x00,
    HD8122_ID_ACK_ACK = 0x01
} hd8122_id_ack_enum;

typedef enum {
    HD8122_ID_CFG_PRT = 0x00,
    HD8122_ID_CFG_MSG = 0x01,
    HD8122_ID_CFG_COORD = 0x06,
    HD8122_ID_CFG_PPS = 0x07,
    HD8122_ID_CFG_CFG = 0x09,
    HD8122_ID_CFG_DOP = 0x0A,
    HD8122_ID_CFG_ELEV = 0x0B,
    HD8122_ID_CFG_NAVSAT = 0x0C,
    HD8122_ID_CFG_HEIGHT = 0x0D,
    HD8122_ID_CFG_SBAS = 0x0E,
    HD8122_ID_CFG_SPDHOLD = 0x0F,
    HD8122_ID_CFG_EPHSAVE = 0x10,
    HD8122_ID_CFG_NUMSV = 0x11,
    HD8122_ID_CFG_SURVEY = 0x12,
    HD8122_ID_CFG_FIXEDLLA = 0x13,
    HD8122_ID_CFG_FIXEDECEF = 0x14,
    HD8122_ID_CFG_ANTIJAM = 0x15,
    HD8122_ID_CFG_BDGEO = 0x16,
    HD8122_ID_CFG_CARRSMOOTH = 0x17,
    HD8122_ID_CFG_GEOFENCE = 0x18,
    HD8122_ID_CFG_SIMPLERST = 0x40,
    HD8122_ID_CFG_SLEEP = 0x41,
    HD8122_ID_CFG_PWRCTL = 0x42,
    HD8122_ID_CFG_PWRCTL2 = 0x44,
    HD8122_ID_CFG_NMEAVER = 0x43,
    HD8122_ID_CFG_FWUP = 0x50
} hd8122_id_cfg_enum;

typedef enum {
    HD8122_ID_MON_VER = 0x04,
    HD8122_ID_MON_INFO = 0x05,
    HD8122_ID_MON_TRKCHAN = 0x08,
    HD8122_ID_MON_RCVCLK = 0x09,
    HD8122_ID_MON_CWI = 0x0A,
} hd8122_id_mon_enum;

typedef enum {
    HD8122_ID_AID_INI = 0x01,
    HD8122_ID_AID_POS = 0x10,
    HD8122_ID_AID_TIME = 0x11,
    HD8122_ID_AID_PEPH_GPS = 0x32,
    HD8122_ID_AID_PEPH_BDS = 0x33,
    HD8122_ID_AID_PALM_GPS = 0x22,
    HD8122_ID_AID_PALM_BD = 0x23,
    HD8122_ID_AID_PALM_GLN = 0x24,
    HD8122_ID_AID_PALM_GAL = 0x25,
    HD8122_ID_AID_PALM_QZSS = 0x26
} hd8122_id_aid_enum;

typedef struct {
    bool enable;
    uint8 gid;  // Groud ID
    uint8 sid;  // Sub ID
    hd8122_id_ack_enum ack_nak;
} hd8122_msg_id_t;

typedef struct {
    uint16 head;
    uint8 id_type;
    uint8 id;
    uint16 data_len;
    uint8 *data;
} hd8122_pack_info_t;

int gnss_8122_dev_open();

int gnss_8122_dev_close(int fd);

int gnss_8122_open();

int gnss_8122_close();

int gnss_8122_fw_dl(int fd, const char *fw_name, const char *dev);

gnss_err_enum gnss_8122_agnss_get_eph(const char *param);

gnss_err_enum gnss_8122_agnss_inject(int fd);
//void gnss_8122_dl_read_cb(const void *data, int data_len);

gnss_err_enum gnss_8122_set(int fd, const char *cmd, void *cmd_rsp, int cmd_rsp_len);

void gnss_8122_set_cb(const void *data, int data_len);

#endif /* _GNSS_HD8122_H */

