#ifndef _LOG_CONFIG_H
#define _LOG_CONFIG_H


#define LOG_CONFIG_PATH     "/etc/mbtk/mbtk_log.json"

#define ROTATE_FILE_COUNT_MAX    10

struct filter_list_t {
    char priority;
    char *tag;
    struct filter_list_t *next;
};

struct file_list_t {
    int total;
    int current;
    char *base_file;
    char *file[ROTATE_FILE_COUNT_MAX];
};

typedef struct log_config_entry_t {
    int enable;
    char *name;
    int send_fd;
    char *out_path;
    char *ip;
    char *port;
    int rotate_file_size;
    int rotate_file_count;
    int32_t log_format;
    struct filter_list_t *filter_list;
} log_config_entry;

int get_rotate_file(int fd, char *base_file, struct file_list_t *_file_list);
extern void* alog_thread(void* argv);
extern void* syslog_main(void* argv);
extern void* socket_log_thread(void* argv);
extern void* common_log_thread(void* argv);

#endif // _LOG_CONFIG_H
