#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <netinet/in.h>
#include <pthread.h>
#include <sys/epoll.h>
#include <fcntl.h>
#include <signal.h>
#include <cutils/properties.h>

#include "mbtk_type.h"
#include "mbtk_info.h"
#include "mbtk_queue.h"
#include "atchannel.h"
#include "at_tok.h"
#include "mbtk_utils.h"
#include "mbtk_ifc.h"
#include "info_data.h"
#include "mbtk_led.h"
#include "cust_info.h"
#include "mbtk_device.h"
#include "mbtk_data_call.h"

typedef struct {
    uint32 band_gsm;
    uint32 band_wcdma;
    uint32 band_tdlte;
    uint32 band_fddlte;
    uint32 band_lte_ext;
} band_set_info_t;

static int sock_listen_fd = -1;
static int epoll_fd = -1;
static list_node_t *sock_client_list = NULL;
static mbtk_queue_node_t info_queue;
static pthread_cond_t info_cond;
static pthread_mutex_t info_mutex;
static mbtk_queue_node_t urc_queue;
static pthread_cond_t urc_cond;
static pthread_mutex_t urc_mutex;
static band_set_info_t band_set_info;
static bool band_set_success = FALSE;
static mbtk_modem_band_area_enum band_area;

static mbtk_band_info_t band_support;
net_info_t net_info;
mbtK_cell_pack_info_t cell_info;
info_cgact_wait_t cgact_wait;
static int cid_active[MBTK_APN_CID_MAX + 1] = {0};
bool at_process = false;
bool at_cfun_command = false;
//mbtk wyq for data_call_ex add start
//  |2----7|
//"00000000"+'\0'
static char cid_bootconn[MBTK_APN_CID_MAX + 2] = {0};
#define DATA_CALL_BOOTCONN_FD 0x5f6f7f8f
//mbtk wyq for data_call_ex add end

//mbtk wyq for server_ready_status add start
static char server_ready_status = 0;
//mbtk wyq for server_ready_status add end

static mbtk_signal_info_t signal_globe;

mbtk_info_err_enum ecall_pack_req_process(sock_client_info_t* cli_info, mbtk_info_pack_t* pack);

/*
AT*POWERIND=0"
or
AT*POWERIND=1~31"

OK

AT*POWERIND=31，就相当于设置NETWORK、SIM、SMS、CS CALL、PS DATA变化时都不主动上报，
其中PS DATA目前暂时不支持，只是保留了这个标志位,0 means resume all.

AP power state: 1~31 means suspend,
bitmap:
bit0 - NETWORK;
bit1 - SIM;
bit2 - SMS;
bit3 - CS CALL
bit4 - PS DATA

*/
static int req_powerind_set(uint32 state, int *cme_err)
{
    ATResponse *response = NULL;
    char cmd[100] = {0};

    if (state >= 0 && state < 32)
    {
        sprintf(cmd, "AT*POWERIND=%d", state);
        LOG("Set the powerind command is = [%s]\n", cmd);
    }
    int err = at_send_command(cmd, &response);
    if (err < 0 || response->success == 0){
        *cme_err = at_get_cme_error(response);
        goto exit;
    }

exit:
    at_response_free(response);
    return err;
}

/*
AT+OOSPP=1
or
AT+OOSPP=0
or
AT+OOSPP=1,20,30,40 //AtOospp()
 param1：mode
 param2：oosPhasePeriod[0] //5 times, 5s by default;
 param3：oosPhasePeriod[1] //5 times, 10s by default;
 param4：oosPhasePeriod[2] //unlimited, 20s by default;


BTW
1, 如果只输入mode=1，其余参数不设置，相当于这个功能打开，时间间隔是这个功能的默认值。
2, 如果当mode=1加上其余设置参数后，功能打开，时间间隔是本次设置的值；
3，如果再设置mode=0，相当于这个功能关闭，是走平台自己另一套的搜网设置。
平台本身是有一套间隔搜网，也有历史频点优先处理的逻辑（不需要我们进行处理），
提供给我们的AT+OOSPP指令是让我们可以自定义搜网间隔
*/
static int req_oos_set(mbtk_oos_info* state, int *cme_err)
{
    ATResponse *response = NULL;
    char cmd[100] = {0};

    if ((state->mode == 1 && state->oosPhase[0] == 0 && state->oosPhase[1] == 0 && state->oosPhase[2] == 0) \
        || state->mode == 0)
    {
        sprintf(cmd, "AT+OOSPP=%d", state->mode);//只有一个值0/1
    }
    else
    {
        if ((state->oosPhase[0] != 0) && (state->oosPhase[1] != 0) && (state->oosPhase[2] != 0))
        {
            sprintf(cmd, "AT+OOSPP=%d,%d,%d,%d", state->mode, state->oosPhase[0], state->oosPhase[1], state->oosPhase[2]);
        }
        else if ((state->oosPhase[0] != 0) && (state->oosPhase[1] != 0) && (state->oosPhase[2] == 0))
        {
            sprintf(cmd, "AT+OOSPP=%d,%d,%d", state->mode, state->oosPhase[0], state->oosPhase[1]);
        }
        else if ((state->oosPhase[0] != 0) && (state->oosPhase[1] == 0) && (state->oosPhase[2] == 0))
        {
            sprintf(cmd, "AT+OOSPP=%d,%d", state->mode, state->oosPhase[0]);
        }
        else
        {
            LOG("AT+OOSPP SET ERR");
            goto exit;
        }
    }

    LOG("Set the oos command is = [%s]\n", cmd);
    int err = at_send_command(cmd, &response);
    if (err < 0 || response->success == 0){
        *cme_err = at_get_cme_error(response);
        goto exit;
    }

exit:
    at_response_free(response);
    return err;
}


/*
AT+OOSPP?
开(默认值)：
+OOSPP:5,10,20
关：
+OOSPP:0
*/
static int req_oos_get(mbtk_oos_info *req, int *cme_err)
{
    ATResponse *response = NULL;

    int err = at_send_command_singleline("AT+OOSPP?", "+OOSPP:", &response);

    if (err < 0 || response->success == 0 || !response->p_intermediates){
        *cme_err = at_get_cme_error(response);
        goto exit;
    }

    char *line = response->p_intermediates->line;

    char *tmp_str = NULL;
    err = at_tok_start(&line);//+OOSPP:10,15,20,过滤+OOSPP:
    if (err < 0)
    {
        goto exit;
    }

    //LOG("req_oos_get =[%s]",line);

    err = at_tok_nextstr(&line, &tmp_str);
    if (err < 0)
    {
        goto exit;
    }

    int mode = atoi(tmp_str);
    if (mode == 0)//关闭状态
    {
        req->mode = mode;
    }
    else//开状态
    {
        req->mode = 1;
        //LOG("tmp_str =[%s]",tmp_str);
        req->oosPhase[0] = atoi(tmp_str);

        err = at_tok_nextstr(&line, &tmp_str);
        if (err < 0)
        {
            goto exit;
        }
        //LOG("tmp_str =[%s]",tmp_str);
        req->oosPhase[1] = atoi(tmp_str);

        err = at_tok_nextstr(&line, &tmp_str);
        if (err < 0)
        {
            goto exit;
        }
        //LOG("tmp_str =[%s]",tmp_str);
        req->oosPhase[2] = atoi(tmp_str);
    }

exit:
    at_response_free(response);
    return err;
}

static void sock_cli_free_func(void *data)
{
    if (data)
    {
        sock_client_info_t *info = (sock_client_info_t*) data;
        LOG("Free Socket client[fd = %d].", info->fd);
        free(info);
    }
}

static void cli_close(sock_client_info_t* client)
{
    struct epoll_event ev;
    memset(&ev,0,sizeof(struct epoll_event));
    ev.data.fd = client->fd;
    ev.events = EPOLLIN | EPOLLERR | EPOLLET;
    epoll_ctl(epoll_fd, EPOLL_CTL_DEL, client->fd, &ev);

    close(client->fd);

    if(list_remove(sock_client_list, client))
    {
        sock_cli_free_func(client);
    }
}

static void pack_error_send(int fd, int info_id, int err)
{
    mbtk_info_pack_t* pack = mbtk_info_pack_creat(info_id);
    if(pack)
    {
        pack->info_err = (uint16)err;
        mbtk_info_pack_send(fd, pack);
        mbtk_info_pack_free(&pack);
    }
    else
    {
        LOG("mbtk_info_pack_creat() fail.");
    }
}

void pack_rsp_send(int fd, int info_id, const void* data, int data_len)
{
    mbtk_info_pack_t* pack = mbtk_info_pack_creat(info_id);
    if(pack)
    {
        pack->info_err = (uint16)MBTK_INFO_ERR_SUCCESS;
        if(data != NULL && data_len > 0)
        {
            //mbtk_info_pack_data_set(pack, data, data_len);
            pack->data_len = (uint16)data_len;
            pack->data = (const uint8*)data;
        }
        mbtk_info_pack_send(fd, pack);
        mbtk_info_pack_free(&pack);
    }
    else
    {
        LOG("mbtk_info_pack_creat() fail.");
    }
}

static int apn_prop_set(mbtk_apn_info_t *apn)
{
    char prop_name[20] = {0};
    char prop_data[300] = {0};
    sprintf(prop_name, "%s_%d",MBTK_APN_PROP,apn->cid);
    snprintf(prop_data, 300, "%d,%s,%s,%s,%s", apn->ip_type, apn->apn,
        str_empty(apn->user) ? "NULL" : apn->user,
        str_empty(apn->pass) ? "NULL" : apn->pass,
        str_empty(apn->auth) ? "NULL" : apn->auth);

    return property_set(prop_name, prop_data);
}

/*
AT*BAND=?
*BAND:(0-18),79,147,482,524503


OK

AT*BAND=15,78,147,482,134742231


*/
static void band_support_get()
{
    // Support band has get.
    if(band_support.net_pref != 0xFF) {
        return;
    }

#if 1
    // 79,147,482,524503
    band_support.gsm_band = (uint16)79;             // GSM : B2/B3/B5/B8(GSM 850/PGSM 900/EGSM 900/DCS GSM 1800/PCS GSM 1900)
    band_support.umts_band = (uint16)155;           // WCDMA : B1/B2/B4/B5/B8
    band_support.tdlte_band = (uint32)482;          // TDD-LTE : B34/B38/B39/B40/B41
    band_support.fddlte_band = (uint32)134742239;   // FDD-LTE : B1/B2/B3/B4/B5/B7/B8/B20/B28
    band_support.lte_ext_band = (uint32)2;          // B66
    band_support.net_pref = (uint8)0;
#else
    ATResponse *response = NULL;
    int tmp_int;
    char *tmp_str;
    int err = at_send_command_singleline("AT*BAND=?", "*BAND:", &response);

    if (err < 0 || response->success == 0 || !response->p_intermediates)
        goto exit;

    char *line = response->p_intermediates->line;
    err = at_tok_start(&line);
    if (err < 0)
    {
        goto exit;
    }

    err = at_tok_nextstr(&line, &tmp_str);
    if (err < 0)
    {
        goto exit;
    }

    err = at_tok_nextint(&line, &tmp_int);
    if (err < 0)
    {
        goto exit;
    }
    band_support.gsm_band = (uint16)tmp_int;

    err = at_tok_nextint(&line, &tmp_int);
    if (err < 0)
    {
        goto exit;
    }
    band_support.umts_band = (uint16)tmp_int;

    err = at_tok_nextint(&line, &tmp_int);
    if (err < 0)
    {
        goto exit;
    }
    band_support.tdlte_band = (uint32)tmp_int;

    err = at_tok_nextint(&line, &tmp_int);
    if (err < 0)
    {
        goto exit;
    }
    band_support.fddlte_band = (uint32)tmp_int;
    band_support.net_pref = (uint8)0;
exit:
    at_response_free(response);
#endif
}

static int parseRegistrationState(char *str, int *items, int **response)
{
    int err;
    char *line = str, *p;
    int *resp = NULL;
    int skip;
    int commas;

    LOGD("parseRegistrationState. Parsing: %s",str);
    err = at_tok_start(&line);
    if (err < 0) goto error;

    /* Ok you have to be careful here
     * The solicited version of the CREG response is
     * +CREG: n, stat, [lac, cid]
     * and the unsolicited version is
     * +CREG: stat, [lac, cid]
     * The <n> parameter is basically "is unsolicited creg on?"
     * which it should always be
     *
     * Now we should normally get the solicited version here,
     * but the unsolicited version could have snuck in
     * so we have to handle both
     *
     * Also since the LAC and CID are only reported when registered,
     * we can have 1, 2, 3, or 4 arguments here
     *
     * finally, a +CGREG: answer may have a fifth value that corresponds
     * to the network type, as in;
     *
     *   +CGREG: n, stat [,lac, cid [,networkType]]
     */

    /* count number of commas */
    commas = 0;
    for (p = line ; *p != '\0' ; p++)
    {
        if (*p == ',') commas++;
    }

    resp = (int *)calloc(commas + 1, sizeof(int));
    if (!resp) goto error;
    switch (commas)
    {
        case 0: /* +CREG: <stat> */
            err = at_tok_nextint(&line, &resp[0]);
            if (err < 0) goto error;
            //resp[1] = -1;
            //resp[2] = -1;
            break;

        case 1: /* +CREG: <n>, <stat> */
            err = at_tok_nextint(&line, &skip);
            if (err < 0) goto error;
            err = at_tok_nextint(&line, &resp[0]);
            if (err < 0) goto error;
            resp[1] = -1;
            //resp[2] = -1;
            if (err < 0) goto error;
            break;

        case 2: /* +CREG: <stat>, <lac>, <cid> */
            err = at_tok_nextint(&line, &resp[0]);
            if (err < 0) goto error;
            err = at_tok_nexthexint(&line, &resp[1]);
            if (err < 0) goto error;
            err = at_tok_nexthexint(&line, &resp[2]);
            if (err < 0) goto error;
            break;
        case 3: /* +CREG: <n>, <stat>, <lac>, <cid> */
            /* +CEREG: 1,"8330","06447340",7 */
#if 0
            err = at_tok_nextint(&line, &skip);
            if (err < 0) goto error;
            err = at_tok_nextint(&line, &resp[0]);
            if (err < 0) goto error;
            err = at_tok_nexthexint(&line, &resp[1]);
            if (err < 0) goto error;
            err = at_tok_nexthexint(&line, &resp[2]);
            if (err < 0) goto error;
#else
            err = at_tok_nextint(&line, &resp[0]);
            if (err < 0) goto error;
            err = at_tok_nextint(&line, &resp[1]);
            if (err < 0) goto error;
            err = at_tok_nexthexint(&line, &resp[2]);
            if (err < 0) goto error;
            err = at_tok_nextint(&line, &resp[3]);
            if (err < 0) goto error;
#endif
            break;
        /* special case for CGREG, there is a fourth parameter
         * that is the network type (unknown/gprs/edge/umts)
         */
        case 4: /* +CGREG: <n>, <stat>, <lac>, <cid>, <networkType> */
            /* +CEREG: 2,1,"8330","06447340",7 */
            err = at_tok_nextint(&line, &skip);
            if (err < 0) goto error;
            err = at_tok_nextint(&line, &resp[0]);
            if (err < 0) goto error;
            err = at_tok_nexthexint(&line, &resp[1]);
            if (err < 0) goto error;
            err = at_tok_nexthexint(&line, &resp[2]);
            if (err < 0) goto error;
            err = at_tok_nexthexint(&line, &resp[3]);
            if (err < 0) goto error;
            break;
        default:
            goto error;
    }
    /*
        if(commas > 1) {
            s_lac = resp[1];
            s_cid = resp[2];
        }*/
    if (response)
        *response = resp;
    if (items)
        *items = commas + 1;
    return 0;
error:
    free(resp);
    return -1;
}

/*
0: minimum functionality
1: full functionality
3: disable phone receive RF circuits.
4: disable phone both transmit and receive RF circuits
5: disable SIM
6: turn off full secondary receive.
-1: fail
*/
static int isRadioOn()
{
    ATResponse *p_response = NULL;
    int err;
    char *line;
    int ret;

    err = at_send_command_singleline("AT+CFUN?", "+CFUN:", &p_response);

    if (err < 0 || p_response->success == 0 || !p_response->p_intermediates)
    {
        // assume radio is off
        goto error;
    }

    line = p_response->p_intermediates->line;

    err = at_tok_start(&line);
    if (err < 0) goto error;

    err = at_tok_nextint(&line, &ret);
    if (err < 0) goto error;

    at_response_free(p_response);

    if(ret == 1) {
        net_info.radio_state = MBTK_RADIO_STATE_ON;
    } else {
        net_info.radio_state = MBTK_RADIO_STATE_OFF;
    }

    return ret;

error:

    at_response_free(p_response);
    return -1;
}

/** Returns SIM_NOT_READY on error */
static mbtk_sim_state_enum getSIMStatus()
{
    ATResponse *p_response = NULL;
    int err;
    mbtk_sim_state_enum ret;
    char *cpinLine;
    char *cpinResult;

    err = at_send_command_singleline("AT+CPIN?", "+CPIN:", &p_response);

    if (err < 0 || p_response->success == 0 || !p_response->p_intermediates)
    {
        switch (at_get_cme_error(p_response))
        {
            case CME_SUCCESS:
                break;

            case CME_SIM_NOT_INSERTED:
            case 13: //sim fail,as "sim absent"
                ret = MBTK_SIM_ABSENT;
                goto done;

            default:
                ret = MBTK_SIM_NOT_READY;
                goto done;
        }
        ret = MBTK_SIM_NOT_READY;
        goto done;
    }

    /* CPIN? has succeeded, now look at the result */

    cpinLine = p_response->p_intermediates->line;
    err = at_tok_start (&cpinLine);

    if (err < 0)
    {
        ret = MBTK_SIM_NOT_READY;
        goto done;
    }

    err = at_tok_nextstr(&cpinLine, &cpinResult);

    if (err < 0)
    {
        ret = MBTK_SIM_NOT_READY;
        goto done;
    }

    if (0 == strcmp (cpinResult, "SIM PIN"))
    {
        ret = MBTK_SIM_PIN;
        goto done;
    }
    else if (0 == strcmp (cpinResult, "SIM PUK"))
    {
        ret = MBTK_SIM_PUK;
        goto done;
    }
    else if (0 == strcmp (cpinResult, "PH-NET PIN"))
    {
        return MBTK_SIM_NETWORK_PERSONALIZATION;
    }
    else if (0 != strcmp (cpinResult, "READY"))
    {
        /* we're treating unsupported lock types as "sim absent" */
        ret = MBTK_SIM_ABSENT;
        goto done;
    }

    at_response_free(p_response);
    p_response = NULL;
    cpinResult = NULL;

    // ret = net_info.radio_state == MBTK_RADIO_STATE_ON ? MBTK_SIM_READY : MBTK_SIM_NOT_READY;
    net_info.sim_state = MBTK_SIM_READY;
    return MBTK_SIM_READY;
done:
    at_response_free(p_response);
    net_info.sim_state = ret;
    return ret;
}

void setRadioPower(int isOn)
{
    int err;
    ATResponse *p_response = NULL;

    LOGI("RadioPower - %s", isOn == 0 ? "OFF" : "ON");

    if(isOn == 0 && net_info.radio_state == MBTK_RADIO_STATE_ON)
    {
        err = at_send_command("AT+CFUN=0", &p_response);
        if (err || !p_response->success)
            goto error;

        net_info.radio_state = MBTK_RADIO_STATE_OFF;
    }
    else if(isOn && net_info.radio_state != MBTK_RADIO_STATE_ON)
    {
        err = at_send_command("AT+CFUN=1", &p_response);
        if (err || !p_response->success)
        {
            if(isRadioOn() == 1)
            {
                net_info.radio_state = MBTK_RADIO_STATE_ON;
            }
            goto error;
        }

        net_info.radio_state = MBTK_RADIO_STATE_ON;
    }

    at_response_free(p_response);
    return;
error:
    at_response_free(p_response);
}

static int apn_user_pass_set_by_cid(int cid, mbtk_apn_info_t *apn)
{
    char prop_name[20] = {0};
    char prop_data[300] = {0};
    sprintf(prop_name, "%s_%d",MBTK_APN_PROP,cid);
    if(property_get(prop_name, prop_data, "") > 0 && !str_empty(prop_data)) {
        char apn_name[128] = {0};
        char *ptr_1 = prop_data;
        mbtk_ip_type_enum ip_type = (mbtk_ip_type_enum)atoi(ptr_1);
        ptr_1 = strstr(ptr_1, ",");
        if(!ptr_1) {
            return -1;
        }
        ptr_1++; // Jump ',' to apn

        char *ptr_2 = strstr(ptr_1, ",");
        if(!ptr_2) {
            return -1;
        }
        memcpy(apn_name, ptr_1, ptr_2 - ptr_1); // apn

        // Check ip_type and apn_name
        if(ip_type != apn->ip_type || strcmp(apn_name, apn->apn)) {
            LOGD("APN Changed, not get user/pass/auth.");
            return -1;
        }

        ptr_2++; // Jump ',' to user
        ptr_1 = strstr(ptr_2, ",");
        if(!ptr_1) {
            return -1;
        }
        if(memcmp(ptr_2, "NULL", 4)) { // Not "NULL"
            memcpy(apn->user, ptr_2, ptr_1 - ptr_2); // user
        }

        ptr_1++; // Jump ',' to pass
        ptr_2 = strstr(ptr_1, ",");
        if(!ptr_2) {
            return -1;
        }
        if(memcmp(ptr_1, "NULL", 4)) { // Not "NULL"
            memcpy(apn->pass, ptr_1, ptr_2 - ptr_1); // pass
        }

        ptr_2++; // Jump ',' to auth (Is last item)
        if(memcmp(ptr_2, "NULL", 4)) { // Not "NULL"
            memcpy(apn->auth, ptr_2, strlen(ptr_2)); // auth
        }

        return 0;
    }
    return -1;
}


/*
AT+CPOL?
*EUICC: 1

OK
*/
static int req_plmn_get(mbtk_plmn_info *type, int *cme_err)
{
    ATResponse *response = NULL;
    char *tmp_ptr = NULL;
    int err = at_send_command_multiline("AT+CPOL?", "+CPOL:", &response);

    if (err < 0 || response->success == 0 || !response->p_intermediates){
        *cme_err = at_get_cme_error(response);
        goto exit;
    }

    int mccmnc_type = -1;
    int count = -1;
    char *mccmnc_name = NULL;
    ATLine* lines_ptr = response->p_intermediates;
    char *line = NULL;
    while(lines_ptr)
    {
        line = lines_ptr->line;
        //if(strStartsWith(line, "+CPOL:"))
        {
            err = at_tok_start(&line);
            if (err < 0)
            {
                goto exit;
            }
            err = at_tok_nextint(&line, &count);
            if (err < 0)
            {
                goto exit;
            }
            type->count = count;

            err = at_tok_nextint(&line, &mccmnc_type);
            if (err < 0)
            {
                goto exit;
            }
            type->mbtk_plmn_name[count-1].format = mccmnc_type;

            err = at_tok_nextstr(&line, &mccmnc_name);
            if (err < 0)
            {
                goto exit;
            }
            memcpy(type->mbtk_plmn_name[count-1].plmn_name, mccmnc_name, strlen(mccmnc_name));
            mccmnc_name = NULL;
        }
        lines_ptr = lines_ptr->p_next;
    }

exit:
    at_response_free(response);
    return err;
}


/*
AT*EUICC?
*EUICC: 1

OK
*/
static int req_sim_card_type_get(uint8 *type, int *cme_err)
{
    ATResponse *response = NULL;
    char *tmp_ptr = NULL;
    int err = at_send_command_singleline("AT*EUICC?", "*EUICC:", &response);

    if (err < 0 || response->success == 0 || !response->p_intermediates){
        *cme_err = at_get_cme_error(response);
        goto exit;
    }

    char *line = response->p_intermediates->line;
    err = at_tok_start(&line);
    if (err < 0)
    {
        goto exit;
    }
    int sim_card_type = -1;
    err = at_tok_nextint(&line, &sim_card_type);
    if (err < 0)
    {
        goto exit;
    }
    if(sim_card_type != -1)
        *type = sim_card_type;
    goto exit;
exit:
    at_response_free(response);
    return err;
}

/*
AT+EPIN?
+EPIN: 3,0,10,0

OK
*/
static int req_pin_puk_last_times_get(mbtk_pin_puk_last_times *times, int *cme_err)
{
    ATResponse *response = NULL;
    char *tmp_ptr = NULL;
    int err = at_send_command_singleline("AT+EPIN?", "+EPIN:", &response);

    if (err < 0 || response->success == 0 || !response->p_intermediates){
        *cme_err = at_get_cme_error(response);
        goto exit;
    }

    char *line = response->p_intermediates->line;
    err = at_tok_start(&line);
    if (err < 0)
    {
        goto exit;
    }
    mbtk_pin_puk_last_times last_times={0};
    err = at_tok_nextint(&line, &(last_times.p1_retry));
    if (err < 0)
    {
        goto exit;
    }
    times->p1_retry = last_times.p1_retry;
    err = at_tok_nextint(&line, &(last_times.p2_retry));
    if (err < 0)
    {
        goto exit;
    }
    times->p2_retry = last_times.p2_retry;
    err = at_tok_nextint(&line, &(last_times.puk1_retry));
    if (err < 0)
    {
        goto exit;
    }
    times->puk1_retry = last_times.puk1_retry;
    err = at_tok_nextint(&line, &(last_times.puk2_retry));
    if (err < 0)
    {
        goto exit;
    }
    times->puk2_retry = last_times.puk2_retry;

exit:
    at_response_free(response);
    return err;
}


/*
AT+CGSN
864788050901201

OK
*/
static int req_imei_get(void *data, int *cme_err)
{
    ATResponse *response = NULL;
    int err = at_send_command_numeric("AT+CGSN", &response);

    if (err < 0 || response->success == 0 || !response->p_intermediates) {
        *cme_err = at_get_cme_error(response);
        goto exit;
    }

    memcpy(data, response->p_intermediates->line, strlen(response->p_intermediates->line));
exit:
    at_response_free(response);
    return err;
}

/*
AT+MRD_SN=R
+MRD_SN:0101,Thu Nov 12 00:00:00 2020,G4M32301020006

OK

*/
static int req_sn_get(void *data, int *cme_err)
{
    ATResponse *response = NULL;
    char *tmp_ptr = NULL;
    int err = at_send_command_singleline("AT+MRD_SN=R", "+MRD_SN:", &response);

    if (err < 0 || response->success == 0 || !response->p_intermediates){
        *cme_err = at_get_cme_error(response);
        goto exit;
    }

    char *line = response->p_intermediates->line;
    err = at_tok_start(&line);
    if (err < 0)
    {
        goto exit;
    }

    err = at_tok_nextstr(&line, &tmp_ptr);
    if (err < 0)
    {
        goto exit;
    }

    err = at_tok_nextstr(&line, &tmp_ptr);
    if (err < 0)
    {
        goto exit;
    }

    err = at_tok_nextstr(&line, &tmp_ptr);
    if (err < 0)
    {
        goto exit;
    }

    memcpy(data, tmp_ptr, strlen(tmp_ptr));

    goto exit;
exit:
    at_response_free(response);
    return err;
}

/*
AT+SYSTIME?
+SYSTIME: 1

OK

*/
static int req_time_get(int *data, int *cme_err)
{
    ATResponse *response = NULL;
    int tmp_int;
    int err = at_send_command_singleline("AT+SYSTIME?", "+SYSTIME:", &response);

    if (err < 0 || response->success == 0 || !response->p_intermediates){
        *cme_err = at_get_cme_error(response);
        goto exit;
    }

    char *line = response->p_intermediates->line;
    err = at_tok_start(&line);
    if (err < 0)
    {
        goto exit;
    }
    err = at_tok_nextint(&line, &tmp_int);
    if (err < 0)
    {
        goto exit;
    }
    *data = tmp_int;

exit:
    at_response_free(response);
    return err;
}

/*
AT+CCLK?
+CCLK: "23/03/20,01:58:00+32"

OK

*/
static int req_net_time_get(char *data, int *cme_err)
{
    ATResponse *response = NULL;
    char *tmp_ptr = NULL;
    int err = at_send_command_singleline("AT+CCLK?", "+CCLK:", &response);

    if (err < 0 || response->success == 0 || !response->p_intermediates){
        *cme_err = at_get_cme_error(response);
        goto exit;
    }

    char *line = response->p_intermediates->line;
    err = at_tok_start(&line);
    if (err < 0)
    {
        goto exit;
    }
    err = at_tok_nextstr(&line, &tmp_ptr);
    if (err < 0)
    {
        goto exit;
    }
    memcpy(data, tmp_ptr, strlen(tmp_ptr));

exit:
    at_response_free(response);
    return err;
}

/*
AT+CFUN?
+CFUN: 1
OK
*/
static int req_modem_get(int *data, int *cme_err)
{
    ATResponse *response = NULL;
    int modem;
    int err = at_send_command_singleline("AT+CFUN?", "+CFUN:", &response);

    if (err < 0 || response->success == 0 || !response->p_intermediates){
        *cme_err = at_get_cme_error(response);
        goto exit;
    }

    char *line = response->p_intermediates->line;
    err = at_tok_start(&line);
    if (err < 0)
    {
        goto exit;
    }
    err = at_tok_nextint(&line, &modem);
    if (err < 0)
    {
        goto exit;
    }
    *data = modem;

exit:
    at_response_free(response);
    return err;
}

/*
AT+CFUN=<fun>[,<rst>]
OK
*/
static int req_modem_set(mbtk_modem_info_t* modem, int *cme_err)
{
    ATResponse *response = NULL;
    char cmd[30] = {0};
    int err = -1;

    sprintf(cmd, "AT+CFUN=%d,%d", modem->fun, modem->rst);
    err = at_send_command(cmd, &response);

    if (err < 0 || response->success == 0){
        *cme_err = at_get_cme_error(response);
        goto exit;
    }
/*
    ATResponse *response = NULL;
    int err = at_send_command_multiline(cmd, "", &response);

    if (err < 0 || response->success == 0 || !response->p_intermediates){
        *cme_err = at_get_cme_error(response);
        goto exit;
    }

    ATLine* lines_ptr = response->p_intermediates;
    char *line = NULL;
    while(lines_ptr)
    {
        line = lines_ptr->line;
        if(strStartsWith(line, "Revision"))
        {
            err = at_tok_start(&line);
            if (err < 0)
            {
                goto exit;
            }
            memcpy(data, line, strlen(line));
            break;
        }
        lines_ptr = lines_ptr->p_next;
    }

    goto exit;
*/
exit:
    at_response_free(response);
    return err;
}


/*
AT+SYSTIME=0,"2022-01-25-11:15:30"
OK

AT+SYSTIME=1
OK
*/
static int req_time_set(int type, char *time, int *cme_err)
{
    ATResponse *response = NULL;
    int tmp_int;
    char cmd[200] = {0};
    if(str_empty(time)){
        sprintf(cmd, "AT+SYSTIME=%d", type);
    } else {
        sprintf(cmd, "AT+SYSTIME=%d,\"%s\"", type, time);
    }
    int err = at_send_command(cmd, &response);

    if (err < 0 || response->success == 0){
        *cme_err = at_get_cme_error(response);
        goto exit;
    }

exit:
    at_response_free(response);
    return err;
}


/*
ATI
Manufacturer:"LYNQ"
Model:"LYNQ_L508TLC"
Revision:L508TLCv02.01b01.00
IMEI:864788050901201

OK

*/
static int req_version_get(void *data, int *cme_err)
{
    ATResponse *response = NULL;
    int err = at_send_command_multiline("ATI", "", &response);

    if (err < 0 || response->success == 0 || !response->p_intermediates){
        *cme_err = at_get_cme_error(response);
        goto exit;
    }

    ATLine* lines_ptr = response->p_intermediates;
    char *line = NULL;
    while(lines_ptr)
    {
        line = lines_ptr->line;
        if(strStartsWith(line, "Revision"))
        {
            err = at_tok_start(&line);
            if (err < 0)
            {
                goto exit;
            }
            memcpy(data, line, strlen(line));
            break;
        }
        lines_ptr = lines_ptr->p_next;
    }

    goto exit;
exit:
    at_response_free(response);
    return err;
}


static int req_md_version_get(void *data, int *cme_err)
{
    ATResponse *response = NULL;
    int err = at_send_command_multiline("AT*CGMR", "", &response);

    if (err < 0 || response->success == 0 || !response->p_intermediates)
    {
        *cme_err = at_get_cme_error(response);
        goto exit;
    }

    ATLine* lines_ptr = response->p_intermediates;
    char *line = NULL;
    while(lines_ptr)
    {
        line = lines_ptr->line;
        char *start = strstr(line, "FALCON_CP_SDK");
        if(start)
        {
            char *end = strstr(start, "_Linux");
            if(end)
            {
                end += strlen("_Linux");
                int length = end - start;
                if (length)
                {
                    strncpy(data, start, length);
                    ((char*)data)[length] = '\0';
                    break;
                }
                else
                {
                    err = -1;
                    goto exit;

                }
            }
            else
            {
                err = -1;
                goto exit;
            }
        }
        lines_ptr = lines_ptr->p_next;
    }

    goto exit;
exit:
    at_response_free(response);
    return err;
}



/*
ATI
Manufacturer:"LYNQ"
Model:"LYNQ_L508TLC"
Revision:L508TLCv02.01b01.00
IMEI:864788050901201

OK

*/
static int req_model_get(void *data, int *cme_err)
{
    ATResponse *response = NULL;
    int err = at_send_command_multiline("ATI", "", &response);

    if (err < 0 || response->success == 0 || !response->p_intermediates){
        *cme_err = at_get_cme_error(response);
        goto exit;
    }

    ATLine* lines_ptr = response->p_intermediates;
    char *line = NULL;
    while(lines_ptr)
    {
        line = lines_ptr->line;
        if(strStartsWith(line, "Model"))
        {
            err = at_tok_start(&line);
            if (err < 0)
            {
                goto exit;
            }
            memcpy(data, line, strlen(line));
            break;
        }
        lines_ptr = lines_ptr->p_next;
    }

    goto exit;
exit:
    at_response_free(response);
    return err;
}

/*
AT+ACONFIG="IMSD=1"
or
AT+ACONFIG="IMSD=0"

OK
*/
static int req_volte_set(int state, int *cme_err)
{
    ATResponse *response = NULL;
    char cmd[30] = {0};
    if(state)
    {
        strcpy(cmd, "AT+ACONFIG=\"IMSD=1\"");
    }
    else
    {
        strcpy(cmd, "AT+ACONFIG=\"IMSD=0\"");
    }
    int err = at_send_command(cmd, &response);

    if (err < 0 || response->success == 0) {
        *cme_err = at_get_cme_error(response);
        goto exit;
    }

    err = 0;
exit:
    at_response_free(response);
    return err;
}

/*
AT+ACONFIG?
PID=0,VID=0,IMSD=1,PIPE=0,FAST=0,RDUP=1,NOCP=0,GEFL=-1237040617

OK
*/
static int req_volte_get(int *state, int *cme_err)
{
    ATResponse *response = NULL;
    char *tmp_ptr = NULL;
    int err = at_send_command_singleline("AT+ACONFIG?", "", &response);

    if (err < 0 || response->success == 0 || !response->p_intermediates){
        *cme_err = at_get_cme_error(response);
        goto exit;
    }

    char *line = response->p_intermediates->line;
    char* ptr = strstr(line, "IMSD=");
    if(ptr)
    {
        *state = atoi(ptr + strlen("IMSD="));
    }
    else
    {
        err = -1;
    }
exit:
    at_response_free(response);
    return err;
}


/*
* Get system temperature.
*
* type[IN]:
*   0: Soc temperature.
*   1: RF temperature.
* temp[OUT]:
*   temperature in celsius.
*

AT*RFTEMP
*RFTEMP:0,28
OK

AT*SOCTEMP
*SOCTEMP:24000
OK

*/
static int req_temp_get(int type, mbtk_thermal_info_t *temp, int *cme_err)
{
    ATResponse *response = NULL;
    int err = -1;
    int tmp_int;
    if(type == 0) { // Soc
        err = at_send_command_singleline("AT*SOCTEMP", "*SOCTEMP:", &response);
    } else { // RF
        err = at_send_command_singleline("AT*RFTEMP", "*RFTEMP:", &response);
    }

    if (err < 0 || response->success == 0 || !response->p_intermediates){
        *cme_err = at_get_cme_error(response);
        goto exit;
    }

    char *line = response->p_intermediates->line;
    err = at_tok_start(&line);
    if (err < 0)
    {
        goto exit;
    }
    err = at_tok_nextint(&line, &tmp_int);
    if (err < 0)
    {
        goto exit;
    }

    if(type == 1) { // RF
        err = at_tok_nextint(&line, &tmp_int);
        if (err < 0)
        {
            goto exit;
        }
        temp->ther = tmp_int;
    } else {
        tmp_int = tmp_int / 1000;
        temp->ther = tmp_int;
        //LOG(" >>>temp =%d",temp->ther);
    }

exit:
    at_response_free(response);
    return err;
}

/*
AT*BAND=15
OK

*/
static int req_band_set(mbtk_band_info_t* band, int *cme_err)
{
    ATResponse *response = NULL;
    char cmd[100] = {0};
    int err = -1;

    if(band->gsm_band == 0 && band->umts_band == 0
        && band->tdlte_band == 0 && band->fddlte_band == 0) {
        sprintf(cmd, "AT*BAND=%d", band->net_pref);
    } else {
        band_support_get();

        log_hex("BAND_SUPPORT", &band_support, sizeof(mbtk_band_info_t));
        log_hex("BAND", band, sizeof(mbtk_band_info_t));

        if(band->gsm_band == 0) {
            band->gsm_band = band_support.gsm_band;
        }
        if(band->umts_band == 0) {
            band->umts_band = band_support.umts_band;
        }
        if(band->tdlte_band == 0) {
            band->tdlte_band = band_support.tdlte_band;
        }
        if(band->fddlte_band == 0) {
            band->fddlte_band = band_support.fddlte_band;
        }

        if((band->gsm_band & band_support.gsm_band) != band->gsm_band) {
            LOG("GSM band error.");
            goto exit;
        }

        if((band->umts_band & band_support.umts_band) != band->umts_band) {
            LOG("UMTS band error.");
            goto exit;
        }

        if((band->tdlte_band & band_support.tdlte_band) != band->tdlte_band) {
            LOG("TDLTE band error.");
            goto exit;
        }

        if((band->fddlte_band & band_support.fddlte_band) != band->fddlte_band) {
            LOG("FDDLTE band error.");
            goto exit;
        }

        if((band->lte_ext_band & band_support.lte_ext_band) != band->lte_ext_band) {
            LOG("EXT_LTE band error.");
            goto exit;
        }

        if(band->net_pref == 0xFF) { // No change net_pref.
            int tmp_int;
            err = at_send_command_singleline("AT*BAND?", "*BAND:", &response);
            if (err < 0 || response->success == 0 || !response->p_intermediates){
                *cme_err = at_get_cme_error(response);
                goto exit;
            }

            char *line = response->p_intermediates->line;
            err = at_tok_start(&line);
            if (err < 0)
            {
                goto exit;
            }

            err = at_tok_nextint(&line, &tmp_int);
            if (err < 0)
            {
                goto exit;
            }
            band->net_pref = (uint8)tmp_int; // Set to current net_pref.

            at_response_free(response);
        }

        if(band->lte_ext_band > 0) {
            sprintf(cmd, "AT*BAND=%d,%d,%d,%d,%d,,,,%d", band->net_pref, band->gsm_band, band->umts_band, band->tdlte_band, band->fddlte_band, band->lte_ext_band);
        } else {
            sprintf(cmd, "AT*BAND=%d,%d,%d,%d,%d", band->net_pref, band->gsm_band, band->umts_band, band->tdlte_band, band->fddlte_band);
        }
    }
    err = at_send_command(cmd, &response);

    if (err < 0 || response->success == 0){
        *cme_err = at_get_cme_error(response);
        goto exit;
    }

    err = 0;
exit:
    at_response_free(response);
    return err;
}

/*
// ???????
AT*BAND=?
*BAND:(0-18),79,147,482,524503

OK

// ???????????
AT*BAND?
*BAND: 15, 78, 147, 482, 524503, 0, 2, 2, 0, 0

OK

// ?????????
AT*BAND=5,79,147,128,1
OK

net_prefferred??
    0 : GSM only
    1 : UMTS only
    2 : GSM/UMTS(auto)
    3 : GSM/UMTS(GSM preferred)
    4 : GSM/UMTS(UMTS preferred)
    5 : LTE only
    6 : GSM/LTE(auto)
    7 : GSM/LTE(GSM preferred)
    8 : GSM/LTE(LTE preferred)
    9 : UMTS/LTE(auto)
    10 : UMTS/LTE(UMTS preferred)
    11 : UMTS/LTE(LTE preferred)
    12 : GSM/UMTS/LTE(auto)
    13 : GSM/UMTS/LTE(GSM preferred)
    14 : GSM/UMTS/LTE(UMTS preferred)
    15 : GSM/UMTS/LTE(LTE preferred)
GSM band??
    1 ?C PGSM 900 (standard or primary)
    2 ?C DCS GSM 1800
    4 ?C PCS GSM 1900
    8 ?C EGSM 900 (extended)
    16 ?C GSM 450
    32 ?C GSM 480
    64 ?C GSM 850
    512 - BAND_LOCK_BIT // used for GSM band setting
UMTS band??
    1 ?C UMTS_BAND_1
    2 ?C UMTS_BAND_2
    4 ?C UMTS_BAND_3
    8 ?C UMTS_BAND_4
    16 ?C UMTS_BAND_5
    32 ?C UMTS_BAND_6
    64 ?C UMTS_BAND_7
    128 ?C UMTS_BAND_8
    256 ?C UMTS_BAND_9
LTEbandH(TDD-LTE band)
    32 ?C TDLTE_BAND_38
    64 ?C TDLTE_BAND_39
    128 ?C TDLTE_BAND_40
    256 ?C TDLTE_BAND_41
LTEbandL(FDD-LTE band)
    1 ?C FDDLTE_BAND_1
    4 ?C FDDLTE _BAND_3
    8 ?C FDDLTE _BAND_4
    64 ?C FDDLTE _BAND_7
    65536 ?C FDDLTE _BAND_17
    524288 ?C FDDLTE _BAND_20
*/
static int req_band_get(mbtk_band_info_t *band, int *cme_err)
{
    ATResponse *response = NULL;
    int tmp_int;

    band_support_get();

    log_hex("BAND_SUPPORT", &band_support, sizeof(mbtk_band_info_t));
    int err = at_send_command_singleline("AT*BAND?", "*BAND:", &response);
    if (err < 0 || response->success == 0 || !response->p_intermediates){
        *cme_err = at_get_cme_error(response);
        goto exit;
    }

    char *line = response->p_intermediates->line;
    err = at_tok_start(&line);
    if (err < 0)
    {
        goto exit;
    }

    err = at_tok_nextint(&line, &tmp_int);
    if (err < 0)
    {
        goto exit;
    }
    band->net_pref = (uint8)tmp_int;

    err = at_tok_nextint(&line, &tmp_int);
    if (err < 0)
    {
        goto exit;
    }
    band->gsm_band = (uint16)tmp_int;

    err = at_tok_nextint(&line, &tmp_int);
    if (err < 0)
    {
        goto exit;
    }
    band->umts_band = (uint16)tmp_int;

    err = at_tok_nextint(&line, &tmp_int);
    if (err < 0)
    {
        goto exit;
    }
    band->tdlte_band = (uint32)tmp_int;

    err = at_tok_nextint(&line, &tmp_int);
    if (err < 0)
    {
        goto exit;
    }
    band->fddlte_band = (uint32)tmp_int;

    // roamingConfig
    err = at_tok_nextint(&line, &tmp_int);
    if (err < 0)
    {
        goto exit;
    }

    // srvDomain
    err = at_tok_nextint(&line, &tmp_int);
    if (err < 0)
    {
        goto exit;
    }

    // bandPriorityFlag
    err = at_tok_nextint(&line, &tmp_int);
    if (err < 0)
    {
        goto exit;
    }

    //
    err = at_tok_nextint(&line, &tmp_int);
    if (err < 0)
    {
        goto exit;
    }

    // ltebandExt
    err = at_tok_nextint(&line, &tmp_int);
    if (err < 0)
    {
        goto exit;
    }
    band->lte_ext_band = (uint32)tmp_int;

    log_hex("BAND", band, sizeof(mbtk_band_info_t));

exit:
    at_response_free(response);
    return err;
}

/*
AT+ICCID
+ICCID: 89860621330065648041

OK
*/
static int req_iccid_get(void *data, int *cme_err)
{
    ATResponse *response = NULL;
    char *tmp_ptr = NULL;
    int err = at_send_command_singleline("AT+ICCID", "+ICCID:", &response);

    if (err < 0 || response->success == 0 || !response->p_intermediates){
        *cme_err = at_get_cme_error(response);
        goto exit;
    }

    char *line = response->p_intermediates->line;
    err = at_tok_start(&line);
    if (err < 0)
    {
        goto exit;
    }

    err = at_tok_nextstr(&line, &tmp_ptr);
    if (err < 0)
    {
        goto exit;
    }

    memcpy(data, tmp_ptr, strlen(tmp_ptr));
exit:
    at_response_free(response);
    return err;
}

/*
AT+CNUM?
+CNUM: "","13980414101",129

OK

*/
static int req_phone_number_get(void *data, int *cme_err)
{
    ATResponse *response = NULL;
    char *tmp_ptr = NULL;
    int err = at_send_command_singleline("AT+CNUM?", "+CNUM:", &response);
    if (err < 0 || response == NULL || response->success == 0 || !response->p_intermediates){
        if(response) {
            *cme_err = at_get_cme_error(response);
        }
        LOGD("AT+CNUM? fail.");
        goto exit;
    }

    char *line = response->p_intermediates->line;
    if(line == NULL) {
        LOGD("line is NULL");
        goto exit;
    }
    err = at_tok_start(&line);
    if (err < 0)
    {
        goto exit;
    }

    err = at_tok_nextstr(&line, &tmp_ptr);
    if (err < 0)
    {
        goto exit;
    }

    err = at_tok_nextstr(&line, &tmp_ptr);
    if (err < 0)
    {
        goto exit;
    }

    memcpy(data, tmp_ptr, strlen(tmp_ptr));
exit:
    at_response_free(response);
    return err;
}


/*
AT+CIMI
460068103383304

OK

*/
static int req_imsi_get(void *data, int *cme_err)
{
    ATResponse *response = NULL;
    int err = at_send_command_numeric("AT+CIMI", &response);

    if (err < 0 || response->success == 0 || !response->p_intermediates){
        *cme_err = at_get_cme_error(response);
        goto exit;
    }

    memcpy(data, response->p_intermediates->line, strlen(response->p_intermediates->line));
exit:
    at_response_free(response);
    return err;
}


/*
AT+CLCK=SC,1/0,1234
+CLCK:1/0

OK

*/
static int req_pin_enable(mbtk_enable_pin_info *data, int *cme_err)
{
    ATResponse *response = NULL;
    char cmd[64]={0};
    sprintf(cmd, "AT+CLCK=SC,%d,%s", data->enable, data->pin_value);

    int err = at_send_command_singleline(cmd, "+CLCK:", &response);
    if (err < 0 || response == NULL || response->success == 0 || !response->p_intermediates){
        if(response) {
            *cme_err = at_get_cme_error(response);
        }
        LOGD("AT+CLCK? fail.");
        goto exit;
    }

    char *line = response->p_intermediates->line;
    if(line == NULL) {
        LOGD("line is NULL");
        goto exit;
    }
    err = at_tok_start(&line);
    if (err < 0)
    {
        goto exit;
    }
    int clck;
    err = at_tok_nextint(&line, &clck);
    if (err < 0)
    {
        goto exit;
    }

exit:
    at_response_free(response);
    return err;
}

/*
AT+CLCK=SC,2
+CLCK: 1

OK
*/
static int req_get_pin_state(mbtk_enable_pin_info *state, int *cme_err)
{
    ATResponse *response = NULL;
    char cmd[64]={0};

    int err = at_send_command_singleline("AT+CLCK=SC,2", "+CLCK:", &response);
    if (err < 0 || response == NULL || response->success == 0 || !response->p_intermediates)
    {
        if(response)
        {
            *cme_err = at_get_cme_error(response);
        }
        LOGE("[req_get_pin_state] AT+CLCK fail.");
        goto exit;
    }

    char *line = response->p_intermediates->line;
    if(line == NULL)
    {
        LOGE("[req_get_pin_state] line is NULL");
        goto exit;
    }
    err = at_tok_start(&line);
    if (err < 0)
    {
        LOGE("[req_get_pin_state] at_tok_start fail.[%d]", err);
        goto exit;
    }

    int clck;
    err = at_tok_nextint(&line, &clck);
    if (err < 0)
    {
        LOGE("[req_get_pin_state] at_tok_nextint fail.[%d]", err);
        goto exit;
    }

    if(clck == 1)
    {
        state = MBTK_PIN_ENABLE;
    }
    else
    {
        state = MBTK_PIN_DISABLE;
    }
exit:
    at_response_free(response);
    response = NULL;
    return err;
}


/*
AT+CPIN=1234

OK

*/
static int req_pin_verify(char *data, int *cme_err)
{
    ATResponse *response = NULL;
    char cmd[64]={0};
    sprintf(cmd, "AT+CPIN=%s", data);
    int err = at_send_command(cmd, &response);
    if (err < 0 || response->success == 0){
        if(cme_err) {
            *cme_err = at_get_cme_error(response);
        }
        goto exit;
    }

exit:
    at_response_free(response);
    return err;
}

/*
AT+CLCK=SC,2
+CLCK: 1

OK

AT+CLCK="SC",1,"1234"
+CLCK:1

OK

AT+CPWD="SC","1234","4321"

OK

*/
static int req_pin_change(mbtk_change_pin_info *data, int *cme_err)
{
    ATResponse *response = NULL;
    char cmd[64]={0};

    int err = at_send_command_singleline("AT+CLCK=SC,2", "+CLCK:", &response);
    if (err < 0 || response == NULL || response->success == 0 || !response->p_intermediates){
        if(response) {
            *cme_err = at_get_cme_error(response);
        }
        LOGD("AT+CLCK fail.");
        goto exit;
    }

    char *line = response->p_intermediates->line;
    if(line == NULL) {
        LOGD("line is NULL");
        goto exit;
    }
    err = at_tok_start(&line);
    if (err < 0)
    {
        goto exit;
    }
    int clck;
    err = at_tok_nextint(&line, &clck);
    if (err < 0)
    {
        goto exit;
    }
    at_response_free(response);

    if(clck==0)
    {
        sprintf(cmd, "AT+CLCK=SC,1,%s", data->old_pin_value);
        err = at_send_command_singleline(cmd, "+CLCK:", &response);
        if (err < 0 || response == NULL || response->success == 0 || !response->p_intermediates){
            if(response) {
                *cme_err = at_get_cme_error(response);
            }
            LOGD("AT+CLCK fail.");
            goto exit;
        }
        line = response->p_intermediates->line;
        if(line == NULL) {
            LOGD("line is NULL");
            goto exit;
        }
        err = at_tok_start(&line);
        if (err < 0)
        {
            goto exit;
        }
        clck = -1;
        err = at_tok_nextint(&line, &clck);
        if (err < 0)
        {
            goto exit;
        }
        at_response_free(response);
        if(clck != 1)
            return err;
    }
    memset(cmd, 0, 64);
    sprintf(cmd, "AT+CPWD=SC,%s,%s", data->old_pin_value,data->new_pin_value);
    err = at_send_command(cmd, &response);
    if (err < 0 || response->success == 0){
        if(cme_err) {
            *cme_err = at_get_cme_error(response);
        }
        goto exit;
    }

exit:
    at_response_free(response);
    return err;
}

/*
AT+CPIN?
+CPIN:SIM PUK

OK

AT+CPIN="PUK","PIN"
+CPIN: READY

OK
*/
static int req_puk_unlock_pin(mbtk_unlock_pin_info *data, int *cme_err)
{
    ATResponse *response = NULL;
    char cmd[64]={0};
#if 0
    int err = at_send_command_singleline("AT+CPIN?", "+CPIN:", &response);
    if (err < 0 || response == NULL || response->success == 0 || !response->p_intermediates){
        if(response) {
            *cme_err = at_get_cme_error(response);
        }
        LOGD("AT+CNUM? fail.");
        goto exit;
    }

    char *line = response->p_intermediates->line;
    if(line == NULL) {
        LOGD("line is NULL");
        goto exit;
    }
    err = at_tok_start(&line);
    if (err < 0)
    {
        goto exit;
    }
    char *tmp_ptr = NULL;
    err = at_tok_nextstr(&line, &tmp_ptr);
    if (err < 0)
    {
        goto exit;
    }
    at_response_free(response);

    if(!strstr(tmp_ptr,"SIM PUK"))
    {
        sprintf(cmd, "AT+CPIN=%s,%s", data->puk_value, data->pin_value);
        err = at_send_command_singleline(cmd, "+CPIN:", &response);
        if (err < 0 || response == NULL || response->success == 0 || !response->p_intermediates){
            if(response) {
                *cme_err = at_get_cme_error(response);
            }
            LOGD("AT+CNUM? fail.");
            goto exit;
        }
        line = response->p_intermediates->line;
        if(line == NULL) {
            LOGD("line is NULL");
            goto exit;
        }
        err = at_tok_start(&line);
        if (err < 0)
        {
            goto exit;
        }
        memset(tmp_ptr, 0, strlen(tmp_ptr));
        err = at_tok_nextstr(&line, &tmp_ptr);
        if (err < 0)
        {
            goto exit;
        }
        at_response_free(response);
        if(strstr(tmp_ptr, "READY"))
            return err;
    }
    else
        return err;
#else
    sprintf(cmd, "AT+CPIN=%s,%s", data->puk_value, data->pin_value);
    int err = at_send_command(cmd, &response);
    if (err < 0 || response->success == 0){
        if(cme_err) {
            *cme_err = at_get_cme_error(response);
        }
        goto exit;
    }

#endif
exit:
    at_response_free(response);
    return err;
}

/*
AT+COPS=?

+COPS: (2, "CHINA MOBILE", "CMCC", "46000", 7),(3, "CHN-CT", "CT", "46011", 7),(3, "CHN-UNICOM", "UNICOM", "46001", 7),(1, "460 15", "460 15", "46015", 7),,(0,1,2,3,4),(0,1,2)

OK

// Return [sel_mode(uint8)type(uint8)plmn(uint32)...sel_mode(uint8)type(uint8)plmn(uint32)]
*/
#if 0
static int req_available_net_get(mbtk_net_array_info_t *data_ptr)
{
    ATResponse *response = NULL;
    char *tmp_ptr = NULL;
    int tmp_int;
    int err = at_send_command_singleline("AT+COPS=?", "+COPS:", &response);

    if (err < 0 || response->success == 0 || !response->p_intermediates)
        goto exit;
#if 1
    char *line_ptr = response->p_intermediates->line;
    if(line_ptr == NULL) {
        LOG("line is NULL");
        goto exit;
    }
    //LOG("Line:%s",line_ptr);
    line_ptr = strstr(line_ptr, "(");
    while(line_ptr) {
        line_ptr++;
        // Only for available/current net.
        if(*line_ptr == '1' || *line_ptr == '2') {
            //LOG("Temp:%s",line_ptr);
            //sleep(1);
            line_ptr = strstr(line_ptr, ",");
            if(line_ptr == NULL)
                goto exit;
            line_ptr++;

            line_ptr = strstr(line_ptr, ",");
            if(line_ptr == NULL)
                goto exit;
            line_ptr++;

            line_ptr = strstr(line_ptr, ",");
            if(line_ptr == NULL)
                goto exit;

            while(*line_ptr != '\0' && (*line_ptr == ',' || *line_ptr == ' ' || *line_ptr == '"'))
                line_ptr++;

            mbtk_net_info_t *net = (mbtk_net_info_t*)malloc(sizeof(mbtk_net_info_t));
            if(net == NULL) {
                LOG("malloc() fail.");
                goto exit;
            }
            memset(net, 0, sizeof(mbtk_net_info_t));

            // Point to "46000"
            //LOG("PLMN:%s",line_ptr);
            //sleep(1);
            net->plmn = (uint32)atoi(line_ptr);

            line_ptr = strstr(line_ptr, ",");
            if(line_ptr == NULL)
                goto exit;

            while(*line_ptr != '\0' && (*line_ptr == ',' || *line_ptr == ' '))
                line_ptr++;

            // Point to "7"
            if(*line_ptr == '\0') {
                free(net);
                goto exit;
            }
            //LOG("Type:%s",line_ptr);
            //sleep(1);
            net->net_type = (uint8)atoi(line_ptr);
            list_add(data_ptr->net_list, net);
            data_ptr->count++;
        }

        line_ptr = strstr(line_ptr, "(");
    }
#endif
exit:
    at_response_free(response);
    return err;
}
#else
static int req_available_net_get(void* buff, int *cme_err)
{
    ATResponse *response = NULL;
    char *tmp_ptr = NULL;
    int tmp_int;
    int buff_size = 0;
    int err = at_send_command_singleline("AT+COPS=?", "+COPS:", &response);

    if (err < 0 || response->success == 0 || !response->p_intermediates){
        *cme_err = at_get_cme_error(response);
        goto exit;
    }
    char *line_ptr = response->p_intermediates->line;
    if(line_ptr == NULL) {
        LOG("line is NULL");
        goto exit;
    }
    uint8* buff_ptr = (uint8*)buff;
    //LOG("Line:%s",line_ptr);
    line_ptr = strstr(line_ptr, "(");
    while(line_ptr) {
        line_ptr++;
        // Only for available/current net.
        if(*line_ptr == '1' || *line_ptr == '2' || *line_ptr == '3') {
            *(buff_ptr + 2) = (uint8)atoi(line_ptr); // net_state

            line_ptr = strstr(line_ptr, ",");
            if(line_ptr == NULL)
                goto exit;
            line_ptr++;

            line_ptr = strstr(line_ptr, ",");
            if(line_ptr == NULL)
                goto exit;
            line_ptr++;

            line_ptr = strstr(line_ptr, ",");
            if(line_ptr == NULL)
                goto exit;

            while(*line_ptr != '\0' && (*line_ptr == ',' || *line_ptr == ' ' || *line_ptr == '"'))
                line_ptr++;

            // set sel_mode to 0
            *buff_ptr = (uint8)0;
            // Point to "46000"
            //LOG("PLMN:%s",line_ptr);
            //sleep(1);
            uint32_2_byte((uint32)atoi(line_ptr), buff_ptr + 3, false); // plmn

            line_ptr = strstr(line_ptr, ",");
            if(line_ptr == NULL)
                goto exit;

            while(*line_ptr != '\0' && (*line_ptr == ',' || *line_ptr == ' '))
                line_ptr++;

            // Point to "7"
            if(*line_ptr == '\0') {
                goto exit;
            }
            //LOG("Type:%s",line_ptr);
            //sleep(1);
            *(buff_ptr + 1) = (uint8)atoi(line_ptr); // net_type

            buff_size += sizeof(mbtk_net_info_t);
            buff_ptr += sizeof(mbtk_net_info_t);
        }

        line_ptr = strstr(line_ptr, "(");
    }
exit:
    at_response_free(response);
    return buff_size;
}
#endif

/*
AT+COPS?
+COPS: 1

OK

or

AT+COPS?
+COPS: 0,2,"46001",7

OK

*/
static int req_net_sel_mode_get(mbtk_net_info_t *net, int *cme_err)
{
    //LOG("req_net_sel_mode_get() 0");
    //sleep(1);
    ATResponse *response = NULL;
    int tmp_int;
    char *tmp_ptr = NULL;
    int err = at_send_command_singleline("AT+COPS?", "+COPS:", &response);
    //LOG("req_net_sel_mode_get() 00");
    //sleep(1);
    if (err < 0 || response->success == 0 || !response->p_intermediates){
        if(cme_err != NULL)
            *cme_err = at_get_cme_error(response);
        err = -1;
        goto exit;
    }
    //LOG("req_net_sel_mode_get() 1");
    //sleep(1);
    char *line = response->p_intermediates->line;
    if(line == NULL) {
        LOG("line is NULL");
        goto exit;
    }
    //LOG("req_net_sel_mode_get() 2");
    //sleep(1);
    err = at_tok_start(&line);
    if (err < 0)
    {
        goto exit;
    }
    //LOG("req_net_sel_mode_get() 3");
    //sleep(1);
    err = at_tok_nextint(&line, &tmp_int);
    if (err < 0)
    {
        goto exit;
    }
    net->net_sel_mode = (uint8)tmp_int;
    //LOG("req_net_sel_mode_get() 4");
    //sleep(1);
    // +COPS: 1
    if(!at_tok_hasmore(&line)) {
        goto exit;
    }
    //LOG("req_net_sel_mode_get() 5");
    //sleep(1);
    err = at_tok_nextint(&line, &tmp_int);
    if (err < 0)
    {
        goto exit;
    }
    //LOG("req_net_sel_mode_get() 6");
    //sleep(1);
    err = at_tok_nextstr(&line, &tmp_ptr);
    if (err < 0)
    {
        goto exit;
    }
    // memcpy(net->plmn, tmp_ptr, strlen(tmp_ptr));
    net->plmn = (uint32)atoi(tmp_ptr);
    //LOG("req_net_sel_mode_get() 7");
    //sleep(1);
    err = at_tok_nextint(&line, &tmp_int);
    if (err < 0)
    {
        goto exit;
    }
    net->net_type = (uint8)tmp_int;

    net->net_state = (uint8)MBTK_NET_AVIL_STATE_CURRENT;

exit:
    //LOG("req_net_sel_mode_get() 8");
    //sleep(1);
    at_response_free(response);
    return err;
}

/*
AT+COPS=0
or
AT+COPS=1,2,"46000",7

OK

*/
static int req_net_sel_mode_set(mbtk_net_info_t* net, int *cme_err)
{
    ATResponse *response = NULL;
    char cmd[50] = {0};
    char* cmp_ptr = cmd;
    if(net == NULL) {
        cmp_ptr += sprintf(cmp_ptr, "AT+COPS=0");
     } else {
        if(net->net_sel_mode == 0) {
            cmp_ptr += sprintf(cmp_ptr, "AT+COPS=0");
        } else if(net->net_type == 0xFF) {
            cmp_ptr += sprintf(cmp_ptr, "AT+COPS=1,2,\"%d\"",net->plmn);
        } else {
            cmp_ptr += sprintf(cmp_ptr, "AT+COPS=1,2,\"%d\",%d",net->plmn, net->net_type);
        }
     }

    int err = at_send_command(cmd, &response);

    if (err < 0 || response->success == 0) {
        *cme_err = at_get_cme_error(response);
        goto exit;
    }

exit:
    at_response_free(response);
    return err;
}

/*
AT+EEMOPT=1
OK

// LTE
AT+EEMGINFO?
// <mcc>, <length of mnc>, <mnc>, <tac>, <PCI>, <dlEuarfcn>, < ulEuarfcn >, <band>, <dlBandwidth>,
// <rsrp>,<rsrq>, <sinr>,
// errcModeState,emmState,serviceState,IsSingleEmmRejectCause,EMMRejectCause,mmeGroupId,mmeCode,mTmsi,
// cellId,subFrameAssignType,specialSubframePatterns,transMode
// mainRsrp,diversityRsrp,mainRsrq,diversityRsrq,rssi,cqi,pathLoss,tb0DlTpt,tb1DlTpt,tb0DlPeakTpt,tb1DlPeakTpt,tb0UlPeakTpt,
// tb1UlPeakTpt,dlThroughPut,dlPeakThroughPut,averDlPRB,averCQITb0,averCQITb1,rankIndex,grantTotal,ulThroughPut,ulPeakThroughPut,currPuschTxPower,averUlPRB,
// dlBer, ulBer,
// diversitySinr, diversityRssi
+EEMLTESVC: 1120, 2, 0, 33584, 430, 40936, 40936, 41, 20,
0, 0, 0,
1, 10, 0, 1, 0, 1059, 78, 3959566565,
105149248, 2, 7, 7,
0, 0, 0, 0, 0, 0, 0, 1190919, 0, 0, 0, 16779777,
0, 5112867, 3959566565, 2, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0,
7, 44

// index,phyCellId,euArfcn,rsrp,rsrq
+EEMLTEINTER: 0, 65535, 38950, 0, 0

+EEMLTEINTER: 1, 0, 0, 0, 0

+EEMLTEINTER: 2, 0, 4294967295, 255, 255

+EEMLTEINTER: 3, 65535, 1300, 0, 0

+EEMLTEINTER: 4, 0, 0, 0, 0

+EEMLTEINTER: 5, 0, 4294967295, 247, 0

+EEMLTEINTER: 6, 197, 41332, 24, 9

+EEMLTEINTER: 7, 0, 0, 0, 0

+EEMLTEINTER: 8, 0, 0, 0, 0

+EEMLTEINTRA: 0, 429, 40936, 56, 12

+EEMLTEINTERRAT: 0,0

+EEMLTEINTERRAT: 1,0

+EEMGINFO: 3, 2         // <state>:
                        // 0: ME in Idle mode
                        // 1: ME in Dedicated mode
                        // 2: ME in PS PTM mode
                        // 3: invalid state
                        // <nw_type>:
                        // 0: GSM 1: UMTS 2: LTE

OK

// WCDMA
AT+EEMGINFO?
// Mode, sCMeasPresent, sCParamPresent, ueOpStatusPresent,

// if sCMeasPresent == 1
// cpichRSCP, utraRssi, cpichEcN0, sQual, sRxLev, txPower,
// endif

// if sCParamPresent == 1
// rac, nom, mcc, mnc_len, mnc, lac, ci,
// uraId, psc, arfcn, t3212, t3312, hcsUsed, attDetAllowed,
// csDrxCycleLen, psDrxCycleLen, utranDrxCycleLen, HSDPASupport, HSUPASupport,
// endif

// if ueOpStatusPresent == 1
// rrcState, numLinks, srncId, sRnti,
// algPresent, cipherAlg, cipherOn, algPresent, cipherAlg, cipherOn,
// HSDPAActive, HSUPAActive, MccLastRegisteredNetwork, MncLastRegisteredNetwork, TMSI, PTMSI, IsSingleMmRejectCause, IsSingleGmmRejectCause,
// MMRejectCause, GMMRejectCause, mmState, gmmState, gprsReadyState, readyTimerValueInSecs, NumActivePDPContext, ULThroughput, DLThroughput,
// serviceStatus, pmmState, LAU_status, LAU_count, RAU_status, RAU_count
// endif
//
+EEMUMTSSVC: 3, 1, 1, 1,
-80, 27, -6, -18, -115, -32768,
1, 1, 1120, 2, 1, 61697, 168432821,
15, 24, 10763, 0, 0, 0, 0,
128, 128, 65535, 0, 0,
2, 255, 65535, 4294967295,
0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 1, 1,
28672, 28672, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0

// index, cpichRSCP, utraRssi, cpichEcN0, sQual, sRxLev ,mcc, mnc, lac, ci, arfcn, psc
+EEMUMTSINTRA: 0, -32768, -1, -32768, -18, -115, 0, 0, 65534, 1, 10763, 32

+EEMUMTSINTRA: 1, -1, -32768, -18, -115, 0, 0, 65534, 2, 10763, 40, 32768

+EEMUMTSINTRA: 2, -32768, -18, -115, 0, 0, 65534, 3, 10763, 278, 32768, 65535

+EEMUMTSINTRA: 3, -18, -115, 0, 0, -2, 4, 10763, 28, 32768, 65535, 32768

+EEMUMTSINTRA: 4, -115, 0, 0, -2, 5, 10763, 270, 32768, 65535, 32768, 65518

+EEMUMTSINTRA: 5, 0, 0, -2, 6, 10763, 286, 32768, 65535, 32768, 65518, 65421

+EEMUMTSINTRA: 6, 0, -2, 7, 10763, 80, 32768, 65535, 32768, 65518, 65421, 0

+EEMUMTSINTRA: 7, -2, 8, 10763, 206, -32768, 65535, 32768, 65518, 65421, 0, 0

+EEMUMTSINTRA: 8, 9, 10763, 11, -32768, -1, 32768, 65518, 65421, 0, 0, 65534

+EEMUMTSINTRA: 9, 10763, 19, -32768, -1, -32768, 65518, 65421, 0, 0, 65534, 11

+EEMUMTSINTRA: 10, 232, -32768, -1, -32768, -18, 65421, 0, 0, 65534, 12, 10763

+EEMUMTSINTRA: 11, -32768, -1, -32768, -18, -115, 0, 0, 65534, 13, 10763, 66

+EEMUMTSINTRA: 12, -1, -32768, -18, -115, 0, 0, 65534, 14, 10763, 216, 32768

+EEMUMTSINTRA: 13, -32768, -18, -115, 0, 0, 65534, 15, 10763, 183, 32768, 65535

+EEMUMTSINTRA: 14, -18, -115, 0, 0, -2, 16, 10763, 165, 32768, 65535, 32768

+EEMUMTSINTRA: 15, -115, 0, 0, -2, 17, 10763, 151, 32768, 65535, 32768, 65518

+EEMUMTSINTRA: 16, 0, 0, -2, 18, 10763, 43, 32768, 65535, 32768, 65518, 65421

+EEMUMTSINTRA: 17, 0, -2, 19, 10763, 72, 32768, 65535, 32768, 65518, 65421, 0

+EEMUMTSINTRA: 18, -2, 20, 10763, 157, -32768, 65535, 32768, 65518, 65421, 0, 0

+EEMUMTSINTRA: 19, 21, 10763, 165, -32768, -1, 32768, 65518, 65421, 0, 0, 65534

+EEMUMTSINTRA: 20, 10763, 301, -32768, -1, -32768, 65518, 65421, 0, 0, 65534, 23

+EEMUMTSINTRA: 21, 23, -32768, -1, -32768, -18, 65421, 0, 0, 65534, 24, 10763

+EEMUMTSINTRA: 22, -32768, -1, -32768, -18, -115, 0, 0, 65534, 25, 10763, 0

+EEMUMTSINTRA: 23, -1, -32768, -18, -115, 0, 0, 65534, 26, 10763, 167, 32768

+EEMUMTSINTRA: 24, -32768, -18, -115, 0, 0, 65534, 27, 10763, 34, 32768, 65535

+EEMUMTSINTRA: 25, -18, -115, 0, 0, -2, 28, 10763, 313, 32768, 65535, 32768

+EEMUMTSINTRA: 26, -115, 0, 0, -2, 29, 10763, 152, 32768, 65535, 32768, 65518

+EEMUMTSINTRA: 27, 0, 0, -2, 30, 10763, 239, 0, 0, 0, 0, 0

+EEMUMTSINTRA: 28, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0

+EEMUMTSINTRA: 29, 0, 0, 0, 0, -115, 0, 0, 65534, 30, 10763, 239

// index,gsmRssi,rxLev,C1,C2,mcc,mnc,lac,ci,arfcn,bsic
+EEMUMTSINTERRAT: 0, -32768, -107, -1, -1, 0, 0, 65534, 0, 117, 36

+EEMUMTSINTERRAT: 1, -107, -1, -1, 0, 0, 65534, 1, 72, 49, 0

+EEMUMTSINTERRAT: 2, -1, -1, 0, 0, 65534, 2, 119, 15, 32768, 149

+EEMUMTSINTERRAT: 3, -1, 0, 0, -2, 3, 121, 23, 0, 0, 0

+EEMGINFO: 3, 1

OK


// GSM
AT+EEMGINFO?
+EEMGINFOBASIC: 2

// mcc, mnc_len, mnc, lac, ci, nom, nco,
// bsic, C1, C2, TA, TxPwr,
// RxSig, RxSigFull, RxSigSub, RxQualFull, RxQualSub,
// ARFCB_tch, hopping_chnl, chnl_type, TS, PacketIdle, rac, arfcn,
// bs_pa_mfrms, C31, C32, t3212, t3312, pbcch_support, EDGE_support,
// ncc_permitted, rl_timeout, ho_count, ho_succ, chnl_access_count, chnl_access_succ_count,
// gsmBand,channelMode
+EEMGINFOSVC: 1120, 2, 0, 32784, 24741, 2, 0,
63, 36, 146, 1, 7,
46, 42, 42, 7, 0,
53, 0, 8, 0, 1, 6, 53,
2, 0, 146, 42, 54, 0, 1,
1, 32, 0, 0, 0, 0,
0, 0

// PS_attached, attach_type, service_type, tx_power, c_value,
// ul_ts, dl_ts, ul_cs, dl_cs, ul_modulation, dl_modulation,
// gmsk_cv_bep, 8psk_cv_bep, gmsk_mean_bep, 8psk_mean_bep, EDGE_bep_period, single_gmm_rej_cause
// pdp_active_num, mac_mode, network_control, network_mode, EDGE_slq_measurement_mode, edge_status
+EEMGINFOPS: 1, 255, 0, 0, 0,
0, 0, 268435501, 1, 0, 0,
4, 0, 96, 0, 0, 0,
0, 0, 0, 65535, 0, 13350

+EEMGINFO: 0, 0

OK

*/
static int req_cell_info_get(int *cme_err)
{
    ATResponse *response = NULL;
    int tmp_int;
    int buff_size = 0;
    // AT+EEMOPT=1 in the first.
    int err = at_send_command("AT+EEMOPT=1", &response);
    if (err < 0 || response->success == 0){
        *cme_err = at_get_cme_error(response);
        goto exit;
    }

    // Reset buffer in the first.
    memset(&cell_info, 0xFF, sizeof(mbtK_cell_pack_info_t));
    cell_info.running = true;
    cell_info.cell_num = 0;

    err = at_send_command_singleline("AT+EEMGINFO?", "+EEMGINFO:", &response);
    if (err < 0 || response->success == 0 || !response->p_intermediates){
        *cme_err = at_get_cme_error(response);
        goto exit;
    }

    // Now, cell infomation has get from URC message.

    char *line = response->p_intermediates->line;
    err = at_tok_start(&line);
    if (err < 0)
    {
        goto exit;
    }
    err = at_tok_nextint(&line, &tmp_int);
    if (err < 0)
    {
        goto exit;
    }
    err = at_tok_nextint(&line, &tmp_int);
    if (err < 0)
    {
        goto exit;
    }

    cell_info.type = (uint8)tmp_int;
    cell_info.running = false;

#if 0
    while(lines_ptr)
    {
        // LTE
        if(strStartsWith(line, "+EEMLTESVC:")) // LTE Server Cell
        {

        }
        else if(strStartsWith(line, "+EEMLTEINTER:")) // LTE
        {

        }
        else if(strStartsWith(line, "+EEMLTEINTRA:")) // LTE
        {

        }
        else if(strStartsWith(line, "+EEMLTEINTERRAT:")) // LTE
        {

        }
        else if(strStartsWith(line, "+EEMGINFO:")) // <state>: 0: ME in Idle mode 1: ME in Dedicated mode 2: ME in PS PTM mode 3: invalid state
                                                   // <nw_type>: 0: GSM 1: UMTS 2: LTE
        {

        }
        // WCDMA
        else if(strStartsWith(line, "+EEMUMTSSVC:")) // WCDMA Server Cell
        {

        }
        else if(strStartsWith(line, "+EEMUMTSINTRA:")) // WCDMA
        {

        }
        else if(strStartsWith(line, "+EEMUMTSINTERRAT:")) // WCDMA
        {

        }
        // GSM
        else if(strStartsWith(line, "+EEMGINFOBASIC:")) // Basic information in GSM
        // 0: ME in Idle mode   1: ME in Dedicated mode   2: ME in PS PTM mode
        {

        }
        else if(strStartsWith(line, "+EEMGINFOSVC:")) // GSM Server Cell
        {

        }
        else if(strStartsWith(line, "+EEMGINFOPS:")) // PS
        {

        }


        lines_ptr = lines_ptr->p_next;
    }
#endif

exit:
    at_response_free(response);
    return buff_size;
}

static int req_cell_info_set(const char *cmgl, char *reg, int len, int *cme_err)
{
    printf("req_cmgl_set(2)-----------------start\n");
    printf("cmgl:%s\n", cmgl);
    ATResponse *response = NULL;
    char cmd[30] = {0};
	char data[218] = {0};
    int err = 0;

	memcpy(data, cmgl, len);

	sprintf(cmd, "at*cell=%s", data);
	printf("cmd:%s\n", cmd);

	if(strlen(cmd) > 0)
	{
        err = at_send_command_multiline(cmd, "", &response);
		if (err < 0 || response->success == 0 || !response->p_intermediates){
			*cme_err = at_get_cme_error(response);
        //    printf("at_send_command_multiline() is err-----------------\n");
			goto exit;
		}

        ATLine* lines_ptr = response->p_intermediates;
        char *line = NULL;
        int reg_len = 0;
		bool flag = false;
        while(lines_ptr)
        {
            line = lines_ptr->line;
            if(line ==NULL)
            {
                printf("line is null----------------------\n");
            }
            printf("-----line:%s\n", line);

            lines_ptr = lines_ptr->p_next;
        }
	}
    err = 0;
	memcpy(reg, "req_cell_info_set succss", strlen("req_cell_info_set succss"));
exit:
    at_response_free(response);
    printf("req_cell_info_set()-----------------end\n");
    return err;
}



/*
AT+CSQ
+CSQ: 31,99

OK

AT+CESQ
+CESQ: 60,99,255,255,20,61

OK

AT+COPS?
+COPS: 0,2,"46001",7

OK

*/
static int req_net_signal_get(mbtk_signal_info_t *signal, int *cme_err)
{
    ATResponse *response = NULL;
    int tmp_int;
    char *tmp_ptr = NULL;
    // AT+EEMOPT=1 in the first.
    int err = at_send_command_singleline("AT+CSQ", "+CSQ:", &response);
    if (err < 0 || response->success == 0 || !response->p_intermediates){
        if(cme_err != NULL)
            *cme_err = at_get_cme_error(response);
        err = -1;
        goto exit;
    }

    char *line = response->p_intermediates->line;
    err = at_tok_start(&line);
    if (err < 0)
    {
        goto exit;
    }
    err = at_tok_nextint(&line, &tmp_int);
    if (err < 0)
    {
        goto exit;
    }
    signal->rssi = (uint8)tmp_int;
    at_response_free(response);

    err = at_send_command_singleline("AT+CESQ", "+CESQ:", &response);
    if (err < 0 || response->success == 0 || !response->p_intermediates){
        if(cme_err != NULL)
            *cme_err = at_get_cme_error(response);
        err = -1;
        goto exit;
    }

    line = response->p_intermediates->line;
    err = at_tok_start(&line);
    if (err < 0)
    {
        goto exit;
    }
    err = at_tok_nextint(&line, &tmp_int);
    if (err < 0)
    {
        goto exit;
    }
    signal->rxlev = (uint8)tmp_int;

    err = at_tok_nextint(&line, &tmp_int);
    if (err < 0)
    {
        goto exit;
    }
    signal->ber = (uint8)tmp_int;

    err = at_tok_nextint(&line, &tmp_int);
    if (err < 0)
    {
        goto exit;
    }
    signal->rscp = (uint8)tmp_int;

    err = at_tok_nextint(&line, &tmp_int);
    if (err < 0)
    {
        goto exit;
    }
    signal->ecno = (uint8)tmp_int;

    err = at_tok_nextint(&line, &tmp_int);
    if (err < 0)
    {
        goto exit;
    }
    signal->rsrq = (uint8)tmp_int;

    err = at_tok_nextint(&line, &tmp_int);
    if (err < 0)
    {
        goto exit;
    }
    signal->rsrp = (uint8)tmp_int;

    at_response_free(response);
    err = at_send_command_singleline("AT+COPS?", "+COPS:", &response);
    if (err < 0 || response->success == 0 || !response->p_intermediates){
        if(cme_err != NULL)
            *cme_err = at_get_cme_error(response);
        err = -1;
        goto exit;
    }
    line = response->p_intermediates->line;
    err = at_tok_start(&line);
    if (err < 0)
    {
        goto exit;
    }
    err = at_tok_nextint(&line, &tmp_int);
    if (err < 0)
    {
        goto exit;
    }
    if(!at_tok_hasmore(&line)) {
        goto exit;
    }
    err = at_tok_nextint(&line, &tmp_int);
    if (err < 0)
    {
        goto exit;
    }
    err = at_tok_nextstr(&line, &tmp_ptr);
    if (err < 0)
    {
        goto exit;
    }
    err = at_tok_nextint(&line, &tmp_int);
    if (err < 0)
    {
        goto exit;
    }
    signal->type = (uint8)tmp_int;
    net_info.net_type = signal->type;

exit:
    at_response_free(response);
    return err;
}

/*
AT+CREG=3
OK

AT+CREG?
+CREG: 3,1,"8330","06447340",7

OK

AT+CREG?
+CREG: 3,0

OK

AT+CEREG?
+CEREG: 3,1,"8330","06447340",7

OK


AT+CIREG?
+CIREG: 2,1,15

OK

AT+CIREG?
+CIREG: 0

OK


*/
static int req_net_reg_get(mbtk_net_reg_info_t *reg, int *cme_err)
{
    ATResponse *response = NULL;
    int tmp_int;
    char *tmp_str = NULL;
    int err = at_send_command("AT+CREG=3", &response);
    if (err < 0 || response->success == 0){
        *cme_err = at_get_cme_error(response);
        goto exit;
    }
    at_response_free(response);

    err = at_send_command_multiline("AT+CREG?", "+CREG:", &response);
    if (err < 0 || response->success == 0 || !response->p_intermediates){
        *cme_err = at_get_cme_error(response);
        goto exit;
    }

    char *line = response->p_intermediates->line;
    err = at_tok_start(&line);
    if (err < 0)
    {
        goto exit;
    }
    err = at_tok_nextint(&line, &tmp_int); // n
    if (err < 0)
    {
        goto exit;
    }
    err = at_tok_nextint(&line, &tmp_int);// stat
    if (err < 0)
    {
        goto exit;
    }
    reg->call_state = (uint8)tmp_int;

    if(at_tok_hasmore(&line)) {
        err = at_tok_nextstr(&line, &tmp_str); // lac
        if (err < 0)
        {
            goto exit;
        }
        reg->lac = strtol(tmp_str, NULL, 16);

        err = at_tok_nextstr(&line, &tmp_str); // ci
        if (err < 0)
        {
            goto exit;
        }
        reg->ci = strtol(tmp_str, NULL, 16);

        err = at_tok_nextint(&line, &tmp_int);// AcT
        if (err < 0)
        {
            goto exit;
        }
        reg->type = (uint8)tmp_int;
    }
    at_response_free(response);

    err = at_send_command_multiline("AT+CEREG?", "+CEREG:", &response);
    if (err < 0 || response->success == 0 || !response->p_intermediates){
        *cme_err = at_get_cme_error(response);
        goto exit;
    }

    line = response->p_intermediates->line;
    err = at_tok_start(&line);
    if (err < 0)
    {
        goto exit;
    }
    err = at_tok_nextint(&line, &tmp_int); // n
    if (err < 0)
    {
        goto exit;
    }
    err = at_tok_nextint(&line, &tmp_int);// stat
    if (err < 0)
    {
        goto exit;
    }
    reg->data_state = (uint8)tmp_int;

    if(reg->lac == 0 && at_tok_hasmore(&line)) {
        err = at_tok_nextstr(&line, &tmp_str); // lac
        if (err < 0)
        {
            goto exit;
        }
        reg->lac = strtol(tmp_str, NULL, 16);

        err = at_tok_nextstr(&line, &tmp_str); // ci
        if (err < 0)
        {
            goto exit;
        }
        reg->ci = strtol(tmp_str, NULL, 16);

        err = at_tok_nextint(&line, &tmp_int);// AcT
        if (err < 0)
        {
            goto exit;
        }
        reg->type = (uint8)tmp_int;
    }
    at_response_free(response);

    err = at_send_command_multiline("AT+CIREG?", "+CIREG:", &response);
    if (err < 0 || response->success == 0 || !response->p_intermediates){
        reg->ims_state = (uint8)0;
        err = 0;
        goto exit;
    }
    line = response->p_intermediates->line;
    err = at_tok_start(&line);
    if (err < 0)
    {
        goto exit;
    }
    err = at_tok_nextint(&line, &tmp_int); // n/stat
    if (err < 0)
    {
        goto exit;
    }
    if(at_tok_hasmore(&line)) {
        err = at_tok_nextint(&line, &tmp_int);// stat
        if (err < 0)
        {
            goto exit;
        }
        reg->ims_state = (uint8)tmp_int;
    } else {
        reg->ims_state = (uint8)tmp_int;
    }

exit:
    at_response_free(response);
    return err;
}


static int net_ims_set(uint8 reg, int *cme_err)
{
    ATResponse *response = NULL;
    char cmd[30] = {0};
    int err = -1;

    sprintf(cmd, "AT+ACONFIG=\"IMSD=%d\"", reg);
    err = at_send_command(cmd, &response);
    LOG("cmd : %s", cmd);

    if (err < 0 || response->success == 0){
        *cme_err = at_get_cme_error(response);
        goto exit;
    }

exit:
    at_response_free(response);
    return err;
}


static int net_ims_get(int *reg, int *cme_err)
{
    ATResponse *response = NULL;
    int tmp_int, tmp_reg = 0;
    int err;
    char *tmp_str = NULL;

    err = at_send_command_singleline("AT+ACONFIG?", "", &response);
    if (err < 0 || response->success == 0 || !response->p_intermediates){
        tmp_reg = 0;
        err = 0;
        goto exit;
    }
    if(response->p_intermediates->line) {
        char *ptr = strstr(response->p_intermediates->line, "IMSD=");
        if(ptr) {
            tmp_reg = atoi(ptr + strlen("IMSD="));
        }
    }

    LOG("net_ims_get reg : %u", tmp_reg);

exit:
    at_response_free(response);
    *reg = tmp_reg;
    return err;
}

static int net_ims_reg_state_get(int *reg, int *cme_err)
{
    ATResponse *response = NULL;
    int tmp_int, tmp_reg = -1;
    int err;
    char *tmp_str = NULL;

    err = at_send_command_multiline("AT+CIREG?", "+CIREG:", &response);
    if (err < 0 || response->success == 0 || !response->p_intermediates){
        tmp_reg = 0;
        err = 0;
        goto exit;
    }
    char *line = response->p_intermediates->line;
    err = at_tok_start(&line);
    if (err < 0)
    {
        goto exit;
    }
    err = at_tok_nextint(&line, &tmp_int); // n/stat
    if (err < 0)
    {
        goto exit;
    }

    if(at_tok_hasmore(&line)) {
        err = at_tok_nextint(&line, &tmp_int);// stat
        if (err < 0)
        {
            goto exit;
        }
        tmp_reg = tmp_int;
    } else {
        tmp_reg = tmp_int;
    }

    LOG("net_ims_get reg : %u", tmp_reg);

exit:
    at_response_free(response);
    *reg = tmp_reg;
    return err;
}



/*
AT+CGDCONT?
+CGDCONT: 1,"IPV4V6","cmnet.MNC000.MCC460.GPRS","10.131.67.146 254.128.0.0.0.0.0.0.0.1.0.2.200.2.158.0",0,0,,,,

+CGDCONT: 8,"IPV4V6","IMS","254.128.0.0.0.0.0.0.0.1.0.2.200.2.160.160",0,0,0,2,1,1

OK


*/
#ifdef MBTK_AF_SUPPORT
mbtk_ip_type_enum default_iptype = MBTK_IP_TYPE_IPV4V6;
#endif

static int req_apn_get(void *data, int *data_len, int *cme_err)
{
    ATResponse *response = NULL;
    int err = at_send_command_multiline("AT+CGDCONT?", "+CGDCONT:", &response);

    if (err < 0 || response->success == 0 || !response->p_intermediates){
        *cme_err = at_get_cme_error(response);
        goto exit;
    }

    ATLine* lines_ptr = response->p_intermediates;
    char *line = NULL;
    int tmp_int;
    char *tmp_str = NULL;
    /*
    <apn_num[1]><cid[1]><ip_type[1]><apn_len[2]><apn><user_len[2]><user><pass_len[2]><pass><auth_len[2]><auth>...
                <cid[1]><ip_type[1]><apn_len[2]><apn><user_len[2]><user><pass_len[2]><pass><auth_len[2]><auth>
    */
    uint8* apn_num = (uint8*)data;
    uint8* data_ptr = (uint8*)(data + sizeof(uint8)); // Jump apn_num[1]
    mbtk_apn_info_t apn;
    while(lines_ptr)
    {
        line = lines_ptr->line;
        err = at_tok_start(&line);
        if (err < 0)
        {
            goto exit;
        }

        err = at_tok_nextint(&line, &tmp_int); // cid
        if (err < 0)
        {
            goto exit;
        }
        // Only get CID 1-7
        if(tmp_int >= MBTK_APN_CID_MIN && tmp_int <= MBTK_APN_CID_MAX) {
            memset(&apn, 0x0, sizeof(mbtk_apn_info_t));
            apn.cid = tmp_int;
            *data_ptr++ = (uint8)tmp_int; // cid

            err = at_tok_nextstr(&line, &tmp_str);// ip type
            if (err < 0)
            {
                goto exit;
            }
            if(!strcasecmp(tmp_str, "IP")) {
                *data_ptr++ = (uint8)MBTK_IP_TYPE_IP;
                apn.ip_type = MBTK_IP_TYPE_IP;
            } else if(!strcasecmp(tmp_str, "IPV6")) {
                *data_ptr++ = (uint8)MBTK_IP_TYPE_IPV6;
                apn.ip_type = MBTK_IP_TYPE_IPV6;
            } else if(!strcasecmp(tmp_str, "IPV4V6")) {
                *data_ptr++ = (uint8)MBTK_IP_TYPE_IPV4V6;
                apn.ip_type = MBTK_IP_TYPE_IPV4V6;
            } else {
                *data_ptr++ = (uint8)MBTK_IP_TYPE_PPP;
                apn.ip_type = MBTK_IP_TYPE_PPP;
            }

#ifdef MBTK_AF_SUPPORT
            if(apn.cid == 1)
            {
                default_iptype = apn.ip_type;
            }
#endif
            err = at_tok_nextstr(&line, &tmp_str); // apn
            if (err < 0)
            {
                goto exit;
            }
            if(str_empty(tmp_str)) {
                uint16_2_byte((uint16)0, data_ptr, false);
                data_ptr += sizeof(uint16);
            } else {
                uint16_2_byte((uint16)strlen(tmp_str), data_ptr, false);
                data_ptr += sizeof(uint16);
                memcpy(data_ptr, tmp_str, strlen(tmp_str));
                data_ptr += strlen(tmp_str);
                memcpy(apn.apn, tmp_str, strlen(tmp_str));
            }

            if(apn_user_pass_set_by_cid(apn.cid, &apn)) {
                // user
                uint16_2_byte((uint16)0, data_ptr, false);
                data_ptr += sizeof(uint16);

                // pass
                uint16_2_byte((uint16)0, data_ptr, false);
                data_ptr += sizeof(uint16);

                // auth
                uint16_2_byte((uint16)0, data_ptr, false);
                data_ptr += sizeof(uint16);
            } else {
                // user
                if(str_empty(apn.user)) {
                    uint16_2_byte((uint16)0, data_ptr, false);
                    data_ptr += sizeof(uint16);
                } else {
                    uint16_2_byte((uint16)strlen(apn.user), data_ptr, false);
                    data_ptr += sizeof(uint16);
                    memcpy(data_ptr, apn.user, strlen(apn.user));
                    data_ptr += strlen(apn.user);
                }

                // pass
                if(str_empty(apn.pass)) {
                    uint16_2_byte((uint16)0, data_ptr, false);
                    data_ptr += sizeof(uint16);
                } else {
                    uint16_2_byte((uint16)strlen(apn.pass), data_ptr, false);
                    data_ptr += sizeof(uint16);
                    memcpy(data_ptr, apn.pass, strlen(apn.pass));
                    data_ptr += strlen(apn.pass);
                }

                // auth
                if(str_empty(apn.auth)) {
                    uint16_2_byte((uint16)0, data_ptr, false);
                    data_ptr += sizeof(uint16);
                } else {
                    uint16_2_byte((uint16)strlen(apn.auth), data_ptr, false);
                    data_ptr += sizeof(uint16);
                    memcpy(data_ptr, apn.auth, strlen(apn.auth));
                    data_ptr += strlen(apn.auth);
                }
            }

            (*apn_num)++;
        }

        lines_ptr = lines_ptr->p_next;
    }

    *data_len = data_ptr - (uint8*)data;

    goto exit;
exit:
    at_response_free(response);
    return err;
}

#if 0
/*
LTE APN
AT+CFUN=4
AT*CGDFLT=1,IP,"private.vpdn",1,0,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1
AT*CGDFAUTH=1,2,"noc@njcc.vpdn.js","123456"
AT+CFUN=1
AT+CEREG?
AT+CGDCONT?

2/3G APN
AT+CGREG?
AT+CGDCONT=6,IP,"private.vpdn"
AT*AUTHREQ=6,2,"noc@njcc.vpdn.js","123456"
AT+CGDATA="",6
AT+CGDCONT?
*/
static int req_apn_set_username(mbtk_apn_info_t *apn, int *cme_err)
{
    ATResponse *response = NULL;
    char cmd[400] = {0};
    int index = 0;
    int err = 0;

    err = at_send_command_singleline("AT+COPS?", "+COPS:", &response);
    if (err < 0 || response->success == 0 || !response->p_intermediates){
        if(cme_err != NULL)
            *cme_err = at_get_cme_error(response);
        err = -1;
        goto apn_set;
    }

    int tmp_int = 0;
    int state=0;
    char cmd_buf[64];
    char *line = response->p_intermediates->line;
    err = at_tok_start(&line);
    if (err < 0)
    {
        goto apn_set;
    }
    err = at_tok_nextint(&line, &tmp_int);
    if (err < 0)
    {
        goto apn_set;
    }
    err = at_tok_nextint(&line, &tmp_int);
    if (err < 0)
    {
        goto apn_set;
    }
    err = at_tok_nextstr(&line, &cmd_buf);
    if (err < 0)
    {
        goto apn_set;
    }
    err = at_tok_nextint(&line, &tmp_int);
    if (err < 0)
    {
        goto apn_set;
    }
    else
        state = tmp_int;

apn_set:
    at_response_free(response);
    *cme_err = MBTK_INFO_ERR_CME_NON;
    //if(state == 7 && apn->cid == 1)    //LTE && cid = 1
    if(0)    //LTE && cid = 1
    {
        err = at_send_command("AT+CFUN=4", &response);
        if (err < 0 || response->success == 0){
            *cme_err = at_get_cme_error(response);
            goto exit;
        }
        at_response_free(response);

        memset(cmd, 0, 400);
        index = 0;
        index += sprintf(cmd, "AT*CGDFLT=%d,", 1);
        switch(apn->ip_type) {
            case MBTK_IP_TYPE_IP: {
                index += sprintf(cmd + index,"\"IP\",");
                break;
            }
            case MBTK_IP_TYPE_IPV6: {
                index += sprintf(cmd + index,"\"IPV6\",");
                break;
            }
            case MBTK_IP_TYPE_IPV4V6: {
                index += sprintf(cmd + index,"\"IPV4V6\",");
                break;
            }
            default: {
                index += sprintf(cmd + index,"\"PPP\",");
                break;
            }
        }

        index += sprintf(cmd + index,"\"%s\",1,0,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1",apn->apn);
        err = at_send_command(cmd, &response);
        if (err < 0 || response->success == 0){
            *cme_err = at_get_cme_error(response);
            goto exit;
        }
        at_response_free(response);

        memset(cmd, 0, 400);
        int cmd_auth=0;
        if(strstr(apn->auth,"NONE"))
            cmd_auth = 0;
        else if(strstr(apn->auth,"PAP"))
            cmd_auth = 1;
        else if(strstr(apn->auth,"CHAP"))
            cmd_auth = 2;
        else if(strstr(apn->auth,"PAP AND CHAP"))
            cmd_auth = 3;
        else
            goto exit;

        sprintf(cmd,"AT*CGDFAUTH=1,%d,%s,%s",cmd_auth,apn->user,apn->pass);

        err = at_send_command(cmd, &response);
        if (err < 0 || response->success == 0){
            *cme_err = at_get_cme_error(response);
            goto exit;
        }
    }
    else                //2/3G
    {
        memset(cmd,0,400);
        index = 0;
        index += sprintf(cmd, "AT+CGDCONT=%d,", apn->cid);
        switch(apn->ip_type) {
            case MBTK_IP_TYPE_IP: {
                index += sprintf(cmd + index,"\"IP\",");
                break;
            }
            case MBTK_IP_TYPE_IPV6: {
                index += sprintf(cmd + index,"\"IPV6\",");
                break;
            }
            case MBTK_IP_TYPE_IPV4V6: {
                index += sprintf(cmd + index,"\"IPV4V6\",");
                break;
            }
            default: {
                index += sprintf(cmd + index,"\"PPP\",");
                break;
            }
        }
        index += sprintf(cmd + index, "\"%s\"", apn->apn);

        err = at_send_command(cmd, &response);
        if (err < 0 || response->success == 0){
            *cme_err = at_get_cme_error(response);
            goto exit;
        }
        at_response_free(response);

        memset(cmd,0,400);
        int cmd_auth=0;
        if(strstr(apn->auth,"NONE"))
            cmd_auth = 0;
        else if(strstr(apn->auth,"PAP"))
            cmd_auth = 1;
        else if(strstr(apn->auth,"CHAP"))
            cmd_auth = 2;
        else if(strstr(apn->auth,"PAP AND CHAP"))
            cmd_auth = 3;
        else
            goto exit;

        sprintf(cmd, "AT*AUTHREQ=%d,%d,%s,%s",apn->cid,cmd_auth,apn->user,apn->pass);
        err = at_send_command(cmd, &response);
        if (err < 0 || response->success == 0){
            *cme_err = at_get_cme_error(response);
            goto exit;
        }
    }

exit:
    at_response_free(response);
    return err;
}
#endif

/*
AT+CGDCONT=1,"IPV4V6","cmnet"
OK

AT*CGDFLT=1,"IPv4v6","reliance.grevpdn.zj",,,,,,,,,,,,,,,,,,1
OK

*/
static int req_apn_set(mbtk_apn_info_t *apn, int *cme_err)
{
    ATResponse *response = NULL;
    char cmd[400] = {0};
    int index = 0;
    int err = 0;

    index += sprintf(cmd, "AT+CGDCONT=%d,", apn->cid);
    switch(apn->ip_type) {
        case MBTK_IP_TYPE_IP: {
            index += sprintf(cmd + index,"\"IP\",");
            break;
        }
        case MBTK_IP_TYPE_IPV6: {
            index += sprintf(cmd + index,"\"IPV6\",");
            break;
        }
        case MBTK_IP_TYPE_IPV4V6: {
            index += sprintf(cmd + index,"\"IPV4V6\",");
            break;
        }
        default: {
            index += sprintf(cmd + index,"\"PPP\",");
            break;
        }
    }
    if(strlen(apn->apn) > 0) {
        index += sprintf(cmd + index,"\"%s\"", apn->apn);
    }

    err = at_send_command(cmd, &response);
    if (err < 0 || response->success == 0){
        if(cme_err) {
            *cme_err = at_get_cme_error(response);
        }
        goto exit;
    }

    if(!str_empty(apn->user) || !str_empty(apn->pass)) {
        at_response_free(response);

        memset(cmd,0,400);
        int cmd_auth=0;
        if(strstr(apn->auth,"NONE"))
            cmd_auth = 0;
        else if(strstr(apn->auth,"PAP"))
            cmd_auth = 1;
        else if(strstr(apn->auth,"CHAP"))
            cmd_auth = 2;
#if 0
        else if(strstr(apn->auth,"PAP AND CHAP"))
            cmd_auth = 3;
#endif
        else
            goto exit;

        sprintf(cmd, "AT*AUTHREQ=%d,%d,%s,%s",apn->cid,cmd_auth,apn->user,apn->pass);
        err = at_send_command(cmd, &response);
        if (err < 0 || response->success == 0){
            *cme_err = at_get_cme_error(response);
            goto exit;
        }
    }

exit:
    at_response_free(response);
    return err;
}

static int req_apn_del(int data, int *cme_err)
{
    ATResponse *response = NULL;
    char cmd[64]={0};
    sprintf(cmd, "AT+CGDCONT=%d", data);
    int err = at_send_command(cmd, &response);
    if (err < 0 || response->success == 0){
        if(cme_err) {
            *cme_err = at_get_cme_error(response);
        }
        goto exit;
    }

exit:
    at_response_free(response);
    return err;
}


int wait_cgact_complete(int timeout)
{
    int count = timeout * 10; // timeout * 1000 / 100
    int i = 0;

    while(cgact_wait.waitting && i < count) {
        i++;
        usleep(100000); // 100ms
    }

    if(i == count) { // Timeout
        return -1;
    } else {
        return 0;
    }
}

/*
AT+CGDATA="",6
CONNECT

OK

AT+CFUN=1

OK

*/
static int req_data_call_user_start(int cid, int *cme_err)
{
    ATResponse *response = NULL;
    char cmd[400] = {0};
    int index = 0;
    int err = 0;

    err = at_send_command_singleline("AT+COPS?", "+COPS:", &response);
    if (err < 0 || response->success == 0 || !response->p_intermediates){
        if(cme_err != NULL)
            *cme_err = at_get_cme_error(response);
        err = -1;
        goto exit;
    }

    int tmp_int;
    char cmd_buf[64];
    char *line = response->p_intermediates->line;
    err = at_tok_start(&line);
    if (err < 0)
    {
        goto exit;
    }
    err = at_tok_nextint(&line, &tmp_int);
    if (err < 0)
    {
        goto exit;
    }
    err = at_tok_nextint(&line, &tmp_int);
    if (err < 0)
    {
        goto exit;
    }
    err = at_tok_nextstr(&line, &cmd_buf);
    if (err < 0)
    {
        goto exit;
    }
    err = at_tok_nextint(&line, &tmp_int);
    if (err < 0)
    {
        goto exit;
    }
    at_response_free(response);

    if(tmp_int == 7 && cid == 1)    //LTE && cid = 1
    {
        ATResponse *response = NULL;
        char cmd[400] = {0};
        int err = 0;

        err = at_send_command("AT+CFUN=1", &response);
        if (err < 0 || response->success == 0){
            if(cme_err) {
                *cme_err = at_get_cme_error(response);
            }
            goto exit;
        }
    }
    else
    {
        ATResponse *response = NULL;
        char cmd[400] = {0};
        int err = 0;
        sprintf(cmd, "AT+CGDATA=\"\",%d", cid);
        err = at_send_command(cmd, &response);
        if (err < 0 || response->success == 0){
            if(cme_err) {
                *cme_err = at_get_cme_error(response);
            }
            goto exit;
        }
    }

exit:
    at_response_free(response);
    return err;
}

/*
AT+CGACT?
+CGACT: 1,1
+CGACT: 8,1
OK

AT+CGACT=1,<cid>
OK

*/
static int req_data_call_start(int cid, int *cme_err)
{
    ATResponse *response = NULL;
    char cmd[400] = {0};
    int err = 0;
#if 0
    err = at_send_command_multiline("AT+CGACT?", "+CGACT:", &response);
    if (err < 0 || response->success == 0 || !response->p_intermediates){
        *cme_err = at_get_cme_error(response);
        goto exit;
    }
    ATLine* lines_ptr = response->p_intermediates;
    char *line = NULL;
    int tmp_int;
    while(lines_ptr)
    {
        line = lines_ptr->line;
        err = at_tok_start(&line);
        if (err < 0)
        {
            goto exit;
        }

        err = at_tok_nextint(&line, &tmp_int); // cid
        if (err < 0)
        {
            goto exit;
        }
        if(tmp_int == cid) { // Found cid
            err = at_tok_nextint(&line, &tmp_int); // cid
            if (err < 0)
            {
                goto exit;
            }
            if(tmp_int == 1) { // This cid has active.
                goto net_config;
            } else {
                goto cid_active;
            }
            break;
        }

        lines_ptr = lines_ptr->p_next;
    }

    if(lines_ptr == NULL) { // No found this cid.
        LOGE("No found cid : %d", cid);
        goto exit;
    }
    at_response_free(response);

    // Start active cid.
cid_active:
#endif

    sprintf(cmd, "AT+CGACT=1,%d", cid);
    err = at_send_command(cmd, &response);
    if (err < 0 || response->success == 0){
        if(cme_err) {
            *cme_err = at_get_cme_error(response);
        }
        goto exit;
    }

exit:
    at_response_free(response);
    return err;
}

/*
AT+CGACT=0,<cid>
OK

*/
static int req_data_call_stop(int cid, int *cme_err)
{
    ATResponse *response = NULL;
    char cmd[400] = {0};
    int err = 0;
#if 0
    err = at_send_command_multiline("AT+CGACT?", "+CGACT:", &response);
    if (err < 0 || response->success == 0 || !response->p_intermediates){
        *cme_err = at_get_cme_error(response);
        goto exit;
    }
    ATLine* lines_ptr = response->p_intermediates;
    char *line = NULL;
    int tmp_int;
    while(lines_ptr)
    {
        line = lines_ptr->line;
        err = at_tok_start(&line);
        if (err < 0)
        {
            goto exit;
        }

        err = at_tok_nextint(&line, &tmp_int); // cid
        if (err < 0)
        {
            goto exit;
        }
        if(tmp_int == cid) { // Found cid
            err = at_tok_nextint(&line, &tmp_int); // cid
            if (err < 0)
            {
                goto exit;
            }
            if(tmp_int == 1) { // This cid has active.
                goto net_config;
            } else {
                goto cid_active;
            }
            break;
        }

        lines_ptr = lines_ptr->p_next;
    }

    if(lines_ptr == NULL) { // No found this cid.
        LOGE("No found cid : %d", cid);
        goto exit;
    }
    at_response_free(response);

    // Start active cid.
cid_active:
#endif

    sprintf(cmd, "AT+CGACT=0,%d", cid);
    err = at_send_command(cmd, &response);
    if (err < 0 || response->success == 0){
        *cme_err = at_get_cme_error(response);
        goto exit;
    }

exit:
    at_response_free(response);
    return err;
}

/*
IPv4 : 10.255.74.26
IPv6 : 254.128.0.0.0.0.0.0.0.1.0.2.144.5.212.239
*/
static bool is_ipv4(const char *ip)
{
    const char *ptr = ip;
    int count = 0;
    while(*ptr) {
        if(*ptr == '.')
            count++;
        ptr++;
    }

    if(count == 3) {
        return true;
    } else {
        return false;
    }
}

/*
AT+CGCONTRDP=1
+CGCONTRDP: 1,7,"cmnet-2.MNC000.MCC460.GPRS","10.255.74.26","","223.87.253.100","223.87.253.253","","",0,0
+CGCONTRDP: 1,7,"cmnet-2.MNC000.MCC460.GPRS","254.128.0.0.0.0.0.0.0.1.0.2.144.5.212.239","","36.9.128.98.32.0.0.2.0.0.0.0.0.0.0.1","36.9.128.98.32.0.0.2.0.0.0.0.0.0.0.2","","",0,0

OK

*/
static int req_data_call_state_get(int cid, mbtk_ipv4_info_t *ipv4, mbtk_ipv6_info_t *ipv6, int *cme_err)
{
    ATResponse *response = NULL;
    char cmd[50] = {0};
    int err = 0;

    sprintf(cmd, "AT+CGCONTRDP=%d", cid);

    err = at_send_command_multiline(cmd, "+CGCONTRDP:", &response);
    if (err < 0 || response->success == 0 || !response->p_intermediates){
        *cme_err = at_get_cme_error(response);
        goto exit;
    }
    ATLine* lines_ptr = response->p_intermediates;
    char *line = NULL;
    int tmp_int;
    char *tmp_ptr = NULL;
    while(lines_ptr)
    {
        line = lines_ptr->line;
        err = at_tok_start(&line);
        if (err < 0)
        {
            goto exit;
        }

        err = at_tok_nextint(&line, &tmp_int); // cid
        if (err < 0)
        {
            goto exit;
        }
        err = at_tok_nextint(&line, &tmp_int); // bearer_id
        if (err < 0)
        {
            goto exit;
        }
        err = at_tok_nextstr(&line, &tmp_ptr); // APN
        if (err < 0)
        {
            goto exit;
        }

        err = at_tok_nextstr(&line, &tmp_ptr); // IP
        if (err < 0 || str_empty(tmp_ptr))
        {
            goto exit;
        }
        if(is_ipv4(tmp_ptr)) {
            if(inet_pton(AF_INET, tmp_ptr, &(ipv4->IPAddr)) < 0) {
                LOGE("inet_pton() fail.");
                err = -1;
                goto exit;
            }

            ipv4->valid = true;
            //log_hex("IPv4", &(ipv4->IPAddr), sizeof(struct in_addr));
        } else {
            if(str_2_ipv6(tmp_ptr, &(ipv6->IPV6Addr))) {
                LOGE("str_2_ipv6() fail.");
                err = -1;
                goto exit;
            }

            ipv6->valid = true;
            //log_hex("IPv6", &(ipv6->IPV6Addr), 16);
        }

        err = at_tok_nextstr(&line, &tmp_ptr); // Gateway
        if (err < 0)
        {
            goto exit;
        }
        if(!str_empty(tmp_ptr)) { // No found gateway
            if(is_ipv4(tmp_ptr)) {
                if(inet_pton(AF_INET, tmp_ptr, &(ipv4->GateWay)) < 0) {
                    LOGE("inet_pton() fail.");
                    err = -1;
                    goto exit;
                }

                //log_hex("IPv4", &(ipv4->GateWay), sizeof(struct in_addr));
            } else {
                if(str_2_ipv6(tmp_ptr, &(ipv6->GateWay))) {
                    LOGE("str_2_ipv6() fail.");
                    err = -1;
                    goto exit;
                }

                //log_hex("IPv6", &(ipv6->GateWay), 16);
            }
        }

        err = at_tok_nextstr(&line, &tmp_ptr); // prim_DNS
        if (err < 0)
        {
            goto exit;
        }
        if(!str_empty(tmp_ptr)) { // No found Primary DNS
            if(is_ipv4(tmp_ptr)) {
                if(inet_pton(AF_INET, tmp_ptr, &(ipv4->PrimaryDNS)) < 0) {
                    LOGE("inet_pton() fail.");
                    err = -1;
                    goto exit;
                }

                //log_hex("IPv4", &(ipv4->PrimaryDNS), sizeof(struct in_addr));
            } else {
                if(str_2_ipv6(tmp_ptr, &(ipv6->PrimaryDNS))) {
                    LOGE("str_2_ipv6() fail.");
                    err = -1;
                    goto exit;
                }

                //log_hex("IPv6", &(ipv6->PrimaryDNS), 16);
            }
        }

        err = at_tok_nextstr(&line, &tmp_ptr); // sec_DNS
        if (err < 0)
        {
            goto exit;
        }
        if(!str_empty(tmp_ptr)) { // No found Secondary DNS
            if(is_ipv4(tmp_ptr)) {
                if(inet_pton(AF_INET, tmp_ptr, &(ipv4->SecondaryDNS)) < 0) {
                    LOGE("inet_pton() fail.");
                    err = -1;
                    goto exit;
                }

                //log_hex("IPv4", &(ipv4->SecondaryDNS), sizeof(struct in_addr));
            } else {
                if(str_2_ipv6(tmp_ptr, &(ipv6->SecondaryDNS))) {
                    LOGE("str_2_ipv6() fail.");
                    err = -1;
                    goto exit;
                }

                //log_hex("IPv6", &(ipv6->SecondaryDNS), 16);
            }
        }

        lines_ptr = lines_ptr->p_next;
    }

exit:
    at_response_free(response);
    return err;
}

/*
AT+CGCONTRDP
+CGCONTRDP: 1,5,"cmnet.MNC000.MCC460.GPRS","10.156.238.86","","223.87.253.100","223.87.253.253","","",0,0
+CGCONTRDP: 1,5,"cmnet.MNC000.MCC460.GPRS","254.128.0.0.0.0.0.0.0.1.0.1.181.5.77.221","","36.9.128.98.32.0.0.2.0.0.0.0.0.0.0.1","36.9.128.98.32.0.0.2.0,0,0
+CGCONTRDP: 8,6,"IMS.MNC000.MCC460.GPRS","254.128.0.0.0.0.0.0.0.1.0.1.181.5.79.116","","","","36.9.128.98.80.2.0.87.0.0.0.0.0.3.31.1","36.9.128.98.80.2,1,0
OK

*/
static int apn_state_get(list_node_t **apn_list)
{
    ATResponse *response = NULL;
    int err = 0;
    *apn_list = list_create(NULL);
    if(*apn_list == NULL)
    {
        LOG("list_create() fail.");
        return -1;
    }

    err = at_send_command_multiline("AT+CGCONTRDP", "+CGCONTRDP:", &response);
    if (err < 0 || response->success == 0 || !response->p_intermediates){
        goto exit;
    }
    ATLine* lines_ptr = response->p_intermediates;
    char *line = NULL;
    int tmp_int;
    char *tmp_ptr = NULL;
    int cid_current = 0;
    info_apn_ip_t *apn = NULL;
    while(lines_ptr)
    {
        line = lines_ptr->line;
        err = at_tok_start(&line);
        if (err < 0)
        {
            goto exit;
        }

        err = at_tok_nextint(&line, &tmp_int); // cid
        if (err < 0)
        {
            goto exit;
        }

        if(tmp_int != 1 && tmp_int != 8) { // Not process cid 1 and 8.
            if(cid_current != tmp_int) { // New cid.
                apn = (info_apn_ip_t*)malloc(sizeof(info_apn_ip_t));
                if(apn == NULL) {
                    goto exit;
                }
                memset(apn, 0, sizeof(info_apn_ip_t));
                apn->cid = tmp_int;
                cid_current = tmp_int;

                list_add(*apn_list, apn);
            }
            err = at_tok_nextint(&line, &tmp_int); // bearer_id
            if (err < 0)
            {
                goto exit;
            }
            err = at_tok_nextstr(&line, &tmp_ptr); // APN
            if (err < 0)
            {
                goto exit;
            }

            err = at_tok_nextstr(&line, &tmp_ptr); // IP
            if (err < 0 || str_empty(tmp_ptr))
            {
                goto exit;
            }
            if(is_ipv4(tmp_ptr)) {
                apn->ipv4_valid = true;
                memcpy(apn->ipv4, tmp_ptr, strlen(tmp_ptr));
            } else {
                apn->ipv6_valid = true;
                uint8 tmp_ipv6[16];
                if(str_2_ipv6(tmp_ptr, tmp_ipv6)) {
                    LOGE("str_2_ipv6() fail.");
                    err = -1;
                    goto exit;
                }

                if(inet_ntop(AF_INET6, tmp_ipv6, apn->ipv6, 50) == NULL) {
                    err = -1;
                    LOGE("inet_ntop ipv6 ip fail.");
                    goto exit;
                }
            }
        }

        lines_ptr = lines_ptr->p_next;
    }

exit:
    at_response_free(response);
    return err;
}

mbtk_info_err_enum call_pack_req_process(sock_client_info_t* cli_info, mbtk_info_pack_t* pack);
mbtk_info_err_enum sms_pack_req_process(sock_client_info_t* cli_info, mbtk_info_pack_t* pack);
mbtk_info_err_enum pb_pack_req_process(sock_client_info_t* cli_info, mbtk_info_pack_t* pack);

//mbtk wyq for data_call_ex add start
void data_call_bootconn_save(int cid, int bootconn);
//mbtk wyq for data_call_ex add end

//void net_list_free(void *data);
// Return MBTK_INFO_ERR_SUCCESS,will call pack_error_send() to send RSP.
// Otherwise, do not call pack_error_send().
static mbtk_info_err_enum pack_req_process(sock_client_info_t* cli_info, mbtk_info_pack_t* pack)
{
    if(pack->info_id > MBTK_INFO_ID_CALL_BEGIN && pack->info_id < MBTK_INFO_ID_CALL_END) {
        return call_pack_req_process(cli_info, pack);
    } else if(pack->info_id > MBTK_INFO_ID_SMS_BEGIN && pack->info_id < MBTK_INFO_ID_SMS_END) {
        return sms_pack_req_process(cli_info, pack);
    } else if(pack->info_id > MBTK_INFO_ID_PB_BEGIN && pack->info_id < MBTK_INFO_ID_PB_END) {
        return pb_pack_req_process(cli_info, pack);
    } else if(pack->info_id > RIL_MSG_ID_ECALL_BEGIN && pack->info_id < RIL_MSG_ID_ECALL_END) {
        return ecall_pack_req_process(cli_info, pack);
    } else {
        mbtk_info_err_enum err = MBTK_INFO_ERR_SUCCESS;
        int cme_err = MBTK_INFO_ERR_CME_NON;
        switch(pack->info_id)
        {
            case MBTK_INFO_ID_DEV_IMEI_REQ: // <string> IMEI
            {
                if(pack->data_len == 0 || pack->data == NULL)   // Get IMEI
                {
                    char imei[20] = {0};
                    if(req_imei_get(imei, &cme_err) || strlen(imei) == 0 || cme_err != MBTK_INFO_ERR_CME_NON)
                    {
                        if(cme_err != MBTK_INFO_ERR_CME_NON) {
                            err = MBTK_INFO_ERR_CME + cme_err;
                        } else {
                            err = MBTK_INFO_ERR_UNKNOWN;
                        }
                        LOG("Get IMEI fail.");
                    }
                    else
                    {
                        pack_rsp_send(cli_info->fd, MBTK_INFO_ID_DEV_IMEI_RSP, imei, strlen(imei));
                    }
                }
                else     // Set IMEI(Unsupport).
                {
                    err = MBTK_INFO_ERR_UNSUPPORTED;
                    LOG("Unsupport set IMEI.");
                }
                break;
            }
            case MBTK_INFO_ID_DEV_SN_REQ: // <string> SN
            {
                if(pack->data_len == 0 || pack->data == NULL)   // Get SN
                {
                    char sn[20] = {0};
                    if(req_sn_get(sn, &cme_err) || strlen(sn) == 0 || cme_err != MBTK_INFO_ERR_CME_NON)
                    {
                        if(cme_err != MBTK_INFO_ERR_CME_NON) {
                            err = MBTK_INFO_ERR_CME + cme_err;
                        } else {
                            err = MBTK_INFO_ERR_UNKNOWN;
                        }
                        LOG("Get SN fail.");
                    }
                    else
                    {
                        pack_rsp_send(cli_info->fd, MBTK_INFO_ID_DEV_SN_RSP, sn, strlen(sn));
                    }
                }
                else     // Set SN(Unsupport).
                {
                    err = MBTK_INFO_ERR_UNSUPPORTED;
                    LOG("Unsupport set SN.");
                }
                break;
            }
            case MBTK_INFO_ID_DEV_MEID_REQ: // <string> MEID (Only for CDMA)
            {
                if(pack->data_len == 0 || pack->data == NULL)   // Get MEID
                {
                    err = MBTK_INFO_ERR_UNSUPPORTED;
                    LOG("Support only for CDMA.");
                }
                else     // Set MEID(Unsupport).
                {
                    err = MBTK_INFO_ERR_UNSUPPORTED;
                    LOG("Unsupport set MEID.");
                }
                break;
            }
            case MBTK_INFO_ID_DEV_VERSION_REQ: // <string> VERSION
            {
                if(pack->data_len == 0 || pack->data == NULL)   // Get VERSION
                {
                    char version[50] = {0};
                    if(req_version_get(version, &cme_err) || strlen(version) == 0 || cme_err != MBTK_INFO_ERR_CME_NON)
                    {
                        if(cme_err != MBTK_INFO_ERR_CME_NON) {
                            err = MBTK_INFO_ERR_CME + cme_err;
                        } else {
                            err = MBTK_INFO_ERR_UNKNOWN;
                        }
                        LOG("Get Version fail.");
                    }
                    else
                    {
                        pack_rsp_send(cli_info->fd, MBTK_INFO_ID_DEV_VERSION_RSP, version, strlen(version));
                    }
                }
                else     // Set VERSION(Unsupport).
                {
                    err = MBTK_INFO_ERR_UNSUPPORTED;
                    LOG("Unsupport set VERSION.");
                }
                break;
            }
            case MBTK_INFO_ID_DEV_MD_VERSION_REQ:
            {
                if(pack->data_len == 0 || pack->data == NULL)   // Get VERSION
                {
                    char version[50] = {0};
                    if(req_md_version_get(version, &cme_err) || strlen(version) == 0 || cme_err != MBTK_INFO_ERR_CME_NON)
                    {
                        if(cme_err != MBTK_INFO_ERR_CME_NON) {
                            err = MBTK_INFO_ERR_CME + cme_err;
                        } else {
                            err = MBTK_INFO_ERR_UNKNOWN;
                        }
                        LOG("Get Version fail.");
                    }
                    else
                    {
                        pack_rsp_send(cli_info->fd, MBTK_INFO_ID_DEV_MD_VERSION_RSP, version, strlen(version));
                    }
                }
                else     // Set MD_VERSION(Unsupport).
                {
                    err = MBTK_INFO_ERR_UNSUPPORTED;
                    LOG("Unsupport set MD_VERSION.");
                }
                break;

            }
            case MBTK_INFO_ID_DEV_MODEL_REQ: //MODEL
            {
                if(pack->data_len == 0 || pack->data == NULL)   // Get MODEL
                {
                    char model[50] = {0};
                    if(req_model_get(model, &cme_err) || strlen(model) == 0 || cme_err != MBTK_INFO_ERR_CME_NON)
                    {
                        if(cme_err != MBTK_INFO_ERR_CME_NON) {
                            err = MBTK_INFO_ERR_CME + cme_err;
                        } else {
                            err = MBTK_INFO_ERR_UNKNOWN;
                        }
                        LOG("Get model fail.");
                    }
                    else
                    {
                        pack_rsp_send(cli_info->fd, MBTK_INFO_ID_DEV_VERSION_RSP, model, strlen(model));
                    }
                }
                else     // Set model(Unsupport).
                {
                    err = MBTK_INFO_ERR_UNSUPPORTED;
                    LOG("Unsupport set model.");
                }
                break;
            }
            case MBTK_INFO_ID_DEV_MODEM_REQ: //MODEM
            {
                if(pack->data_len == 0 || pack->data == NULL)   // Get MODEM
                {
                    int modem = -1;
                    if(req_modem_get(&modem, &cme_err) || modem < 0 || cme_err != MBTK_INFO_ERR_CME_NON)
                    {
                        if(cme_err != MBTK_INFO_ERR_CME_NON) {
                            err = MBTK_INFO_ERR_CME + cme_err;
                        } else {
                            err = MBTK_INFO_ERR_UNKNOWN;
                        }
                        LOG("Get modem fail.");
                    }
                    else
                    {
                        uint8 modem_type = (uint8)modem;
                        pack_rsp_send(cli_info->fd, MBTK_INFO_ID_DEV_MODEM_RSP, &modem_type, sizeof(uint8));
                    }
                }
                else     // Set modem
                {
                    mbtk_modem_info_t *modem = (mbtk_modem_info_t *)pack->data;
                    if(pack->data_len != sizeof(mbtk_modem_info_t))
                    {
                        err = MBTK_INFO_ERR_REQ_PARAMETER;
                        LOG("Set modem error.");
                        break;
                    }
                    if(req_modem_set(modem, &cme_err) || cme_err != MBTK_INFO_ERR_CME_NON)
                    {
                        LOG("Set modem fail.");
                        err = MBTK_INFO_ERR_FORMAT;
                    } else {
                        pack_rsp_send(cli_info->fd, MBTK_INFO_ID_DEV_MODEM_RSP, NULL, 0);
                    }
                }
                break;
            }
            case MBTK_INFO_ID_DEV_TIME_REQ: // <uint8><string>  YYYY-MM-DD-HH:MM:SS
            {
                if(pack->data_len == 0 || pack->data == NULL)   // Get Time
                {
                    int type = -1;
                    if(req_time_get(&type, &cme_err) || type < 0 || cme_err != MBTK_INFO_ERR_CME_NON)
                    {
                        if(cme_err != MBTK_INFO_ERR_CME_NON) {
                            err = MBTK_INFO_ERR_CME + cme_err;
                        } else {
                            err = MBTK_INFO_ERR_UNKNOWN;
                        }
                        LOG("Get Time fail.");
                    }
                    else
                    {
                        uint8 time_type = (uint8)type;
                        pack_rsp_send(cli_info->fd, MBTK_INFO_ID_DEV_TIME_RSP, &time_type, sizeof(uint8));
                    }
                }
                else     // Set Time
                {
                    if(pack->data_len == sizeof(uint8)) {
                        if(req_time_set(*(pack->data), NULL, &cme_err) || cme_err != MBTK_INFO_ERR_CME_NON)
                        {
                            LOG("Set Time fail.");
                            err = MBTK_INFO_ERR_FORMAT;
                        } else {
                            pack_rsp_send(cli_info->fd, MBTK_INFO_ID_DEV_TIME_RSP, NULL, 0);
                        }
                    } else {
                        char time_ptr[100] = {0};
                        memcpy(time_ptr, pack->data + sizeof(uint8), pack->data_len - sizeof(uint8));
                        if(req_time_set(*(pack->data), time_ptr, &cme_err) || cme_err != MBTK_INFO_ERR_CME_NON)
                        {
                            LOG("Set Time fail.");
                            err = MBTK_INFO_ERR_FORMAT;
                        } else {
                            pack_rsp_send(cli_info->fd, MBTK_INFO_ID_DEV_TIME_RSP, NULL, 0);
                        }
                    }
                }
                break;
            }
            case MBTK_INFO_ID_DEV_CELL_TIME_REQ: // <string>  YYYY-MM-DD-HH:MM:SS
            {
                if(pack->data_len == 0 || pack->data == NULL)   // Get Time
                {
                    char time[100];
                    if(req_net_time_get(time, &cme_err) || strlen(time) == 0 || cme_err != MBTK_INFO_ERR_CME_NON)
                    {
                        if(cme_err != MBTK_INFO_ERR_CME_NON) {
                            err = MBTK_INFO_ERR_CME + cme_err;
                        } else {
                            err = MBTK_INFO_ERR_UNKNOWN;
                        }
                        LOG("Get Time fail.");
                    }
                    else
                    {
                        char time_ser[100]={0};
                        memcpy(time_ser,time,strlen(time));
                        pack_rsp_send(cli_info->fd, MBTK_INFO_ID_DEV_CELL_TIME_RSP, time_ser, strlen(time_ser));
                    }
                }
                else     // Set Time
                {
                    err = MBTK_INFO_ERR_UNSUPPORTED;
                    LOG("Unsupport set TIME.");
                }
                break;
            }
            case MBTK_INFO_ID_DEV_VOLTE_REQ:  // <uint8> 0:Close 1:Open
            {
                if(pack->data_len == 0 || pack->data == NULL)   // Get VoLTE state.
                {
                    int state;
                    if(req_volte_get(&state, &cme_err) || cme_err != MBTK_INFO_ERR_CME_NON)
                    {
                        if(cme_err != MBTK_INFO_ERR_CME_NON) {
                            err = MBTK_INFO_ERR_CME + cme_err;
                        } else {
                            err = MBTK_INFO_ERR_UNKNOWN;
                        }
                        LOG("Get VoLTE state fail.");
                    }
                    else
                    {
                        pack_rsp_send(cli_info->fd, MBTK_INFO_ID_DEV_VOLTE_RSP, &state, sizeof(uint8));
                    }
                }
                else     // Set VoLTE state.
                {
                    uint8 on = *(pack->data);
                    if(pack->data_len != sizeof(uint8) || (on != 0 && on != 1))
                    {
                        err = MBTK_INFO_ERR_REQ_PARAMETER;
                        LOG("Set VOLTE parameter error.");
                        break;
                    }

                    if(req_volte_set(on, &cme_err) || cme_err != MBTK_INFO_ERR_CME_NON)
                    {
                        if(cme_err != MBTK_INFO_ERR_CME_NON) {
                            err = MBTK_INFO_ERR_CME + cme_err;
                        } else {
                            err = MBTK_INFO_ERR_UNKNOWN;
                        }
                        LOG("Set VoLTE state fail.");
                    }
                    else
                    {
                        pack_rsp_send(cli_info->fd, MBTK_INFO_ID_DEV_VOLTE_RSP, NULL, 0);

                        // Restart is required to take effect.
                        LOG("Will reboot system...");
                    }
                }
                break;
            }
            case MBTK_INFO_ID_DEV_TEMP_REQ:  // <string> Temperature
            {
                if(pack->data_len == sizeof(uint8) && pack->data) {
                    mbtk_thermal_info_t temp;
                    memset(&temp, 0, sizeof(mbtk_thermal_info_t));
                    if(req_temp_get(*(pack->data), &temp, &cme_err) || cme_err != MBTK_INFO_ERR_CME_NON)
                    {
                        if(cme_err != MBTK_INFO_ERR_CME_NON) {
                            err = MBTK_INFO_ERR_CME + cme_err;
                        } else {
                            err = MBTK_INFO_ERR_UNKNOWN;
                        }
                        LOG("Get temperature fail.");
                    }
                    else
                    {
                        pack_rsp_send(cli_info->fd, MBTK_INFO_ID_DEV_TEMP_RSP, &temp, sizeof(mbtk_thermal_info_t));
                    }
                } else {
                    err = MBTK_INFO_ERR_FORMAT;
                    LOG("Unsupport get Temperature.");
                }
                break;
            }
            case MBTK_INFO_ID_SIM_PLMN_REQ: // plmn
            {
                if(pack->data_len == 0 || pack->data == NULL)   //  plmn
                {
                    mbtk_plmn_info plmn;
                    if(req_plmn_get(&plmn, &cme_err) || cme_err != MBTK_INFO_ERR_CME_NON)
                    {
                        if(cme_err != MBTK_INFO_ERR_CME_NON) {
                            err = MBTK_INFO_ERR_CME + cme_err;
                        } else {
                            err = MBTK_INFO_ERR_UNKNOWN;
                        }
                        LOG("Get PLMN fail.");
                    }
                    else
                    {
                        pack_rsp_send(cli_info->fd, MBTK_INFO_ID_SIM_PLMN_RSP, &plmn, sizeof(mbtk_plmn_info));
                    }
                }
                else     // Set
                {
                    err = MBTK_INFO_ERR_UNSUPPORTED;
                    LOG("Set sim state fail.");
                }
                break;
            }
            case MBTK_INFO_ID_SIM_STATE_REQ: // mbtk_sim_state_enum
            {
                if(pack->data_len == 0 || pack->data == NULL)   // Get sim state.
                {
                    uint8 sim_state = (uint8)getSIMStatus();
                    pack_rsp_send(cli_info->fd, MBTK_INFO_ID_SIM_STATE_RSP, &sim_state, sizeof(uint8));
                }
                else     // Set
                {
                    err = MBTK_INFO_ERR_UNSUPPORTED;
                    LOG("Set sim state fail.");
                }
                break;
            }
            case MBTK_INFO_ID_SIM_STYPE_REQ: // mbtk_sim_card_type_enum
            {
                if(pack->data_len == 0 || pack->data == NULL)   // Get sim card type
                {
                    uint8 sim_card_type;
                    if(req_sim_card_type_get(&sim_card_type, &cme_err) || cme_err != MBTK_INFO_ERR_CME_NON)
                    {
                        if(cme_err != MBTK_INFO_ERR_CME_NON) {
                            err = MBTK_INFO_ERR_CME + cme_err;
                        } else {
                            err = MBTK_INFO_ERR_UNKNOWN;
                        }
                        LOG("Get IMSI fail.");
                    }
                    else
                    {
                        pack_rsp_send(cli_info->fd, MBTK_INFO_ID_SIM_STYPE_RSP, &sim_card_type, sizeof(uint8));
                    }
                }
                else     // Set
                {
                    err = MBTK_INFO_ERR_UNSUPPORTED;
                    LOG("Set sim state fail.");
                }
                break;
            }
            case MBTK_INFO_ID_SIM_PINPUK_TIMES_REQ: // mbtk_pin_puk_last_times
            {
                if(pack->data_len == 0 || pack->data == NULL)   // Get sim card type
                {
                    mbtk_pin_puk_last_times pin_puk_last_times;
                    if(req_pin_puk_last_times_get(&pin_puk_last_times, &cme_err) || cme_err != MBTK_INFO_ERR_CME_NON)
                    {
                        if(cme_err != MBTK_INFO_ERR_CME_NON) {
                            err = MBTK_INFO_ERR_CME + cme_err;
                        } else {
                            err = MBTK_INFO_ERR_UNKNOWN;
                        }
                        LOG("Get IMSI fail.");
                    }
                    else
                    {
                        pack_rsp_send(cli_info->fd, MBTK_INFO_ID_SIM_PINPUK_TIMES_RSP, &pin_puk_last_times, sizeof(mbtk_pin_puk_last_times));
                    }
                }
                else     // Set
                {
                    err = MBTK_INFO_ERR_UNSUPPORTED;
                    LOG("Set sim state fail.");
                }
                break;
            }
            case MBTK_INFO_ID_SIM_ENABLE_PIN_REQ:   // <string> PIN
            {
                if(pack->data_len == 0 || pack->data == NULL)   // Enable PIN
                {
                    mbtk_pin_state_enum pin_state = MBTK_PIN_DISABLE;
                    if(req_get_pin_state(&pin_state, &cme_err) || cme_err != MBTK_INFO_ERR_CME_NON)
                    {
                        if(cme_err != MBTK_INFO_ERR_CME_NON) {
                            err = MBTK_INFO_ERR_CME + cme_err;
                        } else {
                            err = MBTK_INFO_ERR_UNKNOWN;
                        }
                        LOGE("Get pin state fail.");
                    }
                    else
                    {
                        pack_rsp_send(cli_info->fd, MBTK_INFO_ID_SIM_ENABLE_PIN_RSP, &pin_state, sizeof(mbtk_pin_state_enum));
                    }
                }
                else     // Enable PIN
                {
                    mbtk_enable_pin_info *pin = NULL;
                    pin = (mbtk_enable_pin_info *)pack->data;
                    if(req_pin_enable(pin, &cme_err) || cme_err != MBTK_INFO_ERR_CME_NON)
                    {
                        if(cme_err != MBTK_INFO_ERR_CME_NON) {
                            err = MBTK_INFO_ERR_CME + cme_err;
                        } else {
                            err = MBTK_INFO_ERR_UNKNOWN;
                        }
                        LOG("Get IMSI fail.");
                    }
                    else
                    {
                        pack_rsp_send(cli_info->fd, MBTK_INFO_ID_SIM_ENABLE_PIN_RSP, NULL, 0);
                    }
                }
                break;
            }
            case MBTK_INFO_ID_SIM_PIN_REQ:   // <string> PIN
            {
                if(pack->data_len == 0 || pack->data == NULL)   // PIN
                {
                    err = MBTK_INFO_ERR_UNSUPPORTED;
                    LOG("Unsupport GET PIN.");
                }
                else     // Set PIN
                {
                    char pin[16] = {0};
                    memcpy(pin, pack->data, pack->data_len);
                    if(req_pin_verify(pin, &cme_err) || cme_err != MBTK_INFO_ERR_CME_NON)
                    {
                        if(cme_err != MBTK_INFO_ERR_CME_NON) {
                            err = MBTK_INFO_ERR_CME + cme_err;
                        } else {
                            err = MBTK_INFO_ERR_UNKNOWN;
                        }
                        LOG("Set PIN fail.");
                    }
                    else
                    {
                        pack_rsp_send(cli_info->fd, MBTK_INFO_ID_SIM_PIN_RSP, NULL, 0);
                    }
                }
                break;
            }
            case MBTK_INFO_ID_SIM_PUK_REQ:   // <string> PUK
            {
                if(pack->data_len == 0 || pack->data == NULL)
                {
                    err = MBTK_INFO_ERR_UNSUPPORTED;
                    LOG("Unsupport.");
                }
                else     // change PIN
                {
                    mbtk_unlock_pin_info *pin_info = NULL;
                    pin_info = (mbtk_unlock_pin_info *)pack->data;
                    if(req_puk_unlock_pin(pin_info, &cme_err) || cme_err != MBTK_INFO_ERR_CME_NON)
                    {
                        if(cme_err != MBTK_INFO_ERR_CME_NON) {
                            err = MBTK_INFO_ERR_CME + cme_err;
                        } else {
                            err = MBTK_INFO_ERR_UNKNOWN;
                        }
                        LOG("Get IMSI fail.");
                    }
                    else
                    {
                        pack_rsp_send(cli_info->fd, MBTK_INFO_ID_SIM_CHANGE_PIN_RSP, NULL, 0);
                    }
                }
                break;
            }
            case MBTK_INFO_ID_SIM_CHANGE_PIN_REQ:   // <string> <string> old_PIN new_PIN
            {
                if(pack->data_len == 0 || pack->data == NULL)
                {
                    err = MBTK_INFO_ERR_UNSUPPORTED;
                    LOG("Unsupport.");
                }
                else     // change PIN
                {
                    mbtk_change_pin_info *pin_info = NULL;
                    pin_info = (mbtk_change_pin_info *)pack->data;
                    if(req_pin_change(pin_info, &cme_err) || cme_err != MBTK_INFO_ERR_CME_NON)
                    {
                        if(cme_err != MBTK_INFO_ERR_CME_NON) {
                            err = MBTK_INFO_ERR_CME + cme_err;
                        } else {
                            err = MBTK_INFO_ERR_UNKNOWN;
                        }
                        LOG("Get IMSI fail.");
                    }
                    else
                    {
                        pack_rsp_send(cli_info->fd, MBTK_INFO_ID_SIM_CHANGE_PIN_RSP, NULL, 0);
                    }
                }
                break;
            }
            case MBTK_INFO_ID_SIM_IMSI_REQ:  // <string> IMSI
            {
                if(pack->data_len == 0 || pack->data == NULL)   // Get IMSI
                {
                    char imsi[20] = {0};
                    if(req_imsi_get(imsi, &cme_err) || strlen(imsi) == 0 || cme_err != MBTK_INFO_ERR_CME_NON)
                    {
                        if(cme_err != MBTK_INFO_ERR_CME_NON) {
                            err = MBTK_INFO_ERR_CME + cme_err;
                        } else {
                            err = MBTK_INFO_ERR_UNKNOWN;
                        }
                        LOG("Get IMSI fail.");
                    }
                    else
                    {
                        pack_rsp_send(cli_info->fd, MBTK_INFO_ID_SIM_IMSI_RSP, imsi, strlen(imsi));
                    }
                }
                else     // Set IMSI(Unsupport).
                {
                    err = MBTK_INFO_ERR_UNSUPPORTED;
                    LOG("Unsupport set IMSI.");
                }
                break;
            }
            case MBTK_INFO_ID_SIM_ICCID_REQ: // <string> ICCID
            {
                if(pack->data_len == 0 || pack->data == NULL)   // Get ICCID
                {
                    //log_hex("pack", pack, sizeof(mbtk_info_pack_t));
                    //sleep(1);
                    char iccid[50] = {0};
                    if(req_iccid_get(iccid, &cme_err) || strlen(iccid) == 0 || cme_err != MBTK_INFO_ERR_CME_NON)
                    {
                        if(cme_err != MBTK_INFO_ERR_CME_NON) {
                            err = MBTK_INFO_ERR_CME + cme_err;
                        } else {
                            err = MBTK_INFO_ERR_UNKNOWN;
                        }
                        LOG("Get ICCID fail.");
                    }
                    else
                    {
                        pack_rsp_send(cli_info->fd, MBTK_INFO_ID_SIM_ICCID_RSP, iccid, strlen(iccid));
                    }
                }
                else     // Set ICCID(Unsupport).
                {
                    err = MBTK_INFO_ERR_UNSUPPORTED;
                    LOG("Unsupport set ICCID.");
                }
                break;
            }
            case MBTK_INFO_ID_SIM_PN_REQ: // <string> Phone Number
            {
                if(pack->data_len == 0 || pack->data == NULL)   // Get Phone Number
                {
                    //log_hex("pack", pack, sizeof(mbtk_info_pack_t));
                    //sleep(1);
                    char phone_number[50] = {0};
                    if(req_phone_number_get(phone_number, &cme_err) || strlen(phone_number) == 0 || cme_err != MBTK_INFO_ERR_CME_NON)
                    {
                        if(cme_err != MBTK_INFO_ERR_CME_NON) {
                            err = MBTK_INFO_ERR_CME + cme_err;
                        } else {
                            err = MBTK_INFO_ERR_UNKNOWN;
                        }
                        LOG("Get Phone Number fail.");
                    }
                    else
                    {
                        pack_rsp_send(cli_info->fd, MBTK_INFO_ID_SIM_PN_RSP, phone_number, strlen(phone_number));
                    }
                }
                else     // Set Phone Number(Unsupport).
                {
                    err = MBTK_INFO_ERR_UNSUPPORTED;
                    LOG("Unsupport set Phone Number.");
                }
                break;
            }
            case MBTK_INFO_ID_NET_SEL_MODE_REQ: // <mbtk_net_info_t> Operator
            {
                if(pack->data_len == 0 || pack->data == NULL) // Get
                {
                    mbtk_net_info_t info;
                    memset(&info, 0, sizeof(mbtk_net_info_t));
                    if(req_net_sel_mode_get(&info, &cme_err) || cme_err != MBTK_INFO_ERR_CME_NON)
                    {
                        if(cme_err != MBTK_INFO_ERR_CME_NON) {
                            err = MBTK_INFO_ERR_CME + cme_err;
                        } else {
                            err = MBTK_INFO_ERR_UNKNOWN;
                        }
                        LOG("Get Net select mode fail.");
                    }
                    else
                    {
                        LOG("NET : %d, %d, %d, %d", info.net_sel_mode, info.net_type, info.net_state, info.plmn);
                        pack_rsp_send(cli_info->fd, MBTK_INFO_ID_NET_SEL_MODE_RSP, &info, sizeof(mbtk_net_info_t));
                    }
                }
                else     // Set
                {
                    //LOG("1 pack-%p,data-%p,data_len-%d", pack, pack->data, pack->data_len);
                    //log_hex("pack", pack, sizeof(mbtk_info_pack_t));
                    //log_hex("data", pack->data, pack->data_len);

                    mbtk_net_info_t* info = (mbtk_net_info_t*)pack->data;//(mbtk_net_info_t*)mbtk_info_pack_data_get(pack, NULL);
                    if(info == NULL) {
                        err = MBTK_INFO_ERR_FORMAT;
                        LOG("Get Net select mode fail.");
                    } else {
                        LOG("NET : %d, %d, %d", info->net_sel_mode, info->net_type, info->plmn);
                        if(req_net_sel_mode_set(info, &cme_err) || cme_err != MBTK_INFO_ERR_CME_NON) {
                            if(cme_err != MBTK_INFO_ERR_CME_NON) {
                                err = MBTK_INFO_ERR_CME + cme_err;
                            } else {
                                err = MBTK_INFO_ERR_UNKNOWN;
                            }
                            LOG("Get Net select mode fail.");
                        } else {
                            pack_rsp_send(cli_info->fd, MBTK_INFO_ID_NET_SEL_MODE_RSP, NULL, 0);
                        }
                    }
                }
                break;
            }
            case MBTK_INFO_ID_NET_AVAILABLE_REQ:// sel_mode(uint8)type(uint8)plmn(uint32)...sel_mode(uint8)type(uint8)plmn(uint32)
            {
                if(pack->data_len == 0 || pack->data == NULL) // Get Available Net.
                {
                    int buffer_size;
                    uint8 buffer[SOCK_MSG_LEN_MAX];
                    memset(buffer, 0, SOCK_MSG_LEN_MAX);
                    if((buffer_size = req_available_net_get(buffer, &cme_err)) <= 0 || cme_err != MBTK_INFO_ERR_CME_NON)
                    {
                        if(cme_err != MBTK_INFO_ERR_CME_NON) {
                            err = MBTK_INFO_ERR_CME + cme_err;
                        } else {
                            err = MBTK_INFO_ERR_UNKNOWN;
                        }
                        LOG("Get Available Net fail.");
                    }
                    else
                    {
                        pack_rsp_send(cli_info->fd, MBTK_INFO_ID_NET_AVAILABLE_RSP, buffer, buffer_size);
                    }
                }
                else     // Set Available Net(Unsupport).
                {
                    err = MBTK_INFO_ERR_UNSUPPORTED;
                    LOG("Unsupport set available net.");
                }
                break;
            }
            case MBTK_INFO_ID_NET_BAND_REQ:
            {
                if(pack->data_len == 0 || pack->data == NULL)
                {
                    err = MBTK_INFO_ERR_REQ_PARAMETER;
                    LOG("No data found.");
                }
                else     // Get support/current bands.
                {
                    if(pack->data_len == sizeof(uint8)) {
                        if(*(pack->data)) { // Get current bands.
                            mbtk_band_info_t band;
                            memset(&band, 0x0, sizeof(mbtk_band_info_t));
                            if(req_band_get(&band, &cme_err) || cme_err != MBTK_INFO_ERR_CME_NON)
                            {
                                if(cme_err != MBTK_INFO_ERR_CME_NON) {
                                    err = MBTK_INFO_ERR_CME + cme_err;
                                } else {
                                    err = MBTK_INFO_ERR_UNKNOWN;
                                }
                                LOG("Get net band fail.");
                            }
                            else
                            {
                                pack_rsp_send(cli_info->fd, MBTK_INFO_ID_NET_BAND_RSP, &band, sizeof(mbtk_band_info_t));
                            }
                        } else { // Get support bands.
                            band_support_get();
                            if(band_support.net_pref != 0)
                            {
                                err = MBTK_INFO_ERR_UNKNOWN;
                                LOG("Get support bands fail.");
                            }
                            else
                            {
                                pack_rsp_send(cli_info->fd, MBTK_INFO_ID_NET_BAND_RSP, &band_support, sizeof(mbtk_band_info_t));
                            }
                        }
                    } else { // Set current bands.
                        mbtk_band_info_t* band = (mbtk_band_info_t*)pack->data;
                        if(pack->data_len != sizeof(mbtk_band_info_t))
                        {
                            err = MBTK_INFO_ERR_REQ_PARAMETER;
                            LOG("Set net band error.");
                            break;
                        }

                        if(req_band_set(band, &cme_err) || cme_err != MBTK_INFO_ERR_CME_NON)
                        {
                            if(cme_err != MBTK_INFO_ERR_CME_NON) {
                                err = MBTK_INFO_ERR_CME + cme_err;
                            } else {
                                err = MBTK_INFO_ERR_UNKNOWN;
                            }
                            LOG("Set net band fail.");
                        }
                        else
                        {
                            pack_rsp_send(cli_info->fd, MBTK_INFO_ID_NET_BAND_RSP, NULL, 0);
                        }
                    }
                }
                break;
            }
            case MBTK_INFO_ID_NET_CELL_REQ: // mbtk_cell_info_t[]
            {
                if(pack->data_len == 0 || pack->data == NULL)   // Get net cell.
                {
                    if(req_cell_info_get(&cme_err) || cme_err != MBTK_INFO_ERR_CME_NON)
                    {
                        if(cme_err != MBTK_INFO_ERR_CME_NON) {
                            err = MBTK_INFO_ERR_CME + cme_err;
                        } else {
                            err = MBTK_INFO_ERR_UNKNOWN;
                        }
                        LOG("Get net cell fail.");
                    }
                    else
                    {
                        LOG("req_cell_info_get() success,cell number: %d", cell_info.cell_num);
                        //sleep(1);
                        // mbtK_cell_pack_info_t
                        if(cell_info.cell_num > 0 && cell_info.cell_num <= CELL_NUM_MAX && cell_info.type >= 0 && cell_info.type <= 2) {
                            uint8 *data = (uint8*)malloc(sizeof(uint8) + sizeof(mbtk_cell_info_t) * cell_info.cell_num);
                            if(data == NULL){
                                err = MBTK_INFO_ERR_MEMORY;
                                LOG("Get net cell fail.");
                            } else {
                                *data = cell_info.type; // Set network type.
                                // Copy cell info item.
                                #if 0
                                int i = 0;
                                while(i < cell_info.cell_num) {
                                    memcpy(data + sizeof(uint8) + sizeof(mbtk_cell_info_t) * i,
                                        &(cell_info.cell[i]),
                                        sizeof(mbtk_cell_info_t));
                                    i++;
                                }
                                #else
                                memcpy(data + sizeof(uint8),
                                        &(cell_info.cell),
                                        sizeof(mbtk_cell_info_t) * cell_info.cell_num);
                                #endif
                                pack_rsp_send(cli_info->fd, MBTK_INFO_ID_NET_CELL_RSP, data, sizeof(uint8) + sizeof(mbtk_cell_info_t) * cell_info.cell_num);
                                free(data);
                            }
                        } else {
                            err = MBTK_INFO_ERR_UNKNOWN;
                            LOG("Get net cell fail.");
                        }
                    }
                }
                else     // Lock cell
                {
	                char *mem = (char*)(pack->data);
					int len = pack->data_len;
	                char reg[100] = {0};
	                printf("mem:%s, len:%d", pack->data, pack->data_len);

	                if(req_cell_info_set(mem, reg, len, &cme_err) || cme_err != MBTK_INFO_ERR_CME_NON)
	                {
	                //    printf("cpms_set fail\n");
	                    if(cme_err != MBTK_INFO_ERR_CME_NON) {
	                        err = MBTK_INFO_ERR_CME + cme_err;
	                    } else {
	                        err = MBTK_INFO_ERR_UNKNOWN;
	                    }
	                //    LOG("Set req_cell_info_set fail.");
	                }
	                else
	                {

	                    printf("req_cell_info_set success, reg:%s\n", reg);
	                    pack_rsp_send(cli_info->fd, MBTK_INFO_ID_NET_CELL_RSP, reg, strlen(reg));

	                    // Restart is required to take effect.
	                    LOG("Will reboot system...");
	                }
                }
                break;
            }
            case MBTK_INFO_ID_NET_RADIO_REQ: // <uint8> 0:OFF 1:ON
            {
                if(pack->data_len == 0 || pack->data == NULL) // Get
                {
                    uint8 radio_on = (uint8)isRadioOn();
                    if(radio_on < 0)
                    {
                        err = MBTK_INFO_ERR_UNKNOWN;
                        LOG("Get radio state fail.");
                    }
                    else
                    {
                        pack_rsp_send(cli_info->fd, MBTK_INFO_ID_NET_RADIO_RSP, &radio_on, sizeof(uint8));
                    }
                }
                else     // Set
                {
                    at_cfun_command = true;
                    uint8 radio_on = *(pack->data);
                    if(radio_on != 0 && radio_on != 1)
                    {
                        err = MBTK_INFO_ERR_REQ_PARAMETER;
                        LOG("Set radio state fail.");
                    }
                    else
                    {
                        setRadioPower(radio_on);
                        if((radio_on && net_info.radio_state == MBTK_RADIO_STATE_ON)
                            || (!radio_on && net_info.radio_state == MBTK_RADIO_STATE_OFF)) {
                            pack_rsp_send(cli_info->fd, MBTK_INFO_ID_NET_RADIO_RSP, NULL, 0);
                        } else {
                            err = MBTK_INFO_ERR_UNKNOWN;
                            LOG("Set radio state fail.");
                        }
                    }
                    at_cfun_command = false;
                }
                break;
            }
            case MBTK_INFO_ID_NET_SIGNAL_REQ:  // mbtk_signal_info_t
            {
                if(pack->data_len == 0 || pack->data == NULL)   // Get net signal.
                {
                    mbtk_signal_info_t signal;
                    memset(&signal, 0, sizeof(mbtk_signal_info_t));
                    if(req_net_signal_get(&signal, &cme_err) || cme_err != MBTK_INFO_ERR_CME_NON)
                    {
                        if(cme_err != MBTK_INFO_ERR_CME_NON) {
                            err = MBTK_INFO_ERR_CME + cme_err;
                        } else {
                            err = MBTK_INFO_ERR_UNKNOWN;
                        }
                        LOG("Get net signal fail.");
                    }
                    else
                    {
                        pack_rsp_send(cli_info->fd, MBTK_INFO_ID_NET_SIGNAL_RSP, &signal, sizeof(mbtk_signal_info_t));
                    }
                }
                else     // Set
                {
                    err = MBTK_INFO_ERR_UNSUPPORTED;
                    LOG("Set net signal fail.");
                }
                break;
            }
            case MBTK_INFO_ID_NET_REG_REQ:  // mbtk_net_reg_info_t
            {
                if(pack->data_len == 0 || pack->data == NULL)   // Get net reg.
                {
                    mbtk_net_reg_info_t reg;
                    memset(&reg, 0, sizeof(mbtk_net_reg_info_t));
                    if(req_net_reg_get(&reg, &cme_err) || cme_err != MBTK_INFO_ERR_CME_NON)
                    {
                        if(cme_err != MBTK_INFO_ERR_CME_NON) {
                            err = MBTK_INFO_ERR_CME + cme_err;
                        } else {
                            err = MBTK_INFO_ERR_UNKNOWN;
                        }
                        LOG("Get net reg fail.");
                    }
                    else
                    {
                        pack_rsp_send(cli_info->fd, MBTK_INFO_ID_NET_REG_RSP, &reg, sizeof(mbtk_net_reg_info_t));
                    }
                }
                else     // Set
                {
                    err = MBTK_INFO_ERR_UNSUPPORTED;
                    LOG("Set net reg fail.");
                }
                break;
            }
            case MBTK_INFO_ID_NET_APN_REQ:   // mbtk_apn_info_t
            {
                if(pack->data_len == 0 || pack->data == NULL) // Get APN
                {
                    uint8 buff[SOCK_MSG_LEN_MAX];
                    memset(buff, 0, SOCK_MSG_LEN_MAX);
                    int data_len = 0;
                    if(req_apn_get(buff, &data_len, &cme_err) || data_len <= 0 || cme_err != MBTK_INFO_ERR_CME_NON)
                    {
                        if(cme_err != MBTK_INFO_ERR_CME_NON) {
                            err = MBTK_INFO_ERR_CME + cme_err;
                        } else {
                            err = MBTK_INFO_ERR_UNKNOWN;
                        }
                        LOG("Get APN fail.");
                    }
                    else
                    {
                        pack_rsp_send(cli_info->fd, MBTK_INFO_ID_NET_APN_RSP, buff, data_len);
                    }
                }
                else     // Set
                {
                    // <cid[1]><ip_type[1]><apn_len[2]><apn><user_len[2]><user><pass_len[2]><pass><auth_len[2]><auth>
                    const uint8* ptr = pack->data;
                    mbtk_apn_info_t apn;
                    int len;
                    memset(&apn, 0, sizeof(mbtk_apn_info_t));
                    // cid
                    apn.cid = *ptr++;

                    // ip_type
                    apn.ip_type = (mbtk_ip_type_enum)(*ptr++);

                    // apn
                    len = byte_2_uint16(ptr, false);
                    ptr += sizeof(uint16);
                    if(len > 0) {
                        memcpy(apn.apn, ptr, len);
                        ptr += len;
                    }

                    // user
                    len = byte_2_uint16(ptr, false);
                    ptr += sizeof(uint16);
                    if(len > 0) {
                        memcpy(apn.user, ptr, len);
                        ptr += len;
                    }

                    // pass
                    len = byte_2_uint16(ptr, false);
                    ptr += sizeof(uint16);
                    if(len > 0) {
                        memcpy(apn.pass, ptr, len);
                        ptr += len;
                    }

                    // auth
                    len = byte_2_uint16(ptr, false);
                    ptr += sizeof(uint16);
                    if(len > 0) {
                        memcpy(apn.auth, ptr, len);
                        ptr += len;
                    }

                    LOGD("APN : %d, %d, %s, %s, %s, %s", apn.cid, apn.ip_type, str_empty(apn.apn) ? "NULL" : apn.apn,
                        str_empty(apn.user) ? "NULL" : apn.user, str_empty(apn.pass) ? "NULL" : apn.pass, str_empty(apn.auth) ? "NULL" : apn.auth);
                    if(req_apn_set(&apn, &cme_err) || cme_err != MBTK_INFO_ERR_CME_NON)
                    {
                        if(cme_err != MBTK_INFO_ERR_CME_NON) {
                            err = MBTK_INFO_ERR_CME + cme_err;
                        } else {
                            err = MBTK_INFO_ERR_UNKNOWN;
                        }
                        LOG("Set APN fail.");
                    }
                    else
                    {
                        // Save apn.
#ifdef MBTK_AF_SUPPORT
                        if(apn.cid == 1)
                        {
                            default_iptype = apn.ip_type;
                        }
#endif
                        apn_prop_set(&apn);

                        pack_rsp_send(cli_info->fd, MBTK_INFO_ID_NET_APN_RSP, NULL, 0);
                    }
                }
                break;
            }
            case MBTK_INFO_ID_NET_QSER_APN_REQ:
            {
                if(pack->data_len == 0 || pack->data == NULL)
                {
                    uint8 buff[SOCK_MSG_LEN_MAX];
                    memset(buff, 0, SOCK_MSG_LEN_MAX);
                    int data_len = 0;
                    if(mbtk_qser_req_apn_get(buff, &data_len, &cme_err) || cme_err != MBTK_INFO_ERR_CME_NON)
                    {
                        if(cme_err != MBTK_INFO_ERR_CME_NON) {
                            err = MBTK_INFO_ERR_CME + cme_err;
                        } else {
                            err = MBTK_INFO_ERR_UNKNOWN;
                        }
                        LOGE("Get APN fail.");
                    }
                    else
                    {
                        pack_rsp_send(cli_info->fd, MBTK_INFO_ID_NET_APN_RSP, buff, data_len);
                    }
                }
                else
                {
                    const uint8* ptr = pack->data;
                    mbtk_apn_info_t apn;
                    mbtk_apn_req_type_enum req_type = MBTK_APN_REQ_TYPE_SET;
                    uint8 apn_type[MBTK_QSER_APN_NAME_SIZE] = {0};
                    int ret = mbtk_strdata_to_apn(pack->data, &apn, apn_type, &req_type);
                    if(ret < 0)
                    {
                        LOGE("mbtk_strdata_to_apn fail. ret = [%d]", ret);
                        err = MBTK_INFO_ERR_REQ_PARAMETER;
                    }
                    else
                    {
                        if(req_apn_set(&apn, &cme_err) || cme_err != MBTK_INFO_ERR_CME_NON)
                        {
                            if(cme_err != MBTK_INFO_ERR_CME_NON) {
                                err = MBTK_INFO_ERR_CME + cme_err;
                            } else {
                                err = MBTK_INFO_ERR_UNKNOWN;
                            }
                            LOGE("Set APN fail.");
                        }
                        else
                        {
                            // Save apn.
                            apn_prop_set(&apn);
                            mbtk_qser_apn_save(apn, apn_type, true);
                            if(req_type == MBTK_APN_REQ_TYPE_ADD)
                            {
                                pack_rsp_send(cli_info->fd, MBTK_INFO_ID_NET_QSER_APN_RSP, (void *)&apn.cid, 1);
                            }
                            else
                            {
                                pack_rsp_send(cli_info->fd, MBTK_INFO_ID_NET_QSER_APN_RSP, NULL, 0);
                            }
                        }
                    }
                }

                break;
            }
            case MBTK_INFO_ID_NET_APN_DEL_REQ:
            {
                if(pack->data_len == 0 || pack->data == NULL)
                {
                    err = MBTK_INFO_ERR_UNSUPPORTED;
                    LOG("Unsupported delete apn .");
                }
                else
                {
                    int profile = pack->data[0];
                    if(cid_active[profile] == 1)
                    {
                        LOGD("cid pdp already open.");
                        err = MBTK_INFO_ERR_CID_EXIST;
                        break;
                    }
                    if(mbtk_qser_apn_del(profile) < 0)
                    {
                        LOGD("del error.");
                        err = MBTK_INFO_ERR_REQ_PARAMETER;
                    }
                    else
                    {
                        if(req_apn_del(profile, &cme_err) || cme_err != MBTK_INFO_ERR_CME_NON)
                        {
                            if(cme_err != MBTK_INFO_ERR_CME_NON) {
                                err = MBTK_INFO_ERR_CME + cme_err;
                            } else {
                                err = MBTK_INFO_ERR_UNKNOWN;
                            }
                            LOG("Delete apn fail.");
                        }
                        else
                        {
                            pack_rsp_send(cli_info->fd, MBTK_INFO_ID_NET_APN_DEL_RSP, NULL, 0);
                        }
                    }
                }
                break;
            }
            case MBTK_INFO_ID_NET_DATA_CALL_REQ:
            {
                if(pack->data_len == 0 || pack->data == NULL)
                {
                    err = MBTK_INFO_ERR_UNSUPPORTED;
                }
                else
                {
                    /* <call_type[1]><cid[1]><auto_conn_interval[1]><boot_conn[1]><timeout[1]>
                     call_type : mbtk_data_call_type_enum
                     cid : 2 - 7
                     timeout : second
                    */
                    mbtk_data_call_type_enum call_type = (mbtk_data_call_type_enum)pack->data[0];
                    int cid = pack->data[1];
                    int reconn = 0;

#if 0
                    if(cid < MBTK_APN_CID_MIN || cid > MBTK_APN_CID_MAX) {
                        err = MBTK_INFO_ERR_CID;
                        break;
                    }
#endif
                    if(mbtk_check_cid(cid) < 0)
                    {
                        err = MBTK_INFO_ERR_CID;
                        break;
                    }

                    LOG("cid_active[%d] = %d", cid, cid_active[cid]);
                    memset(&cgact_wait, 0, sizeof(info_cgact_wait_t));
                    switch(call_type) {
                        case MBTK_DATA_CALL_START: {
                            //mbtk wyq for data_call_ex add start
                            int auto_conn_interval = pack->data[2];
                            int boot_conn = pack->data[3];
                            int timeout = pack->data[4];
                            data_call_bootconn_save(cid, boot_conn);

                            mbtk_signal_info_t signal;
                            memset(&signal, 0xFF, sizeof(mbtk_signal_info_t));
                            req_net_signal_get(&signal, NULL);

                            if(cid_active[cid] == 1)
                            {
                                err = MBTK_INFO_ERR_CID_EXIST;
                                break;
                            }

                            if(mbtk_check_default_pdp_state(cid))
                            {
                                err = MBTK_INFO_ERR_UNSUPPORTED;
                                break;
                            }

                            data_call_reconn:
                            //mbtk wyq for data_call_ex add end
                            cgact_wait.waitting = true;
                            cgact_wait.cid = cid;
                            cgact_wait.act = true;
                            if(req_data_call_start(cid, &cme_err) || cme_err != MBTK_INFO_ERR_CME_NON)
                            {
                                //mbtk wyq for data_call_ex add start
                                if(reconn < 5 && auto_conn_interval > 0)
                                {
                                    sleep(auto_conn_interval);
                                    reconn++;
                                    cme_err = MBTK_INFO_ERR_CME_NON;
                                    LOG("data_call restart call.");
                                    goto data_call_reconn;
                                }
                                //mbtk wyq for data_call_ex add end
                                if(cme_err != MBTK_INFO_ERR_CME_NON) {
                                    err = MBTK_INFO_ERR_CME + cme_err;
                                } else {
                                    err = MBTK_INFO_ERR_UNKNOWN;
                                }
                                LOG("%d active fail.", cid);
                            }
                            else
                            {
                                // Wait for "CONNECT" or "+CGEV:"
                                if(wait_cgact_complete(timeout)) { // Timeout
                                    err = MBTK_INFO_ERR_TIMEOUT;
                                    break;
                                }

                                // Get IP information.
                                mbtk_ipv4_info_t ipv4;
                                mbtk_ipv6_info_t ipv6;
                                memset(&ipv4, 0, sizeof(mbtk_ipv4_info_t));
                                memset(&ipv6, 0, sizeof(mbtk_ipv6_info_t));
                                if(req_data_call_state_get(cid, &ipv4, &ipv6, &cme_err) || cme_err != MBTK_INFO_ERR_CME_NON)
                                {
                                    if(cme_err != MBTK_INFO_ERR_CME_NON) {
                                        err = MBTK_INFO_ERR_CME + cme_err;
                                    } else {
                                        err = MBTK_INFO_ERR_UNKNOWN;
                                    }
                                    LOG("Get %d state fail.", cid);
                                }
                                else
                                {
                                    // Config IPv4 address.
#ifdef MBTK_AF_SUPPORT
                                    if(cid == 1)
                                    {
                                        //uint8 pdp_data = cid;
                                        //pack_rsp_send(cli_info->fd , MBTK_INFO_ID_IND_PDP_STATE_CHANGE, &pdp_data, sizeof(uint8));
                                        ipv4.valid = false;
                                        ipv6.valid = false;
                                        if(default_iptype == MBTK_IP_TYPE_IP)
                                        {
                                            ipv4.valid = true;
                                        }
                                        else if(default_iptype == MBTK_IP_TYPE_IPV6)
                                        {
                                            ipv6.valid = true;
                                        }
                                        else
                                        {
                                            ipv4.valid = true;
                                            ipv6.valid = true;
                                        }
                                    }
#endif
#if 1
                                    if(ipv4.valid) {
                                        char dev[20] = {0};
                                        sprintf(dev, "ccinet%d", cid - 1);

                                        char ip[20] = {0};
                                        char gateway[20] = {0};
                                        char *gateway_ptr = NULL;
                                        char netmask[20] = {0};
                                        char *netmask_ptr = NULL;
                                        if(inet_ntop(AF_INET, &(ipv4.IPAddr), ip, 20) == NULL) {
                                            err = MBTK_INFO_ERR_UNKNOWN;
                                            LOGE("inet_ntop ipv4 ip fail.");
                                            log_hex("IPv4", &(ipv4.IPAddr), 4);
                                            break;
                                        }

                                        if(ipv4.GateWay) {
                                            if(inet_ntop(AF_INET, &(ipv4.GateWay), gateway, 20) == NULL) {
                                                err = MBTK_INFO_ERR_UNKNOWN;
                                                LOGE("inet_ntop ipv4 gateway fail.");
                                                log_hex("IPv4", &(ipv4.IPAddr), 4);
                                                break;
                                            } else {
                                                gateway_ptr = gateway;
                                            }
                                        }

                                        if(ipv4.NetMask) {
                                            if(inet_ntop(AF_INET, &(ipv4.NetMask), netmask, 20) == NULL) {
                                                err = MBTK_INFO_ERR_UNKNOWN;
                                                LOGE("inet_ntop ipv4 netmask fail.");
                                                log_hex("IPv4", &(ipv4.IPAddr), 4);
                                                break;
                                            } else {
                                                netmask_ptr = netmask;
                                            }
                                        }

                                        if(netmask_ptr == NULL) {
                                            netmask_ptr = netmask;
                                            memcpy(netmask_ptr, "255.255.255.0", strlen("255.255.255.0"));
                                        }

                                        if(mbtk_ifc_configure2(dev, ip, 0, gateway_ptr, netmask_ptr)) {
                                            LOGD("Config %s IPv4 %s fail.", dev, ip);
                                        } else {
                                            LOGD("Config %s IPv4 %s success.", dev, ip);
                                        }

                                    }
#endif
                                    // Config IPv6 address.
                                    if(ipv6.valid) {
                                        char ip[50] = {0};
                                        char dev[20] = {0};
                                        sprintf(dev, "ccinet%d", cid - 1);

                                        if(inet_ntop(AF_INET6, &(ipv6.IPV6Addr), ip, 50) == NULL) {
                                            err = MBTK_INFO_ERR_UNKNOWN;
                                            LOGE("inet_ntop ipv6 ip fail.");
                                            log_hex("IPv6", &(ipv6.IPV6Addr), 16);
                                            break;
                                        }

                                        if(mbtk_ipv6_config(dev, ip, 64)) {
                                            LOGD("Config %s IPv6 %s fail.", dev, ip);
                                        } else {
                                            LOGD("Config %s IPv6 %s success.", dev, ip);
                                        }
                                    }

                                    cid_active[cid] = 1;
                                    mbtk_set_default_pdp_state(true, cid);
                                    mbtk_qser_route_config(cid, &ipv4, &ipv6);
                                    if(cli_info->fd != DATA_CALL_BOOTCONN_FD)
                                    {
                                        mbtk_net_led_set(MBTK_NET_LED_DATA_CONNECT);
                                        pack_rsp_send(cli_info->fd, MBTK_INFO_ID_NET_DATA_CALL_RSP, NULL, 0);
                                    }
                                    else
                                    {
                                        free(pack->data);
                                        free(cli_info);
                                        LOG("data_call bootconn success.");
                                    }
                                }
                            }
                            break;
                        }
                        case MBTK_DATA_CALL_STOP: {
                            //mbtk wyq for data_call_ex add start
                            if(cid_active[cid] == 0)
                            {
                                err = MBTK_INFO_ERR_CID_NO_EXIST;
                                break;
                            }

                            int timeout = pack->data[2];
                            //mbtk wyq for data_call_ex add end
#if (defined(MBTK_AF_SUPPORT) || defined(MBTK_ALL_CID_SUPPORT))
                            if(cid == 1)
                            {
                                char dev[20] = {0};
                                uint8 pdp_data = cid + 100;
                                pack_rsp_send(cli_info->fd , MBTK_INFO_ID_IND_PDP_STATE_CHANGE, &pdp_data, sizeof(uint8));

                                sprintf(dev, "ccinet%d", cid - 1);

                                // Config network.
                                if(mbtk_ifc_configure2(dev, NULL, 0, NULL, NULL)) {
                                    LOGD("Config %s IPv4 0 fail.", dev);
                                } else {
                                    LOGD("Config %s IPv4 0 success.", dev);
                                }
                                cid_active[cid] = 0;
                                mbtk_set_default_pdp_state(false, cid);
                                mbtk_net_led_set(MBTK_NET_LED_NET_CONNECT);
                                pack_rsp_send(cli_info->fd, MBTK_INFO_ID_NET_DATA_CALL_RSP, NULL, 0);
                                break;
                            }
#endif
                            cgact_wait.waitting = true;
                            cgact_wait.cid = cid;
                            cgact_wait.act = false;
                            if(req_data_call_stop(cid, &cme_err) || cme_err != MBTK_INFO_ERR_CME_NON)
                            {
                                if(cme_err != MBTK_INFO_ERR_CME_NON) {
                                    err = MBTK_INFO_ERR_CME + cme_err;
                                } else {
                                    err = MBTK_INFO_ERR_UNKNOWN;
                                }
                                LOG("%d deactive fail.", cid);
                            }
                            else
                            {
                                // Wait for "CONNECT" or "+CGEV:"
                                if(wait_cgact_complete(timeout)) { // Timeout
                                    err = MBTK_INFO_ERR_TIMEOUT;
                                    break;
                                }
                                char dev[20] = {0};
                                sprintf(dev, "ccinet%d", cid - 1);

                                // Config network.
                                if(mbtk_ifc_configure2(dev, NULL, 0, NULL, NULL)) {
                                    LOGD("Config %s IPv4 0 fail.", dev);
                                } else {
                                    LOGD("Config %s IPv4 0 success.", dev);
                                }

#if 0
                                if(mbtk_ipv6_config(dev, NULL, 64)) {
                                    LOGD("Config %s IPv6 0 fail.", dev);
                                } else {
                                    LOGD("Config %s IPv6 0 success.", dev);
                                }
#endif
                                cid_active[cid] = 0;
                                mbtk_set_default_pdp_state(false, cid);
                                mbtk_net_led_set(MBTK_NET_LED_NET_CONNECT);
                                pack_rsp_send(cli_info->fd, MBTK_INFO_ID_NET_DATA_CALL_RSP, NULL, 0);
                            }
                            break;
                        }
                        case MBTK_DATA_CALL_STATE: {
                            if(cid_active[cid] == 0)
                            {
                                err = MBTK_INFO_ERR_CID_NO_EXIST;
                                break;
                            }
                            mbtk_ipv4_info_t ipv4;
                            mbtk_ipv6_info_t ipv6;
                            memset(&ipv4, 0, sizeof(mbtk_ipv4_info_t));
                            memset(&ipv6, 0, sizeof(mbtk_ipv6_info_t));
                            if(req_data_call_state_get(cid, &ipv4, &ipv6, &cme_err) || cme_err != MBTK_INFO_ERR_CME_NON)
                            {
                                if(cme_err != MBTK_INFO_ERR_CME_NON) {
                                    err = MBTK_INFO_ERR_CME + cme_err;
                                } else {
                                    err = MBTK_INFO_ERR_UNKNOWN;
                                }
                                LOG("Get %d state fail.", cid);
                            }
                            else
                            {
                                uint8 buff[SOCK_MSG_LEN_MAX] = {0};
                                int buff_len = 0;
#ifdef MBTK_AF_SUPPORT
                                if(cid == 1)
                                {
                                    ipv4.valid = false;
                                    ipv6.valid = false;
                                    if(default_iptype == MBTK_IP_TYPE_IP)
                                    {
                                        ipv4.valid = true;
                                    }
                                    else if(default_iptype == MBTK_IP_TYPE_IPV6)
                                    {
                                        ipv6.valid = true;
                                    }
                                    else
                                    {
                                        ipv4.valid = true;
                                        ipv6.valid = true;
                                    }
                                }
#endif
                                if(ipv4.valid && ipv6.valid) {
                                    buff[0] = (uint8)2;
                                    buff_len++;

                                    memcpy(buff + buff_len, &ipv4, sizeof(mbtk_ipv4_info_t));
                                    buff_len += sizeof(mbtk_ipv4_info_t);
                                    memcpy(buff + buff_len, &ipv6, sizeof(mbtk_ipv6_info_t));
                                    buff_len += sizeof(mbtk_ipv6_info_t);
                                } else if(ipv4.valid) {
                                    buff[0] = (uint8)0;
                                    buff_len++;

                                    memcpy(buff + buff_len, &ipv4, sizeof(mbtk_ipv4_info_t));
                                    buff_len += sizeof(mbtk_ipv4_info_t);
                                } else if(ipv6.valid) {
                                    buff[0] = (uint8)1;
                                    buff_len++;

                                    memcpy(buff + buff_len, &ipv6, sizeof(mbtk_ipv6_info_t));
                                    buff_len += sizeof(mbtk_ipv6_info_t);
                                } else {
                                    LOGE("Get IPv4/IPv6 fail.");
                                    err = MBTK_INFO_ERR_UNKNOWN;
                                    break;
                                }
                                pack_rsp_send(cli_info->fd, MBTK_INFO_ID_NET_DATA_CALL_RSP, buff, buff_len);
                            }
                            break;
                        }
                        default: {
                            err = MBTK_INFO_ERR_FORMAT;
                            break;
                        }
                    }
                }
                break;
            }
            case MBTK_INFO_ID_NET_IMS_REQ:
            {
                if(pack->data_len == 0 || pack->data == NULL) //Get
                {
                    int reg = -1;
                    if(net_ims_get(&reg, &cme_err) || cme_err != MBTK_INFO_ERR_CME_NON)
                    {
                        if(cme_err != MBTK_INFO_ERR_CME_NON) {
                            err = MBTK_INFO_ERR_CME + cme_err;
                        } else {
                            err = MBTK_INFO_ERR_UNKNOWN;
                        }
                        LOG("Get net ims fail.");
                    }
                    else
                    {
                        uint8 reg_type = (uint8)reg;
                        pack_rsp_send(cli_info->fd, MBTK_INFO_ID_NET_IMS_RSP, &reg_type, sizeof(uint8));
                    }
                }
                else
                {
                    uint8 ims = *(pack->data);

                    if(net_ims_set(ims, &cme_err) || cme_err != MBTK_INFO_ERR_CME_NON)
                    {
                        if(cme_err != MBTK_INFO_ERR_CME_NON) {
                            err = MBTK_INFO_ERR_CME + cme_err;
                        } else {
                            err = MBTK_INFO_ERR_UNKNOWN;
                        }
                        LOG("Set net ims fail.");
                    }
                    else
                    {
                        pack_rsp_send(cli_info->fd, MBTK_INFO_ID_NET_IMS_RSP, NULL, 0);
                    }
                }
                break;
            }
            case MBTK_INFO_ID_NET_IMS_REG_STATE_REQ:
            {
                if(pack->data_len == 0 || pack->data == NULL) //Get
                {
                    int reg = -1;
                    if(net_ims_reg_state_get(&reg, &cme_err) || cme_err != MBTK_INFO_ERR_CME_NON)
                    {
                        if(cme_err != MBTK_INFO_ERR_CME_NON) {
                            err = MBTK_INFO_ERR_CME + cme_err;
                        } else {
                            err = MBTK_INFO_ERR_UNKNOWN;
                        }
                        LOG("Get net ims fail.");
                    }
                    else
                    {
                        uint8 reg_type = (uint8)reg;
                        pack_rsp_send(cli_info->fd, MBTK_INFO_ID_NET_IMS_REG_STATE_RSP, &reg_type, sizeof(uint8));
                    }
                }
                else
                {
                    err = MBTK_INFO_ERR_UNSUPPORTED;
                }
                break;
            }
            case MBTK_INFO_ID_WAKEUP_STA_REQ:
            {
                if(pack->data_len == 0 || pack->data == NULL)
                {
                    err = MBTK_INFO_ERR_UNSUPPORTED;
                    LOG("Get POWERIND state UNSUPPORTED.");
                }
                else     // Set powerind state.
                {
                    uint32 state = *(pack->data);
                    if(req_powerind_set(state, &cme_err) || cme_err != MBTK_INFO_ERR_CME_NON)
                    {
                        if(cme_err != MBTK_INFO_ERR_CME_NON) {
                            err = MBTK_INFO_ERR_CME + cme_err;
                        } else {
                            err = MBTK_INFO_ERR_UNKNOWN;
                        }
                        LOG("Set POWERIND state fail.");
                    }
                    else
                    {
                        pack_rsp_send(cli_info->fd, MBTK_INFO_ID_WAKEUP_STA_RSP, NULL, 0);
                    }
                }
                break;
            }
            case MBTK_INFO_ID_OOS_STA_REQ:
            {
                if(pack->data_len == 0 || pack->data == NULL)
                {
                    mbtk_oos_info oos_t;
                    if(req_oos_get(&oos_t, &cme_err) || cme_err != MBTK_INFO_ERR_CME_NON)
                    {
                        if(cme_err != MBTK_INFO_ERR_CME_NON) {
                            err = MBTK_INFO_ERR_CME + cme_err;
                        } else {
                            err = MBTK_INFO_ERR_UNKNOWN;
                        }
                        LOG("Get SMS OOS fail.");
                    }
                    else
                    {
                        pack_rsp_send(cli_info->fd, MBTK_INFO_ID_OOS_STA_RSP, &oos_t, sizeof(mbtk_oos_info));
                    }
                }
                else     // Set OOS
                {
                    mbtk_oos_info *state = (mbtk_oos_info *)pack->data;
                    if(pack->data_len != sizeof(mbtk_oos_info))
                    {
                        err = MBTK_INFO_ERR_REQ_PARAMETER;
                        LOG("Set oos error.");
                        break;
                    }

                    if(req_oos_set(state, &cme_err) || cme_err != MBTK_INFO_ERR_CME_NON)
                    {
                        if(cme_err != MBTK_INFO_ERR_CME_NON) {
                            err = MBTK_INFO_ERR_CME + cme_err;
                        } else {
                            err = MBTK_INFO_ERR_UNKNOWN;
                        }
                        LOG("Set OOS  fail.");
                    }
                    else
                    {
                        pack_rsp_send(cli_info->fd, MBTK_INFO_ID_OOS_STA_RSP, NULL, 0);
                    }
                }
                break;
            }
			case MBTK_INFO_ID_LED_REQ:
            {
                 if(pack->data_len == 0 || pack->data == NULL)
                {
                    err = MBTK_INFO_ERR_UNSUPPORTED;
                    LOGE("led param is error.");
                }
                else
                {
                    char type = pack->data[0];
                    char status = pack->data[1];
                    LOGE("[set_led] = [%d], [status_led] = [%d].", type, status);

                    if(type == MBTK_LED_TYPE_NET)
                    {
                        if(status == MBTK_LED_STATUS_CLOSE)
                        {
                            mbtk_net_led_set(MBTK_NET_LED_CLOSE);
                        }
                        else
                        {
                            mbtk_net_led_set(MBTK_NET_LED_OPEN);
                        }
                    }
                    else
                    {
                        if(status == MBTK_LED_STATUS_CLOSE)
                        {
                            status_led_set(MBTK_STATUS_LED_CLOSE);
                        }
                        else
                        {
                            status_led_set(MBTK_STATUS_LED_OPEN);
                        }
                    }
                    pack_rsp_send(cli_info->fd, MBTK_INFO_ID_LED_RSP, NULL, 0);
                }
                break;
            }
            default:
            {
                err = MBTK_INFO_ERR_REQ_UNKNOWN;
                LOG("Unknown request : %s", id2str(pack->info_id));
                break;
            }
        }

        return err;
    }
}

// Process AT URC data
static int send_pack_to_queue(sock_client_info_t* cli_info, void* pack)
{
    if(info_queue.count >= PACK_PROCESS_QUEUE_MAX)
    {
        LOG("Packet process queue is full");
        return -1;
    }

    info_queue_item_t *item = (info_queue_item_t*)malloc(sizeof(info_queue_item_t));
    if(!item)
    {
        LOG("malloc() fail[%d].", errno);
        return -1;
    }
    item->cli_info = cli_info;
    item->pack = pack;
    mbtk_queue_put(&info_queue, item);

    // If thread is waitting,continue it.
    if(1/*!is_running*/)
    {
        pthread_mutex_lock(&info_mutex);
        pthread_cond_signal(&info_cond);
        pthread_mutex_unlock(&info_mutex);
    }
    else
    {
        LOG("Packet process thread is process...");
    }

    return 0;
}

static void radio_state_change(void *data, int data_len)
{
    uint8 *data_ptr = (uint8*)data;
    if(data_ptr[0]) {
        net_info.radio_state = MBTK_RADIO_STATE_ON;
    } else {
        net_info.radio_state = MBTK_RADIO_STATE_OFF;
    }

    sock_client_info_t *cli = NULL;
    list_first(sock_client_list);
    while ((cli = (sock_client_info_t*) list_next(sock_client_list)))
    {
        if(cli->ind_num > 0) {
            int i;
            for(i = 0; i < IND_REGISTER_MAX; i++) {
                // Registe MBTK_INFO_ID_IND_RADIO_STATE_CHANGE
                if(cli->ind_register[i] == MBTK_INFO_ID_IND_RADIO_STATE_CHANGE) {
                    pack_rsp_send(cli->fd , MBTK_INFO_ID_IND_RADIO_STATE_CHANGE, data, data_len);
                    break;
                }
            }
        }
    }
}

static void pdp_state_change(void *data, int data_len)
{
    sock_client_info_t *cli = NULL;
    list_first(sock_client_list);
    while ((cli = (sock_client_info_t*) list_next(sock_client_list)))
    {
        if(cli->ind_num > 0) {
            int i;
            for(i = 0; i < IND_REGISTER_MAX; i++) {
                if(cli->ind_register[i] == MBTK_INFO_ID_IND_PDP_STATE_CHANGE) {
                    pack_rsp_send(cli->fd , MBTK_INFO_ID_IND_PDP_STATE_CHANGE, data, data_len);
                    break;
                }
            }
        }
    }
}

static void net_state_change(void *data, int data_len)
{
    sock_client_info_t *cli = NULL;
    list_first(sock_client_list);
    while ((cli = (sock_client_info_t*) list_next(sock_client_list)))
    {
        if(cli->ind_num > 0) {
            int i;
            for(i = 0; i < IND_REGISTER_MAX; i++) {
                // Registe MBTK_INFO_ID_IND_NET_STATE_CHANGE
                if(cli->ind_register[i] == MBTK_INFO_ID_IND_NET_STATE_CHANGE) {
                    pack_rsp_send(cli->fd , MBTK_INFO_ID_IND_NET_STATE_CHANGE, data, data_len);
                    break;
                }
            }
        }
    }
}

static void call_state_change(void *data, int data_len)
{
    sock_client_info_t *cli = NULL;
    list_first(sock_client_list);
    while ((cli = (sock_client_info_t*) list_next(sock_client_list)))
    {
        if(cli->ind_num > 0) {
            int i;
            for(i = 0; i < IND_REGISTER_MAX; i++) {
                // Registed MBTK_INFO_ID_IND_RADIO_STATE_CHANGE
                if(cli->ind_register[i] == MBTK_INFO_ID_IND_CALL_STATE_CHANGE) {
                    pack_rsp_send(cli->fd , MBTK_INFO_ID_IND_CALL_STATE_CHANGE, data, data_len);
                    break;
                }
            }
        }
    }
}

static void sim_state_change(void *data, int data_len)
{
    sock_client_info_t *cli = NULL;
    list_first(sock_client_list);
    while ((cli = (sock_client_info_t*) list_next(sock_client_list)))
    {
        if(cli->ind_num > 0) {
            int i;
            for(i = 0; i < IND_REGISTER_MAX; i++) {
                // Registed MBTK_INFO_ID_IND_RADIO_STATE_CHANGE
                if(cli->ind_register[i] == MBTK_INFO_ID_IND_SIM_STATE_CHANGE) {
                    pack_rsp_send(cli->fd , MBTK_INFO_ID_IND_SIM_STATE_CHANGE, data, data_len);
                    break;
                }
            }
        }
    }
}

static void sms_state_change(void *data, int data_len)
{
    sock_client_info_t *cli = NULL;
    list_first(sock_client_list);
    while ((cli = (sock_client_info_t*) list_next(sock_client_list)))
    {
        if(cli->ind_num > 0) {
            int i;
            for(i = 0; i < IND_REGISTER_MAX; i++) {
                // Registed MBTK_INFO_ID_IND_SMS_STATE_CHANGE
                if(cli->ind_register[i] == MBTK_INFO_ID_IND_SMS_STATE_CHANGE) {
                    pack_rsp_send(cli->fd , MBTK_INFO_ID_IND_SMS_STATE_CHANGE, data, data_len);
                    break;
                }
            }
        }
    }
}

static void signal_state_change(void *data, int data_len)
{
    sock_client_info_t *cli = NULL;
    list_first(sock_client_list);
    while ((cli = (sock_client_info_t*) list_next(sock_client_list)))
    {
        if(cli->ind_num > 0) {
            int i;
            for(i = 0; i < IND_REGISTER_MAX; i++) {
                // Registe MBTK_INFO_ID_IND_SIGNAL_STATE_CHANGE
                if(cli->ind_register[i] == MBTK_INFO_ID_IND_SIGNAL_STATE_CHANGE) {
                    pack_rsp_send(cli->fd , MBTK_INFO_ID_IND_SIGNAL_STATE_CHANGE, data, data_len);
                    break;
                }
            }
        }
    }
}


int urc_msg_distribute(bool async_process, info_urc_msg_id_enum msg, void *data, int data_len)
{
#if 0
    if(urc_queue.count >= PACK_PROCESS_QUEUE_MAX)
    {
        LOG("Packet process queue is full");
        return -1;
    }

    info_urc_msg_t *urc = (info_urc_msg_t*)malloc(sizeof(info_urc_msg_t));
    if(!urc)
    {
        LOG("malloc() fail[%d].", errno);
        return -1;
    }
    urc->msg = msg;
    urc->data = memdup(data, data_len);
    urc->data_len = data_len;

    mbtk_queue_put(&urc_queue, urc);

    // If thread is waitting,continue it.
    if(1/*!is_running*/)
    {
        pthread_mutex_lock(&urc_mutex);
        pthread_cond_signal(&urc_cond);
        pthread_mutex_unlock(&urc_mutex);
    }
    else
    {
        LOG("Packet process thread is process...");
    }

    return 0;
#else
    if(async_process) {
        info_urc_msg_t *urc = (info_urc_msg_t*)malloc(sizeof(info_urc_msg_t));
        if(!urc)
        {
            LOG("malloc() fail[%d].", errno);
            return -1;
        }
        urc->msg = msg;
        if(data && data_len > 0) {
            urc->data = memdup(data, data_len);
            urc->data_len = data_len;
        } else {
            urc->data = NULL;
            urc->data_len = 0;
        }
        return send_pack_to_queue(NULL, urc);
    } else {
        switch(msg) {
            case INFO_URC_MSG_NET_CS_REG_STATE:
            {
                net_state_change(data, data_len);
                break;
            }
            case INFO_URC_MSG_CALL_STATE:
            {
                call_state_change(data, data_len);
                break;
            }
            case INFO_URC_MSG_SMS_STATE:
            {
                sms_state_change(data, data_len);
                break;
            }
            case INFO_URC_MSG_SIM_STATE:
            {
                sim_state_change(data, data_len);
                break;
            }
            case INFO_URC_MSG_PDP_STATE:
            {
                pdp_state_change(data, data_len);
                break;
            }
            default: {
                LOGE("Unknown msg : %d", msg);
                break;
            }
        }

        return 0;
    }
#endif
}


static void ind_regisger(sock_client_info_t* cli_info, uint16 ind)
{
    uint32 i = 0;
    while(i < cli_info->ind_num)
    {
        if(cli_info->ind_register[i] == ind)
            break;
        i++;
    }

    if(i == cli_info->ind_num)   // No found IND
    {
        cli_info->ind_register[i] = ind;
        cli_info->ind_num++;
        LOG("Register IND : %s", id2str(ind));
    }
    else
    {
        LOG("IND had exist.");
    }
}

static void pack_distribute(sock_client_info_t* cli_info, mbtk_info_pack_t* pack)
{
    // Register IND Message.
    if(mbtk_info_type_get(pack->info_id) == MBTK_INFO_TYPE_IND)
    {
        mbtk_info_err_enum err = MBTK_INFO_ERR_SUCCESS;
        if(cli_info->ind_num >= IND_REGISTER_MAX)
        {
            LOG("IND if full.");
            err = MBTK_INFO_ERR_IND_FULL;
        }
        else
        {
            ind_regisger(cli_info, pack->info_id);
        }

        pack_error_send(cli_info->fd, pack->info_id, err);

        mbtk_info_pack_free(&pack);
    }
    else     // Request Information.
    {
        LOG("Start process REQ(%s), Length : %d", id2str(pack->info_id), pack->data_len);
        if(0 && pack->data_len > 0)
        {
            log_hex("DATA", pack->data, pack->data_len);
        }

        // Send to REQ_process_thread process.
        send_pack_to_queue(cli_info, pack);

        // For test.
        // pack_error_send(cli_info->fd, pack->info_id + 1, MBTK_INFO_ERR_SUCCESS);
    }
}

static sock_client_info_t* cli_find(int fd)
{
    sock_client_info_t *result = NULL;
    list_first(sock_client_list);
    while ((result = (sock_client_info_t*) list_next(sock_client_list)))
    {
        if (result->fd == fd)
            return result;
    }

    return NULL;
}

//mbtk wyq for server_ready_status add start
void server_ready_set(void)
{
    server_ready_status = 1;
}

char server_ready_get(void)
{
    return server_ready_status;
}

static void server_state_send(void)
{
    sock_client_info_t *cli = NULL;
    list_first(sock_client_list);
    while ((cli = (sock_client_info_t*) list_next(sock_client_list)))
    {
        if(cli->ind_num > 0) {
            if(cli->ind_register[0] == MBTK_INFO_ID_IND_SERVER_STATE_CHANGE) {
                cli->ind_num = 0;
                cli->ind_register[0] = 0;
                pack_rsp_send(cli->fd , MBTK_INFO_ID_IND_SERVER_STATE_CHANGE, "1", 1);
                break;
            }
        }
        else
        {
            break;
        }
    }
    LOG("handshake message send ok.");
}

//mbtk wyq for server_ready_status add end

//mbtk wyq for data_call_ex add start
//Save the cid that "DATA_CALL" needs to be automatically connected after startup
void data_call_bootconn_save(int cid, int bootconn)
{
    if(cid_bootconn[cid] == bootconn + '0')
    {
        return;
    }
    cid_bootconn[cid] = bootconn + '0';

    LOG("data_call_bootconn_set cid_bootconn = %s", cid_bootconn);
    property_set("persist.mbtk.datacall.bootconn", cid_bootconn);
}

static void* data_call_bootconn_pthread(void *arg)
{
    UNUSED(arg);
    LOG("data_call_bootconn_pthread enter.");
    int i = 0;
    int send_sum = 0;
    int bootconn = 0;

    while(1)
    {
        if(server_ready_get() && send_sum == 0)
        {
            server_state_send();
            send_sum = 1;
        }

        if(net_info.sim_state == MBTK_SIM_READY && net_info.net_type == MBTK_RADIO_TECH_E_UTRAN && bootconn == 0)
        {
            //data_call_bootconn_exec();
            property_get("persist.mbtk.datacall.bootconn", cid_bootconn, "00000000");
            LOG("data_call_bootconn_exec cid_bootconn = %s", cid_bootconn);

            for(i = MBTK_APN_CID_MIN; i < MBTK_APN_CID_MAX + 1; i++)
            {
                if(cid_bootconn[i] == '1')
                {
                        sock_client_info_t *info = (sock_client_info_t*)malloc(sizeof(sock_client_info_t));
                        if(info == NULL)
                        {
                            LOG("clinent_info  malloc() fail.");
                            continue;
                        }
                        memset(info, 0, sizeof(sock_client_info_t));
                        info->fd = DATA_CALL_BOOTCONN_FD;

                        mbtk_info_pack_t* pack = mbtk_info_pack_creat(MBTK_INFO_ID_NET_DATA_CALL_REQ);
                        if(pack == NULL)
                        {
                            free(info);
                            LOG("Packet malloc() fail.");
                            continue;
                        }

                        // "info_err"
                        //pack->info_err = byte_2_uint16(ptr, false)

                        // "data_len"
                        pack->data_len = 5;

                        char *p = (char *)malloc(5);
                        p[0] = MBTK_DATA_CALL_START;
                        p[1] = i;
                        p[2] = 0;
                        p[3] = 1;
                        p[4] = 10;
                        pack->data = p;
                        send_pack_to_queue(info, pack);
                }
            }

            bootconn = 1;
        }

        if(bootconn == 1 && send_sum == 1)
        {
            break;
        }
        else
        {
            sleep(1);
        }
    }

    LOG("data_call_bootconn_pthread exit.");
    return NULL;
}

//mbtk wyq for data_call_ex add end

static void* info_main_pthread(void* arg)
{
    UNUSED(arg);
    epoll_fd = epoll_create(SOCK_CLIENT_MAX + 1);
    if(epoll_fd < 0)
    {
        LOG("epoll_create() fail[%d].", errno);
        return NULL;
    }

    uint32 event = EPOLLIN | EPOLLET;
    struct epoll_event ev;
    ev.data.fd = sock_listen_fd;
    ev.events = event; //EPOLLIN | EPOLLERR | EPOLLET;
    epoll_ctl(epoll_fd,EPOLL_CTL_ADD,sock_listen_fd,&ev);

    int nready = -1;
    struct epoll_event epoll_events[EPOLL_LISTEN_MAX];
    while(1)
    {
        nready = epoll_wait(epoll_fd, epoll_events, EPOLL_LISTEN_MAX, -1);
        if(nready > 0)
        {
            sock_client_info_t *cli_info = NULL;
            int i;
            for(i = 0; i < nready; i++)
            {
                LOG("fd[%d] event = %x",epoll_events[i].data.fd, epoll_events[i].events);
                if(epoll_events[i].events & EPOLLHUP)   // Client Close.
                {
                    if((cli_info = cli_find(epoll_events[i].data.fd)) != NULL)
                    {
                        cli_close(cli_info);
                    }
                    else
                    {
                        LOG("Unknown client[fd = %d].", epoll_events[i].data.fd);
                    }
                }
                else if(epoll_events[i].events & EPOLLIN)
                {
                    if(epoll_events[i].data.fd == sock_listen_fd)   // New clients connected.
                    {
                        int client_fd = -1;
                        while(1)
                        {
                            struct sockaddr_in cliaddr;
                            socklen_t clilen = sizeof(cliaddr);
                            client_fd = accept(epoll_events[i].data.fd, (struct sockaddr *) &cliaddr, &clilen);
                            if(client_fd < 0)
                            {
                                if(errno == EAGAIN)
                                {
                                    LOG("All client connect get.");
                                }
                                else
                                {
                                    LOG("accept() error[%d].", errno);
                                }
                                break;
                            }
                            // Set O_NONBLOCK
                            int flags = fcntl(client_fd, F_GETFL, 0);
                            if (flags > 0)
                            {
                                flags |= O_NONBLOCK;
                                if (fcntl(client_fd, F_SETFL, flags) < 0)
                                {
                                    LOG("Set flags error:%d", errno);
                                }
                            }

                            memset(&ev,0,sizeof(struct epoll_event));
                            ev.data.fd = client_fd;
                            ev.events = event;//EPOLLIN | EPOLLERR | EPOLLET;
                            epoll_ctl(epoll_fd, EPOLL_CTL_ADD, client_fd, &ev);

                            sock_client_info_t *info = (sock_client_info_t*)malloc(sizeof(sock_client_info_t));
                            if(info)
                            {
                                memset(info, 0, sizeof(sock_client_info_t));
                                info->fd = client_fd;
                                if(server_ready_get() == 1)
                                {
                                    info->ind_num = 0;
                                    pack_rsp_send(info->fd , MBTK_INFO_ID_IND_SERVER_STATE_CHANGE, "1", 1);
                                    LOG("server ready ok.");
                                }
                                else
                                {
                                    info->ind_num = 1;
                                    info->ind_register[0] = MBTK_INFO_ID_IND_SERVER_STATE_CHANGE;
                                    LOG("server ready no.");
                                }
                                list_add(sock_client_list, info);
                                LOG("Add New Client FD Into List.");
                            }
                            else
                            {
                                LOG("malloc() fail.");
                            }
                        }
                    }
                    else if((cli_info = cli_find(epoll_events[i].data.fd)) != NULL)    // Client data arrive.
                    {
                        // Read and process every message.
                        mbtk_info_err_enum err = MBTK_INFO_ERR_SUCCESS;
                        mbtk_info_pack_t** pack = mbtk_info_pack_recv(cli_info->fd, true, &err);

                        // Parse packet error,send error response to client.
                        if(pack == NULL)
                        {
                            if(err != MBTK_INFO_ERR_SUCCESS)
                            {
                                pack_error_send(cli_info->fd, MBTK_INFO_ID_REQ_UNKNOWN, err);
                            }
                        }
                        else
                        {
#if 0
                            int i = 0;
                            while(pack[i] != NULL)
                            {
                                pack_distribute(cli_info, pack[i]);
                                // Not free,will free in pack_process() or packet process thread.
                                //mbtk_info_pack_free(&(pack[i]));
                                i++;
                            }
                            free(pack);
#else
                            mbtk_info_pack_t** pack_ptr = pack;
                            while(*pack_ptr)
                            {
                                pack_distribute(cli_info, *pack_ptr);
                                // Not free,will free in pack_process() or packet process thread.
                                //mbtk_info_pack_free(pack_ptr);
                                pack_ptr++;
                            }

                            free(pack);
#endif
                        }
                    }
                    else
                    {
                        LOG("Unknown socket : %d", epoll_events[i].data.fd);
                    }
                }
                else
                {
                    LOG("Unknown event : %x", epoll_events[i].events);
                }
            }
        }
        else
        {
            LOG("epoll_wait() fail[%d].", errno);
        }
    }

    return NULL;
}

/*
void mbtk_radio_ready_cb()
{
    pthread_t radio_pid;
    pthread_attr_t thread_attr;
    pthread_attr_init(&thread_attr);
    if(pthread_attr_setdetachstate(&thread_attr, PTHREAD_CREATE_DETACHED))
    {
        LOG("pthread_attr_setdetachstate() fail.");
        return;
    }

    if(pthread_create(&radio_pid, &thread_attr, radio_ready_thread, NULL))
    {
        LOG("pthread_create() fail.");
    }

    pthread_attr_destroy(&thread_attr);
}
*/

static void net_ifc_state_change(bool act, int cid)
{
    if(cid < MBTK_APN_CID_MIN || cid > MBTK_APN_CID_MAX) { // No nothing for cid 1 and 8
        return;
    }

#if 0
    if(act)
    {
        cid_active[cid] = 1;
        mbtk_set_default_pdp_state(true, cid);
    }
    else
    {
        cid_active[cid] = 0;
        mbtk_set_default_pdp_state(false, cid);
    }
#endif
    char dev[20] = {0};
    sprintf(dev, "ccinet%d", cid - 1);
    if(act) { // Config IP.
        // Get IP information.
        mbtk_ipv4_info_t ipv4;
        mbtk_ipv6_info_t ipv6;
        memset(&ipv4, 0, sizeof(mbtk_ipv4_info_t));
        memset(&ipv6, 0, sizeof(mbtk_ipv6_info_t));
        int cme_err = MBTK_INFO_ERR_CME_NON;
        if(!req_data_call_state_get(cid, &ipv4, &ipv6, &cme_err) && cme_err == MBTK_INFO_ERR_CME_NON)
        {
#ifdef MBTK_AF_SUPPORT
            if(cid == 1)
            {
                ipv4.valid = false;
                ipv6.valid = false;
                if(default_iptype == MBTK_IP_TYPE_IP)
                {
                    ipv4.valid = true;
                }
                else if(default_iptype == MBTK_IP_TYPE_IPV6)
                {
                    ipv6.valid = true;
                }
                else
                {
                    ipv4.valid = true;
                    ipv6.valid = true;
                }
            }
#endif
            // Config IPv4 address.
            if(ipv4.valid) {
                char ip[20] = {0};
                if(inet_ntop(AF_INET, &(ipv4.IPAddr), ip, 20) == NULL) {
                    LOGE("inet_ntop ipv4 ip fail.");
                    return;
                }

                if(mbtk_ifc_configure2(dev, ip, 0, NULL, "255.255.255.0")) {
                    LOGD("Config %s IPv4 %s fail.", dev, ip);
                } else {
                    LOGD("Config %s IPv4 %s success.", dev, ip);
                }
            }

            // Config IPv6 address.
            if(ipv6.valid) {
                char ip[50] = {0};

                if(inet_ntop(AF_INET6, &(ipv6.IPV6Addr), ip, 50) == NULL) {
                    LOGE("inet_ntop ipv6 ip fail.");
                    return;
                }

                if(mbtk_ipv6_config(dev, ip, 64)) {
                    LOGD("Config %s IPv6 %s fail.", dev, ip);
                } else {
                    LOGD("Config %s IPv6 %s success.", dev, ip);
                }
            }

            mbtk_qser_route_config(cid, &ipv4, &ipv6);
        }
    } else { // Del IP
        if(mbtk_ifc_configure2(dev, NULL, 0, NULL, NULL)) {
            LOGD("Config %s IPv4 0 fail.", dev);
        } else {
            LOGD("Config %s IPv4 0 success.", dev);
        }
    }
}

static void data_call_restart()
{
#if 0
    // Waitting for network ok.
    mbtk_net_info_t info;
    int cme_err;
    int i = 0;
    while(i < 15) { // 15s timeout
        cme_err = MBTK_INFO_ERR_CME_NON;
        memset(&info, 0, sizeof(mbtk_net_info_t));
        if(!req_net_sel_mode_get(&info, &cme_err) && cme_err == MBTK_INFO_ERR_CME_NON)
        {
            if(info.net_type >= 2) {
                break;
            }
        }

        sleep(1);
        i++;
    }
#endif
    // +CGACT
    int cid;
    uint8 data_pdp = 0;
    LOGD("Start active APN.");
    at_process = true;
    cgact_wait.act = true;
    for(cid = MBTK_APN_CID_MIN; cid <= MBTK_APN_CID_MAX; cid++) {
        if(cid_active[cid])
        {
            LOG("Active cid : %d", cid);
            cgact_wait.waitting = true;
            cgact_wait.cid = cid;
            net_ifc_state_change(false, cid);
            data_pdp = cid + 100;
            urc_msg_distribute(false, INFO_URC_MSG_PDP_STATE, &data_pdp, sizeof(uint8));
            req_data_call_start(cid, NULL);
            wait_cgact_complete(10);
            net_ifc_state_change(true, cid);
            data_pdp = cid + 220;
            urc_msg_distribute(false, INFO_URC_MSG_PDP_STATE, &data_pdp, sizeof(uint8));
        }
    }
    at_process = false;
}

static void urc_msg_process(info_urc_msg_t *msg)
{
    uint8 *data = NULL;
    if(msg->data) {
        data = (uint8*)msg->data;
    }
    switch(msg->msg) {
        case INFO_URC_MSG_RADIO_STATE:
        {
            radio_state_change(msg->data, msg->data_len);
            // Reconfig APN while radio on.
            if(data[0]) {
                apn_prop_get();
            }
            break;
        }
        case INFO_URC_MSG_CGEV:
        {
            bool act = data[0];
            int cid = data[1];
            if(cid > 0) {
                net_ifc_state_change(act, cid);
            }
            break;
        }
        case INFO_URC_MSG_NET_PS_REG_STATE:
        {
            uint8 net_data[4];
            net_data[0] = (uint8)MBTK_NET_PS_STATE;
            net_data[1] = data[0]; // act
            net_data[3] = data[1]; // 0 - GSM/WCDMA; 1 - LTE
            mbtk_net_reg_state_enum state = (mbtk_net_reg_state_enum)data[0];
            if(state == MBTK_NET_REG_STATE_HOME
                || state == MBTK_NET_REG_STATE_ROAMING) { // Registered, home network or roaming.
                mbtk_net_info_t info;
                int cme_err = MBTK_INFO_ERR_CME_NON;
                memset(&info, 0, sizeof(mbtk_net_info_t));
                if(!req_net_sel_mode_get(&info, &cme_err) && cme_err == MBTK_INFO_ERR_CME_NON)
                {
                    net_data[2] = info.net_type;
                    net_state_change(net_data, sizeof(net_data));

                    if(info.net_type >= MBTK_RADIO_TECH_UTRAN) {
                        data_call_restart();
                    }
                } else {
                    net_data[2] = (uint8)0xFF;
                    net_state_change(net_data, sizeof(net_data));
                }
            } else {
                net_data[2] = (uint8)0xFF;
                net_state_change(net_data, sizeof(net_data));
            }
            break;
        }
        case INFO_URC_MSG_SET_BAND:
        {
            mbtk_band_info_t band;
            int cme_err = MBTK_INFO_ERR_CME_NON;

            band.net_pref = MBTK_NET_PREF_GSM_UMTS_LTE_LTE_PREF;  // 15
            band.gsm_band = (uint16)band_set_info.band_gsm;
            band.umts_band = (uint16)band_set_info.band_wcdma;
            band.tdlte_band = band_set_info.band_tdlte;
            band.fddlte_band = band_set_info.band_fddlte;
            band.lte_ext_band = band_set_info.band_lte_ext;

            if(req_band_set(&band, &cme_err) || cme_err != MBTK_INFO_ERR_CME_NON)
            {
                LOG("Set band fail.");
            }
            else // Set band success.
            {
                // log_hex("BAND-2", &band_set_info, sizeof(band_set_info_t));
                band_set_success = TRUE;
                if(band_area == MBTK_MODEM_BAND_AREA_CN) {
                    property_set("persist.mbtk.band_config", "CN");
                } else if(band_area == MBTK_MODEM_BAND_AREA_EU) {
                    property_set("persist.mbtk.band_config", "EU");
                } else if(band_area == MBTK_MODEM_BAND_AREA_SA) {
                    property_set("persist.mbtk.band_config", "SA");
                } else {
                    property_set("persist.mbtk.band_config", "ALL");
                }
                LOG("Set band success.");
            }
            break;
        }
        case INFO_URC_MSG_GET_SIM_STATE:
        {
            net_info.sim_state = getSIMStatus();
            if(net_info.sim_state == MBTK_SIM_READY)
            {
                LOG("SIM READY!");
            }
            else
            {
                LOG("SIM NOT READY!");
            }
            break;
        }
        case INFO_URC_MSG_NET_STATE_LOG:
        {
            // Get network state and signal.
            char buff[256] = {0};
            uint8 data_signal[8];
            mbtk_signal_info_t signal;
            memset(&signal, 0xFF, sizeof(mbtk_signal_info_t));
            if(!req_net_signal_get(&signal, NULL)) {
                char tmp[50] = {0};
                struct timeval log_time;
                gettimeofday(&log_time, NULL);
                struct tm* tm_t = localtime(&(log_time.tv_sec));
                strftime(tmp, 50, "%F %T", tm_t);
                snprintf(buff, sizeof(buff), "%s:%d,%d,%d,%d,%d,%d,%d,%d", tmp, signal.type, signal.rssi, signal.rxlev, signal.ber, signal.rscp, signal.ecno,
                    signal.rsrq, signal.rsrp);
                mbtk_signal_log(buff);
            }

            if(signal_globe.type != signal.type)
            {
                data_signal[0] = signal.type;
                data_signal[1] = signal.rssi;
                data_signal[2] = signal.rxlev;
                data_signal[3] = signal.ber;
                data_signal[4] = signal.rscp;
                data_signal[5] = signal.ecno;
                data_signal[6] = signal.rsrq;
                data_signal[7] = signal.rsrp;
                signal_globe.type = signal.type;
                signal_state_change(data_signal, sizeof(data_signal));
            }
            break;
        }
        default:
        {
            LOGE("Unknown URC : %d", msg->msg);
            break;
        }
    }
}

static void* pack_process_thread(void* arg)
{
    UNUSED(arg);
    info_queue_item_t* item = NULL;
    mbtk_queue_init(&info_queue);
    pthread_mutex_init(&info_mutex, NULL);
    pthread_cond_init(&info_cond, NULL);

    memset(&band_support, 0xFF, sizeof(mbtk_band_info_t));

    pthread_mutex_lock(&info_mutex);
    while(TRUE)
    {
        if(mbtk_queue_empty(&info_queue))
        {
            LOG("Packet process wait...");
            pthread_cond_wait(&info_cond, &info_mutex);
            LOG("Packet process continue...");
        }
        else
        {
            LOG("Packet process queue not empty,continue...");
        }

        // Process all information request.
        mbtk_info_err_enum err;
        while((item = (info_queue_item_t*)mbtk_queue_get(&info_queue)) != NULL)
        {
            if(item->cli_info) { // REQ form client.
                mbtk_info_pack_t *pack = (mbtk_info_pack_t*)item->pack;
                LOG("Process REQ %s.", id2str(pack->info_id));
                at_process = true;
                err = pack_req_process(item->cli_info, pack);
                if(err != MBTK_INFO_ERR_SUCCESS)
                {
                    if(item->cli_info->fd != DATA_CALL_BOOTCONN_FD)
                    {
                        pack_error_send(item->cli_info->fd, pack->info_id + 1, err);
                    }
                    else
                    {
                        if(pack->data != NULL)
                        {
                            free(pack->data);
                        }
                        if(item->cli_info)
                        {
                            free(item->cli_info);
                        }
                    }
                }
                at_process = false;
                mbtk_info_pack_free(&pack);
                free(item);
            } else { // REQ from myself.
                info_urc_msg_t *urc = (info_urc_msg_t*)item->pack;
                LOG("Process URC %d.", urc->msg);
                urc_msg_process(urc);
                if(!urc->data)
                    free(urc->data);
                free(urc);
            }
        }
    }
    pthread_mutex_unlock(&info_mutex);
    return NULL;
}

void apn_prop_get()
{
    char prop_name[20];
    char prop_data[300];
    // cid : 2 - 7
    int cid = MBTK_APN_CID_MIN;
    mbtk_apn_info_t apn;
    for(; cid <= MBTK_APN_CID_MAX; cid++) {
        memset(prop_name, 0, 20);
        memset(prop_data, 0, 300);
        memset(&apn, 0, sizeof(mbtk_apn_info_t));
        sprintf(prop_name, "%s_%d",MBTK_APN_PROP,cid);
        if(property_get(prop_name, prop_data, "") > 0 && !str_empty(prop_data)) {
            apn.cid = cid;
            char *ptr_1 = prop_data;
            apn.ip_type = (mbtk_ip_type_enum)atoi(ptr_1);
            ptr_1 = strstr(ptr_1, ",");
            if(!ptr_1) {
                continue;
            }
            ptr_1++; // Jump ',' to apn

            char *ptr_2 = strstr(ptr_1, ",");
            if(!ptr_2) {
                continue;
            }
            memcpy(apn.apn, ptr_1, ptr_2 - ptr_1); // apn

            ptr_2++; // Jump ',' to user
            ptr_1 = strstr(ptr_2, ",");
            if(!ptr_1) {
                continue;
            }
            if(memcmp(ptr_2, "NULL", 4)) { // Not "NULL"
                memcpy(apn.user, ptr_2, ptr_1 - ptr_2); // user
            }

            ptr_1++; // Jump ',' to pass
            ptr_2 = strstr(ptr_1, ",");
            if(!ptr_2) {
                continue;
            }
            if(memcmp(ptr_1, "NULL", 4)) { // Not "NULL"
                memcpy(apn.pass, ptr_1, ptr_2 - ptr_1); // pass
            }

            ptr_2++; // Jump ',' to auth (Is last item)
            if(memcmp(ptr_2, "NULL", 4)) { // Not "NULL"
                memcpy(apn.auth, ptr_2, strlen(ptr_2)); // auth
            }

            req_apn_set(&apn, NULL);
        }
    }
}

/*
root@OpenWrt:/usrdata# cat /proc/mtd
dev:    size   erasesize  name
mtd0: 00040000 00020000 "bootloader"
mtd1: 00020000 00020000 "cp_reliabledata"
mtd2: 00020000 00020000 "ap_reliabledata"
mtd3: 00020000 00020000 "cp_reliabledata_backup"
mtd4: 00020000 00020000 "ap_reliabledata_backup"
mtd5: 00020000 00020000 "mep-ota"
mtd6: 00020000 00020000 "mep-ota_backup"
mtd7: 00040000 00020000 "dtim"
mtd8: 00f40000 00020000 "cpimage"
mtd9: 000c0000 00020000 "u-boot"
mtd10: 00500000 00020000 "kernel"
mtd11: 00100000 00020000 "asr_flag"
mtd12: 01400000 00020000 "rootfs"
mtd13: 01400000 00020000 "oem_data"
mtd14: 01e00000 00020000 "OTA"
mtd15: 01400000 00020000 "rootfs_data"
mtd16: 081a0000 00020000 "user_data"
mtd17: 00d20000 00020000 "MRVL_BBM"
*/
static int partition_name_2_dev(const char *name, char *dev) {
    if(name == NULL || dev == NULL) {
        LOGE("ARG error.");
		return -1;
    }

    int fp = fopen("/proc/mtd", "r");
	if (fp == NULL) {
		LOGE("Open MTD failed!");
		return -1;
	}

    char buf[1024];
	while (fgets(buf, 1024, fp) != NULL) {
		if(strstr(buf, name)) {
            int index = atoi(buf + 3);
            sprintf(dev, "/dev/mtdblock%d", index);
            LOGD("%s -> %s", name, dev);
            return 0;
		}
	}

    return -1;
}

static int custom_partition_read(const char *name, mbtk_cust_info_t *cust_info)
{
    int fd = 0, ret = 0;
    unsigned int step = 0, offset = 0, flaglen = 0;
    flaglen = sizeof(mbtk_cust_info_t);

    char mtd_path[50] = {0};
    if(partition_name_2_dev(name, mtd_path)) {
        LOGE("partition_name_2_dev() failed!");
        return -1;
    }

    fd = open(mtd_path, O_RDONLY);
    if (fd < 0) {
        LOGE("Fatal error: can't open cust info %s\n", mtd_path);
        return -1;
    }

    if (read(fd, cust_info, flaglen) < 0)
        goto error;
    if (cust_info->header != CUST_INFO_HEADER) {
        LOGE("Cust info partition error.");
        goto error;
    } else {
        if(cust_info->band_type == 1) { // CN
            LOGD("Band : CN");
        } else if(cust_info->band_type == 2) { // EU
            LOGD("Band : EU");
        } else {
            LOGE("Unknown band type:%d", cust_info->band_type);
            goto error;
        }
    }
    close(fd);
    return 0;
error:
    close(fd);
    return -1;
}

/*
AT*BAND=15,78,147,482,134742231

OK
*/
static void* band_config_thread()
{
    mbtk_device_info_modem_t info_modem;
    memset(&band_set_info, 0, sizeof(band_set_info_t));
    memset(&info_modem, 0, sizeof(mbtk_device_info_modem_t));
    band_set_success = FALSE;
    if(mbtk_dev_info_read(MBTK_DEVICE_INFO_ITEM_MODEM, &(info_modem), sizeof(mbtk_device_info_modem_t))) {
        LOGD("mbtk_dev_info_read(MODEM) fail, use default band.");
        band_area = MBTK_MODEM_BAND_AREA_ALL;
        band_set_info.band_gsm = MBTK_BAND_ALL_GSM_DEFAULT;
        band_set_info.band_wcdma = MBTK_BAND_ALL_WCDMA_DEFAULT;
        band_set_info.band_tdlte = MBTK_BAND_ALL_TDLTE_DEFAULT;
        band_set_info.band_fddlte = MBTK_BAND_ALL_FDDLTE_DEFAULT;
        band_set_info.band_lte_ext = MBTK_BAND_ALL_EXT_LTE_DEFAULT;
    } else {
        band_area = info_modem.band_area;
        band_set_info.band_gsm = info_modem.band_gsm;
        band_set_info.band_wcdma = info_modem.band_wcdma;
        band_set_info.band_tdlte = info_modem.band_tdlte;
        band_set_info.band_fddlte = info_modem.band_fddlte;
        band_set_info.band_lte_ext = info_modem.band_lte_ext;
    }

    bool is_first = TRUE;
    while(!band_set_success) {
        info_urc_msg_t *urc = (info_urc_msg_t*)malloc(sizeof(info_urc_msg_t));
        if(!urc)
        {
            LOG("malloc() fail[%d].", errno);
            break;
        } else {
            urc->msg = INFO_URC_MSG_SET_BAND;
            urc->data = NULL;
            urc->data_len = 0;
            send_pack_to_queue(NULL, urc);

            if(is_first) {
                is_first = FALSE;
            } else {
                LOGE("*BAND exec error, will retry in 5s.");
            }
            sleep(5);
        }
    }

    LOGD("Set Band thread exit.");
    return NULL;
}

static void* net_monitor_thread(void* arg)
{
    UNUSED(arg);
    // Start network monitor
    int cid;
    while(1) {
#if 0
        // Config IP
        list_node_t* apn_list = NULL;
        if(!apn_state_get(&apn_list) && apn_list != NULL) {
            info_apn_ip_t *apn = NULL;
            for(cid = MBTK_APN_CID_MIN; cid <= MBTK_APN_CID_MAX && cid_active[cid]; cid++) {
                bool ip_found = false;
                list_first(apn_list);
                while ((apn = (info_apn_ip_t*) list_next(apn_list))) {
                    if(cid == apn->cid) {
                        ip_found = true;
                        break;
                    }
                }

                char dev[20] = {0};
                sprintf(dev, "ccinet%d", cid - 1);
                if(ip_found) { // Ip ok,set IP.
                    if(apn->ipv4_valid) {
                        if(mbtk_ifc_configure2(dev, (char*)apn->ipv4, 0, NULL, "255.255.255.0")) {
                            LOGD("Config %s IPv4 %s fail.", dev, apn->ipv4);
                        } else {
                            LOGD("Config %s IPv4 %s success.", dev, apn->ipv4);
                        }
                    }

                    if(apn->ipv6_valid) {
                        if(mbtk_ipv6_config(dev, (char*)apn->ipv6, 64)) {
                            LOGD("Config %s IPv6 %s fail.", dev, apn->ipv6);
                        } else {
                            LOGD("Config %s IPv6 %s success.", dev, apn->ipv6);
                        }
                    }
                } else { // No ip
                    if(mbtk_ifc_configure2(dev, NULL, 0, NULL, NULL)) {
                        LOGD("Config %s IPv4 0 fail.", dev);
                    } else {
                        LOGD("Config %s IPv4 0 success.", dev);
                    }
                }
            }

            list_free(apn_list);
        }
#endif

        if(net_info.radio_state == MBTK_RADIO_STATE_ON && net_info.sim_state == MBTK_SIM_READY) {
#if 0
            urc_msg_distribute(true, INFO_URC_MSG_NET_CS_REG_STATE, NULL, 0);
#else
            info_urc_msg_t *urc = (info_urc_msg_t*)malloc(sizeof(info_urc_msg_t));
            if(!urc)
            {
                LOG("malloc() fail[%d].", errno);
            } else {
                urc->msg = INFO_URC_MSG_NET_STATE_LOG;
                urc->data = NULL;
                urc->data_len = 0;
                send_pack_to_queue(NULL, urc);
            }
#endif
            sleep(15);
        }
        else
        {
            info_urc_msg_t *urc = (info_urc_msg_t*)malloc(sizeof(info_urc_msg_t));
            if(!urc)
            {
                LOG("malloc() fail[%d].", errno);
            }
            else
            {
                urc->msg = INFO_URC_MSG_GET_SIM_STATE;
                urc->data = NULL;
                urc->data_len = 0;
                send_pack_to_queue(NULL, urc);
            }
            sleep(2);
        }
    }

    LOGD("monitor_thread exit.");
    return NULL;
}

static void* urc_process_thread(void* arg)
{
    UNUSED(arg);
    info_urc_msg_t* item = NULL;
    mbtk_queue_init(&urc_queue);
    pthread_mutex_init(&urc_mutex, NULL);
    pthread_cond_init(&urc_cond, NULL);

    pthread_mutex_lock(&urc_mutex);
    while(TRUE)
    {
        if(mbtk_queue_empty(&urc_queue))
        {
            LOG("URC process wait...");
            pthread_cond_wait(&urc_cond, &urc_mutex);
            LOG("URC process continue...");
        }
        else
        {
            LOG("URC process queue not empty,continue...");
        }

        // Process all information request.
        while((item = (info_urc_msg_t*)mbtk_queue_get(&urc_queue)) != NULL)
        {
            LOG("Process URC %d.", item->msg);
            uint8 *data = (uint8*)item->data;
            switch(item->msg) {
                case INFO_URC_MSG_RADIO_STATE:
                {
                    radio_state_change(item->data, item->data_len);
                    break;
                }
                case INFO_URC_MSG_CGEV:
                {
                    bool act = data[0];
                    int cid = data[1];
                    if(cid > 0) {
                        net_ifc_state_change(act, cid);
                    }
                    break;
                }
                default:
                {
                    LOGE("Unknown URC : %d", item->msg);
                    break;
                }
            }
            if(!item->data)
                free(item->data);
            free(item);
        }
    }
    pthread_mutex_unlock(&urc_mutex);

    return NULL;
}

static void ril_at_ready_process()
{
    net_info.radio_state = (isRadioOn() == 1) ? MBTK_RADIO_STATE_ON : MBTK_RADIO_STATE_OFF;
#if 1
    if (net_info.radio_state != MBTK_RADIO_STATE_ON)
    {
        setRadioPower(1);
    } else { // Radio has ON
        apn_prop_get();
    }

    if(net_info.radio_state == MBTK_RADIO_STATE_ON)
    {
        at_send_command("AT+CEREG=2", NULL);
    }

    int count = 0;
#endif
    net_info.sim_state = getSIMStatus();
#if 0
    while (net_info.sim_state != MBTK_SIM_READY && count < 30)
    {
        if(net_info.radio_state != MBTK_RADIO_STATE_ON)
        {
            setRadioPower(1);
        }
        LOGD("Waitting for SIM READY...");
        sleep(1);
        net_info.sim_state = getSIMStatus();
        count++;
    }
#endif
    if(net_info.sim_state == MBTK_SIM_READY)
    {
        LOGD("SIM READY!");
        at_send_command("AT+COPS=3", NULL);
    }
    else
    {
        LOGE("SIM NOT READY!");
    }
}

int mbtk_get_apn_send_pack(void)
{
    sock_client_info_t *info = (sock_client_info_t*)malloc(sizeof(sock_client_info_t));
    if(info == NULL)
    {
        LOG("clinent_info  malloc() fail.");
        return -1;
    }
    memset(info, 0, sizeof(sock_client_info_t));
    info->fd = DATA_CALL_APN_GET_FD;

    mbtk_info_pack_t* pack = mbtk_info_pack_creat(MBTK_INFO_ID_NET_QSER_APN_REQ);
    if(pack == NULL)
    {
        free(info);
        LOG("Packet malloc() fail.");
        return -1;
    }

    send_pack_to_queue(info, pack);
    return 0;
}

int mbtk_info_server_start()
{
    signal(SIGPIPE, SIG_IGN);

    //check cfun and sim card status
    ril_at_ready_process();

    //any AT instruction that is not sent through pack_process_thread needs to precede the thread
    //thread create
    if(sock_listen_fd > 0)
    {
        LOG("Information Server Has Started.");
        return -1;
    }

    struct sockaddr_un server_addr;
    sock_listen_fd = socket(AF_LOCAL, SOCK_STREAM, 0);
    if(sock_listen_fd < 0)
    {
        LOG("socket() fail[%d].", errno);
        return -1;
    }

    // Set O_NONBLOCK
    int flags = fcntl(sock_listen_fd, F_GETFL, 0);
    if (flags < 0)
    {
        LOG("Get flags error:%d", errno);
        goto error;
    }
    flags |= O_NONBLOCK;
    if (fcntl(sock_listen_fd, F_SETFL, flags) < 0)
    {
        LOG("Set flags error:%d", errno);
        goto error;
    }

    unlink(SOCK_INFO_PATH);
    memset(&server_addr, 0, sizeof(struct sockaddr_un));
    server_addr.sun_family = AF_LOCAL;
    strcpy(server_addr.sun_path, SOCK_INFO_PATH);
    if(bind(sock_listen_fd, (struct sockaddr *)&server_addr, sizeof(server_addr)))
    {
        LOG("bind() fail[%d].", errno);
        goto error;
    }

    if(listen(sock_listen_fd, SOCK_CLIENT_MAX))
    {
        LOG("listen() fail[%d].", errno);
        goto error;
    }

    sock_client_list = list_create(sock_cli_free_func);
    if(sock_client_list == NULL)
    {
        LOG("list_create() fail.");
        goto error;
    }

    pthread_t info_pid, pack_pid, monitor_pid, urc_pid, bootconn_pid;
    pthread_attr_t thread_attr;
    pthread_attr_init(&thread_attr);
    if(pthread_attr_setdetachstate(&thread_attr, PTHREAD_CREATE_DETACHED))
    {
        LOG("pthread_attr_setdetachstate() fail.");
        goto error;
    }

    if(pthread_create(&info_pid, &thread_attr, info_main_pthread, NULL))
    {
        LOG("pthread_create() fail.");
        goto error;
    }

    if(pthread_create(&pack_pid, &thread_attr, pack_process_thread, NULL))
    {
        LOG("pthread_create() fail.");
        goto error;
    }

#if 0
    if(pthread_create(&urc_pid, &thread_attr, urc_process_thread, NULL))
    {
        LOG("pthread_create() fail.");
        goto error;
    }
#endif

    // Set Band
    // AT*BAND=15,78,147,482,134742231
    char buff[10];
    memset(buff, 0, 10);
    property_get("persist.mbtk.band_config", buff, "");
    if(strlen(buff) == 0) {
        pthread_t band_pid;
        if(pthread_create(&band_pid, &thread_attr, band_config_thread, NULL))
        {
            LOG("pthread_create() fail.");
        }
    }

#if 0
    if(pthread_create(&monitor_pid, &thread_attr, net_monitor_thread, NULL))
    {
        LOG("pthread_create() fail.");
    }
#endif

    //mbtk wyq for data_call_ex add start
    if(pthread_create(&bootconn_pid, &thread_attr, data_call_bootconn_pthread, NULL))
    {
        LOG("pthread_create() fail.");
    }
    //mbtk wyq for data_call_ex add end

    pthread_attr_destroy(&thread_attr);

    mbtk_qser_apn_init();

    LOG("MBTK Information Server Start...");

    return 0;

error:
    close(sock_listen_fd);
    sock_listen_fd = -1;
    return -1;
}

#if 0
int main(int argc, char *argv[])
{
    if(mbtk_info_server_start())
    {
        return -1;
    }

    while(1)
    {
        sleep(24 * 60 * 60);
    }

    return 0;
}
#endif


