#include "mbtk_type.h"
#include "mbtk_device.h"

static char* band_2_str(mbtk_modem_band_area_enum band_area)
{
    switch(band_area)
    {
        case MBTK_MODEM_BAND_AREA_CN:
            return "CN";
        case MBTK_MODEM_BAND_AREA_EU:
            return "EU";
        case MBTK_MODEM_BAND_AREA_SA:
            return "SA";
        default:
            return "ALL";
    }
}

int main(int argc, char *argv[])
{
    mbtk_device_info_basic_t info_basic;
    memset(&info_basic, 0, sizeof(mbtk_device_info_basic_t));
    int result = mbtk_dev_info_read(MBTK_DEVICE_INFO_ITEM_BASIC, &info_basic, sizeof(mbtk_device_info_basic_t));
    if(result) {
        printf("mbtk_dev_info_read(BASIC) fail.\n");
        return -1;
    }

    /*
    uint8 project[16];          // T108 / L508_X6
        uint8 project_cust[16];     // T108_C1 / L508_X6_C1  (Refer to: Custom_Model in blf file.)
        uint32 ab_support;          // 1 for ab
        uint8 revision_out[48];     // L508_X6v01.01b04.00
        uint8 revision_in[64];
    */
    printf("Project:%s\n", info_basic.project);
    printf("Custom_Model:%s\n", info_basic.project_cust);
    printf("Revision_Out:%s\n", info_basic.revision_out);
    printf("Revision_In:%s\n", info_basic.revision_in);
    printf("Build_Time:%s\n", info_basic.build_time);
    printf("AB System:%s\n", info_basic.ab_support ? "Yes" : "No");
    printf("Reboot flag:%d\n", info_basic.reboot_flag);

    mbtk_device_info_modem_t info_modem;
    memset(&info_modem, 0, sizeof(mbtk_device_info_modem_t));
    result = mbtk_dev_info_read(MBTK_DEVICE_INFO_ITEM_MODEM, &info_modem, sizeof(mbtk_device_info_modem_t));
    if(result) {
        printf("mbtk_dev_info_read(MODEM) fail.\n");
        return -1;
    }

    printf("Band:%s\n", band_2_str(info_modem.band_area));
    printf("Band GSM:0x%08x\n", info_modem.band_gsm);
    printf("Band WCDMA:0x%08x\n", info_modem.band_wcdma);
    printf("Band TDLTE:0x%08x\n", info_modem.band_tdlte);
    printf("Band FDDLTE:0x%08x\n", info_modem.band_fddlte);
    printf("Band EXT_LTE:0x%08x\n", info_modem.band_lte_ext);

    return 0;
}


