/*************************************************************
Description:
    MBTK sleep head file.
Author:
    XiaoRui
Date:
    2024/10/24 20:08:03
*************************************************************/
#ifndef _MBTK_SLEEP_H
#define _MBTK_SLEEP_H

#include <stdio.h>
#include <time.h>
#include <sys/time.h>
#include <unistd.h>
#include <sys/un.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <errno.h>
#include <sys/ioctl.h>
#include <net/if.h>
#include <string.h>
#include <fcntl.h>
#include <signal.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <sys/file.h>
#include <stddef.h>
#include <sys/types.h>
#include <pthread.h>
#include <sys/epoll.h>
#include <linux/input.h>

#include "mbtk_type.h"
#include "mbtk_info_api.h"


/*************************************************************
    Constants and Macros
*************************************************************/


static bool autosleep_enable = FALSE;

#define LOCK_MAX_SIZE 129

/*************************************************************
    Definitions:enum,struct,union,class
*************************************************************/
typedef struct
{
    int fd;
    char name[64];
} mbtk_lock_name_s;



/*************************************************************
    Extern variables
*************************************************************/


/*************************************************************
    Public Function Declaration
*************************************************************/
int mbtk_autosuspend_enable(char enable);
int mbtk_wakelock_create(const char* name , size_t len);
int mbtk_wakelock_lock(int fd);
int mbtk_wakelock_unlock(int fd);
int mbtk_wakelock_destroy(int fd);


#endif /* _MBTK_SLEEP_H */
