#include <stdio.h>
//#include <include/log.h>
#include <sys/un.h>
#include <pthread.h>
#include <stdarg.h>
#include <stdlib.h>
#include <sys/prctl.h>
#include <time.h>
#include <string.h>
#include <sys/time.h>
#include <syslog.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <errno.h>
#include <unistd.h>
#include <include/logd.h>
#include <ctype.h>

#include "mbtk_type.h"
#include "mbtk_log.h"
#include "mbtk_str.h"

typedef enum {
    LOG_ID_MAIN = 0,
    LOG_ID_RADIO = 1,
    LOG_ID_EVENTS = 2,
    LOG_ID_SYSTEM = 3,
    LOG_ID_KMSG = 4,
    LOG_ID_MAX
} log_id_t;

#define LOG_VERBOSE 8

static int tlog_fd = -1;
// Default for radio log.
static int syslog_radio_enable = 2;
static FILE* logfile = NULL;
static int signal_fd = -1;

static bool log_level_printed = FALSE;

/**
 * @brief      mbtk_log_init
 *
 * @details    设置Log输出方式
 * @param
 *             path:
 *                   不填参数(NULL) stdout : 命令行输
 *                   "syslog":输出到syslog
 *                   "radio":CatStudio
 *                   文件路径:输出到自定义文件路径
 *             tag : 自定义tag
 *
 *   example:
 *       mbtk_log_init(NULL, "MBTK_RIL");
 *       mbtk_log_init("syslog", "MBTK_RIL");
 *       mbtk_log_init("radio", "MBTK_RIL");
 *       mbtk_log_init("/tmp/log/test.log", "MBTK_RIL");
 */
void mbtk_log_init(char* path, char* tag)
{
    if (str_empty(path)) {
        tlog_fd = STDOUT_FILENO;
    } else if (0 == memcmp(path, "syslog", 6)) {
        openlog(tag, LOG_PID, LOG_USER);
        syslog_radio_enable = 1;
    } else if (0 == memcmp(path, "radio", 5)) {
        if (tag && strlen(tag) > 0) {
            set_service_log_tag(tag);
        } else {
            set_service_log_tag("MBTK");
        }
        syslog_radio_enable = 2;
    } else if (path) {
        tlog_fd = open(path, O_CREAT | O_WRONLY | O_APPEND, 0600);
        if (tlog_fd < 0) {
            fprintf(stderr, "failed to open %s: %s\n", path, strerror(errno));
            exit(-1);
        }
    }
}

/* Control the log output */
void mbtk_log(int level, const char* format, ...)
{
    char buf[1024] = {0};
    va_list ap;
    struct timeval log_time;
    int length = 0;

    va_start(ap, format);
    length = vsnprintf(buf, sizeof(buf), format, ap);
    if (length < 0 || 0 == length) {
        va_end(ap);
        return;
    }

    if (1 == syslog_radio_enable) {
        syslog(level, "%s", buf);
    } else if (2 == syslog_radio_enable) {
        __android_log_printf(LOG_ID_RADIO, level, "%s", buf);

        if(!log_level_printed) {
            __android_log_printf(LOG_ID_RADIO, LOG_ERR_LEVEL, "sloglevel = %d", get_service_log_level());
            log_level_printed = TRUE;
        }
    } else if (-1 != tlog_fd) {
        char tmp[50] = {0};
        gettimeofday(&log_time, NULL);
        struct tm* tm_t = localtime(&(log_time.tv_sec));
        strftime(tmp, 50, "%F %T", tm_t);
        snprintf(tmp + strlen(tmp), sizeof(tmp) - strlen(tmp), " %d<%d>:", (int)(log_time.tv_usec / 1000), level);
        write(tlog_fd, tmp, strlen(tmp));
        write(tlog_fd, buf, length);
        if (buf[length - 1] != '\n') {
            write(tlog_fd, "\n", 1);
        }
        if (tlog_fd > 2) {
            fsync(tlog_fd);
        }
    }

    va_end(ap);
}

void log_hex(const char* tag, const void* data, int data_len)
{
    char buffer[60];
    char str[17];
    int size = 0;
    uint8* ptr = (uint8*)data;
    int i, j;
    memset(buffer, 0x0, 60);
    memset(str, 0x0, 17);
    LOGI("%s,Length-%d:", tag, data_len);
    LOGI("       0  1  2  3  4  5  6  7  8  9  a  b  c  d  e  f");
    size += snprintf(buffer, 60, "%04x| ", 0);
    for (i = 0; i < data_len; i++) {
        size += snprintf(buffer + size, 60 - size, "%02x ", ptr[i]);
        if (isprint(ptr[i])) {
            str[i % 16] = ptr[i];
        } else {
            str[i % 16] = '.';
        }
        if ((i + 1) % 16 == 0 || i == data_len - 1) {
            for (j = size; j < 54; j++) {
                buffer[j] = ' ';
            }
            LOGI("%s| %s", buffer, str);

            memset(buffer, 0x0, 60);
            memset(str, 0x0, 17);
            size = 0;
            size += snprintf(buffer, 60, "%04x| ", (i + 1) / 16);
        }
    }
}

#define _MOPEN_RILD_SOCKET "/tmp/logd_socket"

int mbtk_signal_log(char *data)
{
    char buff[256];
    int size = 0;
    int ret = 0;
    int i = 0;
    static struct sockaddr_un srv_addr;

    if(signal_fd < 0) {
        if (access(_MOPEN_RILD_SOCKET, F_OK) == -1) {
            LOGW("Service not running...");
            return -1;
        }

        signal_fd = socket(PF_UNIX, SOCK_STREAM, 0);
        if (signal_fd < 0) {
            LOGE("cannot creat socket");
            return -1;
        }

        srv_addr.sun_family = AF_UNIX;
        strcpy(srv_addr.sun_path, _MOPEN_RILD_SOCKET);
        ret = connect(signal_fd, (struct sockaddr*)&srv_addr, sizeof(srv_addr));
        if (ret < 0) {
            LOGE("cannot connect server, ret=%d, errno=%d", ret, errno);
            close(signal_fd);
            signal_fd = -1;
            return -1;
        }
    }

    memset(buff, 0, sizeof(buff));
    snprintf(buff, sizeof(buff), "%s\n", data);
    size = write(signal_fd, buff, sizeof(buff));
    if (size < 0 || size == 0) {
        LOGE("cannot write , ret=%d, errno=%d\n", ret, errno);
        return 1;
    }

    // close(signal_fd);

    return 0;
}
