#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/socket.h>
#include <errno.h>
#include <fcntl.h>
#include <string.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <linux/un.h>
#include <linux/netlink.h>
#include <cutils/properties.h>
#include <time.h>
#include <sys/time.h>

//#include "cploader.h"
#include "mbtk_log.h"
#include "mbtk_ifc.h"
#include "mbtk_type.h"
#include "atchannel.h"
#include "at_tok.h"
#include "mbtk_utils.h"
#include "mbtk_task.h"
#include "mbtk_info.h"
#include "mbtk_ntp.h"
#include "mbtk_net_control.h"
#include "info_data.h"
#include "mbtk_led.h"

#define TEMP_FAILURE_RETRY(exp) ({         \
    typeof (exp) _rc;                      \
    do {                                   \
        _rc = (exp);                       \
    } while (_rc == -1 && errno == EINTR); \
    _rc; })

#define BUFFER_SIZE 2048
#define UEVENT_USIM_DEV "/devices/virtual/usim_event/usim0"
#define MBTK_BOOT_SERVER_READY "/etc/init.d/mbtk_boot_server_ready"
#define MBTK_BOOT_NET_READY "/etc/init.d/mbtk_boot_net_ready"
#define MBTK_RILD_PID_FILE "/var/run/mbtk_rild.pid"
#define MBTK_RILD_TEMP_FILE "/tmp/mbtk_rild.count"

struct cooling_device
{
    const char *name;
    const char *action;
    const char *path;
    const char *event;
    const char *subsystem;
};
static pthread_t uevnet_task_id;
extern net_info_t net_info;
extern mbtK_cell_pack_info_t cell_info;
extern info_cgact_wait_t cgact_wait;
extern bool at_process;
extern bool at_cfun_command;
static bool is_first_boot = FALSE;

void setRadioPower(int isOn);
int urc_msg_distribute(bool async_process, info_urc_msg_id_enum msg, void *data, int data_len);
int mbtk_signal_log(char *data);

/* Called on command thread */
static void onATTimeout()
{
    LOGI("AT channel timeout; closing\n");
    at_close();
}

/* Called on command or reader thread */
static void onATReaderClosed()
{
    LOGI("AT channel closed\n");
    at_close();
}

//int req_time_set(int type, char *time, int *cme_err);
static int metis_strptime(char *str_time)
{
    struct tm stm;
    char dateTime[30];
    struct timeval tv;
    if(strptime(str_time, "%Y-%m-%d %H:%M:%S",&stm) != NULL)
    {
        time_t _t = mktime(&stm);
        tv.tv_sec = _t;
        if(settimeofday(&tv, NULL)) {
            LOG("Set time fail:%d", errno);
            return -1;
        } else {
            LOG("Set time to %s.", str_time);
            return 0;
        }
    } else {
        LOG("Set time fail.");
        return -1;
    }
}

static void* ntp_pthread_run(void* arg)
{
    // Waitting for network connected.
    while(mbtk_net_state_get() == MBTK_NET_STATE_OFF) {
        sleep(1);
    }
    LOG("Network is connected.");

    char time_type[10];
    while(1){
        memset(time_type, 0, 10);
        property_get("persist.mbtk.time_type", time_type, "0");
    	if(atoi(time_type) == MBTK_TIME_TYPE_NTP) // NTP time
    	{
            char time_str[100] = {0};
            time_t time = 0;
            while((time = (time_t)mbtk_at_systime()) == 0) {
                usleep(100000);
            }
            struct tm *tm_t;
            tm_t = localtime(&time);
            strftime(time_str,128,"%F %T",tm_t);

            // NTP time
            metis_strptime(time_str);
    	} else {
            break;
    	}

        sleep(64); // Sleep 64s.
    }
    return NULL;
}

static void ntp_thread_start()
{
    pthread_t ntp_pid;
    pthread_attr_t thread_attr;
    pthread_attr_init(&thread_attr);
    if(pthread_attr_setdetachstate(&thread_attr, PTHREAD_CREATE_DETACHED))
    {
        LOG("pthread_attr_setdetachstate() fail.");
        return;
    }

    if(pthread_create(&ntp_pid, &thread_attr, ntp_pthread_run, NULL))
    {
        LOG("pthread_create() fail.");
    }
}

static void mbtk_net_ready()
{
    // /etc/init.d/mbtk_boot_net_ready
    if(is_first_boot) {
        if(access(MBTK_BOOT_NET_READY , X_OK) == 0) {
            LOGD("Exec : %s", MBTK_BOOT_NET_READY);
            system(MBTK_BOOT_NET_READY);
        } else {
            LOGE("%s can not exec.", MBTK_BOOT_NET_READY);
        }
        is_first_boot = FALSE; // Only one time.
    } else {
        LOGD("No exec : %s", MBTK_BOOT_NET_READY);
    }
}

bool sms_cmt = false;
mbtk_sim_card_info sim_info_reg={0};
static void onUnsolicited(const char *s, const char *sms_pdu)
{
    LOGV("URC : %s", s);
    // MBTK_AT_READY
    if (strStartsWith(s, "MBTK_AT_READY")) // AT ready.
    {

    }
#if 0
    else if(strStartsWith(s, "*SIMDETEC:")) // *SIMDETEC:1,SIM
    {
        const char* ptr = strstr(s, ",");
        if(ptr)
        {
            ptr++; // Jump ','
            if(memcmp(ptr, "SIM", 3) == 0)
                net_info.sim_state = MBTK_SIM_STATE_READY;
            else
                net_info.sim_state = MBTK_SIM_STATE_ABSENT;
        }
    }
#endif
    else if(strStartsWith(s, "*RADIOPOWER:")) // "*RADIOPOWER: 1"
    {
        const char* ptr = s + strlen("*RADIOPOWER:");
        while(*ptr != '\0' && *ptr == ' ' )
        {
            ptr++;
        }

        uint8 state;
        if(*ptr == '1') {
            //net_info.radio_state = MBTK_RADIO_STATE_ON;
            // mbtk_radio_ready_cb();
            state = (uint8)1;
        } else {
            //net_info.radio_state = MBTK_RADIO_STATE_OFF;
            state = (uint8)0;
        }
        urc_msg_distribute(true, INFO_URC_MSG_RADIO_STATE, &state, sizeof(uint8));
    }
    // "CONNECT"
    else if(strStartsWith(s, "CONNECT"))
    {
        if(cgact_wait.waitting && cgact_wait.act) {
            cgact_wait.waitting = false;
        }

        uint8 data_pdp;
        data_pdp = 1;       //
        urc_msg_distribute(false, INFO_URC_MSG_PDP_STATE, &data_pdp, sizeof(uint8));
    }
    // +CGEV:
    // +CGEV: NW DEACT <cid>,<cid>
    // +CGEV: ME DEACT <cid>,<cid>
    // +CGEV: NW PDN DEACT <cid>
    // +CGEV: ME PDN DEACT <cid>
    // +CGEV: NW DETACH
    // +CGEV: ME DETACH
    //
    // +CGEV: NW ACT <cid>,<cid>
    // +CGEV: ME ACT <cid>,<cid>
    // +CGEV: EPS PDN ACT <cid>
    // +CGEV: ME PDN ACT <cid>,<reason>,<cid>
    // +CGEV: ME PDN ACT <cid>,<reason>
    // +CGEV: NW PDN ACT <cid>
    // +CGEV: EPS ACT <cid>
    // +CGEV: NW MODIFY <cid>,<reason>
    // +CGEV: NW REATTACH
    else if(strStartsWith(s, "+CGEV:"))
    {
        if(at_process && !at_cfun_command) {
            if(cgact_wait.act) {
                if(strStartsWith(s, "+CGEV: ME PDN ACT ")) { // +CGEV: ME PDN ACT 15,4
                    if(cgact_wait.cid == atoi(s + 18)) {
                        cgact_wait.waitting = false;
                    }

                    uint8 data_pdp;
                    char* tmp_s = memdup(s + 18,strlen(s + 18));
                    char* free_ptr = tmp_s;
                    char *line = tmp_s;
                    int tmp_int;
                    if (at_tok_start(&line) < 0)
                    {
                        goto at_PDP_CREG_EXIT;
                    }
                    if (at_tok_nextint(&line, &tmp_int) < 0)
                    {
                        goto at_PDP_CREG_EXIT;
                    }
                    if (at_tok_nextint(&line, &tmp_int) < 0)
                    {
                        goto at_PDP_CREG_EXIT;
                    }
                    data_pdp = tmp_int;
at_PDP_CREG_EXIT:
                    free(free_ptr);

                    //data_pdp = (uint8)atoi(s + 20);  //reason
                    if(cgact_wait.cid >= 1 && cgact_wait.cid < 8)
                    {
                        if(data_pdp == 0)
                        {
                            data_pdp = 25;
                            urc_msg_distribute(false, INFO_URC_MSG_PDP_STATE, &data_pdp, sizeof(uint8));
                            //data_pdp = cgact_wait.cid + 200;
                        }
                        else if(data_pdp == 1)
                        {
                            data_pdp = 26;
                            urc_msg_distribute(false, INFO_URC_MSG_PDP_STATE, &data_pdp, sizeof(uint8));
                        }
                        else if(data_pdp == 2)
                        {
                            data_pdp = 27;
                            urc_msg_distribute(false, INFO_URC_MSG_PDP_STATE, &data_pdp, sizeof(uint8));
                        }
                        else if(data_pdp == 3)
                        {
                            data_pdp = 27;
                            urc_msg_distribute(false, INFO_URC_MSG_PDP_STATE, &data_pdp, sizeof(uint8));
                        }
                        else
                        {

                        }
                        if(cgact_wait.cid != 0)
                        {
                            data_pdp = cgact_wait.cid + 200;
                            urc_msg_distribute(false, INFO_URC_MSG_PDP_STATE, &data_pdp, sizeof(uint8));
                        }
                    }
                } else if(strStartsWith(s, "+CGEV: NW MODIFY ")) { // +CGEV: NW MODIFY 1,4
                    if(cgact_wait.cid == atoi(s + 17)) {
                        cgact_wait.waitting = false;
                    }
                }
            } else {
                if(strStartsWith(s, "+CGEV: ME PDN DEACT ")) { // +CGEV: ME PDN DEACT 1
                    if(cgact_wait.cid == atoi(s + 20)) {
                        cgact_wait.waitting = false;
                    }
                    uint8 data_pdp;
                    data_pdp = 0;       //
                    urc_msg_distribute(false, INFO_URC_MSG_PDP_STATE, &data_pdp, sizeof(uint8));
                    if(cgact_wait.cid != 0)
                    {
                        data_pdp = cgact_wait.cid + 100;
                        urc_msg_distribute(false, INFO_URC_MSG_PDP_STATE, &data_pdp, sizeof(uint8));
                    }
                }
            }
        } else {
            // apn_state_set

            // +CGEV: NW PDN DEACT <cid>

            // +CGEV: EPS PDN ACT 1
            // +CGEV: ME PDN ACT 8,1

            // +CGEV: ME PDN ACT 2,4
            uint8 data[2] = {0xFF};
            if(strStartsWith(s, "+CGEV: NW PDN DEACT ")) { // +CGEV: NW PDN DEACT <cid>
                //apn_state_set(atoi(s + 20), false);
                data[0] = (uint8)0;
                data[1] = (uint8)atoi(s + 20);

                uint8 data_pdp;
                data_pdp = 0;       //
                urc_msg_distribute(false, INFO_URC_MSG_PDP_STATE, &data_pdp, sizeof(uint8));
                data_pdp = data[1] + 100;
                urc_msg_distribute(false, INFO_URC_MSG_PDP_STATE, &data_pdp, sizeof(uint8));
            } else if(strStartsWith(s, "+CGEV: EPS PDN ACT ")) { // +CGEV: EPS PDN ACT <cid>
                //apn_state_set(atoi(s + 19), true);
#if (defined(MBTK_AF_SUPPORT) || defined(MBTK_ALL_CID_SUPPORT))
				//data[0] = (uint8)1;
                //data[1] = (uint8)atoi(s + 19);
#else
                data[0] = (uint8)1;
                data[1] = (uint8)atoi(s + 19);
#endif
            } else if(strStartsWith(s, "+CGEV: ME PDN DEACT ")) { // +CGEV: EPS PDN DEACT <cid>
                //apn_state_set(atoi(s + 19), true);
                data[0] = (uint8)0;
                data[1] = (uint8)atoi(s + 20);

                uint8 data_pdp;
                data_pdp = 0;       //
                urc_msg_distribute(false, INFO_URC_MSG_PDP_STATE, &data_pdp, sizeof(uint8));
                data_pdp = data[1] + 100;
                urc_msg_distribute(false, INFO_URC_MSG_PDP_STATE, &data_pdp, sizeof(uint8));
            } else if(strStartsWith(s, "+CGEV: ME PDN ACT ")) { // +CGEV: ME PDN ACT <cid>,1
                //apn_state_set(atoi(s + 18), true);
                data[0] = (uint8)1;
                data[1] = (uint8)atoi(s + 18);

                uint8 data_pdp;
                char* tmp_s = memdup(s + 18,strlen(s + 18));
                char* free_ptr = tmp_s;
                char *line = tmp_s;
                int tmp_int;
                if (at_tok_start(&line) < 0)
                {
                    goto PDP_CREG_EXIT;
                }
                if (at_tok_nextint(&line, &tmp_int) < 0)
                {
                    goto PDP_CREG_EXIT;
                }
                if (at_tok_nextint(&line, &tmp_int) < 0)
                {
                    goto PDP_CREG_EXIT;
                }
                data_pdp = tmp_int;
PDP_CREG_EXIT:
                free(free_ptr);
                //data_pdp = (uint8)atoi(s + 20);  //reason
                if(data[1] >= 1 && data[1] < 8)
                {
                    if(data_pdp == 0)
                    {
                        data_pdp = 25;
                        urc_msg_distribute(false, INFO_URC_MSG_PDP_STATE, &data_pdp, sizeof(uint8));
                    }
                    else if(data_pdp == 1)
                    {
                        data_pdp = 26;
                        urc_msg_distribute(false, INFO_URC_MSG_PDP_STATE, &data_pdp, sizeof(uint8));
                    }
                    else if(data_pdp == 2)
                    {
                        data_pdp = 27;
                        urc_msg_distribute(false, INFO_URC_MSG_PDP_STATE, &data_pdp, sizeof(uint8));
                    }
                    else if(data_pdp == 3)
                    {
                        data_pdp = 27;
                        urc_msg_distribute(false, INFO_URC_MSG_PDP_STATE, &data_pdp, sizeof(uint8));
                    }
                    else
                    {

                    }

                    data_pdp = data[1] + 200;
                    urc_msg_distribute(false, INFO_URC_MSG_PDP_STATE, &data_pdp, sizeof(uint8));
					data[1] = 0;
                }
            } else {
                LOGI("No process : %s", s);
            }

			urc_msg_distribute(true, INFO_URC_MSG_CGEV, data, sizeof(uint8) * 2);
        }
    }
    // +CREG: 1, "8010", "000060a5", 0, 2, 0
    // +CREG: 1, "8330", "06447347", 7, 2, 0
    // +CEREG: 1, "8330", "06447347", 7
    // $CREG: 1, "8330", "06447347", 7,"0d4", 2, 0
    // $CREG: 1, "8010", "000060a7", 0,, 2, 0
    // +CGREG: 1
    else if(strStartsWith(s, "+CGREG:")     // GMS/WCDMA data registed.
         || strStartsWith(s, "+CEREG:"))    // LTE data registed.
    {
        char* tmp_s = s + 7;
        static bool net_led_gms_wcdma = FALSE;
        static bool net_led_lte = FALSE;
        while(*tmp_s && *tmp_s == ' ')
            tmp_s++;
        uint8 data[2];
        data[0] = (uint8)atoi(tmp_s); // Reg State.

        if(strStartsWith(s, "+CGREG:"))
        {
           data[1] = 0;  // GMS/WCDMA
           if(data[0] == 1)
           {
               net_led_gms_wcdma = TRUE;
           }
           else
           {
               net_led_gms_wcdma = FALSE;
           }

        }
        else
        {
           data[1] = 1;  // LTE
           if(data[0] == 1)
           {
               net_led_lte = TRUE;
           }
           else
           {
               net_led_lte = FALSE;
           }
        }

        if(FALSE == net_led_gms_wcdma && FALSE == net_led_lte)
        {
           mbtk_net_led_set(MBTK_NET_LED_SEARCH_NETWORK);
        }
        else
        {
           mbtk_net_led_set(MBTK_NET_LED_NET_CONNECT);
           mbtk_net_ready();
        }

        urc_msg_distribute(true, INFO_URC_MSG_NET_PS_REG_STATE, data, sizeof(data));
        urc_msg_distribute(true, INFO_URC_MSG_NET_STATE_LOG, NULL, 0);
    }
    // +CREG: 1, "8010", "000060a5", 0, 2, 0
    // +CREG: 1, "8330", "06447347", 7, 2, 0
    // +CREG: 0
    else if(strStartsWith(s, "+CREG:"))     // GMS/WCDMA/LTE CS registed.
    {
        uint8 data[3];
        data[0] = (uint8)MBTK_NET_CS_STATE;
        char* tmp_s = memdup(s,strlen(s));
        char* free_ptr = tmp_s;
        char *line = tmp_s;
        int tmp_int;
        char *tmp_str;
        if (at_tok_start(&line) < 0)
        {
            goto CREG_EXIT;
        }
        if (at_tok_nextint(&line, &tmp_int) < 0)
        {
            goto CREG_EXIT;
        }
        data[1] = (uint8)tmp_int; // Reg State.
        if (data[1])
        {
            if (at_tok_nextstr(&line, &tmp_str) < 0)
            {
                goto CREG_EXIT;
            }
            if (at_tok_nextstr(&line, &tmp_str) < 0)
            {
                goto CREG_EXIT;
            }
            if (at_tok_nextint(&line, &tmp_int) < 0)
            {
                goto CREG_EXIT;
            }
            data[2] = (uint8)tmp_int; // AcT
        } else {
            data[2] = (uint8)0xFF; // AcT
        }
        if(data[1] == 5)
        {
            uint8 data_pdp;
            data_pdp = 5;       //
            urc_msg_distribute(false, INFO_URC_MSG_PDP_STATE, &data_pdp, sizeof(uint8));
        }
        urc_msg_distribute(false, INFO_URC_MSG_NET_CS_REG_STATE, data, sizeof(data));
        urc_msg_distribute(true, INFO_URC_MSG_NET_STATE_LOG, NULL, 0);
CREG_EXIT:
        free(free_ptr);
    }
    // +CLCC: 1, 1, 6, 0, 0, "18981911691", 129, "",, 0
    else if(strStartsWith(s, "+CLCC:"))
    {
        mbtk_call_info_t reg;
        reg.call_wait = MBTK_CLCC;
        char* tmp_s = memdup(s,strlen(s));
        char* free_ptr = tmp_s;
        char *line = tmp_s;
        int tmp_int;
        char *tmp_str;
        int err;

        err = at_tok_start(&line);
        if (err < 0)
        {
            goto CLCC_EXIT;
        }
        err = at_tok_nextint(&line, &tmp_int); // dir1
        if (err < 0)
        {
            goto CLCC_EXIT;
        }
        reg.dir1 = (uint8)tmp_int;
        err = at_tok_nextint(&line, &tmp_int);// dir
        if (err < 0)
        {
            goto CLCC_EXIT;
        }
        reg.dir = (uint8)tmp_int;
        err = at_tok_nextint(&line, &tmp_int);// state
        if (err < 0)
        {
            goto CLCC_EXIT;
        }
        reg.state = (uint8)tmp_int;
        err = at_tok_nextint(&line, &tmp_int);// mode
        if (err < 0)
        {
            goto CLCC_EXIT;
        }
        reg.mode = (uint8)tmp_int;
        err = at_tok_nextint(&line, &tmp_int);// mpty
        if (err < 0)
        {
            goto CLCC_EXIT;
        }
        reg.mpty = (uint8)tmp_int;
        err = at_tok_nextstr(&line, &tmp_str); // phone_number
        if (err < 0)
        {
            goto CLCC_EXIT;
        }

        memset(reg.phone_number,0,sizeof(reg.phone_number));
        memcpy(reg.phone_number, tmp_str, strlen(tmp_str));
        err = at_tok_nextint(&line, &tmp_int);// tpye
        if (err < 0)
        {
            goto CLCC_EXIT;
        }
        reg.type = (uint8)tmp_int;

        if(reg.state == 2 || reg.state == 3 || reg.state == 0)
        {
            mbtk_net_led_set(MBTK_NET_LED_CALL_CONNECT);
        }

        if(reg.state == 4 && reg.dir == 1)
        {
            mbtk_net_led_set(MBTK_NET_LED_CALL_CONNECT);
        }


        urc_msg_distribute(false, INFO_URC_MSG_CALL_STATE, &reg, sizeof(mbtk_call_info_t));
CLCC_EXIT:
        free(free_ptr);
    }
    // +CPAS: 4
    else if(strStartsWith(s, "+CPAS:"))
    {
        mbtk_call_info_t reg;
        reg.call_wait = 0;
        char* tmp_s = memdup(s,strlen(s));
        char* free_ptr = tmp_s;
        char *line = tmp_s;
        int tmp_int;
        int err;

        memset(&reg,0,sizeof(reg));

        err = at_tok_start(&line);
        if (err < 0)
        {
            goto CPAS_EXIT;
        }
        err = at_tok_nextint(&line, &tmp_int);
        if (err < 0)
        {
            goto CPAS_EXIT;
        }
        reg.pas = (uint8)tmp_int;
        reg.call_wait = MBTK_CPAS;
        urc_msg_distribute(false, INFO_URC_MSG_CALL_STATE, &reg, sizeof(mbtk_call_info_t));
CPAS_EXIT:
        free(free_ptr);
    }
    // +CALLDISCONNECT: 1
    else if(strStartsWith(s, "+CALLDISCONNECT:"))
    {
        mbtk_call_info_t reg;
        reg.call_wait = 0;
        char* tmp_s = memdup(s,strlen(s));
        char* free_ptr = tmp_s;
        char *line = tmp_s;
        int tmp_int;
        int err;

        memset(&reg,0,sizeof(reg));

        err = at_tok_start(&line);
        if (err < 0)
        {
            goto CALLDISCONNECTED_EXIT;
        }
        err = at_tok_nextint(&line, &tmp_int);
        if (err < 0)
        {
            goto CALLDISCONNECTED_EXIT;
        }
        reg.disconnected_id = tmp_int;
        reg.call_wait = MBTK_DISCONNECTED;

        if(reg.call_wait == MBTK_DISCONNECTED)
        {
            mbtk_net_led_set(MBTK_NET_LED_CALL_DISCONNECT);
        }

        urc_msg_distribute(false, INFO_URC_MSG_CALL_STATE, &reg, sizeof(mbtk_call_info_t));

CALLDISCONNECTED_EXIT:
        free(free_ptr);
    }
    // *SIMDETEC:1,SIM
    else if(strStartsWith(s, "*SIMDETEC:"))
    {
        if(strStartsWith(s, "*SIMDETEC:1,NOS"))
        {
            net_info.sim_state = MBTK_SIM_ABSENT;
        }

        sim_info_reg.sim = -1;
        if(strStartsWith(s, "*SIMDETEC:1,NOS"))
            sim_info_reg.sim = 0;
        else if(strStartsWith(s, "*SIMDETEC:1,SIM"))
            sim_info_reg.sim = 1;
        if(sim_info_reg.sim == 0)
        {
            uint8 data_pdp;
            data_pdp = 11;       //
            urc_msg_distribute(false, INFO_URC_MSG_PDP_STATE, &data_pdp, sizeof(uint8));
        }
        urc_msg_distribute(false, INFO_URC_MSG_SIM_STATE, &sim_info_reg, sizeof(mbtk_sim_card_info));
    }
    // *EUICC:1
/*0: SIM
1: USIM
2: TEST SIM
3: TEST USIM
4: UNKNOWN
Note: *EUICC:
*/
    else if(strStartsWith(s, "*EUICC:"))
    {
        sim_info_reg.sim = -1;
        sim_info_reg.sim_card_type = -1;
        if(strStartsWith(s, "*EUICC: 0"))
            sim_info_reg.sim_card_type = 1;
        else if(strStartsWith(s, "*EUICC: 1"))
            sim_info_reg.sim_card_type = 2;
        else if(strStartsWith(s, "*EUICC: 2"))
            sim_info_reg.sim_card_type = 1;
        else if(strStartsWith(s, "*EUICC: 3"))
            sim_info_reg.sim_card_type = 2;
        else if(strStartsWith(s, "*EUICC: 4"))
            sim_info_reg.sim_card_type = 0;
        urc_msg_distribute(false, INFO_URC_MSG_SIM_STATE, &sim_info_reg, sizeof(mbtk_sim_card_info));
    }
    // +CPIN: SIM PIN
    else if(strStartsWith(s, "+CPIN:"))
    {
        sim_info_reg.sim = -1;
        if(strStartsWith(s, "+CPIN: READY"))
        {
            sim_info_reg.sim = 1;
            net_info.sim_state = MBTK_SIM_READY;
        }
        else if(strStartsWith(s, "+CPIN: SIM PIN"))
        {
            sim_info_reg.sim = 2;
            net_info.sim_state = MBTK_SIM_PIN;
        }
        else if(strStartsWith(s, "+CPIN: SIM PUK"))
        {
            sim_info_reg.sim = 3;
            net_info.sim_state = MBTK_SIM_PUK;
        }
        else if(strStartsWith(s, "+CPIN: PH-SIMLOCK PIN"))
        {
            sim_info_reg.sim = 4;
            net_info.sim_state = MBTK_SIM_ABSENT;
        }
        else if(strStartsWith(s, "+CPIN: PH-SIMLOCK PUK"))
        {
            sim_info_reg.sim = 5;
            net_info.sim_state = MBTK_SIM_ABSENT;
        }
        else if(strStartsWith(s, "+CPIN: PH-FSIM PIN"))
        {
            sim_info_reg.sim = 6;
            net_info.sim_state = MBTK_SIM_ABSENT;
        }
        else if(strStartsWith(s, "+CPIN: PH-FSIM PUK"))
        {
            sim_info_reg.sim = 7;
            net_info.sim_state = MBTK_SIM_ABSENT;
        }
        else if(strStartsWith(s, "+CPIN: SIM PIN2"))
        {
            sim_info_reg.sim = 8;
            net_info.sim_state = MBTK_SIM_ABSENT;
        }
        else if(strStartsWith(s, "+CPIN: SIM PUK2"))
        {
            sim_info_reg.sim = 9;
            net_info.sim_state = MBTK_SIM_ABSENT;
        }
        else if(strStartsWith(s, "+CPIN: PH-NET PIN"))
        {
            sim_info_reg.sim = 10;
            net_info.sim_state = MBTK_SIM_NETWORK_PERSONALIZATION;
        }
        else if(strStartsWith(s, "+CPIN: PH-NET PUK"))
        {
            sim_info_reg.sim = 11;
            net_info.sim_state = MBTK_SIM_ABSENT;
        }
        else if(strStartsWith(s, "+CPIN: PH-NETSUB PINMT"))
        {
            sim_info_reg.sim = 12;
            net_info.sim_state = MBTK_SIM_ABSENT;
        }
        else if(strStartsWith(s, "+CPIN: PH-NETSUB PUK"))
        {
            sim_info_reg.sim = 13;
            net_info.sim_state = MBTK_SIM_ABSENT;
        }
        else if(strStartsWith(s, "+CPIN: PH-SP PIN"))
        {
            sim_info_reg.sim = 14;
            net_info.sim_state = MBTK_SIM_ABSENT;
        }
        else if(strStartsWith(s, "+CPIN: PH-SP PUK"))
        {
            sim_info_reg.sim = 15;
            net_info.sim_state = MBTK_SIM_ABSENT;
        }
        else if(strStartsWith(s, "+CPIN: PH-CORP PIN"))
        {
            sim_info_reg.sim = 16;
            net_info.sim_state = MBTK_SIM_ABSENT;
        }
        else if(strStartsWith(s, "+CPIN: PH-CORP PUK"))
        {
            sim_info_reg.sim = 17;
            net_info.sim_state = MBTK_SIM_ABSENT;
        }
        else if(strStartsWith(s, "+CPIN: SIM REMOVED"))
        {
             sim_info_reg.sim = 18;
             net_info.sim_state = MBTK_SIM_ABSENT;
        }
        else
            sim_info_reg.sim = 20;

        if(sim_info_reg.sim == 18)
        {
            uint8 data_pdp;
            data_pdp = 11;       //
            urc_msg_distribute(false, INFO_URC_MSG_PDP_STATE, &data_pdp, sizeof(uint8));
        }

        urc_msg_distribute(false, INFO_URC_MSG_SIM_STATE, &sim_info_reg, sizeof(mbtk_sim_card_info));
    }
    // +CMT: ,23
    // 0891683108200855F6240D91688189911196F10000221130717445230331D90C
    else if(strStartsWith(s, "+CMT:") || sms_cmt)
    {
        if(!sms_cmt){
            sms_cmt = true;
        }else{
            sms_cmt = false;
        }
        printf("+CMT() sms_cmt:%d, s:%s, len:%d\n",sms_cmt,  s, strlen(s));
        urc_msg_distribute(false, INFO_URC_MSG_SMS_STATE, s, strlen(s));
    }
#if 0
    // LTE data registed.
    // +CEREG: 1, "8330", "06447347", 7
    else if(strStartsWith(s, "+CEREG:"))
    {
        char* tmp_s = memdup(s,strlen(s));
        char* free_ptr = tmp_s;
        char *line = tmp_s;
        int tmp_int;
        char *tmp_str;
        if (at_tok_start(&line) < 0)
        {
            goto CREG_EXIT;
        }
        if (at_tok_nextint(&line, &tmp_int) < 0)
        {
            goto CREG_EXIT;
        }
        uint8 data = (uint8)tmp_int; // Reg State.

        urc_msg_distribute(INFO_URC_MSG_NET_REG_STATE, &data, sizeof(uint8));
CREG_EXIT:
        free(free_ptr);
    }
#endif
    /*
    // <mcc>, <length of mnc>, <mnc>, <tac>, <PCI>, <dlEuarfcn>, < ulEuarfcn >, <band>, <dlBandwidth>,
    // <rsrp>,<rsrq>, <sinr>,
    // errcModeState,emmState,serviceState,IsSingleEmmRejectCause,EMMRejectCause,mmeGroupId,mmeCode,mTmsi,
    // cellId,subFrameAssignType,specialSubframePatterns,transMode
    // mainRsrp,diversityRsrp,mainRsrq,diversityRsrq,rssi,cqi,pathLoss,tb0DlTpt,tb1DlTpt,tb0DlPeakTpt,tb1DlPeakTpt,tb0UlPeakTpt,
    // tb1UlPeakTpt,dlThroughPut,dlPeakThroughPut,averDlPRB,averCQITb0,averCQITb1,rankIndex,grantTotal,ulThroughPut,ulPeakThroughPut,currPuschTxPower,averUlPRB,
    // dlBer, ulBer,
    // diversitySinr, diversityRssi
    +EEMLTESVC: 1120, 2, 0, 33584, 430, 40936, 40936, 41, 20,
    0, 0, 0,
    1, 10, 0, 1, 0, 1059, 78, 3959566565,
    105149248, 2, 7, 7,
    0, 0, 0, 0, 0, 0, 0, 1190919, 0, 0, 0, 16779777,
    0, 5112867, 3959566565, 2, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0,
    7, 44
    */
    else if(strStartsWith(s, "+EEMLTESVC:"))   // LTE Server Cell
    {
        // tac, PCI, dlEuarfcn, ulEuarfcn, band
        if(cell_info.running) {
            int tmp_int;
            int i = 0;
            char* tmp_s = memdup(s,strlen(s));
            char* free_ptr = tmp_s;
            char *line = tmp_s;
            if (at_tok_start(&line) < 0)
            {
                goto EEMLTESVC_EXIT;
            }

            if (at_tok_nextint(&line, &tmp_int) < 0)
            {
                goto EEMLTESVC_EXIT;
            }
            cell_info.cell[cell_info.cell_num].value6 = (uint32)tmp_int;    //mcc
            if (at_tok_nextint(&line, &tmp_int) < 0)
            {
                goto EEMLTESVC_EXIT;
            }
            if (at_tok_nextint(&line, &tmp_int) < 0)
            {
                goto EEMLTESVC_EXIT;
            }
            cell_info.cell[cell_info.cell_num].value7 = (uint32)tmp_int;    //mnc
            /*
            // Jump 2 integer.
            i = 0;
            while(i < 2) {
                if (at_tok_nextint(&line, &tmp_int) < 0)
                {
                    goto EEMLTESVC_EXIT;
                }
                i++;
            }
            */
            if (at_tok_nextint(&line, &tmp_int) < 0)
            {
                goto EEMLTESVC_EXIT;
            }
            cell_info.cell[cell_info.cell_num].value1 = (uint32)tmp_int;    //tac
            if (at_tok_nextint(&line, &tmp_int) < 0)
            {
                goto EEMLTESVC_EXIT;
            }
            cell_info.cell[cell_info.cell_num].value2 = (uint32)tmp_int;    //pci
            if (at_tok_nextint(&line, &tmp_int) < 0)
            {
                goto EEMLTESVC_EXIT;
            }
            cell_info.cell[cell_info.cell_num].value3 = (uint32)tmp_int;    //dl arfcn
            if (at_tok_nextint(&line, &tmp_int) < 0)
            {
                goto EEMLTESVC_EXIT;
            }
            cell_info.cell[cell_info.cell_num].value4 = (uint32)tmp_int;    //ul arfcn
            if (at_tok_nextint(&line, &tmp_int) < 0)
            {
                goto EEMLTESVC_EXIT;
            }
            cell_info.cell[cell_info.cell_num].value5 = (uint32)tmp_int;    //band
            if (at_tok_nextint(&line, &tmp_int) < 0)
            {
                goto EEMLTESVC_EXIT;
            }
            if (at_tok_nextint(&line, &tmp_int) < 0)
            {
                goto EEMLTESVC_EXIT;
            }
            cell_info.cell[cell_info.cell_num].value8 = (uint32)tmp_int;    //cid
            if (at_tok_nextint(&line, &tmp_int) < 0)
            {
                goto EEMLTESVC_EXIT;
            }
            cell_info.cell[cell_info.cell_num].value9 = (uint32)tmp_int;    //rsrp

            for(i =0; i < 10; i++)
            {
                if (at_tok_nextint(&line, &tmp_int) < 0)
                {
                    goto EEMLTESVC_EXIT;
                }
            }
			cell_info.cell[cell_info.cell_num].value10 = (uint32)tmp_int;   //cell identiy

            cell_info.cell_num++;

EEMLTESVC_EXIT:
            free(free_ptr);
        }
    }
    /*
    // index,phyCellId,euArfcn,rsrp,rsrq
    +EEMLTEINTER: 0, 65535, 38950, 0, 0
    */
    else if(strStartsWith(s, "+EEMLTEINTER:") || strStartsWith(s, "+EEMLTEINTRA:")) // LTE Ƶ/ͬƵС
    {
        // phyCellId,euArfcn,rsrp,rsrq
        if(cell_info.running) {
            int tmp_int;
            char* tmp_s = memdup(s,strlen(s));
            char* free_ptr = tmp_s;
            char *line = tmp_s;
            if (at_tok_start(&line) < 0)
            {
                goto EEMLTEINTER_EXIT;
            }
            if (at_tok_nextint(&line, &tmp_int) < 0)
            {
                goto EEMLTEINTER_EXIT;
            }
            if (at_tok_nextint(&line, &tmp_int) < 0 || tmp_int <= 0 || tmp_int > 503)
            {
                goto EEMLTEINTER_EXIT;
            }
            cell_info.cell[cell_info.cell_num].value1 = (uint32)tmp_int;
            if (at_tok_nextint(&line, &tmp_int) < 0)
            {
                goto EEMLTEINTER_EXIT;
            }
            cell_info.cell[cell_info.cell_num].value2 = (uint32)tmp_int;
            if (at_tok_nextint(&line, &tmp_int) < 0)
            {
                goto EEMLTEINTER_EXIT;
            }
            cell_info.cell[cell_info.cell_num].value3 = (uint32)tmp_int;
            LOG("cell line : %s", line);
            if (at_tok_nextint(&line, &tmp_int) < 0)
            {
                goto EEMLTEINTER_EXIT;
            }
            cell_info.cell[cell_info.cell_num].value4 = (uint32)tmp_int;
            if (at_tok_nextint(&line, &tmp_int) < 0)
            {
                LOG("cell tmp_int : %d", tmp_int);
                goto EEMLTEINTER_EXIT;
            }
            cell_info.cell[cell_info.cell_num].value5 = (uint32)tmp_int;
            LOG("cell value5 : %d", cell_info.cell[cell_info.cell_num].value5);
            cell_info.cell_num++;
EEMLTEINTER_EXIT:
            free(free_ptr);
        }
    }
    // Do nothing
    else if(strStartsWith(s, "+EEMLTEINTERRAT:")) // LTE RATСϢ
    {
        if(cell_info.running) {

        }
    }
    // WCDMA
    /*
    // Mode, sCMeasPresent, sCParamPresent, ueOpStatusPresent,

    // if sCMeasPresent == 1
    // cpichRSCP, utraRssi, cpichEcN0, sQual, sRxLev, txPower,
    // endif

    // if sCParamPresent == 1
    // rac, nom, mcc, mnc_len, mnc, lac, ci,
    // uraId, psc, arfcn, t3212, t3312, hcsUsed, attDetAllowed,
    // csDrxCycleLen, psDrxCycleLen, utranDrxCycleLen, HSDPASupport, HSUPASupport,
    // endif

    // if ueOpStatusPresent == 1
    // rrcState, numLinks, srncId, sRnti,
    // algPresent, cipherAlg, cipherOn, algPresent, cipherAlg, cipherOn,
    // HSDPAActive, HSUPAActive, MccLastRegisteredNetwork, MncLastRegisteredNetwork, TMSI, PTMSI, IsSingleMmRejectCause, IsSingleGmmRejectCause,
    // MMRejectCause, GMMRejectCause, mmState, gmmState, gprsReadyState, readyTimerValueInSecs, NumActivePDPContext, ULThroughput, DLThroughput,
    // serviceStatus, pmmState, LAU_status, LAU_count, RAU_status, RAU_count
    // endif
    //
    +EEMUMTSSVC: 3, 1, 1, 1,
    -80, 27, -6, -18, -115, -32768,
    1, 1, 1120, 2, 1, 61697, 168432821,
    15, 24, 10763, 0, 0, 0, 0,
    128, 128, 65535, 0, 0,
    2, 255, 65535, 4294967295,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 1, 1,
    28672, 28672, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0
    */
    else if(strStartsWith(s, "+EEMUMTSSVC:")) // WCDMA Server Cell
    {
        // lac, ci, arfcn
        if(cell_info.running) {
            int tmp_int;
            int i = 0;
            char* tmp_s = memdup(s,strlen(s));
            char* free_ptr = tmp_s;
            char *line = tmp_s;
            if (at_tok_start(&line) < 0)
            {
                goto EEMUMTSSVC_EXIT;
            }
            // Jump 12 integer.
            i = 0;
            while(i < 12) {
                if (at_tok_nextint(&line, &tmp_int) < 0)
                {
                    goto EEMUMTSSVC_EXIT;
                }
                i++;
            }
            // mcc
            if (at_tok_nextint(&line, &tmp_int) < 0)
            {
                goto EEMUMTSSVC_EXIT;
            }
            cell_info.cell[cell_info.cell_num].value4= (uint32)tmp_int;
            // mnc
            if (at_tok_nextint(&line, &tmp_int) < 0)
            {
                goto EEMUMTSSVC_EXIT;
            }
            cell_info.cell[cell_info.cell_num].value5= (uint32)tmp_int;
            // lac
            if (at_tok_nextint(&line, &tmp_int) < 0)
            {
                goto EEMUMTSSVC_EXIT;
            }
            cell_info.cell[cell_info.cell_num].value1 = (uint32)tmp_int;
            // ci
            if (at_tok_nextint(&line, &tmp_int) < 0)
            {
                goto EEMUMTSSVC_EXIT;
            }
            cell_info.cell[cell_info.cell_num].value2 = (uint32)tmp_int;

            if (at_tok_nextint(&line, &tmp_int) < 0)
            {
                goto EEMUMTSSVC_EXIT;
            }
            // cpi
            if (at_tok_nextint(&line, &tmp_int) < 0)
            {
                goto EEMUMTSSVC_EXIT;
            }
            cell_info.cell[cell_info.cell_num].value6= (uint32)tmp_int;
            /*
            // Jump 2 integer.
            i = 0;
            while(i < 2) {
                if (at_tok_nextint(&line, &tmp_int) < 0)
                {
                    goto EEMUMTSSVC_EXIT;
                }
                i++;
            }
            */
            // arfcn
            if (at_tok_nextint(&line, &tmp_int) < 0)
            {
                goto EEMUMTSSVC_EXIT;
            }
            cell_info.cell[cell_info.cell_num].value3 = (uint32)tmp_int;

            cell_info.cell_num++;
EEMUMTSSVC_EXIT:
            free(free_ptr);
        }
    }
    /*
    // index, cpichRSCP, utraRssi, cpichEcN0, sQual, sRxLev ,mcc, mnc, lac, ci, arfcn, psc
    +EEMUMTSINTRA: 0, -32768, -1, -32768, -18, -115, 0, 0, 65534, 1, 10763, 32
    */
    else if(strStartsWith(s, "+EEMUMTSINTRA:")) // WCDMAٽС
    {
        // lac, ci, arfcn
        if(cell_info.running) {
            int tmp_int;
            int i = 0;
            char* tmp_s = memdup(s,strlen(s));
            char* free_ptr = tmp_s;
            char *line = tmp_s;
            if (at_tok_start(&line) < 0)
            {
                goto EEMUMTSINTRA_EXIT;
            }
            // Jump 8 integer.
            i = 0;
            while(i < 8) {
                if (at_tok_nextint(&line, &tmp_int) < 0)
                {
                    goto EEMUMTSINTRA_EXIT;
                }
                i++;
            }

            // lac
            if (at_tok_nextint(&line, &tmp_int) < 0 || tmp_int <= 0 || tmp_int >= 65536)
            {
                goto EEMUMTSINTRA_EXIT;
            }
            cell_info.cell[cell_info.cell_num].value1 = (uint32)tmp_int;

            // ci
            if (at_tok_nextint(&line, &tmp_int) < 0 || tmp_int <= 0 || tmp_int >= 65536)
            {
                goto EEMUMTSINTRA_EXIT;
            }
            cell_info.cell[cell_info.cell_num].value2 = (uint32)tmp_int;

            // arfcn
            if (at_tok_nextint(&line, &tmp_int) < 0 || tmp_int <= 0 || tmp_int >= 65536)
            {
                goto EEMUMTSINTRA_EXIT;
            }
            cell_info.cell[cell_info.cell_num].value3 = (uint32)tmp_int;

            cell_info.cell_num++;
EEMUMTSINTRA_EXIT:
            free(free_ptr);
        }
    }
    /*
    // index,gsmRssi,rxLev,C1,C2,mcc,mnc,lac,ci,arfcn,bsic
    +EEMUMTSINTERRAT: 0, -32768, -107, -1, -1, 0, 0, 65534, 0, 117, 36
    */
    else if(strStartsWith(s, "+EEMUMTSINTERRAT:")) // WCDMA RATСϢ
    {
        // lac, ci, arfcn
        if(cell_info.running) {
            int tmp_int;
            int i = 0;
            char* tmp_s = memdup(s,strlen(s));
            char* free_ptr = tmp_s;
            char *line = tmp_s;
            if (at_tok_start(&line) < 0)
            {
                goto EEMUMTSINTERRAT_EXIT;
            }
            // Jump 7 integer.
            i = 0;
            while(i < 7) {
                if (at_tok_nextint(&line, &tmp_int) < 0)
                {
                    goto EEMUMTSINTERRAT_EXIT;
                }
                i++;
            }

            // lac
            if (at_tok_nextint(&line, &tmp_int) < 0 || tmp_int <= 0 || tmp_int >= 65536)
            {
                goto EEMUMTSINTERRAT_EXIT;
            }
            cell_info.cell[cell_info.cell_num].value1 = (uint32)tmp_int;

            // ci
            if (at_tok_nextint(&line, &tmp_int) < 0 || tmp_int <= 0 || tmp_int >= 65536)
            {
                goto EEMUMTSINTERRAT_EXIT;
            }
            cell_info.cell[cell_info.cell_num].value2 = (uint32)tmp_int;

            // arfcn
            if (at_tok_nextint(&line, &tmp_int) < 0 || tmp_int <= 0 || tmp_int >= 65536)
            {
                goto EEMUMTSINTERRAT_EXIT;
            }
            cell_info.cell[cell_info.cell_num].value3 = (uint32)tmp_int;

            cell_info.cell_num++;
EEMUMTSINTERRAT_EXIT:
            free(free_ptr);
        }
    }
    // GSM
    // +EEMGINFOBASIC: 2
    // Do nothing.
    else if(strStartsWith(s, "+EEMGINFOBASIC:")) // Basic information in GSM
        // 0: ME in Idle mode   1: ME in Dedicated mode   2: ME in PS PTM mode
    {
        if(cell_info.running) {

        }
    }
    /*
    // mcc, mnc_len, mnc, lac, ci, nom, nco,
    // bsic, C1, C2, TA, TxPwr,
    // RxSig, RxSigFull, RxSigSub, RxQualFull, RxQualSub,
    // ARFCB_tch, hopping_chnl, chnl_type, TS, PacketIdle, rac, arfcn,
    // bs_pa_mfrms, C31, C32, t3212, t3312, pbcch_support, EDGE_support,
    // ncc_permitted, rl_timeout, ho_count, ho_succ, chnl_access_count, chnl_access_succ_count,
    // gsmBand,channelMode
    +EEMGINFOSVC: 1120, 2, 0, 32784, 24741, 2, 0,
    63, 36, 146, 1, 7,
    46, 42, 42, 7, 0,
    53, 0, 8, 0, 1, 6, 53,
    2, 0, 146, 42, 54, 0, 1,
    1, 32, 0, 0, 0, 0,
    0, 0
    */
    else if(strStartsWith(s, "+EEMGINFOSVC:")) // GSM Server Cell
    {
        // lac, ci, arfcn, bsic
        LOG("+EEMGINFOSVC: 1= %d\n.",cell_info.running);
        if(cell_info.running) {
            int tmp_int;
            int i = 0;
            char* tmp_s = memdup(s,strlen(s));
            char* free_ptr = tmp_s;
            char *line = tmp_s;
            if (at_tok_start(&line) < 0)
            {
                goto EEMGINFOSVC_EXIT;
            }

            // mcc
            if (at_tok_nextint(&line, &tmp_int) < 0 || tmp_int <= 0 || tmp_int >= 65536)
            {
                goto EEMGINFOSVC_EXIT;
            }
            cell_info.cell[cell_info.cell_num].value5 = (uint32)tmp_int;

            //mnc_len
            if (at_tok_nextint(&line, &tmp_int) < 0 || tmp_int <= 0 || tmp_int >= 65536)
            {
                goto EEMGINFOSVC_EXIT;
            }
            // mnc
            if (at_tok_nextint(&line, &tmp_int) < 0 || tmp_int <= 0 || tmp_int >= 65536)
            {
                goto EEMGINFOSVC_EXIT;
            }
            cell_info.cell[cell_info.cell_num].value6 = (uint32)tmp_int;

            /*
            // Jump 3 integer.
            i = 0;
            while(i < 3) {
                if (at_tok_nextint(&line, &tmp_int) < 0)
                {
                    goto EEMGINFOSVC_EXIT;
                }
                i++;
            }
            */
            // lac
            if (at_tok_nextint(&line, &tmp_int) < 0 || tmp_int < 0 || tmp_int >= 65536)
            {
                goto EEMGINFOSVC_EXIT;
            }
            cell_info.cell[cell_info.cell_num].value1 = (uint32)tmp_int;

            // ci
            if (at_tok_nextint(&line, &tmp_int) < 0 || tmp_int < 0 || tmp_int >= 65536)
            {
                goto EEMGINFOSVC_EXIT;
            }
            cell_info.cell[cell_info.cell_num].value2 = (uint32)tmp_int;

            // Jump 2 integer.
            i = 0;
            while(i < 2) {
                if (at_tok_nextint(&line, &tmp_int) < 0)
                {
                    goto EEMGINFOSVC_EXIT;
                }
                i++;
            }

            // bsic
            if (at_tok_nextint(&line, &tmp_int) < 0 || tmp_int < 0 || tmp_int >= 65536)
            {
                goto EEMGINFOSVC_EXIT;
            }
            cell_info.cell[cell_info.cell_num].value4 = (uint32)tmp_int;

            // Jump 15 integer.
            i = 0;
            while(i < 15) {
                if (at_tok_nextint(&line, &tmp_int) < 0)
                {
                    goto EEMGINFOSVC_EXIT;
                }
                i++;
            }

            // arfcn
            if (at_tok_nextint(&line, &tmp_int) < 0 || tmp_int < 0 || tmp_int >= 65536)
            {
                goto EEMGINFOSVC_EXIT;
            }
            cell_info.cell[cell_info.cell_num].value3 = (uint32)tmp_int;

            cell_info.cell_num++;
EEMGINFOSVC_EXIT:
            free(free_ptr);
        }
    }
    /*
    // PS_attached, attach_type, service_type, tx_power, c_value,
    // ul_ts, dl_ts, ul_cs, dl_cs, ul_modulation, dl_modulation,
    // gmsk_cv_bep, 8psk_cv_bep, gmsk_mean_bep, 8psk_mean_bep, EDGE_bep_period, single_gmm_rej_cause
    // pdp_active_num, mac_mode, network_control, network_mode, EDGE_slq_measurement_mode, edge_status
    +EEMGINFOPS: 1, 255, 0, 0, 0,
    0, 0, 268435501, 1, 0, 0,
    4, 0, 96, 0, 0, 0,
    0, 0, 0, 65535, 0, 13350
    */
    // Do nothing.
    else if(strStartsWith(s, "+EEMGINFOPS:")) // PSϢ
    {
        if(cell_info.running) {

        }
    }
    else if(strStartsWith(s, "+EEMGINFONC:")) // cell
    {
        if(cell_info.running) {
            int tmp_int;
            int i = 0;
            char* tmp_s = memdup(s,strlen(s));
            char* free_ptr = tmp_s;
            char *line = tmp_s;
            if (at_tok_start(&line) < 0)
            {
                goto EEMGINFOPS_EXIT;
            }

            // nc_num
            if (at_tok_nextint(&line, &tmp_int) < 0 || tmp_int < 0 || tmp_int >= 65536)
            {
                LOG("cell_info.running 1= %d\n.",cell_info.running);
                goto EEMGINFOPS_EXIT;
            }
            // mcc
            if (at_tok_nextint(&line, &tmp_int) < 0 || tmp_int < 0 || tmp_int >= 65536)
            {
                LOG("cell_info.running 2= %d\n.",cell_info.running);
                goto EEMGINFOPS_EXIT;
            }
            cell_info.cell[cell_info.cell_num].value5 = (uint32)tmp_int;

            // mnc
            if (at_tok_nextint(&line, &tmp_int) < 0 || tmp_int < 0 || tmp_int >= 65536)
            {
                LOG("cell_info.running 3= %d\n.",cell_info.running);
                goto EEMGINFOPS_EXIT;
            }
            cell_info.cell[cell_info.cell_num].value6 = (uint32)tmp_int;

            // lac
            if (at_tok_nextint(&line, &tmp_int) < 0 || tmp_int < 0 || tmp_int >= 65536)
            {
                LOG("cell_info.running 4= %d\n.",cell_info.running);
                goto EEMGINFOPS_EXIT;
            }
            cell_info.cell[cell_info.cell_num].value1 = (uint32)tmp_int;

            // rac
            if (at_tok_nextint(&line, &tmp_int) < 0 || tmp_int < 0 || tmp_int >= 65536)
            {
                LOG("cell_info.running 5= %d\n.",cell_info.running);
                goto EEMGINFOPS_EXIT;
            }

            // ci
            if (at_tok_nextint(&line, &tmp_int) < 0 || tmp_int < 0 || tmp_int >= 65536)
            {
                LOG("cell_info.running 6= %d\n.",cell_info.running);
                goto EEMGINFOPS_EXIT;
            }
            cell_info.cell[cell_info.cell_num].value2 = (uint32)tmp_int;

            // rx_lv
            if (at_tok_nextint(&line, &tmp_int) < 0)
            {
                LOG("cell_info.running 7= %d\n.",cell_info.running);
                goto EEMGINFOPS_EXIT;
            }

            // bsic
            if (at_tok_nextint(&line, &tmp_int) < 0 || tmp_int < 0 || tmp_int >= 65536)
            {
                LOG("cell_info.running 8= %d\n.",cell_info.running);
                goto EEMGINFOPS_EXIT;
            }
            cell_info.cell[cell_info.cell_num].value4 = (uint32)tmp_int;

            // Jump 2 integer.
            i = 0;
            while(i < 2) {
                if (at_tok_nextint(&line, &tmp_int) < 0)
                {
                    LOG("cell_info.running 9= %d\n.",cell_info.running);
                    goto EEMGINFOPS_EXIT;
                }
                i++;
            }

            // arfcn
            if (at_tok_nextint(&line, &tmp_int) < 0 || tmp_int < 0 || tmp_int >= 65536)
            {
                LOG("cell_info.running 10 = %d\n.",cell_info.running);
                goto EEMGINFOPS_EXIT;
            }
            cell_info.cell[cell_info.cell_num].value3 = (uint32)tmp_int;

            cell_info.cell_num++;
EEMGINFOPS_EXIT:
            free(free_ptr);
        }
    }
    else if(strStartsWith(s, "+ZGIPDNS:")) // +ZGIPDNS: 1,"IPV4V6","10.156.239.245","10.156.239.246","223.87.253.100","223.87.253.253","fe80:0000:0000:0000:0001:0001:9b8c:7c0c","fe80::1:1:9b8c:7c0d","2409:8062:2000:2::1","2409:8062:2000:2::2"
    {

    }
    else
    {
        LOGV("Unknown URC : %s", s);
    }
}

static int openSocket(const char* sockname)
{
    int sock = socket(AF_UNIX, SOCK_STREAM, 0);
    if (sock < 0)
    {
        LOGE("Error create socket: %s\n", strerror(errno));
        return -1;
    }
    struct sockaddr_un addr;
    memset(&addr, 0, sizeof(addr));
    addr.sun_family = AF_UNIX;
    strncpy(addr.sun_path, sockname, sizeof(addr.sun_path));
    while (TEMP_FAILURE_RETRY(connect(sock,(const struct sockaddr*)&addr, sizeof(addr))) != 0)
    {
        LOGE("Error connect to socket %s: %s, try again", sockname, strerror(errno));
        sleep(1);
    }

#if 0
    int sk_flags = fcntl(sock, F_GETFL, 0);
    fcntl(sock, F_SETFL, sk_flags | O_NONBLOCK);
#endif

    return sock;
}

static void ril_get_cgpaddr_ip_process()
{
    int err, skip;
    ATResponse *p_response = NULL;
    char *line;
    char *ipv4 = NULL, *ipv6 = NULL;
    err = at_send_command_singleline("AT+CGPADDR", "+CGPADDR:", &p_response);
    if ((err < 0) || (p_response == NULL) || (p_response->success == 0))
    {
        LOGE("+CGPADDR exec error.");
        goto error;
    }

    // +CGPADDR: 1, "10.51.59.229", "254.128.0.0.0.0.0.0.0.1.0.0.111.176.63.99"
    // +CGPADDR: 1, "10.124.139.131"
    line = p_response->p_intermediates->line;
    err = at_tok_start(&line);
    if (err < 0)
    {
        goto error;
    }

    err = at_tok_nextint(&line, &skip);
    if (err < 0)
    {
        goto error;
    }

    if (!at_tok_hasmore(&line))
    {
        goto error;
    }

    err = at_tok_nextstr(&line, &ipv4);
    if (err < 0)
    {
        LOGE("Get IPv4 fail.");
        goto error;
    }

    if (at_tok_hasmore(&line))
    {
        err = at_tok_nextstr(&line, &ipv6);
        if (err < 0)
        {
            LOGE("Get IPv6 fail.");
            goto error;
        }
    }
    else
    {
        LOGD("No IPv6 Found.");
    }

    if(ipv6)
    {
        LOGD("IPv6 : %s", ipv6);
    }

    if(ipv4)
    {
        LOGD("IPv4 : %s", ipv4);

//        ril_net_dev_config("ccinet0", ipv4, NULL);
    }
error:
    at_response_free(p_response);
}

static void sim_state_change(bool plug_in) {
    if(plug_in) {
        // If radio on,must off in the first.
        if(net_info.radio_state == MBTK_RADIO_STATE_ON) {
            setRadioPower(0);
        }
        setRadioPower(1);
    } else {
        setRadioPower(0);
    }
}

static int open_uevent_socket()
{
    struct sockaddr_nl addr;
    int sz = 64*1024;
    int s = 0;

    memset(&addr, 0, sizeof(addr));
    addr.nl_family = AF_NETLINK;
    addr.nl_pid = getpid();
    addr.nl_groups = 0xffffffff;

    s = socket(PF_NETLINK, SOCK_DGRAM, NETLINK_KOBJECT_UEVENT);
    if (s < 0)
    {
        LOGE("socket() fail.[%d]", errno);
        return -1;
    }

    setsockopt(s, SOL_SOCKET, SO_RCVBUFFORCE, &sz, sizeof(sz));

    if (bind(s, (struct sockaddr *) &addr, sizeof(addr)) < 0)
    {
        close(s);
        return -1;
    }

    return s;
}

static void parse_uevent(const char *msg, int msg_len, struct cooling_device *cdev)
{
    // change@/devices/virtual/usim_event/usim0\0
    // ACTION=change\0
    // DEVPATH=/devices/virtual/usim_event/usim0\0
    // SUBSYSTEM=usim_event\0
    // USIM_NAME=usim0\0
    // USIM_EVENT=plugout\0
    // SEQNUM=704
    int i = 0;
    while (i < msg_len)
    {
        if(*(msg + i) == '\0')
        {
            i++;
            continue;
        }
        if (!strncmp(msg + i, "USIM_NAME=", 10))
        {
            i += 10;
            cdev->name = msg + i;
            i += strlen(msg + i);
        }
        else if (!strncmp(msg + i, "ACTION=", 7))
        {
            i += 7;
            cdev->action = msg + i;
            i += strlen(msg + i);
        }
        else if (!strncmp(msg + i, "DEVPATH=", 8))
        {
            i += 8;
            cdev->path = msg + i;
            i += strlen(msg + i);
        }
        else if (!strncmp(msg + i, "USIM_EVENT=", 11))
        {
            i += 11;
            cdev->event = msg + i;
            i += strlen(msg + i);
        }
        else if (!strncmp(msg + i, "SUBSYSTEM=", 10))
        {
            i += 10;
            cdev->subsystem = msg + i;
            i += strlen(msg + i);
        }
        else
        {
            i++;
        }
    }

    if(!strncmp(cdev->path, UEVENT_USIM_DEV, sizeof(UEVENT_USIM_DEV))
       && !strncmp(cdev->action, "change", 5))
    {
        LOGD("event { name=%s, action=%s, path=%s, subsystem=%s, event=%s}",
             cdev->name,    cdev->action, cdev->path, cdev->subsystem, cdev->event);
        if(!strcmp(cdev->event, "plugout"))
        {
            sim_state_change(FALSE);
        }
        else if(!strcmp(cdev->event, "plugin"))
        {
            sim_state_change(TRUE);
        }
        else
        {
            LOGE("usim evnet error!");
        }
    }
}

static void* uevnet_run(void *payload)
{
    int socket_fd = -1;
    char msg[BUFFER_SIZE+2];
    int n;

    socket_fd = open_uevent_socket();
    if(socket_fd > 0)
    {
        while(1)
        {
            if((n = recv(socket_fd, msg, BUFFER_SIZE, 0)) > 0)
            {
                struct cooling_device cdev;
                memset(&cdev, 0x0, sizeof(cdev));

                if(n == BUFFER_SIZE)
                    continue;
                msg[n] = '\0';
                // change@/devices/virtual/usim_event/usim0\0ACTION=change\0DEVPATH=/devices/virtual/usim_event/usim0\0SUBSYSTEM=usim_event\0USIM_NAME=usim0\0USIM_EVENT=plugout\0SEQNUM=704
                log_hex("UEVENT", msg, n);
                parse_uevent(msg, n, &cdev);
            }
            else
            {
                LOGE("recv msg error.");
            }
        }
    }

    LOGD("UEVENT Thread exit!!!");
    return NULL;
}

int uevent_main()
{
    mbtk_task_info task;
    task.task_id = &uevnet_task_id;
    task.thread_run = uevnet_run;
    task.args = NULL;
    return mbtk_task_start(&task);
}

/*
int ril_main()
{
    return mbtk_task_queue_start(&ril_task, ril_main_run);
}
*/

int mbtk_info_server_start();
int InProduction_Mode(void);
void server_ready_set(void);


/*
 *Get mtdblock which name is ASR_FLAG
 *return path if found, else return NULL
 */
static int asrFlagPathGet(char *asr_flag_path)
{
	char buf[128];
	unsigned char find = 0;
	FILE *fd = fopen("/proc/mtd", "r");
	if (fd == NULL) {
		LOGE("Open MTD failed!");
		return -1;
	}

	memset(buf, '\0', 128);
	while (fgets(buf, 128, fd) != NULL) {
		if(strstr(buf, "asr_flag")) {
			char *p = strstr(buf, "mtd");
			if(p)
			{
				int bln;
				sscanf(p, "mtd%d", &bln);
				sprintf(asr_flag_path, "/dev/mtdblock%d", bln);
				find = 1;
				break;
			}
		}
		memset(buf, '\0', 128);
	}

	fclose(fd);
	return ((find == 1) ? 0 : -1);
}

static int readFromMTD(const char *path, unsigned int offset, void *buf, int size)
{
	int ret, fd;
	if (!path)
		return -1;

	fd = open(path, O_RDONLY);
	if (fd < 0) {
		LOGE("readFromMTD open error,%d", errno);
		return -1;
	}

	ret = lseek(fd, offset, SEEK_SET);
	if (ret < 0) {
		close(fd);
		LOGE("readFromMTD lseek error,%d", errno);
		return -1;
	}
	ret = read(fd, buf, size);
	if (ret < 0) {
		close(fd);
		LOGE("readFromMTD read error,%d", errno);
		return -1;
	}
	close(fd);
	return 0;
}

static int writeToMTD(const char *path, unsigned int offset, void *buf, int size)
{
	int ret, fd;

	if (!path)
		return -1;

	fd = open(path, O_RDWR | O_SYNC);
	if (fd < 0)
		return -1;

	ret = lseek(fd, offset, SEEK_SET);
	if (ret < 0) {
		close(fd);
		return -1;
	}
	ret = write(fd, buf, size);
	if (ret < 0) {
		LOGE("writetomtd:write error:%d", errno);
		close(fd);
		return -1;
	}

	close(fd);
	return 0;
}

static void fota_result_check()
{
#if 0
    ASR_flag tag;
    char asr_flag_path[30] = {0};
    if(asrFlagPathGet(asr_flag_path)) {
        LOGE("getAsrFlagPath() fail.");
        return;
    }

    if(readFromMTD(asr_flag_path, ASR_FLAG_OFFSET, &tag, sizeof(tag)) < 0)
    {
        LOGE("Get FOTA result fail.");
    }
    else
    {
        LOGD("FOTA result : %d, %d", tag.fota_result[0], tag.fota_result[1]);
        tag.fota_result[0] = 0;
        tag.fota_result[1] = 0;
        if(writeToMTD(asr_flag_path, ASR_FLAG_OFFSET, &tag, sizeof(tag)) < 0)
        {
            LOGE("FOTA result update fail.");
        } else {
            LOGD("FOTA result update success.");
        }
    }
#endif
}

static void mbtk_ril_ready()
{
    // /etc/init.d/mbtk_boot_server_ready
    if(is_first_boot) {
        if(access(MBTK_BOOT_SERVER_READY , X_OK) == 0) {
            LOGD("Exec : %s", MBTK_BOOT_SERVER_READY);
            system(MBTK_BOOT_SERVER_READY);
        } else {
            LOGE("%s can not exec.", MBTK_BOOT_SERVER_READY);
        }
    } else {
        LOGD("No exec : %s", MBTK_BOOT_SERVER_READY);
    }
}

#if 1
int main(int argc, char *argv[])
{
    mbtk_log_init("radio", "MBTK_RIL");

    MBTK_SOURCE_INFO_PRINT("mbtk_rild");

#ifdef MBTK_DUMP_SUPPORT
    mbtk_debug_open(NULL, TRUE);
#endif

// Using Killall,the file lock may be not release.
#if 0
    if(app_already_running(MBTK_RILD_PID_FILE)) {
        LOGW("daemon already running.");
        exit(1);
    }
#endif

    LOGI("mbtk_ril start.");

    int fd = open(MBTK_RILD_TEMP_FILE, O_CREAT | O_RDWR, 0644);
    if(fd > 0) {
        char buff[10] = {0};
        int count = 0;
        if(read(fd, buff, sizeof(buff)) > 0) {
            count = atoi(buff);
        } else {
            count = 0;
        }

        if(count <= 0) {
            is_first_boot = TRUE;
            count = 0;
        } else {
            is_first_boot = FALSE;
        }

        count++;
        memset(buff, 0, sizeof(buff));
        snprintf(buff, sizeof(buff), "%d", count);
        write(fd, buff, strlen(buff));
        close(fd);
    } else {
        is_first_boot = FALSE;
        LOGE("Open %s fail:%d", MBTK_RILD_TEMP_FILE, errno);
        LOGW("Will not exec %s and %s.", MBTK_BOOT_SERVER_READY, MBTK_BOOT_NET_READY);
    }

    if(InProduction_Mode()) {
        LOGI("Is Production Mode, will exit...");
        exit(0);
    }

    int at_sock = openSocket("/tmp/atcmd_at");
    if(at_sock < 0)
    {
        LOGE("Open AT Socket Fail[%d].", errno);
        return -1;
    }
    int uart_sock = openSocket("/tmp/atcmd_urc");
    if(uart_sock < 0)
    {
        LOGE("Open Uart Socket Fail[%d].", errno);
        return -1;
    }

    at_set_on_reader_closed(onATReaderClosed);
    at_set_on_timeout(onATTimeout);

    if(at_open(at_sock, uart_sock, onUnsolicited))
    {
        LOGE("Start AT thread fail.");
        return -1;
    }

#if 1
    if(at_handshake())
    {
        LOGE("AT handshake fail.");
        return -1;
    }
#endif

    LOGD("AT OK.");

    if(mbtk_info_server_start())
    {
        LOGE("mbtk_info_server_start() fail.");
        return -1;
    }

    char led_enable_str[10];
    memset(led_enable_str, 0, 10);
    property_get("persist.mbtk.led_enable", led_enable_str, "1");
    if(atoi(led_enable_str) == 1) { // NTP time
        LOG("Start LED thread.");
        mbtk_led_init();
    }

#if 0
    if(uevent_main())
    {
        LOGE("Start uevent thread fail.");
        return -1;
    }
#endif

    char time_type[10];
    memset(time_type, 0, 10);
    property_get("persist.mbtk.time_type", time_type, "0");
    if(atoi(time_type) == MBTK_TIME_TYPE_NTP) { // NTP time
        LOG("Start NTP thread.");
        ntp_thread_start();
    }

    fota_result_check();

    mbtk_ril_ready();

    server_ready_set();//Set the server readiness state
    while(1)
    {
        sleep(24 * 60 * 60);
    }

    LOGD("!!!mbtk_ril exit!!!");
    return 0;
}

#else
int main()
{
    char buff[BUFFER_SIZE + 1] = {0};
    if(!mbtk_at("AT+CFUN=1", buff, BUFFER_SIZE))
    {
        LOGD("+CFUN RSP:%s", buff);
        while(1)
        {
            sleep(1);
            memset(buff, 0x0, BUFFER_SIZE + 1);
            if(!mbtk_at("AT+CGPADDR", buff, BUFFER_SIZE))
            {
                LOGD("+CGPADDR RSP:%s", buff);
                if(strstr(buff, "+CGPADDR:"))
                {
                    // +CGPADDR: 1, "10.99.223.168", "254.128.0.0.0.0.0.0.0.1.0.0.117.9.250.59"
                    //
                    // OK
                    char *ip_start = NULL;
                    char *ip_end = NULL;
                    char ipv4[50] = {0};
                    ip_start = strstr(buff,"\"");
                    if(ip_start)
                        ip_end = strstr(ip_start + 1, "\"");
                    if(ip_start && ip_end && ip_end - ip_start - 1 > 0)
                    {
                        memcpy(ipv4, ip_start + 1, ip_end - ip_start - 1);
                        LOGD("IP : %s", ipv4);
                        if(!mbtk_ifc_open())
                        {
                            in_addr_t addr;
                            inet_aton(ipv4,(struct in_addr *)&addr);
                            LOGD("IP : %s -> %x", ipv4, addr);
                            if(!mbtk_ifc_set_addr("ccinet0", addr, 0))
                            {
                                mbtk_ifc_up("ccinet0");
                            }

                            mbtk_ifc_close();
                        }

                        system("route add default dev ccinet0");

                        LOGD("Set IP success.");
                    }
                    else
                    {
                        LOGD("Get IP fail.");
                    }

                    break;
                }
            }
        }
    }

    return 0;
}
#endif
