#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <netinet/in.h>
#include <pthread.h>
#include <sys/epoll.h>
#include <fcntl.h>
#include <signal.h>

#include "mbtk_type.h"
#include "mbtk_info.h"
#include "atchannel.h"
#include "at_tok.h"
#include "mbtk_utils.h"
#include "info_data.h"
#include "mbtk_log.h"

void pack_rsp_send(int fd, int info_id, const void* data, int data_len);

/*
AT+CMGF?
+CMGF: 0

OK

*/
static int req_cmgf_get(int *state, int *cme_err)
{
    ATResponse *response = NULL;
    char *tmp_ptr = NULL;
    int err = at_send_command_singleline("AT+CMGF?", "", &response);

    if (err < 0 || response->success == 0 || !response->p_intermediates){
        *cme_err = at_get_cme_error(response);
        goto exit;
    }

    char *line = response->p_intermediates->line;
    printf("req_cmgf_get() ---line:%s\n", line);
    char* ptr = strstr(line, "+CMGF: ");
    printf("req_cmgf_get() ---ptr:%s\n",ptr);
    if(ptr)
    {
        *state = atoi(ptr + strlen("+CMGF: "));
    }
    else
    {
        err = -1;
    }
exit:
    at_response_free(response);
    return err;
}

/*
AT+CMGF=0"
or
AT+CMGF=1"

OK
*/
static int req_cmgf_set(int state, int *cme_err)
{
    LOGD("req_cmgf_set()-------------start");
    LOGD("state:%d",state);
    ATResponse *response = NULL;
    char cmd[30] = {0};
    if(state)
    {
        strcpy(cmd, "AT+CMGF=1");
    }
    else
    {
        strcpy(cmd, "AT+CMGF=0");
    }

    LOGD("req_cmgf_set()----cmd:%s", cmd);
    int err = at_send_command(cmd, &response);

    if (err < 0 || response->success == 0) {
        *cme_err = at_get_cme_error(response);
        goto exit;
    }

    err = 0;
exit:
    at_response_free(response);
    return err;
}

/*set AT+CNMI=1,2*/
static int req_cnmi_set(int *cme_err)
{
    printf("req_cnmi_set()-------------start3\n");
    ATResponse *response = NULL;
    char cmd[30] = {0};

	strcpy(cmd, "AT+CNMI=1,2");

    printf("req_cnmi_set()----cmd:%s\n", cmd);
    int err = at_send_command(cmd, &response);

    if (err < 0 || response->success == 0) {
		printf("err:%d, response->success:%d \n", err, response->success);
        *cme_err = at_get_cme_error(response);
        goto exit;
    }

    err = 0;
exit:
    at_response_free(response);
    printf("exit,err:%d\n", err);
    return err;
}

/*
AT+CPMS?

+CPMS: "SM",15,50,"SM",15,50,"SM",15,50

OK

*/
static int req_cpms_get(char *reg, int *cme_err)
{
	printf("req_cpms_get------------start(3)\n");
    ATResponse *response = NULL;
    char *tmp_ptr = NULL;
    int err = at_send_command_singleline("AT+CPMS?", "", &response);

    if (err < 0 || response->success == 0 || !response->p_intermediates){
        *cme_err = at_get_cme_error(response);
        goto exit;
    }

	ATLine* lines_ptr = response->p_intermediates;
	char *line = NULL;
	int len = 0;
	while(lines_ptr)
	{
		line = lines_ptr->line;
		if(line ==NULL)
		{
			printf("line is null----------------------\n");
		}

		printf("-----------line:%s, strlen:%d, len:%d----------\n", line, strlen(line), len);
		memcpy(reg+len, line, strlen(line));
        len += strlen(line);
		lines_ptr = lines_ptr->p_next;
	}

	printf("cpms_get()------reg:%s\n", reg);

exit:
    at_response_free(response);
    return err;
}



/*
AT+CPMS=<mem1>[,<mem2>[,<mem3>]]
AT+CPMS="ME","ME","ME"

+CPMS: 14,50,14,50,14,50

OK

*/
static int req_cpms_set(const char *mem, char *reg, int len, int *cme_err)
{
    printf("req_cpms_set(2)----------------start\n");
    printf("mem:%s\n", mem);
    ATResponse *response = NULL;
    char cmd[30] = {0};
    int err = 0;
	char data[20] = {0};

    if(mem != NULL)
    {
    	memcpy(data, mem, len);
        sprintf(cmd, "AT+CPMS=%s", data);
    }
    else{
        printf("mem is null\n");
    }

	printf("cmd:%s,data:%s---------\n", cmd,data);

	if(strlen(cmd) > 8)
	{
        err = at_send_command_multiline(cmd, "+CPMS:", &response);
        if (err < 0 || response->success == 0){
            *cme_err = at_get_cme_error(response);
            goto exit;
        }

        char *line = response->p_intermediates->line;
        printf("line:%s, len:%d\n", line, strlen(line));

        memcpy(reg, line, strlen(line));

        printf("cpms_reg:%s\n", reg);
	}
    err = 0;
exit:
    printf("goto exit do");
    at_response_free(response);
    return err;
}

/*
if PDU mode (+CMGF=0):
	AT+CMGS=<length><CR>
PDU is given<ctrl-Z/ESC>
if text mode (+CMGF=1):
	AT+CMGS=<da>[,<toda>]<CR>
text is entered<ctrl-Z/ESC>

	AT+CMGS=15775690697,hello world


*/
static int req_cmgs_set(char *cmgs, char *reg, int len, int *cme_err)
{
    LOGD("req_cmgs_set()----------------start");
    LOGD("cmgs:%s", cmgs);
    ATResponse *response = NULL;
    char cmd[30] = {0};
	char data[218] = {0};
	char pnum[20] = {0};
    char *ptr = cmgs;
    int err = 0;
	int data_len = 0;

	char *src = strstr(cmgs, ",");
	if(src != NULL)
	{
		memcpy(pnum, ptr,  src - ptr);
		src++;
		int data_len = 0;
        data_len = len - (src - ptr);
		memcpy(data, src, data_len);

	}
    else
    {
        LOGD("cmgs param is error");
        return -1;
    }
    LOGD("num:%s", pnum);
    LOGD("data:%s", data);
    
	sprintf(cmd, "AT+CMGS=%s", pnum);
    LOGD("cmd:%s", cmd);
    
	if(strlen(cmd) > 0)
	{
		int err = at_send_command_sms(cmd, data, "+CMGS: ", &response);
		LOGD("err:%d, response:%d", err, response->success);

		if (err < 0 || response->success == 0) {
	        *cme_err = at_get_cme_error(response);
	        goto exit;
	    }
		char *line;
		line = response->p_intermediates->line;
		memcpy(reg, line, strlen(line));
		LOGD("line:%s", line);

	}
    err = 0;
exit:
    at_response_free(response);
    return err;
}

static int req_cmgw_set(char *cmgw,int len, int *cme_err)
{
    printf("req_cmgw_set()----------------start\n");
    printf("cmgw:%s\n", cmgw);
    ATResponse *response = NULL;
    char cmd[30] = {0};
	char data[218] = {0};
	char pnum[13] = {0};
    char *ptr = cmgw;
    int err = 0;

	char *src = strstr(cmgw, ",");
	if(src != NULL)
	{
		memcpy(pnum, ptr,  src - ptr);
		src++;
		int data_len = 0;
        data_len = len - (src - ptr);
		memcpy(data, src, data_len);
	}

	sprintf(cmd, "AT+CMGW=%s", pnum);
	printf("cmd:%s,data:%s---------\n", cmd,data);
	
	if(strlen(cmd) > 0)
	{
		int err = at_send_command_sms(cmd, data, "+CMGW: ", &response);
		printf("err:%d, response:%d\n", err, response->success);

		if (err < 0 || response->success == 0) {
	        *cme_err = at_get_cme_error(response);
	        goto exit;
	    }
		char *line;
		line = response->p_intermediates->line;
		printf("line:%s\n", line);
	}
    err = 0;
exit:
    at_response_free(response);
    return err;
}

/*
AT+CMGD=25
OK

+MMSG: 1, 0
*/
static int req_cmgd_set(char *cmgd, int len, int *cme_err)
{
    printf("0req_cmgd_set()--------------start\n");
    printf("cmgd:%s\n", cmgd);
    ATResponse *response = NULL;
    char cmd[30] = {0};
	char data[218] = {0};
	char pnum[13] = {0};
    char *ptr = cmgd;
    int err = 0;

	memcpy(data, cmgd, len );
	sprintf(cmd, "AT+CMGD=%s", data);
	printf("cmd:%s,data:%s---------\n", cmd,data);
	
	if(strlen(cmd) > 0)
	{
		int err = at_send_command(cmd, &response);
	    if (err < 0 || response->success == 0) {
	        *cme_err = at_get_cme_error(response);
	        goto exit;
	    }

//     Format problem caused the crash
//       char *line;
//		line = response->p_intermediates->line;
//		printf("line:%s\n", line);
	}
    err = 0;
exit:
    at_response_free(response);
    return err;
}

/*
AT+CMGD=?

+CMGD: (0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37),(0-4)

OK

*/
static int req_cmgd_get(char *reg, int *cme_err)
{
    ATResponse *response = NULL;
    char *tmp_ptr = NULL;
    int err = at_send_command_singleline("AT+CMGD=?", "+CMGD:", &response);

    if (err < 0 || response->success == 0 || !response->p_intermediates){
        *cme_err = at_get_cme_error(response);
        goto exit;
    }

    char *line = response->p_intermediates->line;

    const char* start = strchr(line, '(');
    const char* end = strchr(line, ')');

    if (start && end && end > start)
    {
        int len_t = end - start - 1;
        char substr_t[len_t + 1];

        strncpy(substr_t, start + 1, len_t);
        substr_t[len_t] = '\0';
        strncpy(reg, substr_t, len_t);
    }
    else
    {
        strcpy(reg, "");
    }

exit:
    at_response_free(response);
    return err;
}


/*
AT+CMGL="ALL"	

+CMGL: 1,"REC READ","10658678",,"22.11.14 10:41:44 GMT+8"

56DB5DDD62

+CMGL: 2,"STO UNSENT","18927467953"
hello world

*/

static int req_cmgl_set(const char *cmgl, char *reg, int len, int *cme_err)
{
    printf("req_cmgl_set(2)-----------------start\n");
    printf("cmgl:%s\n", cmgl);
    ATResponse *response = NULL;
    char cmd[30] = {0};
	char data[218] = {0};
	char index_data[256] = {0};
	int s_index = 0, g_index = 0;
	bool index_flag = false;
	char *ptr_index = index_data;
	char phone[50];
	char number[5] = {0};
    int err = 0;

	memcpy(data, cmgl, len);

	char *ptr1 = data;
	char *ptr2 = strstr(data, ",");
	if(ptr2 != NULL)
	{
		memcpy(number,ptr1, ptr2-ptr1 );
		s_index = atoi(number);
		if(s_index == 0)
		{
			index_flag = TRUE;
			memcpy(ptr_index, "+CMGL:", strlen("+CMGL:"));
		}
        memset(number, 0, sizeof(number));
		ptr2++;
	}else{
		printf("cmgl set data is error\n eg:index,data\n");
		return -1;
	}

	sprintf(cmd, "AT+CMGL=%s", ptr2);
	printf("cmd:%s\n", cmd);

	ptr1 = NULL;
	ptr2 = NULL;
	
	if(strlen(cmd) > 0)
	{
        err = at_send_command_multiline(cmd, "", &response);
		if (err < 0 || response->success == 0 || !response->p_intermediates){
			*cme_err = at_get_cme_error(response);
            printf("at_send_command_multiline() is err-----------------\n");
			goto exit;
		}

        ATLine* lines_ptr = response->p_intermediates;
        char *line = NULL;
        int reg_len = 0;
		bool flag = false;
        while(lines_ptr)
        {
            line = lines_ptr->line;
            if(line ==NULL)
            {
                printf("line is null----------------------\n");
            }

            printf("-----line:%s\n", line);
			if(!flag)
			{
				ptr1 = strstr(line, "+CMGL: ");
				if(ptr1 != NULL)
				{
                    ptr1 += 7;
                    ptr2 = strstr(line, ",");
                    memcpy(number,ptr1, ptr2-ptr1 );
                    printf("number:%s, ptr1:%s, ptr2:%s\n", number, ptr1, ptr2);
                    g_index = atoi(number);
                    if(index_flag)
                    {
                        sprintf(ptr_index+strlen(ptr_index), "%d,", g_index);
                    }
				}
				//if( g_index == s_index)
                if( g_index == s_index  && !index_flag)
				{
                    printf("g_index == s_index, g_index:%d,s_index:%d\n", g_index, s_index);
					flag = true;
				}
			}
			if(flag && reg_len <=1024)
			{
	            memcpy(reg+reg_len, line, strlen(line));
	            printf("-----memcpy------reg:%s----------\n", reg);
	            printf("len:%d\n", reg_len);
	            reg_len += strlen(line);
			}

            lines_ptr = lines_ptr->p_next;
        }
	}

	if(index_flag)
	{
		memset(reg, 0, sizeof(reg));
		memcpy(reg, ptr_index, strlen(ptr_index) );
	}
    err = 0;
exit:
    at_response_free(response);
    printf("req_cmgl_set()-----------------end\n");
    return err;
}

/*
at+csca?
+CSCA: "+8613800280500",145
OK
*/
static int req_csca_get(char *req, int *cme_err)
{
    ATResponse *response = NULL;
    char *tmp_ptr = NULL;
    int err = at_send_command_singleline("AT+CSCA?", "", &response);

    if (err < 0 || response->success == 0 || !response->p_intermediates){
        *cme_err = at_get_cme_error(response);
        goto exit;
    }

    char *line = response->p_intermediates->line;
    printf("req_csca_get() ---line:%s\n", line);
    char* ptr = strstr(line, "+CSCA: ");
    printf("req_csca_get() ---ptr:%s\n",ptr);
    if(ptr)
    {
        memcpy(req, line, strlen(line));
        printf("err:%d, req:%s\n", err, req);
        err = 0;
    }
    else
    {
        err = -1;
    }
    
exit:
    at_response_free(response);
    return err;
}

static int req_csca_set(char *csca, int len, int *cme_err)
{
    printf("req_csca_set()--------------start\n");
    printf("csca:%s\n", csca);
    ATResponse *response = NULL;
    char cmd[30] = {0};
	char data[218] = {0};
	char pnum[13] = {0};
    char *ptr = csca;
    int err = 0;

	memcpy(data, csca, len);
	sprintf(cmd, "AT+CSCA=%s", data);
	printf("cmd:%s,data:%s---------\n", cmd,data);
	
	if(strlen(cmd) > 0)
	{
		int err = at_send_command(cmd, &response);
	    if (err < 0 || response->success == 0) {
	        *cme_err = at_get_cme_error(response);
	        goto exit;
	    }

    //    char *line;
	//	line = response->p_intermediates->line;
	//	printf("line:%s\n", line);
	}
    err = 0;
exit:
    at_response_free(response);
    return err;
}

static int req_csmp_set(char *csmp, int len, int *cme_err)
{
    printf("req_csmp_set()-------------------start\n");
    printf("csmp:%s\n", csmp);
    ATResponse *response = NULL;
    char cmd[30] = {0};
	char data[218] = {0};
	char pnum[13] = {0};
    char *ptr = csmp;
    int err = 0;

	memcpy(data, csmp, len);
	sprintf(cmd, "AT+CSMP=%s", data);
	printf("cmd:%s,data:%s---------\n", cmd,data);
	
	if(strlen(cmd) > 0)
	{
		int err = at_send_command(cmd, &response);
	    if (err < 0 || response->success == 0) {
	        *cme_err = at_get_cme_error(response);
	        goto exit;
	    }

        char *line;
		line = response->p_intermediates->line;
		printf("line:%s\n", line);
	}
    err = 0;
exit:
    at_response_free(response);
    return err;
}

static int req_cscb_set(char *cscb,int len, int *cme_err)
{
    printf("req_cscb_set()----------------start\n");
    printf("cscb:%s\n", cscb);
    ATResponse *response = NULL;
    char cmd[30] = {0};
	char data[218] = {0};
	char pnum[13] = {0};
    char *ptr = cscb;
    int err = 0;

	memcpy(data, cscb, len);
	sprintf(cmd, "AT+CSCB=%s", cscb);
	printf("cmd:%s,data:%s---------\n", cmd,data);
	
	if(strlen(cmd) > 0)
	{
		int err = at_send_command(cmd, &response);
	    if (err < 0 || response->success == 0) {
	        *cme_err = at_get_cme_error(response);
	        goto exit;
	    }

        char *line;
		line = response->p_intermediates->line;
		printf("line:%s\n", line);
	}
    err = 0;
exit:
    at_response_free(response);
    return err;
}

/*
AT+CMSS=13
+CMSS: 81
OK
*/
static int req_cmss_set(const char *cmss, char *reg, int len, int *cme_err)
{
    printf("req_cmss_set()----------------start\n");
    printf("cmss:%s\n", cmss);
    ATResponse *response = NULL;
    char cmd[30] = {0};
	char data[20] = {0};
    int err = 0;

    if(cmss != NULL)
    {
    	memcpy(data, cmss, len);
        sprintf(cmd, "AT+CMSS=%s", data);
    //    sprintf(cmd, "AT+CMSS=%d", 8);
    }
    else{
        printf("mem is null\n");
    }

    printf("cmss.   cmd:%s\n", cmd);

	if(strlen(cmd) > 8)
	{
        err = at_send_command_multiline(cmd, "+CMSS:", &response);
		if (err < 0 || response->success == 0){
			*cme_err = at_get_cme_error(response);
			goto exit;
		}
		
		char *line = response->p_intermediates->line;
		printf("line:%s\n", line);
		
		char *tmp_str = NULL;
		err = at_tok_nextstr(&line, &tmp_str); // phone_number
		if (err < 0)
		{
			goto exit;
		}
		memcpy(reg, tmp_str, strlen(tmp_str));
		printf("cmss_reg:%s\n", reg);
        /*
	    int err = at_send_command(cmd, &response);

	    if (err < 0 || response->success == 0) {
	        *cme_err = at_get_cme_error(response);
	        goto exit;
	    }

        char *line;
		line = response->p_intermediates->line;
		printf("line:%s\n", line);
        */
	}
    err = 0;
exit:
    at_response_free(response);
    return err;
}


/*
AT+CMGR=1
+CMGR: "REC READ","10658678",,"22.11.14 10:41:44 GMT+8"

56DB5DDD624B673A62A5FF039003003400310034003500340035003F0073003D0037003800680061006C00450066

OK
*/
static int req_cmgr_set(int index, char *reg, int *cme_err)
{
    printf("0req_cmgr_set()-------------------start\n");
    printf("index:%d\n", index);
    ATResponse *response = NULL;
    char cmd[30] = {0};
    int err = 0;
    sprintf(cmd, "AT+CMGR=%d", index);

    printf("req_cmgr_set()----cmd:%s\n", cmd);

	if(strlen(cmd) > 0)
	{
        err = at_send_command_multiline(cmd, "", &response);
		if (err < 0 || response->success == 0 || !response->p_intermediates){
			*cme_err = at_get_cme_error(response);
            printf("at_send_command_multiline() is err-----------------\n");
			goto exit;
		}

        ATLine* lines_ptr = response->p_intermediates;
        char *line = NULL;
        int reg_len = 0;
        while(lines_ptr)
        {
            line = lines_ptr->line;
            if(line ==NULL)
            {
                printf("line is null----------------------\n");
            }

            if(reg_len > 0)
			{
				memcpy(reg+reg_len, "\r\n", strlen("\r\n"));
				reg_len += strlen("\r\n");
			}
            memcpy(reg+reg_len, line, strlen(line));
            printf("-----memcpy------reg:%s----------\n", reg);
            printf("len:%d\n", reg_len);
            reg_len += strlen(line);
            lines_ptr = lines_ptr->p_next;
        }
	}

    err = 0;
exit:
    at_response_free(response);
    return err;
}


//void net_list_free(void *data);
// Return MBTK_INFO_ERR_SUCCESS,will call pack_error_send() to send RSP.
// Otherwise, do not call pack_error_send().
mbtk_info_err_enum sms_pack_req_process(sock_client_info_t* cli_info, mbtk_info_pack_t* pack)
{
    mbtk_info_err_enum err = MBTK_INFO_ERR_SUCCESS;
    int cme_err = MBTK_INFO_ERR_CME_NON;
    switch(pack->info_id)
    {
        case MBTK_INFO_ID_SMS_STATE_REQ:
        {
            if(pack->data_len == 0 || pack->data == NULL)
            {
                err = MBTK_INFO_ERR_UNSUPPORTED;
            }
            else     // Set
            {

            }
            break;
        }
        case MBTK_INFO_ID_SMS_CMGF_REQ:
        {
            if(pack->data_len == 0 || pack->data == NULL)   // Get VoLTE state.
            {
                int state;
                if(req_cmgf_get(&state, &cme_err) || cme_err != MBTK_INFO_ERR_CME_NON)
                {
                    if(cme_err != MBTK_INFO_ERR_CME_NON) {
                        err = MBTK_INFO_ERR_CME + cme_err;
                    } else {
                        err = MBTK_INFO_ERR_UNKNOWN;
                    }
                    LOGD("Get SMS CMGF fail.");
                }
                else
                {
                    pack_rsp_send(cli_info->fd, MBTK_INFO_ID_SMS_CMGF_RSP, &state, sizeof(uint8));
                }
            }
            else     // Set VoLTE state.
            {
                uint8 mode = *(pack->data);
                if(pack->data_len != sizeof(uint8) || (mode != 0 && mode != 1))
                {
                    err = MBTK_INFO_ERR_REQ_PARAMETER;
                    LOGD("Set SMS CMGF parameter error.");
                    break;
                }

                if(req_cmgf_set(mode, &cme_err) || cme_err != MBTK_INFO_ERR_CME_NON)
                {
                    if(cme_err != MBTK_INFO_ERR_CME_NON) {
                        err = MBTK_INFO_ERR_CME + cme_err;
                    } else {
                        err = MBTK_INFO_ERR_UNKNOWN;
                    }
                    LOGD("Set SMS CMGF fail.");
                }
                else
                {
                    pack_rsp_send(cli_info->fd, MBTK_INFO_ID_SMS_CMGF_RSP, NULL, 0);

                    // Restart is required to take effect.
                    LOGD("Will reboot system...");
                }
            }
            break;
        }
        case MBTK_INFO_ID_SMS_CNMI_REQ:
        {
            if(pack->data_len == 0 || pack->data == NULL)   // SET at+cnmi=1,2.
            {
                int state;
                if(req_cnmi_set(&cme_err) || cme_err != MBTK_INFO_ERR_CME_NON)
                {
                    printf("set req_cnmi_set() fail.\n");
                    if(cme_err != MBTK_INFO_ERR_CME_NON) {
                        err = MBTK_INFO_ERR_CME + cme_err;
                    } else {
                        err = MBTK_INFO_ERR_UNKNOWN;
                    }
                    LOG("set sms cnmi fail.");
                }
                else
                {
                    printf("req_cnmi_set success\n");
                    pack_rsp_send(cli_info->fd, MBTK_INFO_ID_SMS_CNMI_RSP, NULL, 0);
                }
            }
			break;
		}
        case MBTK_INFO_ID_SMS_CPMS_REQ:
        {
            if(pack->data_len == 0 || pack->data == NULL)   // Get VoLTE state.
            {
                char reg[100] = {0};
                if(req_cpms_get(reg, &cme_err) || cme_err != MBTK_INFO_ERR_CME_NON)
                {
                    if(cme_err != MBTK_INFO_ERR_CME_NON) {
                        err = MBTK_INFO_ERR_CME + cme_err;
                    } else {
                        err = MBTK_INFO_ERR_UNKNOWN;
                    }
                    LOG("Get SMS CMGF fail.");
                }
                else
                {
                    printf("req_cpms_get_ success, reg:%s, len:%d ", reg, strlen(reg));
                    pack_rsp_send(cli_info->fd, MBTK_INFO_ID_SMS_CPMS_RSP, reg, strlen(reg));
                }
            }
            else     // Set VoLTE state.
            {
                char *mem = (char*)(pack->data);
				int len = pack->data_len;
                char reg[100] = {0};
                printf("mem:%s, len:%d", pack->data, pack->data_len);

                if(req_cpms_set(mem, reg, len, &cme_err) || cme_err != MBTK_INFO_ERR_CME_NON)
                {
                    printf("cpms_set fail\n");
                    if(cme_err != MBTK_INFO_ERR_CME_NON) {
                        err = MBTK_INFO_ERR_CME + cme_err;
                    } else {
                        err = MBTK_INFO_ERR_UNKNOWN;
                    }
                    LOG("Set SMS CMGF fail.");
                }
                else
                {
                    printf("cpms_set success, reg:%s\n", reg);
                    pack_rsp_send(cli_info->fd, MBTK_INFO_ID_SMS_CPMS_RSP, reg, strlen(reg));

                    // Restart is required to take effect.
                    LOG("Will reboot system...");
                }
            }
            break;
        }
        case MBTK_INFO_ID_SMS_CMGS_REQ:
        {
            if(pack->data_len == 0 || pack->data == NULL)   // Get VoLTE state.
            {
                printf("pack->data_len:%d,,pack->data:%s\n",pack->data_len, pack->data);
                err = MBTK_INFO_ERR_UNSUPPORTED;
            }
            else     // Set VoLTE state.
            {
				char *cmgs = (char*)pack->data;
				int len = pack->data_len;
				char reg[50] ={0};
                LOGD("mbtk_sms,cmgs:%s,len:%d", cmgs, len);

                if(req_cmgs_set(cmgs,reg,len, &cme_err) || cme_err != MBTK_INFO_ERR_CME_NON)
                {
                    if(cme_err != MBTK_INFO_ERR_CME_NON) {
                        err = MBTK_INFO_ERR_CME + cme_err;
                    } else {
                        err = MBTK_INFO_ERR_UNKNOWN;
                    }
                    LOGD("Set SMS CMGS fail.");
                }
                else
                {
                    pack_rsp_send(cli_info->fd, MBTK_INFO_ID_SMS_CMGS_RSP, reg, strlen(reg));

                    // Restart is required to take effect.
                    LOGD("Will reboot system...");
                }

            }
            break;
        }
        case MBTK_INFO_ID_SMS_CMSS_REQ:
        {
            if(pack->data_len == 0 || pack->data == NULL)   // Get VoLTE state.
            {
                printf("pack->data_len:%d,,pack->data:%s\n",pack->data_len, pack->data);
                err = MBTK_INFO_ERR_UNSUPPORTED;
            }
            else     // Set VoLTE state.
            {
				char *cmss = (char*)pack->data;
				int len = pack->data_len;
                char reg[128] = {0};
                printf("mbtk_sms,cmgs:%s, len:%d\n", cmss, len);

                if(req_cmss_set(cmss,reg, len, &cme_err) || cme_err != MBTK_INFO_ERR_CME_NON)
                {
                    if(cme_err != MBTK_INFO_ERR_CME_NON) {
                        err = MBTK_INFO_ERR_CME + cme_err;
                    } else {
                        err = MBTK_INFO_ERR_UNKNOWN;
                    }
                    LOG("Set SMS CMGF fail.");
                }
                else
                {
                    printf("req_cmss_set success, reg:%s", reg);
                    pack_rsp_send(cli_info->fd, MBTK_INFO_ID_SMS_CMSS_RSP, NULL, 0);

                    // Restart is required to take effect.
                    LOG("Will reboot system...");
                }

            }
            break;
        }
        case MBTK_INFO_ID_SMS_CMGR_REQ:
        {
            if(pack->data_len == 0 || pack->data == NULL)   // Get VoLTE state.
            {
                printf("pack->data_len:%d,,pack->data:%s\n",pack->data_len, pack->data);
                err = MBTK_INFO_ERR_UNSUPPORTED;
            }
            else     // Set VoLTE state.
            {
                uint8 index = *(pack->data);
                char reg[1024] = {0};
                if(pack->data_len != sizeof(uint8) )
                {
                    err = MBTK_INFO_ERR_REQ_PARAMETER;
                    LOG("Set SMS CMGF parameter error.");
                    break;
                }

                if(req_cmgr_set(index, reg, &cme_err) || cme_err != MBTK_INFO_ERR_CME_NON)
                {
                    if(cme_err != MBTK_INFO_ERR_CME_NON) {
                        err = MBTK_INFO_ERR_CME + cme_err;
                    } else {
                        err = MBTK_INFO_ERR_UNKNOWN;
                    }
                    LOG("Set SMS CMGF fail.");
                }
                else
                {
                    printf("1req_cmgr_set_success, reg:%s\n", reg);
                    pack_rsp_send(cli_info->fd, MBTK_INFO_ID_SMS_CMGR_RSP, reg, strlen(reg));

                    // Restart is required to take effect.
                    LOG("Will reboot system...");
                }

            }
            break;
        }
        case MBTK_INFO_ID_SMS_CMGW_REQ:
        {
            if(pack->data_len == 0 || pack->data == NULL)   // +CMGW=<oa/da>[,<tooa/toda>[,<stat>]]<CR>
            {
                printf("pack->data_len:%d,,pack->data:%s\n",pack->data_len, pack->data);
                err = MBTK_INFO_ERR_UNSUPPORTED;
            }
            else     // Set cmgw data.
            {
				char *cmgw = (char*)pack->data;
				int len = pack->data_len;
                printf("mbtk_sms,cmgw:%s,len:%d\n", cmgw, len);

                if(req_cmgw_set(cmgw, len, &cme_err) || cme_err != MBTK_INFO_ERR_CME_NON)
                {
                    if(cme_err != MBTK_INFO_ERR_CME_NON) {
                        err = MBTK_INFO_ERR_CME + cme_err;
                    } else {
                        err = MBTK_INFO_ERR_UNKNOWN;
                    }
                    LOG("Set SMS CMGF fail.");
                }
                else
                {
                    pack_rsp_send(cli_info->fd, MBTK_INFO_ID_SMS_CMGW_RSP, NULL, 0);

                    // Restart is required to take effect.
                    LOG("Will reboot system...");
                }

            }
            break;
        }
        case MBTK_INFO_ID_SMS_CMGD_REQ:
        {
            if(pack->data_len == 0 || pack->data == NULL)   // Get VoLTE state.
            {
                char reg[1024] = {0};
                if(req_cmgd_get(reg, &cme_err) || cme_err != MBTK_INFO_ERR_CME_NON)
                {
                    if(cme_err != MBTK_INFO_ERR_CME_NON) {
                        err = MBTK_INFO_ERR_CME + cme_err;
                    } else {
                        err = MBTK_INFO_ERR_UNKNOWN;
                    }
                    LOG("Get SMS CMGD fail.");
                }
                else
                {
                    LOG("req_cmgd_get success, reg:%s, len:%d ", reg, strlen(reg));
                    pack_rsp_send(cli_info->fd, MBTK_INFO_ID_SMS_CMGD_RSP, reg, strlen(reg));
                }
            }
            else     // Set VoLTE state.
            {
				char *cmgd = (char*)pack->data;
				int len = pack->data_len;
                printf("mbtk_sms,cmgs:%s,len:%d\n", cmgd, len);

                if(req_cmgd_set(cmgd,len, &cme_err) || cme_err != MBTK_INFO_ERR_CME_NON)
                {
                    if(cme_err != MBTK_INFO_ERR_CME_NON) {
                        err = MBTK_INFO_ERR_CME + cme_err;
                    } else {
                        err = MBTK_INFO_ERR_UNKNOWN;
                    }
                    LOG("Set SMS CMGF fail.");
                }
                else
                {
                    pack_rsp_send(cli_info->fd, MBTK_INFO_ID_SMS_CMGD_RSP, NULL, 0);

                    // Restart is required to take effect.
                    LOG("Will reboot system...");
                }

            }
            break;
        }
        case MBTK_INFO_ID_SMS_CMGL_REQ:
        {
            if(pack->data_len == 0 || pack->data == NULL)   // Get VoLTE state.
            {
                printf("pack->data_len:%d,,pack->data:%s\n",pack->data_len, pack->data);
                err = MBTK_INFO_ERR_UNSUPPORTED;
            }
            else     // Set VoLTE state.
            {
				char *cmgl = (char*)pack->data;
				int len = pack->data_len;
                char reg[5*1024] = {0};
                char reg1[1024+1] = {0};
                printf("mbtk_sms,cmgs:%s, len:%d\n", cmgl, len);

                if(req_cmgl_set(cmgl, reg, len, &cme_err) || cme_err != MBTK_INFO_ERR_CME_NON)
                {
                    if(cme_err != MBTK_INFO_ERR_CME_NON) {
                        err = MBTK_INFO_ERR_CME + cme_err;
                    } else {
                        err = MBTK_INFO_ERR_UNKNOWN;
                    }
                    LOG("Set SMS CMGF fail.");
                }
                else
                {
                 //   printf("1cmgl_set_success---------len:%d\n reg:%s\n",strlen(reg), reg);
                    memcpy(reg1, reg, 1024);
                    printf("0len:%d, reg1:%s\n", strlen(reg1), reg1);
                    pack_rsp_send(cli_info->fd, MBTK_INFO_ID_SMS_CMGL_RSP, reg1, strlen(reg1));

                    // Restart is required to take effect.
                    LOG("Will reboot system...");
                }

            }
            break;
        }
        case MBTK_INFO_ID_SMS_CSCA_REQ:
        {
            if(pack->data_len == 0 || pack->data == NULL)   // Get VoLTE state.
            {
                char csca[50]={0};
                if(req_csca_get(csca, &cme_err) || cme_err != MBTK_INFO_ERR_CME_NON)
                {
                    if(cme_err != MBTK_INFO_ERR_CME_NON) {
                        err = MBTK_INFO_ERR_CME + cme_err;
                    } else {
                        err = MBTK_INFO_ERR_UNKNOWN;
                    }
                    LOG("Get SMS CSCA fail.");
                    printf("get sms csca fail\n");
                }
                else
                {
                    printf("get sms csca suscess\n");
                    pack_rsp_send(cli_info->fd, MBTK_INFO_ID_SMS_CSCA_RSP, csca, strlen(csca));
                }
                err = MBTK_INFO_ERR_UNSUPPORTED;
            }
            else     // Set VoLTE state.
            {
				char *csca = (char*)pack->data;
				int len = pack->data_len;
                printf("mbtk_sms,cmgs:%s,len:%d\n", csca, len);

                if(req_csca_set(csca, len, &cme_err) || cme_err != MBTK_INFO_ERR_CME_NON)
                {
                    if(cme_err != MBTK_INFO_ERR_CME_NON) {
                        err = MBTK_INFO_ERR_CME + cme_err;
                    } else {
                        err = MBTK_INFO_ERR_UNKNOWN;
                    }
                    LOG("Set SMS CMGF fail.");
                }
                else
                {
                    pack_rsp_send(cli_info->fd, MBTK_INFO_ID_SMS_CSCA_RSP, NULL, 0);

                    // Restart is required to take effect.
                    LOG("Will reboot system...");
                }

            }
            break;
        }
        case MBTK_INFO_ID_SMS_CSMP_REQ:
        {
            if(pack->data_len == 0 || pack->data == NULL)   // Get VoLTE state.
            {
                printf("pack->data_len:%d,,pack->data:%s\n",pack->data_len, pack->data);
                err = MBTK_INFO_ERR_UNSUPPORTED;
            }
            else     // Set VoLTE state.
            {
				char *csmp = (char*)pack->data;
				int len = pack->data_len;
                printf("mbtk_sms,cmgs:%s,len:%d\n", csmp, len);

                if(req_csmp_set(csmp,len, &cme_err) || cme_err != MBTK_INFO_ERR_CME_NON)
                {
                    if(cme_err != MBTK_INFO_ERR_CME_NON) {
                        err = MBTK_INFO_ERR_CME + cme_err;
                    } else {
                        err = MBTK_INFO_ERR_UNKNOWN;
                    }
                    LOG("Set SMS CMGF fail.");
                }
                else
                {
                    pack_rsp_send(cli_info->fd, MBTK_INFO_ID_SMS_CSMP_RSP, NULL, 0);

                    // Restart is required to take effect.
                    LOG("Will reboot system...");
                }

            }
            break;
        }
        case MBTK_INFO_ID_SMS_CSCB_REQ:
        {
            if(pack->data_len == 0 || pack->data == NULL)   // Get VoLTE state.
            {
                printf("pack->data_len:%d,,pack->data:%s\n",pack->data_len, pack->data);
                err = MBTK_INFO_ERR_UNSUPPORTED;
            }
            else     // Set VoLTE state.
            {
				char *cscb = (char*)pack->data;
				int len = pack->data_len;
                printf("mbtk_sms,cmgs:%s, len:%d\n", cscb, len);

                if(req_cscb_set(cscb,len, &cme_err) || cme_err != MBTK_INFO_ERR_CME_NON)
                {
                    if(cme_err != MBTK_INFO_ERR_CME_NON) {
                        err = MBTK_INFO_ERR_CME + cme_err;
                    } else {
                        err = MBTK_INFO_ERR_UNKNOWN;
                    }
                    LOG("Set SMS CMGF fail.");
                }
                else
                {
                    pack_rsp_send(cli_info->fd, MBTK_INFO_ID_SMS_CSCB_RSP, NULL, 0);

                    // Restart is required to take effect.
                    LOG("Will reboot system...");
                }

            }
            break;
        }
        default:
        {
            err = MBTK_INFO_ERR_REQ_UNKNOWN;
            LOG("Unknown request : %s", id2str(pack->info_id));
            break;
        }
    }

    return err;
}
