#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <errno.h>
#include <unistd.h>
#include <time.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <pthread.h>

#include "mbtk_loop_buffer.h"
#include "mbtk_log.h"
#include "mbtk_utils.h"


static void* read_run(void* arg)
{
    mbtk_loop_buff_handle *handle = (mbtk_loop_buff_handle*)arg;
    int fd = open("/data/voip_playback.wav", O_RDONLY);
    int read_count = 0;
    int buff_count = 0;
    if(fd > 0) {
        char buff[1569];
        int len;
        int temp_len;
        while((len = read(fd, buff, sizeof(buff))) > 0) {
            read_count += len;

            temp_len = mbtk_loopbuff_writen(handle, buff, len);
            if(temp_len > 0) {
                if(temp_len != len) {
                    printf("mbtk_loopbuff_writen() fail : %d/%d\n", temp_len, len);
                }
                buff_count += temp_len;
            } else {
                printf("mbtk_loopbuff_writen() fail.\n");
            }
        }
        close(fd);
    }
    printf("read complete : %d / %d\n", read_count, buff_count);

    return NULL;
}

static void* write_run(void* arg)
{
    mbtk_loop_buff_handle *handle = (mbtk_loop_buff_handle*)arg;
    int write_count = 0;
    int buff_count = 0;
    int fd = open("/data/voip_playback_copy.wav", O_WRONLY | O_CREAT | O_TRUNC, 0644);
    if(fd > 0) {
        char buff[999];
        int len;
        while((len = mbtk_loopbuff_readn(handle, buff, sizeof(buff))) > 0) {
            buff_count += len;
            len = write(fd, buff, len);
            if(len > 0)
                write_count += len;
            else
                printf("mbtk_write() fail.\n");
        }
        close(fd);
    }

    printf("write complete : %d / %d\n", write_count, buff_count);
    return NULL;
}

int main(int argc, char *argv[])
{
    mbtk_log_init("radio", "LOOPBUFF");
    mbtk_loop_buff_handle *handle = mbtk_loopbuff_get(7 * 1001);
    if(handle) {
        pthread_t read_pid, write_pid;
        if(pthread_create(&read_pid, NULL, read_run, handle))
        {
            LOGE("pthread_create() fail.");
            return -1;
        }

        if(pthread_create(&write_pid, NULL, write_run, handle))
        {
            LOGE("pthread_create() fail.");
            return -1;
        }

        sleep(1);

        if (pthread_join(read_pid, NULL)){
            printf("error join thread!\n");
            abort();
        }

        if (pthread_join(write_pid, NULL)){
            printf("error join thread!\n");
            abort();
        }

        mbtk_loopbuff_free(handle);
    }
    return 0;
}


