/**
 * @file
 * @author  Jinhua Huang <jinhuahuang@asrmicro.com>
 * @version 1.0
 *
 * @section LICENSE
 * Copyright (C) 2021, ASR microelectronics, All rights reserved.
 *
 * @section DESCRIPTION
 * Aboot tiny downloader for Jacana with firmware and pvt
 *
 */
#ifndef __JACANA_DOWNLOAD_H__
#define __JACANA_DOWNLOAD_H__

#ifdef __cplusplus
extern "C" {
#endif

/**
 * Aboot tiny downloader for jacana
 *
 * @param dev uart device name
 * @param baud uart baud rate
 *
 * @return 0 for success, otherwise failed
 *
 */
int jacana_aboot_tiny_download(const char *dev, int baud);

/**
 * Aboot tiny force stop for jacana
 *
 * @return 0 for success, otherwise failed
 */
int jacana_aboot_tiny_force_stop(void);

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* __JACANA_DOWNLOAD_H__ */
