#ifndef JACANA_FIRMWARE_H
#define JACANA_FIRMWARE_H

#ifdef __cplusplus
extern "C" {
#endif

#define MAX_READ_CACHE_SZ 	4096

/*---------------------------------------------------------------------------*/
typedef struct firmware_handle {
  void *priv;
  size_t start;
  size_t end;
  void *data;
  size_t read_sz;
  char *read_ptr;
  char *middle_ptr;
  char *end_ptr;
  void *pvt_info;
} firmware_handle_t;
/*---------------------------------------------------------------------------*/
/* portable layer api */
void *jacana_firmware_raw_open(void);
size_t jacana_firmware_raw_get_total_size(void *priv);
int jacana_firmware_raw_read(void *priv, size_t start,
                             uint8_t *data, size_t size);
void jacana_firmware_raw_close(void *priv);
/*---------------------------------------------------------------------------*/
int jacana_firmware_open(firmware_handle_t *firmware, void *priv);
int jacana_firmware_read_line(firmware_handle_t *firmware, char *line);
int jacana_firmware_read_data(firmware_handle_t *firmware,
                              uint8_t *data, size_t size);
void jacana_firmware_close(firmware_handle_t *firmware);
/*---------------------------------------------------------------------------*/

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* JACANA_FIRMWARE_H */
