#ifndef _CUSTOM_UPGRADE_H_
#define  _CUSTOM_UPGRADE_H_
//#include "hdbd_types.h"
#include "stdint.h"
#include "port.h"

extern uint8_t g_bin_buff[500*1024];

void gnss_gpio_init()
{
	// init reset, prtrg, uart etc .
	//......

	//......
}

void gnss_enter_boot(int32_t fd)
{
	//entern boot mode
	/*......
	// demo
	hd_delayMs(200);
	GNSS_PRTRG_LOW();
	hd_delayMs(1000);
	GNSS_RESET_LOW(1000);
	hd_delayMs(1000);
	GNSS_RESET_HIGH();
	hd_delayMs(1000);
	GNSS_PRTRG_HIGH();
	hd_delayMs();
	......*/

}

void gnss_reset()
{
	//gnss chip reset
	/*......
	// demo
	GNSS_RESET_LOW();
	hd_delayMs(300);
	GNSS_RESET_HIGH();
	......*/
}

int32_t set_gnss_baud(int32_t fd, uint8_t cmd_baud)
{
    tcflush(fd, TCIOFLUSH);
    if(cmd_baud == 1)
	{
		uart_init(fd, 460800, 0, 8, 1, 'N');
    }
    else if(cmd_baud == 2)
	{
		uart_init(fd, 115200, 0, 8, 1, 'N');
    }
    else if(cmd_baud == 3)
	{
		uart_init(fd, 9600, 0, 8, 1, 'N');
    }
	else
	{
		uart_init(fd, 115200, 0, 8, 1, 'N');
	}
    tcflush(fd, TCIOFLUSH);

	return 0;
}

extern int uart_send(int32_t fd, uint8_t *cmd, int cmd_len);

extern int uart_recv(int32_t fd, uint8_t *buf, int *actual_length, int timeout);

int bsp_flash_readbytes(uint32_t addr, uint8_t *pbuf, uint32_t len)
{
	if( (pbuf == NULL) || (len == 0) )
	{
        printf("[%s %d] input info error!", __FUNCTION__, __LINE__);
		return -1;
	}
	memcpy(pbuf, addr+g_bin_buff, len);

	return 0;
}

void uart_clear_buf(int32_t fd)
{
    tcflush(fd, TCIFLUSH);
	//clearBuffer(fd, TCIOFLUSH);
	return;
}

int uart_control(int32_t fd, int type)
{
	// uart authority control

	//......

	//......

	return 0;
}

void hd_delayMs(uint32_t ms)
{
	usleep(ms*1000);
	return;
}

#endif
