#if 1
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <pthread.h>
//#include <string.h>
#include <fcntl.h>
//#include <signal.h>
#include <cutils/properties.h>
#include <stdint.h>
#include <string.h>
#include <time.h>

#include "mbtk_log.h"
#include "mbtk_info_api.h"
#include "mbtk_utils.h"

#define MBTK_RESULT_FAIL -1
#define MBTK_RESULT_SUCCESS 0
#define BOOT_CHECK_TIME 200       //200ms
#define NORMAL_CHECK_TIME 30000   //30s
#define PERIOD_LEN 10
#define update_ril_digit 0x7 //The last three digits are reserved for RIL service,0x111
#define update_gnss_digit 1<<4
int in_period[PERIOD_LEN] = {100,100,200,200,500,500,500,500,2000,5000};//ms

static mbtk_ready_status_type mbtk_ready_status = MBTK_READY_INIT;
static mbtk_info_handle_t* mbtk_handle = NULL;
static pthread_mutex_t lock;
int tag = 0;
void update_ril_value(int value)
{
    FILE *fp;
    char buf[16];
    char cmd[64];
    int rd_value = 0;
    int ret = 0;

    pthread_mutex_lock(&lock);

    fp = popen("uci get lynq_uci.sdk_ready","r");
    if(fp == NULL)
    {
        LOGE("Failed to run uci get lynq_uci.sdk_ready\n");
        pthread_mutex_unlock(&lock);
        return;
    }
    if(fgets(buf, sizeof(buf) - 1, fp) == NULL)
    {
        LOGE("update_ril_value fgets failed");
        pthread_mutex_unlock(&lock);
        pclose(fp);
        return;
    }
    if(tag != 0)
    {
        rd_value = atoi(buf);
    }
    else
    {
        tag = 1;
    }
    
    rd_value &= ~(update_ril_digit);//The last three digits are reserved for RIL service
    rd_value |= (value & update_ril_digit);
    sprintf(cmd,"uci set lynq_uci.sdk_ready='%d'",rd_value);
    ret = system(cmd);
    if(ret != 0)
    {
        LOGE("Failed to run uci set lynq_uci.sdk_ready\n");
    }

    pclose(fp);
    pthread_mutex_unlock(&lock);
    return;
}

void update_gnss_value()
{
    FILE *fp;
    char buf[16];
    char cmd[64];
    int rd_value = 0;
    int ret = 0;

    pthread_mutex_lock(&lock);

    fp = popen("uci get lynq_uci.sdk_ready","r");
    if(fp == NULL)
    {
        LOGE("Failed to run uci get lynq_uci.sdk_ready\n");
        pthread_mutex_unlock(&lock);
        return;
    }
    if(fgets(buf, sizeof(buf) - 1, fp) == NULL)
    {
        LOGE("update_gnss_value fgets failed");
        pthread_mutex_unlock(&lock);
        pclose(fp);
        return;
    }
    rd_value = atoi(buf);
    rd_value &= ~(update_gnss_digit);
    rd_value |= (update_gnss_digit); //The fifth digits is reserved for GNSS service
    sprintf(cmd,"uci set lynq_uci.sdk_ready='%d'",rd_value);
    ret = system(cmd);
    if(ret != 0)
    {
        LOGE("Failed to run uci set lynq_uci.sdk_ready\n");
    }
    pthread_mutex_unlock(&lock);
    pclose(fp);
    return;
}

#if 1
static mbtk_ready_status_type modem_check(void)
{
    char imei[16]= {0};
    int cme_err = 0;

    if(mbtk_handle == NULL)
    {
        mbtk_handle = mbtk_info_handle_get();
        if(mbtk_handle == NULL)
        {
            LOGE("[SDK_READY] mbtk_info_handle_get fail.");
            return MBTK_READY_RIL_FAIL;
        }
    }

    mbtk_handle->info_err = 0;
    cme_err = mbtk_imei_get(mbtk_handle, imei);
    //LOGE("[SDK_READY] imei = [%s], cme_err = [%d]", imei, cme_err);
    if(cme_err == 0 && strlen(imei) == 0)
    {
        mbtk_info_handle_free(&mbtk_handle);
        mbtk_handle = NULL;
        return MBTK_READY_RIL_FAIL;
    }
    if(cme_err != 0 || strlen(imei) == 0)
    {
        mbtk_info_handle_free(&mbtk_handle);
        mbtk_handle = NULL;
        return MBTK_READY_MODEM_FAIL;
    }
    return MBTK_READY_SUCCESS;
}
#endif
long get_uptime()
{
    struct timespec start_time;
    clock_gettime(CLOCK_MONOTONIC, &start_time);
    return start_time.tv_sec;
}
static void* sdk_ready_check_pthread(void *arg)
{
    UNUSED(arg);
    LOGE("[SDK_READY] sdk_ready_check_pthread entry.");
    mbtk_ready_status_type now_ready_status = MBTK_READY_INIT;
    //char buf[MBTK_READY_STRING_SIZE_MAX] = {0};
    // buf[0] = '0' + now_ready_status;
    // property_set(MBTK_READY_UCI, buf);// init state value
    int sleep_time = 30;
    long uptime = 0;
    int count = 0;
    while(1)
    {
        now_ready_status = modem_check();
        //buf[0] = '0' + now_ready_status;
        //property_set(MBTK_READY_UCI, buf);
        update_ril_value(now_ready_status);
        mbtk_ready_status = now_ready_status;
        uptime = get_uptime();
        if(uptime < 50)//in 50s
        {
            if(now_ready_status != MBTK_READY_SUCCESS)
            {
                sleep_time = BOOT_CHECK_TIME;
            }
            else
            {
               sleep_time = NORMAL_CHECK_TIME;
            }
        }
        else
        {
            if(now_ready_status != MBTK_READY_SUCCESS)
            {
                if(count < PERIOD_LEN)
                {
                    sleep_time = in_period[count];
                }
                else
                {
                    count = 0;
                    sleep_time = in_period[count];
                }
                count++;
            }
            else
            {
                sleep_time = NORMAL_CHECK_TIME;
                count = 0;
            }

        }
        usleep(sleep_time*1000);
    }
    LOGE("[SDK_READY] sdk_ready_check_pthread exit.");
    return NULL;
}

static int is_process_running(const char *process_name) 
{
    char command[128];
    FILE *fp;
    int found = 0;

    snprintf(command, sizeof(command), "ps | grep -v grep | grep '%s'", process_name);
    fp = popen(command, "r");
    if (!fp) 
    {
        LOGE("[GNSS_CHECK] popen failed for command: %s", command);
        return 0;
    }

    char line[256];
    if (fgets(line, sizeof(line), fp)) 
    {
        found = 1;
    }
    pclose(fp);
    return found;
}

static void* check_gnss(void *arg) 
{
    UNUSED(arg);
    const char *gnss_process_name = "mbtk_gnssd";
    int current_status;
    while (1)
    {
        current_status = is_process_running(gnss_process_name);
        if (current_status == 0)
        {
            LOGI("[GNSS_CHECK] GNSS process stopped, setting status to 1");
            update_gnss_value();
        }
        sleep(30);
    }
    return NULL;
}

int main(int argc, char *argv[])
{
    mbtk_log_init("radio", "MBTK_SDK_READY");

    MBTK_SOURCE_INFO_PRINT("mbtk_sdk_ready");

    if(mbtk_ready_status != MBTK_READY_INIT)
    {
        LOGE("[SDK_READY] sdk has check.");
        return MBTK_RESULT_FAIL;
    }

#ifdef MBTK_DUMP_SUPPORT
    mbtk_debug_open(NULL, TRUE);
#endif

	LOGE("[SDK_READY] sdk check init.");
    pthread_t ril_check_pid, gnss_check_pid;
    pthread_attr_t thread_attr;
    pthread_attr_init(&thread_attr);
    if(pthread_attr_setdetachstate(&thread_attr, PTHREAD_CREATE_DETACHED))
    {
        LOGE("[SDK_READY] pthread_attr_setdetachstate() fail.");
        return MBTK_RESULT_FAIL;
    }

    if(pthread_create(&ril_check_pid, &thread_attr, sdk_ready_check_pthread, NULL))
    {
        LOGE("[SDK_READY] sdk_ready_check_pthread pthread_create() fail.");
    }

    sleep(1);

    if(pthread_create(&gnss_check_pid, &thread_attr, check_gnss, NULL))
    {
        LOGE("[SDK_READY] check_gnss pthread_create() fail.");
    }

    pthread_attr_destroy(&thread_attr);

    LOGE("[SDK_READY] sdk check start.");
    while(1)
    {
        sleep(24 * 60 * 60);
    }

    LOGE("[SDK_READY]!!!mbtk_sdk_ready exit!!!");
    return MBTK_RESULT_SUCCESS;
}
#endif