/*************************************************************
Description:
    C file for L620 coap.
Author:
    LuoJian
Date:
    2019/3/25 9:23:29
*************************************************************/
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <linux/in.h>
#include <unistd.h>

#include "mbtk_coap.h"
#include "mbtk_type.h"
#include "mbtk_log.h"
#include "mbtk_sock2.h"


/*************************************************************
    Variables:public
*************************************************************/


#define MBTK_ECOAP_TIMEOUT (15 * 1000)
#define MBTK_ECOAP_WAIT_CLOSE_TIMEOUT (5 * 60 * 1000)
#define MBTK_ECOAP_STACK_SIZE                (12 * 1024)        // task stack size

#define ECOAPVER 1
#define EOCAPTYPE 2
#define ECOAPCODE 3
#define ECOAPMSGID 4
#define ECOAPTOKEN 5


/*param--------------------*/
// Point the first item.
static mbtk_ecoap_package_s *mbtk_ecoap_head = NULL;
static mbtk_ecoap_package_ver mbth_ecoap_package_ver={1,0,1,1};


struct sockaddr_in serveraddr = {0};
int socket_id;
int addrlen;

static mbtk_init_info *coap_init_info = NULL;
static int coap_handle = -1;
static bool coap_sock_inited = FALSE;
static int coap_fd = -1;



// Point the last item.
static mbtk_ecoap_package_s *mbtk_ecoap_tail = NULL;
static mbtk_ecoap_net_s mbtk_ecoap_net;
static mbtk_ecoap_state_e mbtk_ecoap_state = MBTK_ECOAP_STATE_NON;

//static uint16 mbtk_ecoap_curr_coap_id = 0;
//static char mbtk_ecoap_host[MBTK_ECOAP_NEW_MAX+1] = {'\0'};

//static int mbtk_ecoap_port;
//static int mbtk_ecoap_is_dtls;
static mbtk_ecoap_opt_2 mbtk_ecoap_option_2;
static mbtk_ecoap_opt_3 mbtk_ecoap_option_3;
static int mbtk_ecoap_recv = -1;
//static int mbtk_ecoap_cur_time =0;

/*func------------------------*/
void mbtk_ecoap_option_add(mbtk_ecoap_option_s *option);
int mbtk_ecoap_list_del(uint16 message_id,int optDel);
int mbtk_ecoap_get_message_type(void);
void mbtk_ecoap_get_code(char *ptr);

#define HEXCHAR(x) ((x >= '0' && x <= '9') || (x >= 'a' && x <= 'f') || (x >= 'A' && x <= 'F'))


#if 1

#ifndef toupper
#define toupper(a)  ((((a) >= 'a') && ((a) <= 'z')) ? ((a) - 'a' + 'A') : (a))
#endif

void HexToStr(byte *pbDest, byte *pbSrc, int nLen)
{
	char   ddl,ddh;
	int i;

	for (i=0; i<nLen; i++)
	{
		ddh = 48 + pbSrc[i] / 16;
		ddl = 48 + pbSrc[i] % 16;
		if (ddh > 57)
		{
			ddh = ddh + 7;
		}
		if (ddl > 57)
		{
			ddl = ddl + 7;
		}
		pbDest[i*2] = ddh;
		pbDest[i*2+1] = ddl;
	}
	pbDest[nLen*2] = '\0';
}

uint8_t StrToHex(byte *pbDest, byte *pbSrc, int nLen)
{
	char h1,h2;
	byte s1,s2;
	uint8_t i;

	for (i=0; i<nLen; i++)
	{
		h1 = pbSrc[2*i];
		h2 = pbSrc[2*i+1];
		s1 = toupper(h1) - 0x30;
		if (s1 > 9)
		{
			s1 -= 7;
		}
		s2 = toupper(h2) - 0x30;
		if (s2 > 9)
		{
			s2 -= 7;
		}
		pbDest[i] = s1*16 + s2;
		//DS_MBTK_MSG1_HIGH("StrToHex:%.2X",pbDest[i]);
	}
	return i;
}

void coap_log(int is_ascii,const char* data,int len)
{
    if(len <= 0) {
        return;
    }

    if(is_ascii) { // Is ASCII
        int i = 0;
        int count = len / 100 + 1;

        // Has '\0'
        if(len != strlen(data)) {
            return;
        }

        while(i < count) {
            printf("%s\n",data + i * 100);
            i++;
        }
    } else { // Is hex
        int index = 0;
        int i = 0;
        char buf_temp[100];
        while(index % 16 == 0 && index < len) {
            memset(buf_temp,0,100);
            for(i = 0;i < 16 && index + i < len;i++) {
                snprintf(buf_temp + i * 3,100 - i,"%.2x ",((char*)data)[index + i]);
            }
            index += 16;
            printf("%s\n", buf_temp);
        }
    }
}



static void
mbtk_ecoap_show_error
(
    int rsp_errno
)
{
    char temp[50] = {0};
    memset(temp, 0, 50);
    snprintf(temp,50,"\r\n+MCOAPERROR:%d\r\n",rsp_errno);
    printf("%s\n",temp);
}

int ecoap_recv_buffer(char * dest,const char* data,int len)
{
    if( len <= 0) {
        return -1;
    }
    int buffer_len = 0;
    char Payload[MBTK_ECOAP_DATA_MAX*2+1] ={'\0'};
	int pud_lenth = mbtk_coap_get_pdu_Length();
	int type = mbtk_ecoap_get_message_type();
	char code[12];
    memset(code,0x00,sizeof(code));
	mbtk_ecoap_get_code(code);
	uint16_t mesageId = coapGetRecvMessageID();
	memset(Payload,0x00,MBTK_ECOAP_DATA_MAX*2+1);
	snprintf(dest,MBTK_ECOAP_DATA_MAX,
			"+COAPNMI:%d\r\nMessage Type:%d\r\nCode:\"%s\"\r\nMessage ID:%d\r\nPayload:",
			pud_lenth,
			type,
			code,
			mesageId);


    int i = 0;
	for(i = 0; i < len; i++)
	{
		if(data[i] == 0xFF && i> 3)   //BUG 46397
		{
			LOGE("data[i] == 0xFF\n");
			memcpy(Payload, data+i+1, len - i-1);
			Payload[len-i -1]='\0';
			break;
		}
	}

    LOGE("len:%d, i :%d\n",len,i);
	if(Payload[len-i -1] == '\0' )
	{
		LOGE("==\0-------------------\n");
	//	coap_log(-1,(char*)Payload,len - i-1);
	}else{
		LOGE("!=\0--------------------\n");
		Payload[0]='\0';
	}

    buffer_len = strlen(dest) + strlen(Payload);
    strcat(dest,Payload);
	LOGE("2---------buffer_len:%d,coap_recv_buffer_dest:%s,Payload:%s\n",buffer_len,dest,Payload);
    return buffer_len;
}

int mbtk_ecoap_get_message_type(void)
{
    switch(coapGetRecvType())
    {
        case COAP_CONFIRMABLE:
            return 0;
        break;

        case COAP_NON_CONFIRMABLE:
            return 1;
        break;

        case COAP_ACKNOWLEDGEMENT:
            return 2;
        break;

        case COAP_RESET:
            return 3;
        break;
    }
	return 0;
}

void mbtk_ecoap_get_code(char *ptr)
{
	switch(coapGetRecvCode()) {
		case COAP_EMPTY:
			memcpy(ptr,"0.00",4);
		break;
		case COAP_GET:
			memcpy(ptr,"0.01",4);
		break;
		case COAP_POST:
			memcpy(ptr,"0.02",4);
		break;
		case COAP_PUT:
			memcpy(ptr,"0.03",4);
		break;
		case COAP_DELETE:
			memcpy(ptr,"0.04",4);
		break;
		case COAP_CREATED:
			memcpy(ptr,"2.01",4);
		break;
		case COAP_DELETED:
			memcpy(ptr,"2.02",4);
		break;
		case COAP_VALID:
			memcpy(ptr,"2.03",4);
		break;
		case COAP_CHANGED:
			memcpy(ptr,"2.04",4);
		break;
		case COAP_CONTENT:
			memcpy(ptr,"2.05",4);
		break;
		case COAP_CONTINUE:
			memcpy(ptr,"2.31",4);
		break;
		case COAP_BAD_REQUEST:
			memcpy(ptr,"4.00",4);
		break;
		case COAP_UNAUTHORIZED:
			memcpy(ptr,"4.01",4);
		break;
		case COAP_BAD_OPTION:
			memcpy(ptr,"4.02",4);
		break;
		case COAP_FORBIDDEN:
			memcpy(ptr,"4.03",4);
		break;
		case COAP_NOT_FOUND:
			memcpy(ptr,"4.04",4);
		break;
		case COAP_METHOD_NOT_ALLOWED:
			memcpy(ptr,"4.05",4);
		break;
		case COAP_NOT_ACCEPTABLE:
			memcpy(ptr,"4.06",4);
		break;
		case COAP_PRECONDITION_FAILED:
			memcpy(ptr,"4.12",4);
		break;
		case COAP_REQUEST_ENTITY_TOO_LARGE:
			memcpy(ptr,"4.13",4);
		break;
		case COAP_UNSUPPORTED_CONTENT_FORMAT:
			memcpy(ptr,"4.15",4);
		break;
		case COAP_INTERNAL_SERVER_ERROR:
			memcpy(ptr,"5.00 ",4);
		break;
		case COAP_NOT_IMPLEMENTED:
			memcpy(ptr,"5.01",4);
		break;
		case COAP_BAD_GATEWAY:
			memcpy(ptr,"5.02",4);
		break;
		case COAP_SERVICE_UNAVAILABLE:
			memcpy(ptr,"5.03",4);
		break;
		case COAP_GATEWAY_TIMEOUT:
			memcpy(ptr,"5.04",4);
		break;
		case COAP_PROXYING_NOT_SUPPORTED:
			memcpy(ptr,"5.05",4);
		break;
		default:
			sprintf(ptr, "UndefCod%u",(unsigned)(coapGetRecvCode()));
	}
}

#if 0
static int
mbtk_ecoap_is_open()
{
    if(mbtk_ecoap_state >= MBTK_ECOAP_STATE_OPENED)
        return 0;

    return -1;
}


static void mbtk_ecoap_reset()
{
    memset(&mbtk_ecoap_net,0x0,sizeof(mbtk_ecoap_net_s));
    mbtk_ecoap_net.message_id = 1;   //change mbtk_ecoap_net.message_id = 0;
    memset(&mbtk_ecoap_option_2, 0x0, sizeof(mbtk_ecoap_opt_2));
    memset(&mbth_ecoap_package_ver, 0x0,sizeof(mbtk_ecoap_package_ver));
    mbth_ecoap_package_ver.version = 1;
    mbth_ecoap_package_ver.type = 0;
    mbth_ecoap_package_ver.code = 1;
    mbth_ecoap_package_ver.message_id = 1;
    mbtk_ecoap_recv = -1;

    mbtk_ecoap_package_s *coap = mbtk_ecoap_head;
	mbtk_ecoap_package_s *coap_next = NULL;
	mbtk_ecoap_option_s * option_ptr = NULL;
	mbtk_ecoap_option_s * option_ptr_next = NULL;

    while(coap != NULL)
    {
		coap_next = coap->next;
		if(coap->payload != NULL)
			free(coap->payload);

		if(coap->options != NULL)
		{
			option_ptr = coap->options;
			while(option_ptr != NULL)
			{
				option_ptr_next = option_ptr->next;
				free(option_ptr);
				option_ptr = NULL;
				option_ptr = option_ptr_next;
			}

		}

		free(coap);
		coap = NULL;
		coap = coap_next;

    }

    mbtk_ecoap_head = mbtk_ecoap_tail = NULL;
}


static void mbtk_ecoap_close()
{

}
#endif




mbtk_ecoap_package_s *mbtk_ecoap_get_by_msg_id(uint16 message_id)
{
    if(mbtk_ecoap_head == NULL)
    {
    }
    else
    {
        mbtk_ecoap_package_s *coap_ptr = mbtk_ecoap_head;
        while(coap_ptr != NULL)
        {
            if(coap_ptr->message_id == message_id)
            {
                return coap_ptr;;
            }
            coap_ptr = coap_ptr->next;
        }
    }
    return NULL;
}

static void mbtk_ecoap_list_item_init(unsigned int  sig,mbtk_ecoap_package_s *coap,uint16 message_id)
{
    switch(sig)
    {
        case ECOAPVER:
            coap->version = message_id;
            break;
        case EOCAPTYPE:
            coap->type = message_id;
            break;
        case ECOAPCODE:
            coap->code = message_id;
            break;
        case ECOAPMSGID:
            coap->message_id = message_id;
            break;
        case ECOAPTOKEN:
            coap->token_len = message_id;
            break;
        default:
            break;
    }
    coap->next = NULL;  //change delete this code
}


mbtk_ecoap_package_s* mbtk_ecoap_list_add(uint16 message_id)
{
    LOGE("mbtk_ecoap_list_add-----memssage_id:%d\n",message_id);
    if(mbtk_ecoap_head == NULL)
    {
        mbtk_ecoap_head = (mbtk_ecoap_package_s*)malloc(sizeof(mbtk_ecoap_package_s));
        memset(mbtk_ecoap_head, 0,sizeof(mbtk_ecoap_package_s));
        mbtk_ecoap_list_item_init(ECOAPMSGID,mbtk_ecoap_head,message_id);
        mbtk_ecoap_tail = mbtk_ecoap_head;
        return mbtk_ecoap_head;
    }
    else
    {
        mbtk_ecoap_package_s *coap_ptr = mbtk_ecoap_head;
        while(coap_ptr != NULL)
        {
            if(coap_ptr->message_id == message_id)
            {
                printf("Coap %d exist.\n",message_id);
                return NULL;
            }
            coap_ptr = coap_ptr->next;
        }
        mbtk_ecoap_tail->next = (mbtk_ecoap_package_s*)malloc(sizeof(mbtk_ecoap_package_s));
        mbtk_ecoap_list_item_init(ECOAPMSGID,mbtk_ecoap_tail->next,message_id);
        mbtk_ecoap_tail = mbtk_ecoap_tail->next;
        return mbtk_ecoap_tail;
    }
}

static void mbtk_ecoap_free(mbtk_ecoap_package_s *coap)
{
    if(coap != NULL)
    {
        if(coap->payload != NULL)
            free(coap->payload);

        if(coap->options != NULL)
        {
            mbtk_ecoap_option_s *option_ptr = coap->options;
            while(option_ptr != NULL)
            {
				mbtk_ecoap_option_s *tmp_ptr = option_ptr;
                option_ptr = option_ptr->next;
				free(tmp_ptr);
            }
        }

        free(coap);
        coap = NULL;
    }
}

int mbtk_ecoap_list_del(uint16 message_id,int optDel)
{
    LOGE("mbtk_ecoap_list_del:message_id:%d\n",message_id);
    if(mbtk_ecoap_head == NULL)
    {
    	printf("mbtk_ecoap_head == NULL\n");
	return -1;
    }

    mbtk_ecoap_recv = -1;
    if(optDel)
    {
        memset(&mbtk_ecoap_option_2, 0x0, sizeof(mbtk_ecoap_opt_2));
        memset(&mbtk_ecoap_option_3, 0x0, sizeof(mbtk_ecoap_opt_3));
        memset(&mbth_ecoap_package_ver,0x0,sizeof(mbth_ecoap_package_ver));
        mbth_ecoap_package_ver.version = 1;
        mbth_ecoap_package_ver.type = 0;
        mbth_ecoap_package_ver.code = 1;
        mbth_ecoap_package_ver.message_id = 1;
    }
    mbtk_ecoap_package_s *coap = mbtk_ecoap_head;
    if(mbtk_ecoap_head->message_id == message_id) // Is first item.
    {
        mbtk_ecoap_head = mbtk_ecoap_head->next;

        mbtk_ecoap_free(coap);
        return 0;
    }
    else     // Not first item.
    {
        while(coap->next != NULL)
        {
            if(message_id == coap->next->message_id)   // delete
            {
                mbtk_ecoap_package_s *coap_tmp = coap->next;
                if(mbtk_ecoap_tail == coap_tmp)
                {
                    mbtk_ecoap_tail = coap;
                }
                coap->next = coap_tmp->next;
                mbtk_ecoap_free(coap_tmp);
                return 0;;
            }
            coap = coap->next;
        }
        return -1;
    }
}

void mbtk_ecoap_option_add(mbtk_ecoap_option_s *option)
{
    if(option != NULL)
    {
        switch(option->type)
        {
            case COAP_OPTION_IF_MATCH:
            case COAP_OPTION_URI_HOST:
            case COAP_OPTION_ETAG:
            case COAP_OPTION_IF_NONE_MATCH:
            case COAP_OPTION_LOCATION_PATH:
            case COAP_OPTION_LOCATION_QUERY:
            case COAP_OPTION_PROXY_URI:
            case COAP_OPTION_PROXY_SCHEME:
            case COAP_OPTION_URI_PORT:
            case COAP_OPTION_ACCEPT:
            case COAP_OPTION_SIZE2:
            case COAP_OPTION_SIZE1:
            {
                break;
            }
            case COAP_OPTION_BLOCK2:
            case COAP_OPTION_BLOCK1:
            {
                LOGE("option->opt.opt_block.number = %d\n",option->opt.opt_block.number);
                if(option->opt.opt_block.number <= 0x0F)
                {
                    uint8_t temp[1];
                    temp[0] = (uint8_t)(((option->opt.opt_block.number << 4) & 0xF0)
                                        | ((option->opt.opt_block.more_flag << 3) & 0x08)
                                        | (option->opt.opt_block.size & 0x07));
                    coapAddOption(option->type,1,temp);
                }
                else if(option->opt.opt_block.number <= 0x0FFF)
                {
                    uint8_t temp[2];
                    temp[0] = (uint8_t)(option->opt.opt_block.number >> 4);
                    temp[1] = (uint8_t)(((option->opt.opt_block.number << 4) & 0xF0)
                                        | ((option->opt.opt_block.more_flag << 3) & 0x08)
                                        | (option->opt.opt_block.size & 0x07));
                    coapAddOption(option->type,2,temp);

                }
                else
                {
                    uint8_t temp[3];
                    temp[0] = (uint8_t)(option->opt.opt_block.number >> 12);
                    temp[1] = (uint8_t)(option->opt.opt_block.number >> 4);
                    temp[2] = (uint8_t)(((option->opt.opt_block.number << 4) & 0xF0)
                                        | ((option->opt.opt_block.more_flag << 3) & 0x08)
                                        | (option->opt.opt_block.size & 0x07));
                    coapAddOption(option->type,3,temp);

                }
                break;
            }
            case COAP_OPTION_MAX_AGE:
            {
                uint8_t temp[1];
                temp[0] = (uint8_t)option->opt.opt_int;
                coapAddOption(option->type,1,temp);
                break;
            }
            case COAP_OPTION_OBSERVE:
            {
                uint8_t temp[1];
                temp[0] = (uint8_t)option->opt.opt_int;
                coapAddOption(option->type,1,temp);
                break;
            }
            case COAP_OPTION_URI_QUERY:
            {
                coapAddURIQuery((char*)option->opt.opt_str);
                break;
            }
            case COAP_OPTION_URI_PATH:
            {
                coapSetURI((char*)option->opt.opt_str);
                break;
            }
            case COAP_OPTION_CONTENT_FORMAT:
            {
                coapSetContentFormat(option->opt.opt_content_format);
                break;
            }
            default:
                printf("No such type:%d\n",option->type);
                break;
        }
    }
}

static void mbtk_ecoap_set_option(mbtk_ecoap_package_s *coap,
                                 mbtk_coap_option_type type,void *str,
                                 int int0,int int1,int int2)
{
    if(coap != NULL)
    {
/*        if(coap->options == NULL)
        {
            coap->options = (mbtk_ecoap_option_s*)malloc(sizeof(mbtk_ecoap_option_s));
            memset(coap->options,0x0,sizeof(mbtk_ecoap_option_s));
            coap->options->type = type;
            coap->options->next = NULL;
        }
*/
        mbtk_ecoap_option_s *option = coap->options;
        while(option != NULL)
        {
            LOGE("1option != NULL\n");
            if(option->type == type)
            {
                break;
            }
            option = option->next;
        }

        LOGE("----------------------\n");
        if(option == NULL) // Now option
        {
            LOGE("option == NULL\n");
            option = (mbtk_ecoap_option_s*)malloc(sizeof(mbtk_ecoap_option_s));
            memset(option,0x0,sizeof(mbtk_ecoap_option_s));
//            option->type = type;

            option->next = coap->options;
            coap->options = option;
            option->type = type;
        }
        else // Change option
        {
            // Do noting.
        }

        switch(type)
        {
            case COAP_OPTION_IF_MATCH:
            case COAP_OPTION_URI_HOST:
            case COAP_OPTION_ETAG:
            case COAP_OPTION_IF_NONE_MATCH:
            case COAP_OPTION_LOCATION_PATH:
            case COAP_OPTION_URI_QUERY:
            case COAP_OPTION_LOCATION_QUERY:
            case COAP_OPTION_PROXY_URI:
            case COAP_OPTION_PROXY_SCHEME:
            case COAP_OPTION_URI_PATH:
            {
                memset(option->opt.opt_str,0x0,128);
                memcpy(option->opt.opt_str,str,strlen((char*)str));
                break;
            }
            case COAP_OPTION_OBSERVE:
            case COAP_OPTION_MAX_AGE:
            case COAP_OPTION_URI_PORT:
            case COAP_OPTION_SIZE2:
            case COAP_OPTION_SIZE1:
            {
                option->opt.opt_int = (int)int0;
                break;
            }
            case COAP_OPTION_BLOCK2:
            case COAP_OPTION_BLOCK1:
            {
                option->opt.opt_block.size = (mbtk_ecoap_option_block_e)int0;
                option->opt.opt_block.number = (int)int1;
                option->opt.opt_block.more_flag = (uint8)int2;
                break;
            }
            case COAP_OPTION_CONTENT_FORMAT:
			{
                option->opt.opt_content_format = (mbtk_content_format_type)int0;
                break;
            }
            case COAP_OPTION_ACCEPT:
            {
                option->opt.opt_content_format = (mbtk_content_format_type)int0;
                break;
            }
            default:
                printf("No such type:%d\n",type);
                break;
        }
    }
}


static void mbtk_ecoap_send_ack(mbtk_coap_code_type code,
                               uint16_t message_id,uint8 token_len,uint8 *token)
{
    coapReset();
    coapSetVersion(1);
    coapSetType(COAP_ACKNOWLEDGEMENT);
    coapSetMessageID(message_id);

    if(code == COAP_POST || code == COAP_PUT)
        coapSetCode(COAP_CHANGED);
    else
        coapSetCode(COAP_EMPTY);

    if(token_len > 0)
    {
        coapSetToken(token, token_len);
    }

    uint8_t* pduPointer = coapGetPDUPointer();
    int pduLen = coapGetPDULength();
	int err;
	int res = mbtk_sock_write(coap_handle, coap_fd, pduPointer, pduLen, 300, &err);
    if(res != pduLen)
    {
        printf("Send ACK fail.[res:%d,pduLen:%d],err:%d\n",res,pduLen,err);
    }
    else
    {
        printf("Send ACK to server success.\n");
    }
}



static int mbtk_ecoap_handle_sock_init(char *ip_addr, int port, bool is_support_ssl, bool ingnore_cert)
{
    mbtk_sock_info *sock_info = NULL;
    int rc = 0;
    int errno;

    sock_info = (mbtk_sock_info *)malloc(sizeof(mbtk_sock_info));
    if(sock_info == NULL)
    {
        rc = -1;
        return rc;
    }
    memcpy(sock_info->address, ip_addr, strlen(ip_addr));
    sock_info->port = port;
    sock_info->is_support_ssl = is_support_ssl;
    sock_info->ingnore_cert = ingnore_cert;
	sock_info->type = MBTK_SOCK_UDP;

    printf("host %s\nport %d\nis_support_ssl %d\ningnore_cert %d\n",sock_info->address,sock_info->port,sock_info->is_support_ssl,sock_info->ingnore_cert);

	if(!coap_sock_inited)
	{
		coap_handle = mbtk_sock_init(coap_init_info);
	    if (coap_handle < 0 )
	    {
	        rc = -1;
	        return rc;
	    }
		coap_sock_inited = TRUE;
	}


    coap_fd  = mbtk_sock_open(coap_handle, sock_info, 3000, &errno);
    if(coap_fd < 0)
    {
    	printf("creat socket fail, errno:%d\n",errno);
        rc = -1;
        return rc;
    }
    mbtk_ecoap_state = MBTK_ECOAP_STATE_READY;
	return rc;
}



int mbtk_ecoap_ecoap_send(mbtk_ecoap_package_s* coap)
{
    if(coap != NULL)
    {
        coapReset();
        coapSetVersion(coap->version);
        coapSetType(coap->type);
        coapSetCode(coap->code);
        coapSetMessageID(coap->message_id);

        if(coap->token_len > 0)
        {
            coapSetToken(coap->token, coap->token_len);
        }

        mbtk_ecoap_option_s *option = coap->options;
        while(option != NULL)
        {
            mbtk_ecoap_option_add(option);
            option = option->next;
        }

        if(coap->payload_len > 0)
        {
            coapSetPayload((uint8_t*)coap->payload, coap->payload_len);
        }

        uint8_t *pduPointer = coapGetPDUPointer();
        int pduLen = coapGetPDULength();
        uint8_t pduPointer2[MBTK_ECOAP_DATA_MAX*2];
		int err;
        memset ( pduPointer2,0x00,MBTK_ECOAP_DATA_MAX*2 );
        if((mbtk_ecoap_option_2.optlen + pduLen) > MBTK_ECOAP_DATA_MAX*2)
        {
            printf("This length is too long\n");
            return -1;
        }

        LOGE("pduLen:%d, optlen:%d\n",pduLen ,mbtk_ecoap_option_2.optlen);
   //     printf("pduPointer:\n");
   //     coap_log(-1,(char*)pduPointer,pduLen);
        int j=0,k=0;
        LOGE("pduPointer-----------end\n");
//        int optflag = 0;
        pduPointer2[0]= *pduPointer++;
        pduPointer2[1]= *pduPointer++;
        pduPointer2[2]= *pduPointer++;
        pduPointer2[3]= *pduPointer++;
        for(j = 0; j < mbtk_ecoap_option_2.optlen; j++)
        {
            pduPointer2[4+j] = mbtk_ecoap_option_2.optVal[j];
			LOGE("j:%d, %X",j, mbtk_ecoap_option_2.optVal[j]);
            k++;
        }
        int pduLen2 = 4;
        while(pduLen > pduLen2 )
        {
        	LOGE("\r\npduLen > pduLen2 \r\n");
            LOGE("pduLen:%d,pduPointer:%X,k:%d\n",pduLen2,*pduPointer,k);
            pduPointer2[pduLen2+k] = *pduPointer++;
            pduLen2++;
        }

        pduLen += mbtk_ecoap_option_2.optlen;

        printf("sendpdu:--------pduLen:%d\n",pduLen);
		coap_log(FALSE,(char*)pduPointer2,pduLen);
		int send_len = 0;

		if((send_len = mbtk_sock_write(coap_handle, coap_fd, pduPointer2, pduLen, 300, &err)) != pduLen)
//        if((send_len = sendto(socket_id, pduPointer2, pduLen, 0, (struct sockaddr*)&serveraddr, addrlen)) != pduLen)
        {
            printf("coap_udp_sendto complate.[%d/%d]\n",send_len,pduLen);

            coap->send_count++;
			return -1;
        }

        if(coap->type != COAP_CONFIRMABLE)
        {
            mbtk_ecoap_list_del(coap->message_id,0);
        }

    }
	return 0;
}

void mbtk_ecoap_recv_buffer(char * dest)
{
	int pud_lenth = mbtk_coap_get_pdu_Length();
	int type = mbtk_ecoap_get_message_type();
	char code[12];
    memset(code,0x00,sizeof(code));
	mbtk_ecoap_get_code(code);
	uint16_t mesageId = coapGetRecvMessageID();
	memset(dest,0x00,129);
	snprintf(dest,128,
			"+COAPNMI:%d\r\nMessage Type:%d\r\nCode:\"%s\"\r\nMessage ID:%d\r\nPayload:",
			pud_lenth,
			type,
			code,
			mesageId);
}


static void mbtk_ecoap_recv_resolve(const void *data,uint16 data_len)
{
    if(coapCreateRecv((uint8_t*)data, data_len) <= 0)
    {
        printf("coapCreateRecv fail.\n");
    }
    else
    {
        LOGE("coapCreateRecv() success.\n");

        uint8_t version = coapGetRecvVersion();
        mbtk_coap_type type = coapGetRecvType();
        mbtk_coap_code_type code = coapGetRecvCode();
        uint16_t message_id = coapGetRecvMessageID();
        int pud_lenth = mbtk_coap_get_pdu_Length();
        LOGE("version:%d;type:%d\n",version,type);
        LOGE("code:%d;message_id:%d,pud_lenth:%d\n",code,message_id,pud_lenth);

        uint8 token_len = coapGetRecvTokenLength();
        char token[9] = {0};
        memcpy(token,coapGetRecvTokenPointer(),token_len);
        LOGE("token[%d]:%s\n",token_len,token);

//        uint16 playload_len = coapGetRecvPayloadLength();
//        uint8 *playload = coapGetRecvPayloadPointer();
//        printf("----------------payload-----------------\n");
//        coap_log(0,(char*)playload,playload_len);
//        printf("--------------payload end----------------\n");


		char buff_data[MBTK_ECOAP_DATA_MAX*2+1];
		memset ( buff_data,0x00,MBTK_ECOAP_DATA_MAX*2+1 );
        int buffer_len = ecoap_recv_buffer(buff_data, data, data_len);
		printf("recv buff_len:%d\n",buffer_len);
        printf("buf:\n%s\r\n",buff_data);

        LOGE("type:%X\n",type);
        if(type == COAP_CONFIRMABLE) // Should ACK
        {
            mbtk_ecoap_send_ack(code,message_id,token_len,(uint8*)token);
        }
        else if(type == COAP_NON_CONFIRMABLE)
        {
            // Do nothing.
        }
        else if(type == COAP_ACKNOWLEDGEMENT)
        {
            mbtk_ecoap_package_s * coap_send = mbtk_ecoap_get_by_msg_id(message_id);
            if(coap_send != NULL)
            {
                uint32_t number;
                uint8_t more_flag;
                uint8_t size;
                LOGE("Get message(%d) ack.\n",message_id);
                if(coapGetRecvOptionBlock2(&number, &more_flag, &size))
                {
                    LOGE("Block2 (size:%d; more_flag:%d; number:%d)\n",size,more_flag,number);
                    if(more_flag) // Has data no read.
                    {
                        coap_send->message_id = ++mbtk_ecoap_net.message_id ;
                        mbtk_ecoap_set_option(coap_send, COAP_OPTION_BLOCK2, NULL,
                                             size,number + 1,0);

                        mbtk_ecoap_ecoap_send(coap_send);
                    }
                    else
                    {
                        mbtk_ecoap_list_del(message_id,0);
                    }
                }
                else
                {
                    printf("coapGetRecvOptionBlock2() fail.\n");
                    mbtk_ecoap_list_del(message_id,0);
                }
            }
            else
            {
                printf("Coap not match.\n");
            }
        }
        else     // COAP_RESET
        {
            printf("Coap type error.\n");
        }
    }
	coapDeleteRecv();

}


static int ecoap_sig_recv_handle(void)
{
    LOGE("coap_sig_recv_handle----------start\n");

    uint8_t buffer[MBTK_ECOAP_DATA_MAX*2+1];
    memset ( buffer,0x00,MBTK_ECOAP_DATA_MAX*2+1 );
    int ret=-1;
	int err = -1;
	while(TRUE)
	{
		ret = mbtk_sock_read(coap_handle, coap_fd, buffer, MBTK_ECOAP_DATA_MAX*2, 1000*10, &err);
		if(ret <= 0)
		{
            printf("read fail, err:%d",err);
			break;
		}
        printf("recv_from ret:%d\n",ret);
        coap_log(FALSE,(char*)buffer,ret);
        mbtk_ecoap_recv_resolve(buffer,ret);
	}

    return ret;
}

static int ecoap_sig_send_complete_handle(void )
{
    int ret=-1;
    mbtk_ecoap_package_s *coap = mbtk_ecoap_get_by_msg_id(mbtk_ecoap_net.message_id);
    if(coap == NULL)
    {
        mbtk_ecoap_show_error(MBTK_ECOAP_ERR_MSG_ID);
        return -1;
    }

    ret = mbtk_ecoap_ecoap_send(coap);

    return ret;

}

//static int mbtk_ecoap_open(int open);



#endif


/*************************************************************
    Public Function Definitions
*************************************************************/

/*************************************************************
	ip_addr: url
	port

*************************************************************/
int mbtk_coap_ecoapnew_exec_cmd
(
    char *ip_addr,
    int port,
    bool is_support_ssl,
    bool ingnore_cert
)
{
    printf("mbtk_coap_ecoapnew_exec_cmd()------start1\n");
	int ret = 0;
	if( !ip_addr)
	{
	    mbtk_ecoap_show_error(MBTK_ECOAP_ERR_NO_READY);
	    return -1;
	}

	ret = mbtk_ecoap_handle_sock_init(ip_addr, port, is_support_ssl, ingnore_cert);

    return ret;
}

int mbtk_coap_ecoaprxmod_exec_cmd
(
	int mode
)
{
    int result = 0;
//	int rx_mod = mode;

    return result;
}

int mbtk_coap_ecoappr_exec_cmd
(
	int format
)
{
    int result = 0;
//	uint16 ecoappr = format;
    return result;
}

int mbtk_coap_ecoaprxget_exec_cmd
(
    int len
)
{
    int result = 0;
//	int get_len = len;

    return result;

}

int mbtk_coap_ecoapver_exec_cmd
(
    int version
)
{
    int result = 0;
	mbth_ecoap_package_ver.version = version;
    return result;

}

int mbtk_coap_ecoaptype_exec_cmd
(
    mbtk_coap_type type
)
{
    int result = 0;
	mbth_ecoap_package_ver.type = type;

    return result;

}


int mbtk_coap_ecoapcode_exec_cmd
(
    mbtk_coap_code_type code
)
{
    int  result = 0;
	mbth_ecoap_package_ver.code = code;
        LOGE("ver:%d,type:%d,code:%d,msg:%d\n",
            mbth_ecoap_package_ver.version,
            mbth_ecoap_package_ver.type,
            mbth_ecoap_package_ver.code,
            mbth_ecoap_package_ver.message_id);
    return result;

}

int mbtk_coap_ecoaptoken_exec_cmd
(
    char *token_buf, int len
)
{
    int result = 0;
	uint16 token_length = len;
	char * token = token_buf;
	if(strlen(token) != token_length)
	{
		return -1;
	}

	mbth_ecoap_package_ver.token_len = token_length;
	memcpy(mbth_ecoap_package_ver.token, token, strlen(token));

	return result;
}

int mbtk_coap_ecoapmsgid_exec_cmd
(
    int msg_id
)
{
    int result = 0;
	 mbth_ecoap_package_ver.message_id = msg_id;

	return result;
}

int mbtk_coap_ecoapopt_exec_cmd
(
    char *value_buf, int buf_len
)
{
    int result = 0;
	int opt = buf_len;
    char* value = value_buf;

    if(value == NULL)
    {
        return -1;
    }
    if(opt != strlen(value))
    {
        return -1;
    }

    memset(&mbtk_ecoap_option_2, 0x0, sizeof(mbtk_ecoap_opt_2));
    memset(&mbtk_ecoap_option_3, 0x0, sizeof(mbtk_ecoap_opt_3));

    mbtk_ecoap_option_3.optlen = opt;
    mbtk_ecoap_option_2.optlen = opt / 2;

    if(mbtk_ecoap_option_2.optlen > 0)
    {
        memcpy(mbtk_ecoap_option_3.optVal, value, opt);
        mbtk_ecoap_option_3.optVal[opt] = '\0';
        StrToHex((byte*)mbtk_ecoap_option_2.optVal, (byte*)value, strlen(value));
//		printf("\r\nopt2---------option_len,option_data");
//		coap_log(FALSE,(char*)mbtk_ecoap_option_2.optVal,mbtk_ecoap_option_2.optlen);
    }
    return result;

}

int mbtk_coap_ecoapsend_exec_cmd
(
    int message_id, int Data_len, char *data
)
{
    int data_len = Data_len;
    char * send_data = NULL;
	int err = -1;
    if(data_len != 0 )
    {
        send_data = data;
    }
    int coap_id = message_id;

	LOGE("send---------coap_id:%d,data_len:%d\n",coap_id,data_len);

     if(mbtk_ecoap_state <= MBTK_ECOAP_STATE_CLOSING )
    {
        mbtk_ecoap_show_error(MBTK_ECOAP_ERR_NO_OPEN);
        return -1;
    }

    if(coap_id != mbth_ecoap_package_ver.message_id)
    {
        mbtk_ecoap_show_error(MBTK_ECOAP_ERR_MSG_ID);
        return -1;
    }

    if(coap_id != mbtk_ecoap_net.message_id)
    {
        printf("send_cmd del message_id:%d\n",mbtk_ecoap_net.message_id);
        mbtk_ecoap_list_del(mbtk_ecoap_net.message_id,-1);
    }

    if(send_data)
    {
        if(data_len != strlen(send_data) || data_len > 1024)
        {
            mbtk_ecoap_show_error(MBTK_ECOAP_ERR_PAYLOAD_LENGTH);
            return -1;
        }
    }

    mbtk_ecoap_package_s *coap = mbtk_ecoap_get_by_msg_id(coap_id);
    if( !coap)
    {
        mbtk_ecoap_net.message_id = mbth_ecoap_package_ver.message_id;
        coap = mbtk_ecoap_list_add(mbtk_ecoap_net.message_id);
        if(coap != NULL)
        {
            mbtk_ecoap_list_item_init(ECOAPVER,coap,mbth_ecoap_package_ver.version);
            mbtk_ecoap_list_item_init(EOCAPTYPE,coap,mbth_ecoap_package_ver.type);
            mbtk_ecoap_list_item_init(ECOAPCODE,coap,mbth_ecoap_package_ver.code);
            if(mbth_ecoap_package_ver.token_len > 0)
            {
                coap->token_len = mbth_ecoap_package_ver.token_len;
                memcpy(coap->token, mbth_ecoap_package_ver.token, strlen((char *)mbth_ecoap_package_ver.token));
            }

            if(data_len > 0)
            {
                coap->payload_len = data_len;
                if(coap->payload != NULL)
                {
                    free(coap->payload);
                    coap->payload = NULL;
                }
                coap->payload = (uint8*)malloc(data_len + 1);
                memset(coap->payload,0x00,data_len + 1);
                memcpy(coap->payload,send_data,data_len);
            }

        }
        else{
            printf("coap new error\n");
        }

    }
    else
    {
		printf("coap is NULL\n");
    }

    mbtk_ecoap_recv = 0;
	if(mbtk_ecoap_state < MBTK_ECOAP_STATE_READY)
	{
	    printf("State[%d] error,not ready...\n",mbtk_ecoap_state);
	    return -1;
	}

	if( !ecoap_sig_send_complete_handle() )
	{
		ecoap_sig_recv_handle();
	}

	if(mbtk_sock_close(coap_handle, coap_fd,1000, &err)) {
        return -1;
    }

    coap_fd = -1;
    return 0;

}

int mbtk_coap_ecoapdel_exec_cmd( int del_id )
{

    int result = 0;
	LOGE("del---------del_id:%d\n",del_id);
	if(del_id != 1)
	{
		return -1;
	}

	 if(mbtk_ecoap_state <= MBTK_ECOAP_STATE_CLOSING )
	{
		mbtk_ecoap_show_error(MBTK_ECOAP_ERR_NO_OPEN);
		return -1;
	}

	LOGE("del---------del_id:%d\n",del_id);

    return result;

}

int mbtk_coap_ecoapclose_exec_cmd( void )
{
    int result = 0;
	if(!coap_sock_inited) {
        LOGE("HTTP not inited.");
        return -1;
    }

    int err = mbtk_sock_deinit(coap_handle);
    if(err != MBTK_SOCK_SUCCESS) {
        LOGE("mbtk_sock_deinit() fail.");
        return -1;
    }

    coap_handle = -1;
    coap_sock_inited = FALSE;
    return 0;

    return result;
}

void mbtk_coap_lib_info_print()
{
    MBTK_SOURCE_INFO_PRINT("mbtk_coap_lib");
}

