//
// Created by hitmoon on 15-12-9.
//

#ifndef SMS_SMS_H
#define SMS_SMS_H

#include <string.h>
#include "mbtk_utf.h"
#include "mbtk_type.h"

#define MAX_SMS_NR 32

//typedef int bool;

#define true 1
#define false 0

enum EnumDCS {
    BIT7 = 0,            // GSM 字符集
    BIT8 = 1,            // ASCII字符集
    UCS2 = 2             // Unicode 字符集
};

enum EnumUDL {
    BIT7UDL = 160,
    BIT8UDL = 140,
    UCS2UDL = 70
};

enum EnumCSMIEI {
    BIT8MIEI = 0,
    BIT16MIEI = 8
};

struct PDUUDH {
    unsigned int count;    // 信息元素数据字节数
    char IEI;           // 信息元素标识
    char *IED;          // 信息元素数据
};

// 用户数据头
struct UDHS {
    int count;
    struct PDUUDH *UDH;
};

// 用户数据数组，用于拆分短信
struct UDS {
    unsigned int total;
    char **Data;
};

// 编码后短信
struct PDUS {
    unsigned int count;
    char **PDU;
};

struct ByteArray {
    char *array;
    unsigned int len;
};

struct SMS_Struct {
    char *SCA;         // 服务中心地址
    char *OA;          // 发送方地址
    char *SCTS;        // 服务中心时间戳
    struct UDHS *UDH;     // 用户数据头
    char *UD;          // 用户数据

    bool RP;              // 应答路径
    bool UDHI;            // 用户数据头标识
    bool SRI;             // 状态报告指示
    bool MMS;             // 更多信息发送
    int MTI;              // 信息类型指示

    char PID;          // PID 协议标识

    enum EnumDCS DCS;      // 数据编码方案
    bool TC;              // 文本压缩指示 0： 未压缩 1：压缩
    int MC;               // 消息类型 -1： 无 1：移动设备特定类型 2：SIM特定类型 3：终端设备特定类型

};

/* mbtk sms start */

#define REPLACEMENT_CHAR    (UTF32)0x0000FFFD
#define MAX_UNI_BMP         (UTF32)0x0000FFFF
#define MAX_UNI_UCS2        MAX_UNI_BMP
#define MAX_UTF16           (UTF32)0x0010FFFF
#define MAX_UTF32           (UTF32)0x7FFFFFFF
#define MAX_LEGAL_UTF32     (UTF32)0x0010FFFF

#define MDAPI_TIME_STR_SIZE         22
#define MDAPI_PHONE_NUMBER_SIZE     32
#define MDAPI_MAX_PDU_SIZE          512
#define MAX_CONCATENATED_MSG 32
#define MAX_7BIT_MSG_LEN    153
#define MAX_UCS2_MSG_LEN    67
#define MAX_8BIT_MSG_LEN    268 //134*2

#define SMS_DELIVER         0x00
#define SMS_DELIVER_REPORT  0x00
#define SMS_SUBMIT          0x01
#define SMS_SUBMIT_REPORT   0x01
#define SMS_STATUS_REPORT   0x02
#define SMS_STATUS_COMMAND  0x02


#define STATUS_SUCCESS          0
#define STATUS_MEM_EXHAUSTED    (-0xC0000)
#define STATUS_ILLEGAL_UTF8     (-0xC0001)
#define STATUS_ILLEGAL_UTF16    (-0xC0002)
#define STATUS_ILLEGAL_UTF32    (-0xC0003)
#define STATUS_ILLEGAL_UCS2     (-0xC0004)
#define STATUS_NULL_POINTER     (-0x00001)


#define SUR_HIGH_START  (UTF32)0xD800
#define SUR_HIGH_END    (UTF32)0xDBFF
#define SUR_LOW_START   (UTF32)0xDC00
#define SUR_LOW_END     (UTF32)0xDFFF



/*
 * Unix/Linux
 */
typedef char kal_int8;

typedef unsigned char kal_uint8;

typedef short kal_int16;

typedef unsigned short kal_uint16;

typedef int kal_int32;

typedef unsigned int kal_uint32;

/**/
typedef long long kal_int64;

/**/
typedef unsigned long long kal_uint64;

typedef char kal_char;




enum SMS_VPF_E
{
    SMS_VPF_NO_PRESENT  = 0x00,
    SMS_VPF_RESORVED    = 0x01,
    SMS_VPF_RELATIVE    = 0x02,
    SMS_VPF_ABSOLUTE    = 0x03,
    SMS_VPF_INVALID     = 0xFF,
};


enum SMS_ADDR_NUM_PLAN
{
    SMS_NP_UNKOWN       = 0x00,
    SMS_NP_ISDNTEL      = 0x01,
    SMS_NP_DATA         = 0x03,
    SMS_NP_TELIX        = 0x04,
    SMS_NP_NATIONAL     = 0x08,
    SMS_NP_PRIVATE      = 0x09,
    SMS_NP_RESERVED     = 0xFF,
};

enum SMS_ADDR_TYPE
{
    SMS_TON_UNKNOWN         = 0,
    SMS_TON_INTERNATIONAL   = 1,
    SMS_TON_NATIONAL        = 2,
    SMS_TON_NETWORKSPECIFIC = 3,
    SMS_TON_SUBSCRIBER      = 4,
    SMS_TON_ALPHANUMERIC    = 5,
    SMS_TON_ABBREVIATED     = 6,
    SMS_TON_RESERVED        = 7
};

enum SMS_ADDR_ENCODE_TYPE
{
    SMS_ENCODE_SCA      = 0,
    SMS_ENCODE_OADA     = 1,
    SMS_ENCODE_INVALID  = 0xFF,
};

enum MDAPI_RET_e {
    MDAPI_RET_SUCCESS       = 0,
    MDAPI_RET_ERROR         = 1,
    MDAPI_RET_TIMEOUT       = 2,
    MDAPI_RET_NOT_SUPPORT   = 3,
};

enum MDAPI_SMS_CHARSET_E
{
    MDAPI_SMS_CHARSET_GSM_7BIT  = 0x00000000,
    MDAPI_SMS_CHARSET_GSM_8BIT  = 0x00000001,
    MDAPI_SMS_CHARSET_UCS2      = 0x00000002,
    MDAPI_SMS_CHARSET_INVALID,
};

enum MDAPI_SMS_POSITION_E
{
    MDAPI_SMS_POS_INBOX     = 0x00000001,
    MDAPI_SMS_POS_SENTBOX   = 0x00000002,
    MDAPI_SMS_POS_DRAFBOX   = 0x00000003,
    MDAPI_SMS_POS_OUTBOX    = 0x00000004,
    MDAPI_SMS_POS_INVALID,
};

/* */
enum  MDAPI_SMS_MSGTYPE_E
{
    MDAPI_SMS_NORMAL_MSG    = 0x00000000,
    MDAPI_SMS_MSG_REPORT    = 0x00000001,
    MDAPI_SMS_MMS_ALERT     = 0x00000002,
    MDAPI_SMS_VOICE_MAIL    = 0x00000003,
    MDAPI_SMS_MSGTYPE_INVALID,
};

typedef struct _mdapi_sms_setting {
    kal_int8 rd;    /* reject duplicate */
    kal_int8 vpf;   /* validity peroid format */
    kal_int8 srr;   /* status report request */
    kal_int8 rp;    /* replay path */
    kal_int32 validity_period;   /* validity peroid */
} mdapi_sms_settings_t;

typedef struct _mdapi_sms_record {
    kal_int32 msg_id;
    kal_int32 is_read;
    kal_int32 position;
    kal_int32 result;
    kal_int32 msg_type;
    kal_int32 sms_class;
    kal_int32 total_pack;
    kal_int32 curr_pack;
    kal_int32 ref_num;
    kal_int32 msg_location;
    kal_int16 charset;
    kal_char  time[MDAPI_TIME_STR_SIZE];            /*YYYY-MM-DD HH:MM:SS*/
    kal_char  phone_number[MDAPI_PHONE_NUMBER_SIZE];
    kal_char  *msg_content;
} mdapi_sms_record_t;

typedef struct _smsbuf {
    kal_uint8 *curbyte;
    kal_uint8 *finalbyte;
    kal_uint8 *septet_start;
    kal_uint8 curbit;
    kal_uint8 smsbuf[512];
} smsbuf_t;

static const kal_int32 UTF16_HALF_SHIFT  = 10; /* used for shifting by 10 bits */
static const UTF32 UTF16_HALF_BASE = 0x0010000UL;
static const UTF32 UTF16_HALF_MASK = 0x3FFUL;

static const unsigned char utf8_tailing_bytes[256] = {
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
    1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
    1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
    2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
    3,3,3,3,3,3,3,3,4,4,4,4,5,5,5,5
};

static const UTF32 utf8_offsets[6] = {
    0x00000000UL,
    0x00003080UL,
    0x000E2080UL,
    0x03C82080UL,
    0xFA082080UL,
    0x80282080UL
};

#define MAX_OUT_SIZE 512
#define MAX_PDU_SIZE 512

typedef struct latin1_to_gsm_extable {
    kal_int8 symbol;
    kal_uint8 value;
} Latin1_to_Gsm_ExTable;



static const UTF8 first_byte_mark[7] = {
    0x00,
    0x00,
    0xC0,
    0xE0,
    0xF0,
    0xF8,
    0xFC
};


int smsPduEncode(const char *smsc, const char *da_num, const char *msg, int charset, char *smsc_pdu, char **pdu);

int smsPduDecode(const char *pdu_str, int pdu_len, char *da_num, char *smsc, char *msg, int *charset, int *curr_pack, int *total_pack, char *date);

kal_int32 _mdapi_sms_get_msg_num(const char *msg, int charset, kal_int32 *msg_num, kal_int32 *msg_len);

kal_int32 _mdapi_sms_encode_addr(smsbuf_t *buf, kal_int8 *smsc, kal_int32 type);

kal_int32 _mdapi_sms_encode_pdu(mdapi_sms_record_t *sms,kal_int8 *smsc, mdapi_sms_settings_t *settings, kal_char *start, kal_int32 send_size, kal_uint8 *udh, kal_char *output, kal_int32 out_len, kal_int32 *sca_out_len);

void ArrayToStr(unsigned char *Buff, unsigned int BuffLen, char *OutputStr);
/* mbtk sms end */


// 短信解码
struct SMS_Struct PDUDecoding(const char *data);

// 短信编码, 自动确定编码方案
struct PDUS *PDUEncoding(char *SCA, char *DA, char *UDC, struct UDHS *udhs);

// 短信编码真正的工作
/// 发送方PDU格式（SMS-SUBMIT-PDU）
/// SCA（Service Center Adress）：短信中心，长度1-12
/// PDU-Type（Protocol Data Unit Type）：协议数据单元类型，长度1
/// MR（Message Reference）：消息参考值，为0～255。长度1
/// DA（Destination Adress）：接收方SME的地址，长度2-12
/// PID（Protocol Identifier）：协议标识，长度1
/// DCS（Data Coding Scheme）：编码方案，长度1
/// VP（Validity Period）：有效期，长度为1（相对）或者7（绝对或增强）
/// UDL（User Data Length）：用户数据段长度，长度1
/// UD（User Data）：用户数据，长度0-140

struct PDUS *PDUDoEncoding(char *SCA, char *DA, char *UDC, struct UDHS *udhs, enum EnumDCS DCS);


// 服务中心地址解码
char *SCADecoding(const char *data, int *EndIndex);

// 原始地址解码
char *OADecoding(const char *data, int index, int *EndIndex);

// 服务中心时间戳解码
char *SCTSDecoding(const char *data, int index);

// BCD 解码
int BCDDecoding(const char *data, int index, bool isMSB);

// 用户数据头解码
struct UDHS *UDHDecoding(const char *data, int index);

// 用户数据解码
char *UserDataDecoding(const char *data, int index, bool UDHI, enum EnumDCS dcs);

// 7-Bit编码解压缩
char *BIT7Unpack(const char *data, int index, int Septets, int FillBits);

// 转换GSM字符编码到Unicode编码
char *BIT7Decoding(char *BIT7Data, unsigned int size);

// 7-Bit序列和Unicode编码是否相同
int isBIT7Same(u_int16_t UCS2);

// 判断是否是GSM字符串
int isGSMString(char *Data);

// 用户数据拆分
struct UDS *UDCSplit(char *UDC, struct UDHS *uhds, enum EnumDCS DCS);

// 获得用户数据头长度
int getUDHL(struct UDHS *udhs);

// 计算需要的7-Bit编码字节数
int SeptetsLength(char *source);

// 将7-Bit编码字节数换算成UCS2编码字符数
int SeptetsToChars(char *source, int index, int septets);

// 在用户数据头中增加长短信信息元素
struct UDHS *UpdateUDH(struct UDHS *udhs, int CSMMR, int total, int index);

//单条短信编码
char *SoloPDUEncoding(char *SCA, char *DA, char *UC, struct UDHS *udhs, enum EnumDCS DCS);

// SCA编码
char *SCAEncoding(char *SCA);

// PDUTYPE 编码
char *PDUTypeEncoding(bool UDH);

// MR,消息参考值
char *MREncoding();

//接收方SME地址
char *DAEncoding(char *DA);

// 协议标识
char *PIDEncoding();

// 编码方案
char *DCSEncoding(char *UD, enum EnumDCS DCS);

// 用户数据长度及内容
char *UDEncoding(char *UD, struct UDHS *udhs, enum EnumDCS DCS);

// 用户数据头编码
char *UDHEncoding(struct UDHS *udhs, int *UDHL);

// 用户数据内容编码
char *UDCEncoding(char *UDC, int *UDCL, int UDHL, enum EnumDCS DCS);

// 将UCS2编码字符串转换成7-Bit编码字节 序列
struct ByteArray *BIT7Encoding(char *UDC, int *Septets);

//  7-Bit编码压缩
char *BIT7Pack(struct ByteArray *Bit7Array, int UDHL);

void sms_init();

#endif //SMS_SMS_H
