#include "mbtk_log.h"
#include "mbtk_wifi_ap.h"

#include <stdlib.h>
#include <stdio.h>


int mbtk_wifi_get_setting(const char *path, const char *key, char *value, int value_max_len)
{
	int ret = 0;
	int cnt = 0;
	int key_len; 
	int line_len;
	int value_len;
	FILE *fp;
	char line_buf[SETTING_LINE_MAX_LEN] = {0}; 
	
	if (NULL == path || NULL == key || NULL == value || 0 >= value_max_len) {
		return -1;
	}
	
	key_len = strlen(key);
	if (0 >= key_len || SETTING_KEY_MAX_LEN < key_len) {
		return -2;
	}
	
	if (F_OK != access(path, F_OK)) {
		return -3;
	}
	
	fp = fopen(path, "r");
	if (NULL == fp) {
		return -4;
	}
	
	while(NULL != fgets(line_buf, SETTING_LINE_MAX_LEN-1, fp)) {
		line_len = strlen(line_buf);
		if (line_len > key_len) {
			if (0 == strncmp(line_buf, key, key_len) && SETTING_SPLIT_CHAR == line_buf[key_len]) {
				ret = 1;
				break;
			}
		}
		memset(line_buf, 0, sizeof(line_buf));
		
		cnt++;
		if (SETTING_LINE_MAX < cnt) {
			break;
		}	
	}
	
	fclose(fp);
	
	if (1 == ret) {
		value_len = line_len - key_len - 1;
		if (0 < value_len) {
			if (value_len > value_max_len) {
				value_len = value_max_len;
			}
	
			strncpy(value, &line_buf[key_len + 1], value_len);
			value[value_len] = '\0';
			
	
			if ('\n' == value[value_len-1]) {
				value[value_len-1] = '\0';
			}
			if (2 <= value_len && '\r' == value[value_len-2]) {
				value[value_len-2] = '\0';
			}
			
		} else {
			value[0] = '\0';
		}		
	}
	
	return ret;
}
 

int mbtk_wifi_set_setting(const char *path, const char *key, const char *value)
{
	int i, j;
	int fd;
	int tmp_data_cnt = 0;
	int ret = 0;
	int cnt = 0;
	int key_len; 
	int line_len;
	int value_len;
	int len;
	FILE *fp = NULL;
	char tmp_key[SETTING_KEY_MAX_LEN+1] = {0};
	char tmp_value[SETTING_VALUE_MAX_LEN+1] = {0};
	char line_buf[SETTING_LINE_MAX_LEN] = {0};
	char tmp_data_buf[SETTING_LINE_MAX][SETTING_LINE_MAX_LEN] = {0};
	
	
	if (NULL == path || NULL == key || NULL == value) {
		return -1;
	}
	
	key_len = strlen(key);
	if (0 >= key_len || SETTING_KEY_MAX_LEN < key_len) {
		return -2;
	}
	
	for (i = 0, j = 0; i < key_len; i++) {
		if ('\r' == key[i] || '\n' == key[i]) {
			break;
		}
		tmp_key[j++] = key[i];
	}
	key_len = j;
	
	value_len = strlen(value);
	if (SETTING_VALUE_MAX_LEN < value_len) {
		value_len = SETTING_VALUE_MAX_LEN;
	} else if (value_len <= 0) {
		value_len = 0;
	}
	
	for (i = 0, j = 0; i < value_len; i++) {
		if ('\r' == value[i] || '\n' == value[i]) {
			break;
		}
		tmp_value[j++] = value[i];
	}
	value_len = j;


    /*
	if (F_OK != access(path, F_OK)) 
	{
		fp = fopen(path, "w+");
		if (NULL == fp) {
			return -3;
		}
 

		sprintf(line_buf, "%s%c%s\n", SETTING_VERSION_KEY, SETTING_SPLIT_CHAR, SETTING_VERSION_VALUE);
		line_len = strlen(line_buf);
		ret = fwrite(line_buf, 1, line_len, fp);		
 

		memset(line_buf, 0, sizeof(line_buf));
		sprintf(line_buf, "%s%c%s\n", tmp_key, SETTING_SPLIT_CHAR, tmp_value);
		line_len = strlen(line_buf);
		if (line_len != fwrite(line_buf, 1, line_len, fp)) {
			ret = -4;
		} else {
			ret = 2;
		}
 
		fclose(fp);
		return ret;
	}
    */

	if (NULL == fp) {
		fp = fopen(path, "r+");
		if (NULL == fp) {
			return -5;
		}
	}
	
	while(NULL != fgets(line_buf, SETTING_LINE_MAX_LEN-1, fp)) {
		line_len = strlen(line_buf);
		if (line_len > key_len) {
			if (1 != ret && 0 == strncmp(line_buf, tmp_key, key_len) && SETTING_SPLIT_CHAR == line_buf[key_len]) {
				ret = 1;
				sprintf(line_buf, "%s%c%s\n", tmp_key, SETTING_SPLIT_CHAR, tmp_value);
			}
		}
		
		strcpy(tmp_data_buf[tmp_data_cnt++], line_buf);
		
		memset(line_buf, 0, sizeof(line_buf));
		
		cnt++;
		if (SETTING_LINE_MAX < cnt) {
			break;
		}	
	}
	
	
	if (1 == ret) {
		rewind(fp);
		for (i = 0; i < tmp_data_cnt; i++) {
			fputs(tmp_data_buf[i], fp);
		}
		
		len = ftell(fp);
		fd = fileno(fp);
        if(0 > ftruncate(fd, len))
        {
            return -1;
        }
		
	} else { 
		if (SETTING_LINE_MAX > cnt) {
			sprintf(line_buf, "%s%c%s\n", tmp_key, SETTING_SPLIT_CHAR, tmp_value);
			line_len = strlen(line_buf);
			if (line_len != fwrite(line_buf, 1, line_len, fp)) {
				ret = -6;
			}
		} else {
			ret = -7;
		}		
	}	
	
	fclose(fp);
	
	return ret;
}
 


int mbtk_wifi_ap_start(void)
{
    if(0 > system("hostapd /etc/wifi/hostapd.conf -B"))
    {
        return -1;
    }

    if(0 > system("sleep 5s"))
    {
        return -1;
    }

    if(0 > system("brctl addif br-lan wlan0"))
    {
        return -1;
    }

    if(0 > system("iptables -t nat -A POSTROUTING -o ccinet0 -j MASQUERADE --random"))
    {
        return -1;
    }

    return 0;
}

int mbtk_wifi_ap_stop(void)
{
    if(0 > system("killall hostapd"))
    {
        return -1;
    }

    return 0;

}

int mbtk_wifi_set_file(const char *path, const char *value)
{
    FILE *file;
    
    file = fopen(path, "w");
    if (!file) 
    {
        return -1;
    }

    fputs(value, file);


    fclose(file);
    return 0;
}

int mbtk_wifi_get_file(const char *path, char *value, int value_max_len)
{
    FILE *file;
    char buf[SETTING_LINE_MAX_LEN] = {0};
    int len = 0;
    
    file = fopen(path, "r");
    if (!file) 
    {
        return -1;
    }

    while(NULL != fgets(buf, SETTING_LINE_MAX_LEN, file))
    {
        LOGD("mbtk_wifi_get_file:%s\n", buf);
        len += strlen(buf);
        if(len > value_max_len)
        {
            break;
        }
        strncat(value, buf, strlen(buf));
        LOGD("value:%s\n", value);
    }


    fclose(file);
    return 0;
}

int mbtk_wifi_get_pkt(mbtk_wifi_pkt_stats_t* pkt_stat)
{
    if(NULL == pkt_stat)
    {
        return -1;
    }

    char buf[1024] = {0};
    char* ptr = NULL;
    char* ptr2 = NULL;
    unsigned long long ull_temp = 0;
    FILE* fp = NULL;
    fp = popen("cat /proc/net/dev | grep wlan0", "r");
    if(NULL == fgets(buf, 1024, fp))
    {
        return -1;
    }
    pclose(fp);

    LOGD("pkt:%s, len:%d\n", buf, strlen(buf));


    pkt_stat->rx_bytes = strtoull(buf + 7, &ptr, 10);

    pkt_stat->rx_packets = strtoull(ptr, &ptr2, 10);

    pkt_stat->rx_errors = strtoull(ptr2, &ptr, 10);

    pkt_stat->rx_dropped = strtoull(ptr, &ptr2, 10);

    ull_temp = strtoull(ptr2, &ptr, 10);

    ull_temp = strtoull(ptr, &ptr2, 10);

    ull_temp = strtoull(ptr2, &ptr, 10);

    ull_temp = strtoull(ptr, &ptr2, 10);

    pkt_stat->tx_bytes = strtoull(ptr2, &ptr, 10);

    pkt_stat->tx_packets = strtoull(ptr, &ptr2, 10);

    pkt_stat->tx_errors = strtoull(ptr2, &ptr, 10);

    pkt_stat->tx_dropped = strtoull(ptr, &ptr2, 10);



    return 0;
}

int mbtk_wifi_get_dhcp(mbtk_lanhost_ts* lanhost_arr)
{
    if(NULL == lanhost_arr)
    {
        return -1;
    }
    
    int lanhost_num = 0;
    int i = 0;
    char* ptr = NULL;
    FILE *file;
    char buf[SETTING_LINE_MAX_LEN] = {0};

    file = fopen(DHCP_PATH, "r");
    if (!file) 
    {
        return -1;
    }

    lanhost_arr->array_len = 0;
    while(NULL != fgets(buf, SETTING_LINE_MAX_LEN, file))
    {
        LOGD("mbtk_wifi_get_file:%s\n", buf);
        ptr = buf;
        
        for(i = 0; i < 4; i++)
        {
            lanhost_arr->array[lanhost_num].name[i] = *ptr;
            ptr++;
        }

        LOGD("mbtk_wifi_get_file name:%s\n", lanhost_arr->array[lanhost_num].name);

        for(i = 0; i < 17; i++)
        {
            ptr++;
            lanhost_arr->array[lanhost_num].macaddr[i]= *ptr;
        }

        LOGD("mbtk_wifi_get_file mac:%s\n", lanhost_arr->array[lanhost_num].macaddr);
        ptr++;
        for(i = 0; i < 15; i++)
        {
            ptr++;
            lanhost_arr->array[lanhost_num].addr[i]= *ptr;
        }
        LOGD("mbtk_wifi_get_file addr:%s\n", lanhost_arr->array[lanhost_num].addr);
        memcpy(lanhost_arr->array[lanhost_num].ifname, DEF_INTERFACE, strlen(DEF_INTERFACE));
        lanhost_num++;
          
    }


    fclose(file);

    return 0;
}

int mbkt_wifi_get_uptime(mbtk_lanhost_ts* lanhost_arr)
{
    
    if(NULL == lanhost_arr)
    {
        return -1;
    }

    unsigned long long connected_time = 0; 
    char buf[1024] = {0};
    int i = 0;
    FILE* fp = NULL;

    lanhost_arr->array_len = 0;
    fp = popen("hostapd_cli all_sta | grep connected_time", "r");
    while(NULL != fgets(buf, 1024, fp))
    {
        if(0 > sscanf(buf, "connected_time=%llu", &connected_time))
        {
            return -1;
        }

        LOGD("qser wifi connected_time%llu", connected_time);
        lanhost_arr->array[i].uptime = connected_time;
        lanhost_arr->array_len++;
        connected_time = 0;
        i++;
    }
    pclose(fp);

   return 0;
}


