#ifndef MBTK_SOCK_INTERNAL_INCLUDE
#define MBTK_SOCK_INTERNAL_INCLUDE
#include "mbtk_sock2.h"
//#include <openssl/ssl.h>

#define MBTK_HANDLE_MAX_NUM 5
#define MBTK_SOCK_MAX_NUM 10

typedef struct {
    int fd;
    mbtk_sock_type type; // socket type:TCP or UDP
#ifdef MBTK_SSL_SUPPORT	
#ifdef MBTK_POLARSSL_SUPPORT
    entropy_context* entropy;
    ctr_drbg_context* ctr_drbg;
    ssl_context *ssl;
    ssl_session *saved_session;
    x509_crt *cacert;
    x509_crt *clicert;
    pk_context* pkey;
#else
    SSL_CTX *ctx;
    SSL *ssl;
#endif
#endif
} mbtk_sock_inter_info_s;

typedef struct {
    mbtk_init_info init_info;
    int sock_num;
    mbtk_sock_inter_info_s inter_infos[MBTK_SOCK_MAX_NUM];
    mbtk_sock_info infos[MBTK_SOCK_MAX_NUM];
} mbtk_sock_s;
struct options
{
    const char *server_name;    /* hostname of the server (client only)     */
    const char *server_addr;    /* address of the server (client only)      */
    int server_port;            /* port on which the ssl service runs       */
    int debug_level;            /* level of debugging                       */
    int nbio;                   /* should I/O be blocking?                  */
    const char *request_page;   /* page on server to request                */
    int request_size;           /* pad request with header to requested size */
    const char *ca_file;        /* the file with the CA certificate(s)      */
    const char *ca_path;        /* the path with the CA certificate(s) reside */
    const char *crt_file;       /* the file with the client certificate     */
    const char *key_file;       /* the file with the client key             */
    const char *psk;            /* the pre-shared key                       */
    const char *psk_identity;   /* the pre-shared key identity              */
    int force_ciphersuite[2];   /* protocol/ciphersuite to use, or all      */
    int renegotiation;          /* enable / disable renegotiation           */
    int allow_legacy;           /* allow legacy renegotiation               */
    int renegotiate;            /* attempt renegotiation?                   */
    int renego_delay;           /* delay before enforcing renegotiation     */
    int exchanges;              /* number of data exchanges                 */
    int min_version;            /* minimum protocol version accepted        */
    int max_version;            /* maximum protocol version accepted        */
    int auth_mode;              /* verify mode for connection               */
    unsigned char mfl_code;     /* code for maximum fragment length         */
    int trunc_hmac;             /* negotiate truncated hmac or not          */
    int reconnect;              /* attempt to resume session                */
    int reco_delay;             /* delay in seconds before resuming session */
    int tickets;                /* enable / disable session tickets         */
    const char *alpn_string;    /* ALPN supported protocols                 */
} opt;

#endif /* MBTK_SOCK_INTERNAL_INCLUDE */
